# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudAsmDiskGroupsResult',
    'AwaitableGetCloudAsmDiskGroupsResult',
    'get_cloud_asm_disk_groups',
    'get_cloud_asm_disk_groups_output',
]

@pulumi.output_type
class GetCloudAsmDiskGroupsResult:
    """
    A collection of values returned by getCloudAsmDiskGroups.
    """
    def __init__(__self__, cloud_asm_disk_group_collections=None, cloud_asm_id=None, filters=None, id=None, opc_named_credential_id=None):
        if cloud_asm_disk_group_collections and not isinstance(cloud_asm_disk_group_collections, list):
            raise TypeError("Expected argument 'cloud_asm_disk_group_collections' to be a list")
        pulumi.set(__self__, "cloud_asm_disk_group_collections", cloud_asm_disk_group_collections)
        if cloud_asm_id and not isinstance(cloud_asm_id, str):
            raise TypeError("Expected argument 'cloud_asm_id' to be a str")
        pulumi.set(__self__, "cloud_asm_id", cloud_asm_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)

    @_builtins.property
    @pulumi.getter(name="cloudAsmDiskGroupCollections")
    def cloud_asm_disk_group_collections(self) -> Sequence['outputs.GetCloudAsmDiskGroupsCloudAsmDiskGroupCollectionResult']:
        """
        The list of cloud_asm_disk_group_collection.
        """
        return pulumi.get(self, "cloud_asm_disk_group_collections")

    @_builtins.property
    @pulumi.getter(name="cloudAsmId")
    def cloud_asm_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_asm_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudAsmDiskGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "opc_named_credential_id")


class AwaitableGetCloudAsmDiskGroupsResult(GetCloudAsmDiskGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAsmDiskGroupsResult(
            cloud_asm_disk_group_collections=self.cloud_asm_disk_group_collections,
            cloud_asm_id=self.cloud_asm_id,
            filters=self.filters,
            id=self.id,
            opc_named_credential_id=self.opc_named_credential_id)


def get_cloud_asm_disk_groups(cloud_asm_id: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetCloudAsmDiskGroupsFilterArgs', 'GetCloudAsmDiskGroupsFilterArgsDict']]] = None,
                              opc_named_credential_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAsmDiskGroupsResult:
    """
    This data source provides the list of Cloud Asm Disk Groups in Oracle Cloud Infrastructure Database Management service.

    Lists ASM disk groups for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_disk_groups = oci.DatabaseManagement.get_cloud_asm_disk_groups(cloud_asm_id=test_cloud_asm["id"],
        opc_named_credential_id=cloud_asm_disk_group_opc_named_credential_id)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['filters'] = filters
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudAsmDiskGroups:getCloudAsmDiskGroups', __args__, opts=opts, typ=GetCloudAsmDiskGroupsResult).value

    return AwaitableGetCloudAsmDiskGroupsResult(
        cloud_asm_disk_group_collections=pulumi.get(__ret__, 'cloud_asm_disk_group_collections'),
        cloud_asm_id=pulumi.get(__ret__, 'cloud_asm_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'))
def get_cloud_asm_disk_groups_output(cloud_asm_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudAsmDiskGroupsFilterArgs', 'GetCloudAsmDiskGroupsFilterArgsDict']]]]] = None,
                                     opc_named_credential_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAsmDiskGroupsResult]:
    """
    This data source provides the list of Cloud Asm Disk Groups in Oracle Cloud Infrastructure Database Management service.

    Lists ASM disk groups for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_disk_groups = oci.DatabaseManagement.get_cloud_asm_disk_groups(cloud_asm_id=test_cloud_asm["id"],
        opc_named_credential_id=cloud_asm_disk_group_opc_named_credential_id)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['filters'] = filters
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudAsmDiskGroups:getCloudAsmDiskGroups', __args__, opts=opts, typ=GetCloudAsmDiskGroupsResult)
    return __ret__.apply(lambda __response__: GetCloudAsmDiskGroupsResult(
        cloud_asm_disk_group_collections=pulumi.get(__response__, 'cloud_asm_disk_group_collections'),
        cloud_asm_id=pulumi.get(__response__, 'cloud_asm_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        opc_named_credential_id=pulumi.get(__response__, 'opc_named_credential_id')))
