# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudDbSystemDiscoveryResult',
    'AwaitableGetCloudDbSystemDiscoveryResult',
    'get_cloud_db_system_discovery',
    'get_cloud_db_system_discovery_output',
]

@pulumi.output_type
class GetCloudDbSystemDiscoveryResult:
    """
    A collection of values returned by getCloudDbSystemDiscovery.
    """
    def __init__(__self__, agent_id=None, cloud_db_system_discovery_id=None, compartment_id=None, dbaas_parent_infrastructure_id=None, defined_tags=None, deployment_type=None, discovered_components=None, display_name=None, freeform_tags=None, grid_home=None, id=None, lifecycle_details=None, patch_operations=None, resource_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if cloud_db_system_discovery_id and not isinstance(cloud_db_system_discovery_id, str):
            raise TypeError("Expected argument 'cloud_db_system_discovery_id' to be a str")
        pulumi.set(__self__, "cloud_db_system_discovery_id", cloud_db_system_discovery_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dbaas_parent_infrastructure_id and not isinstance(dbaas_parent_infrastructure_id, str):
            raise TypeError("Expected argument 'dbaas_parent_infrastructure_id' to be a str")
        pulumi.set(__self__, "dbaas_parent_infrastructure_id", dbaas_parent_infrastructure_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if discovered_components and not isinstance(discovered_components, list):
            raise TypeError("Expected argument 'discovered_components' to be a list")
        pulumi.set(__self__, "discovered_components", discovered_components)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grid_home and not isinstance(grid_home, str):
            raise TypeError("Expected argument 'grid_home' to be a str")
        pulumi.set(__self__, "grid_home", grid_home)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if patch_operations and not isinstance(patch_operations, list):
            raise TypeError("Expected argument 'patch_operations' to be a list")
        pulumi.set(__self__, "patch_operations", patch_operations)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used for the cloud DB system connector.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemDiscoveryId")
    def cloud_db_system_discovery_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_db_system_discovery_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbaasParentInfrastructureId")
    def dbaas_parent_infrastructure_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent cloud DB Infrastructure. For VM Dbsystems , it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.
        """
        return pulumi.get(self, "dbaas_parent_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        """
        The deployment type of cloud dbsystem.
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="discoveredComponents")
    def discovered_components(self) -> Sequence['outputs.GetCloudDbSystemDiscoveryDiscoveredComponentResult']:
        """
        The list of DB system components that were found in the DB system discovery.
        """
        return pulumi.get(self, "discovered_components")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> _builtins.str:
        """
        The directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system discovery.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetCloudDbSystemDiscoveryPatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the existing Oracle Cloud Infrastructure resource matching the discovered DB system.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the cloud DB system discovery resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the cloud DB system discovery was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the cloud DB system discovery was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCloudDbSystemDiscoveryResult(GetCloudDbSystemDiscoveryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudDbSystemDiscoveryResult(
            agent_id=self.agent_id,
            cloud_db_system_discovery_id=self.cloud_db_system_discovery_id,
            compartment_id=self.compartment_id,
            dbaas_parent_infrastructure_id=self.dbaas_parent_infrastructure_id,
            defined_tags=self.defined_tags,
            deployment_type=self.deployment_type,
            discovered_components=self.discovered_components,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            grid_home=self.grid_home,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            patch_operations=self.patch_operations,
            resource_id=self.resource_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_cloud_db_system_discovery(cloud_db_system_discovery_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudDbSystemDiscoveryResult:
    """
    This data source provides details about a specific Cloud Db System Discovery resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud DB system discovery resource specified by `cloudDbSystemDiscoveryId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_system_discovery = oci.DatabaseManagement.get_cloud_db_system_discovery(cloud_db_system_discovery_id=test_cloud_db_system_discovery_oci_database_management_cloud_db_system_discovery["id"])
    ```


    :param _builtins.str cloud_db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system discovery.
    """
    __args__ = dict()
    __args__['cloudDbSystemDiscoveryId'] = cloud_db_system_discovery_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudDbSystemDiscovery:getCloudDbSystemDiscovery', __args__, opts=opts, typ=GetCloudDbSystemDiscoveryResult).value

    return AwaitableGetCloudDbSystemDiscoveryResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        cloud_db_system_discovery_id=pulumi.get(__ret__, 'cloud_db_system_discovery_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dbaas_parent_infrastructure_id=pulumi.get(__ret__, 'dbaas_parent_infrastructure_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        discovered_components=pulumi.get(__ret__, 'discovered_components'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        grid_home=pulumi.get(__ret__, 'grid_home'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        patch_operations=pulumi.get(__ret__, 'patch_operations'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_cloud_db_system_discovery_output(cloud_db_system_discovery_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudDbSystemDiscoveryResult]:
    """
    This data source provides details about a specific Cloud Db System Discovery resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud DB system discovery resource specified by `cloudDbSystemDiscoveryId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_system_discovery = oci.DatabaseManagement.get_cloud_db_system_discovery(cloud_db_system_discovery_id=test_cloud_db_system_discovery_oci_database_management_cloud_db_system_discovery["id"])
    ```


    :param _builtins.str cloud_db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system discovery.
    """
    __args__ = dict()
    __args__['cloudDbSystemDiscoveryId'] = cloud_db_system_discovery_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudDbSystemDiscovery:getCloudDbSystemDiscovery', __args__, opts=opts, typ=GetCloudDbSystemDiscoveryResult)
    return __ret__.apply(lambda __response__: GetCloudDbSystemDiscoveryResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        cloud_db_system_discovery_id=pulumi.get(__response__, 'cloud_db_system_discovery_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dbaas_parent_infrastructure_id=pulumi.get(__response__, 'dbaas_parent_infrastructure_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        discovered_components=pulumi.get(__response__, 'discovered_components'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        grid_home=pulumi.get(__response__, 'grid_home'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        patch_operations=pulumi.get(__response__, 'patch_operations'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
