# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalDbSystemConnectorsResult',
    'AwaitableGetExternalDbSystemConnectorsResult',
    'get_external_db_system_connectors',
    'get_external_db_system_connectors_output',
]

@pulumi.output_type
class GetExternalDbSystemConnectorsResult:
    """
    A collection of values returned by getExternalDbSystemConnectors.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_db_system_connector_collections=None, external_db_system_id=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_system_connector_collections and not isinstance(external_db_system_connector_collections, list):
            raise TypeError("Expected argument 'external_db_system_connector_collections' to be a list")
        pulumi.set(__self__, "external_db_system_connector_collections", external_db_system_connector_collections)
        if external_db_system_id and not isinstance(external_db_system_id, str):
            raise TypeError("Expected argument 'external_db_system_id' to be a str")
        pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the external connector. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalDbSystemConnectorCollections")
    def external_db_system_connector_collections(self) -> Sequence['outputs.GetExternalDbSystemConnectorsExternalDbSystemConnectorCollectionResult']:
        """
        The list of external_db_system_connector_collection.
        """
        return pulumi.get(self, "external_db_system_connector_collections")

    @_builtins.property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the connector is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalDbSystemConnectorsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalDbSystemConnectorsResult(GetExternalDbSystemConnectorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbSystemConnectorsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_db_system_connector_collections=self.external_db_system_connector_collections,
            external_db_system_id=self.external_db_system_id,
            filters=self.filters,
            id=self.id)


def get_external_db_system_connectors(compartment_id: Optional[_builtins.str] = None,
                                      display_name: Optional[_builtins.str] = None,
                                      external_db_system_id: Optional[_builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetExternalDbSystemConnectorsFilterArgs', 'GetExternalDbSystemConnectorsFilterArgsDict']]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbSystemConnectorsResult:
    """
    This data source provides the list of External Db System Connectors in Oracle Cloud Infrastructure Database Management service.

    Lists the external connectors in the specified external DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_connectors = oci.DatabaseManagement.get_external_db_system_connectors(compartment_id=compartment_id,
        display_name=external_db_system_connector_display_name,
        external_db_system_id=test_external_db_system["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    :param _builtins.str external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalDbSystemId'] = external_db_system_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbSystemConnectors:getExternalDbSystemConnectors', __args__, opts=opts, typ=GetExternalDbSystemConnectorsResult).value

    return AwaitableGetExternalDbSystemConnectorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_system_connector_collections=pulumi.get(__ret__, 'external_db_system_connector_collections'),
        external_db_system_id=pulumi.get(__ret__, 'external_db_system_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_external_db_system_connectors_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             external_db_system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExternalDbSystemConnectorsFilterArgs', 'GetExternalDbSystemConnectorsFilterArgsDict']]]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalDbSystemConnectorsResult]:
    """
    This data source provides the list of External Db System Connectors in Oracle Cloud Infrastructure Database Management service.

    Lists the external connectors in the specified external DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_connectors = oci.DatabaseManagement.get_external_db_system_connectors(compartment_id=compartment_id,
        display_name=external_db_system_connector_display_name,
        external_db_system_id=test_external_db_system["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    :param _builtins.str external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalDbSystemId'] = external_db_system_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalDbSystemConnectors:getExternalDbSystemConnectors', __args__, opts=opts, typ=GetExternalDbSystemConnectorsResult)
    return __ret__.apply(lambda __response__: GetExternalDbSystemConnectorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_db_system_connector_collections=pulumi.get(__response__, 'external_db_system_connector_collections'),
        external_db_system_id=pulumi.get(__response__, 'external_db_system_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
