# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalListenerResult',
    'AwaitableGetExternalListenerResult',
    'get_external_listener',
    'get_external_listener_output',
]

@pulumi.output_type
class GetExternalListenerResult:
    """
    A collection of values returned by getExternalListener.
    """
    def __init__(__self__, additional_details=None, adr_home_directory=None, compartment_id=None, component_name=None, defined_tags=None, display_name=None, endpoints=None, external_connector_id=None, external_db_home_id=None, external_db_node_id=None, external_db_system_id=None, external_listener_id=None, freeform_tags=None, host_name=None, id=None, lifecycle_details=None, listener_alias=None, listener_ora_location=None, listener_type=None, log_directory=None, oracle_home=None, serviced_asms=None, serviced_databases=None, state=None, system_tags=None, time_created=None, time_updated=None, trace_directory=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if adr_home_directory and not isinstance(adr_home_directory, str):
            raise TypeError("Expected argument 'adr_home_directory' to be a str")
        pulumi.set(__self__, "adr_home_directory", adr_home_directory)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name and not isinstance(component_name, str):
            raise TypeError("Expected argument 'component_name' to be a str")
        pulumi.set(__self__, "component_name", component_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if external_connector_id and not isinstance(external_connector_id, str):
            raise TypeError("Expected argument 'external_connector_id' to be a str")
        pulumi.set(__self__, "external_connector_id", external_connector_id)
        if external_db_home_id and not isinstance(external_db_home_id, str):
            raise TypeError("Expected argument 'external_db_home_id' to be a str")
        pulumi.set(__self__, "external_db_home_id", external_db_home_id)
        if external_db_node_id and not isinstance(external_db_node_id, str):
            raise TypeError("Expected argument 'external_db_node_id' to be a str")
        pulumi.set(__self__, "external_db_node_id", external_db_node_id)
        if external_db_system_id and not isinstance(external_db_system_id, str):
            raise TypeError("Expected argument 'external_db_system_id' to be a str")
        pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if external_listener_id and not isinstance(external_listener_id, str):
            raise TypeError("Expected argument 'external_listener_id' to be a str")
        pulumi.set(__self__, "external_listener_id", external_listener_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_alias and not isinstance(listener_alias, str):
            raise TypeError("Expected argument 'listener_alias' to be a str")
        pulumi.set(__self__, "listener_alias", listener_alias)
        if listener_ora_location and not isinstance(listener_ora_location, str):
            raise TypeError("Expected argument 'listener_ora_location' to be a str")
        pulumi.set(__self__, "listener_ora_location", listener_ora_location)
        if listener_type and not isinstance(listener_type, str):
            raise TypeError("Expected argument 'listener_type' to be a str")
        pulumi.set(__self__, "listener_type", listener_type)
        if log_directory and not isinstance(log_directory, str):
            raise TypeError("Expected argument 'log_directory' to be a str")
        pulumi.set(__self__, "log_directory", log_directory)
        if oracle_home and not isinstance(oracle_home, str):
            raise TypeError("Expected argument 'oracle_home' to be a str")
        pulumi.set(__self__, "oracle_home", oracle_home)
        if serviced_asms and not isinstance(serviced_asms, list):
            raise TypeError("Expected argument 'serviced_asms' to be a list")
        pulumi.set(__self__, "serviced_asms", serviced_asms)
        if serviced_databases and not isinstance(serviced_databases, list):
            raise TypeError("Expected argument 'serviced_databases' to be a list")
        pulumi.set(__self__, "serviced_databases", serviced_databases)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if trace_directory and not isinstance(trace_directory, str):
            raise TypeError("Expected argument 'trace_directory' to be a str")
        pulumi.set(__self__, "trace_directory", trace_directory)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, _builtins.str]:
        """
        The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @_builtins.property
    @pulumi.getter(name="adrHomeDirectory")
    def adr_home_directory(self) -> _builtins.str:
        """
        The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        """
        return pulumi.get(self, "adr_home_directory")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="componentName")
    def component_name(self) -> _builtins.str:
        """
        The name of the external listener.
        """
        return pulumi.get(self, "component_name")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetExternalListenerEndpointResult']:
        """
        The list of protocol addresses the listener is configured to listen on.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @_builtins.property
    @pulumi.getter(name="externalDbHomeId")
    def external_db_home_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        """
        return pulumi.get(self, "external_db_home_id")

    @_builtins.property
    @pulumi.getter(name="externalDbNodeId")
    def external_db_node_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        """
        return pulumi.get(self, "external_db_node_id")

    @_builtins.property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @_builtins.property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> _builtins.str:
        return pulumi.get(self, "external_listener_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        The name of the host on which the external listener is running.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="listenerAlias")
    def listener_alias(self) -> _builtins.str:
        """
        The listener alias.
        """
        return pulumi.get(self, "listener_alias")

    @_builtins.property
    @pulumi.getter(name="listenerOraLocation")
    def listener_ora_location(self) -> _builtins.str:
        """
        The location of the listener configuration file listener.ora.
        """
        return pulumi.get(self, "listener_ora_location")

    @_builtins.property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> _builtins.str:
        """
        The type of listener.
        """
        return pulumi.get(self, "listener_type")

    @_builtins.property
    @pulumi.getter(name="logDirectory")
    def log_directory(self) -> _builtins.str:
        """
        The destination directory of the listener log file.
        """
        return pulumi.get(self, "log_directory")

    @_builtins.property
    @pulumi.getter(name="oracleHome")
    def oracle_home(self) -> _builtins.str:
        """
        The Oracle home location of the listener.
        """
        return pulumi.get(self, "oracle_home")

    @_builtins.property
    @pulumi.getter(name="servicedAsms")
    def serviced_asms(self) -> Sequence['outputs.GetExternalListenerServicedAsmResult']:
        """
        The list of ASMs that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_asms")

    @_builtins.property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> Sequence['outputs.GetExternalListenerServicedDatabaseResult']:
        """
        The list of databases that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_databases")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the external listener.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the external listener was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the external listener was last updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="traceDirectory")
    def trace_directory(self) -> _builtins.str:
        """
        The destination directory of the listener trace file.
        """
        return pulumi.get(self, "trace_directory")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The listener version.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalListenerResult(GetExternalListenerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalListenerResult(
            additional_details=self.additional_details,
            adr_home_directory=self.adr_home_directory,
            compartment_id=self.compartment_id,
            component_name=self.component_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            endpoints=self.endpoints,
            external_connector_id=self.external_connector_id,
            external_db_home_id=self.external_db_home_id,
            external_db_node_id=self.external_db_node_id,
            external_db_system_id=self.external_db_system_id,
            external_listener_id=self.external_listener_id,
            freeform_tags=self.freeform_tags,
            host_name=self.host_name,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            listener_alias=self.listener_alias,
            listener_ora_location=self.listener_ora_location,
            listener_type=self.listener_type,
            log_directory=self.log_directory,
            oracle_home=self.oracle_home,
            serviced_asms=self.serviced_asms,
            serviced_databases=self.serviced_databases,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            trace_directory=self.trace_directory,
            version=self.version)


def get_external_listener(external_listener_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalListenerResult:
    """
    This data source provides details about a specific External Listener resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external listener specified by `externalListenerId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener = oci.DatabaseManagement.get_external_listener(external_listener_id=test_external_listener_oci_database_management_external_listener["id"])
    ```


    :param _builtins.str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    """
    __args__ = dict()
    __args__['externalListenerId'] = external_listener_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalListener:getExternalListener', __args__, opts=opts, typ=GetExternalListenerResult).value

    return AwaitableGetExternalListenerResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        adr_home_directory=pulumi.get(__ret__, 'adr_home_directory'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_name=pulumi.get(__ret__, 'component_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        external_connector_id=pulumi.get(__ret__, 'external_connector_id'),
        external_db_home_id=pulumi.get(__ret__, 'external_db_home_id'),
        external_db_node_id=pulumi.get(__ret__, 'external_db_node_id'),
        external_db_system_id=pulumi.get(__ret__, 'external_db_system_id'),
        external_listener_id=pulumi.get(__ret__, 'external_listener_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        listener_alias=pulumi.get(__ret__, 'listener_alias'),
        listener_ora_location=pulumi.get(__ret__, 'listener_ora_location'),
        listener_type=pulumi.get(__ret__, 'listener_type'),
        log_directory=pulumi.get(__ret__, 'log_directory'),
        oracle_home=pulumi.get(__ret__, 'oracle_home'),
        serviced_asms=pulumi.get(__ret__, 'serviced_asms'),
        serviced_databases=pulumi.get(__ret__, 'serviced_databases'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        trace_directory=pulumi.get(__ret__, 'trace_directory'),
        version=pulumi.get(__ret__, 'version'))
def get_external_listener_output(external_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalListenerResult]:
    """
    This data source provides details about a specific External Listener resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external listener specified by `externalListenerId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener = oci.DatabaseManagement.get_external_listener(external_listener_id=test_external_listener_oci_database_management_external_listener["id"])
    ```


    :param _builtins.str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    """
    __args__ = dict()
    __args__['externalListenerId'] = external_listener_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalListener:getExternalListener', __args__, opts=opts, typ=GetExternalListenerResult)
    return __ret__.apply(lambda __response__: GetExternalListenerResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        adr_home_directory=pulumi.get(__response__, 'adr_home_directory'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        component_name=pulumi.get(__response__, 'component_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        external_connector_id=pulumi.get(__response__, 'external_connector_id'),
        external_db_home_id=pulumi.get(__response__, 'external_db_home_id'),
        external_db_node_id=pulumi.get(__response__, 'external_db_node_id'),
        external_db_system_id=pulumi.get(__response__, 'external_db_system_id'),
        external_listener_id=pulumi.get(__response__, 'external_listener_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        listener_alias=pulumi.get(__response__, 'listener_alias'),
        listener_ora_location=pulumi.get(__response__, 'listener_ora_location'),
        listener_type=pulumi.get(__response__, 'listener_type'),
        log_directory=pulumi.get(__response__, 'log_directory'),
        oracle_home=pulumi.get(__response__, 'oracle_home'),
        serviced_asms=pulumi.get(__response__, 'serviced_asms'),
        serviced_databases=pulumi.get(__response__, 'serviced_databases'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        trace_directory=pulumi.get(__response__, 'trace_directory'),
        version=pulumi.get(__response__, 'version')))
