# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CatalogLock',
    'CatalogPrivateEndpointLock',
    'MetastoreLock',
    'GetCatalogLockResult',
    'GetCatalogPrivateEndpointLockResult',
    'GetCatalogPrivateEndpointsCatalogPrivateEndpointResult',
    'GetCatalogPrivateEndpointsCatalogPrivateEndpointLockResult',
    'GetCatalogPrivateEndpointsFilterResult',
    'GetCatalogTypesFilterResult',
    'GetCatalogTypesTypeCollectionResult',
    'GetCatalogTypesTypeCollectionItemResult',
    'GetCatalogsCatalogResult',
    'GetCatalogsCatalogLockResult',
    'GetCatalogsFilterResult',
    'GetConnectionsConnectionCollectionResult',
    'GetConnectionsConnectionCollectionItemResult',
    'GetConnectionsFilterResult',
    'GetDataAssetsDataAssetCollectionResult',
    'GetDataAssetsDataAssetCollectionItemResult',
    'GetDataAssetsFilterResult',
    'GetMetastoreLockResult',
    'GetMetastoresFilterResult',
    'GetMetastoresMetastoreResult',
    'GetMetastoresMetastoreLockResult',
]

@pulumi.output_type
class CatalogLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CatalogPrivateEndpointLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogPrivateEndpointLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogPrivateEndpointLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogPrivateEndpointLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetastoreLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCatalogLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCatalogPrivateEndpointLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCatalogPrivateEndpointsCatalogPrivateEndpointResult(dict):
    def __init__(__self__, *,
                 attached_catalogs: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 dns_zones: Sequence[_builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetCatalogPrivateEndpointsCatalogPrivateEndpointLockResult'],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param Sequence[_builtins.str] attached_catalogs: The list of catalogs using the private reverse connection endpoint
        :param _builtins.str compartment_id: The OCID of the compartment where you want to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
        :param Sequence[_builtins.str] dns_zones: List of DNS zones to be used by the data assets to be harvested. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: Unique identifier that is immutable
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param Sequence['GetCatalogPrivateEndpointsCatalogPrivateEndpointLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param _builtins.str subnet_id: Subnet Identifier
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "attached_catalogs", attached_catalogs)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_zones", dns_zones)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="attachedCatalogs")
    def attached_catalogs(self) -> Sequence[_builtins.str]:
        """
        The list of catalogs using the private reverse connection endpoint
        """
        return pulumi.get(self, "attached_catalogs")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where you want to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[_builtins.str]:
        """
        List of DNS zones to be used by the data assets to be harvested. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        """
        return pulumi.get(self, "dns_zones")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetCatalogPrivateEndpointsCatalogPrivateEndpointLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetCatalogPrivateEndpointsCatalogPrivateEndpointLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCatalogPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCatalogTypesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Immutable resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Immutable resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCatalogTypesTypeCollectionResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 items: Sequence['outputs.GetCatalogTypesTypeCollectionItemResult']):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetCatalogTypesTypeCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetCatalogTypesTypeCollectionItemResult(dict):
    def __init__(__self__, *,
                 catalog_id: _builtins.str,
                 description: _builtins.str,
                 key: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str,
                 type_category: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str catalog_id: Unique catalog identifier.
        :param _builtins.str description: Detailed description of the type.
        :param _builtins.str key: Unique type key that is immutable.
        :param _builtins.str name: Immutable resource name.
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param _builtins.str type_category: Indicates the category of this type . For example, data assets or connections.
        :param _builtins.str uri: URI to the type instance in the API.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type_category", type_category)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> _builtins.str:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Detailed description of the type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Unique type key that is immutable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Immutable resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="typeCategory")
    def type_category(self) -> _builtins.str:
        """
        Indicates the category of this type . For example, data assets or connections.
        """
        return pulumi.get(self, "type_category")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        URI to the type instance in the API.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetCatalogsCatalogResult(dict):
    def __init__(__self__, *,
                 attached_catalog_private_endpoints: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetCatalogsCatalogLockResult'],
                 number_of_objects: _builtins.int,
                 service_api_url: _builtins.str,
                 service_console_url: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param Sequence[_builtins.str] attached_catalog_private_endpoints: The list of private reverse connection endpoints attached to the catalog
        :param _builtins.str compartment_id: The OCID of the compartment where you want to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str lifecycle_details: An message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in 'Failed' state.
        :param Sequence['GetCatalogsCatalogLockArgs'] locks: Locks associated with this resource.
        :param _builtins.int number_of_objects: The number of data objects added to the data catalog. Please see the data catalog documentation for further information on how this is calculated.
        :param _builtins.str service_api_url: The REST front endpoint URL to the data catalog instance.
        :param _builtins.str service_console_url: The console front endpoint URL to the data catalog instance.
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: The time the data catalog was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "attached_catalog_private_endpoints", attached_catalog_private_endpoints)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "number_of_objects", number_of_objects)
        pulumi.set(__self__, "service_api_url", service_api_url)
        pulumi.set(__self__, "service_console_url", service_console_url)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="attachedCatalogPrivateEndpoints")
    def attached_catalog_private_endpoints(self) -> Sequence[_builtins.str]:
        """
        The list of private reverse connection endpoints attached to the catalog
        """
        return pulumi.get(self, "attached_catalog_private_endpoints")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where you want to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        An message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetCatalogsCatalogLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter(name="numberOfObjects")
    def number_of_objects(self) -> _builtins.int:
        """
        The number of data objects added to the data catalog. Please see the data catalog documentation for further information on how this is calculated.
        """
        return pulumi.get(self, "number_of_objects")

    @_builtins.property
    @pulumi.getter(name="serviceApiUrl")
    def service_api_url(self) -> _builtins.str:
        """
        The REST front endpoint URL to the data catalog instance.
        """
        return pulumi.get(self, "service_api_url")

    @_builtins.property
    @pulumi.getter(name="serviceConsoleUrl")
    def service_console_url(self) -> _builtins.str:
        """
        The console front endpoint URL to the data catalog instance.
        """
        return pulumi.get(self, "service_console_url")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the data catalog was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetCatalogsCatalogLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCatalogsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetConnectionsConnectionCollectionResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 items: Sequence['outputs.GetConnectionsConnectionCollectionItemResult']):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemResult(dict):
    def __init__(__self__, *,
                 catalog_id: _builtins.str,
                 created_by_id: _builtins.str,
                 data_asset_key: _builtins.str,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 external_key: _builtins.str,
                 is_default: _builtins.bool,
                 key: _builtins.str,
                 properties: Mapping[str, _builtins.str],
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_status_updated: _builtins.str,
                 time_updated: _builtins.str,
                 type_key: _builtins.str,
                 updated_by_id: _builtins.str,
                 uri: _builtins.str,
                 enc_properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str catalog_id: Unique catalog identifier.
        :param _builtins.str created_by_id: OCID of the user who created the resource.
        :param _builtins.str data_asset_key: Unique data asset key.
        :param _builtins.str description: A description of the connection.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
        :param _builtins.str external_key: Unique external identifier of this resource in the external source system.
        :param _builtins.bool is_default: Indicates whether this connection is the default connection.
        :param _builtins.str key: Unique connection key that is immutable.
        :param Mapping[str, _builtins.str] properties: A map of maps that contains the properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. Example: `{"properties": { "default": { "username": "user1"}}}`
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param _builtins.str time_created: Time that the resource was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_status_updated: Time that the resource's status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: Time that the resource was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type_key: The key of the object type. Type key's can be found via the '/types' endpoint.
        :param _builtins.str updated_by_id: OCID of the user who updated the resource.
        :param _builtins.str uri: URI to the connection instance in the API.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "created_by_id", created_by_id)
        pulumi.set(__self__, "data_asset_key", data_asset_key)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_key", external_key)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_status_updated", time_status_updated)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type_key", type_key)
        pulumi.set(__self__, "updated_by_id", updated_by_id)
        pulumi.set(__self__, "uri", uri)
        if enc_properties is not None:
            pulumi.set(__self__, "enc_properties", enc_properties)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> _builtins.str:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> _builtins.str:
        """
        OCID of the user who created the resource.
        """
        return pulumi.get(self, "created_by_id")

    @_builtins.property
    @pulumi.getter(name="dataAssetKey")
    def data_asset_key(self) -> _builtins.str:
        """
        Unique data asset key.
        """
        return pulumi.get(self, "data_asset_key")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> _builtins.str:
        """
        Unique external identifier of this resource in the external source system.
        """
        return pulumi.get(self, "external_key")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Indicates whether this connection is the default connection.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Unique connection key that is immutable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Mapping[str, _builtins.str]:
        """
        A map of maps that contains the properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. Example: `{"properties": { "default": { "username": "user1"}}}`
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time that the resource was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> _builtins.str:
        """
        Time that the resource's status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_status_updated")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time that the resource was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> _builtins.str:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.
        """
        return pulumi.get(self, "type_key")

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> _builtins.str:
        """
        OCID of the user who updated the resource.
        """
        return pulumi.get(self, "updated_by_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        URI to the connection instance in the API.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="encProperties")
    def enc_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "enc_properties")


@pulumi.output_type
class GetConnectionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDataAssetsDataAssetCollectionResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 items: Sequence['outputs.GetDataAssetsDataAssetCollectionItemResult']):
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDataAssetsDataAssetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDataAssetsDataAssetCollectionItemResult(dict):
    def __init__(__self__, *,
                 catalog_id: _builtins.str,
                 created_by_id: _builtins.str,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 external_key: _builtins.str,
                 key: _builtins.str,
                 lifecycle_details: _builtins.str,
                 properties: Mapping[str, _builtins.str],
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_harvested: _builtins.str,
                 time_updated: _builtins.str,
                 type_key: _builtins.str,
                 updated_by_id: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str catalog_id: Unique catalog identifier.
        :param _builtins.str created_by_id: OCID of the user who created the resource.
        :param _builtins.str description: Detailed description of the data asset.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
        :param _builtins.str external_key: Unique external identifier of this resource in the external source system.
        :param _builtins.str key: Unique data asset key that is immutable.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        :param Mapping[str, _builtins.str] properties: A map of maps that contains the properties which are specific to the asset type. Each data asset type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most data assets have required properties within the "default" category. Example: `{"properties": { "default": { "host": "host1", "port": "1521", "database": "orcl"}}}`
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param _builtins.str time_created: Time that the resource was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_harvested: The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: Time that the resource was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type_key: The key of the object type.
        :param _builtins.str updated_by_id: OCID of the user who updated the resource.
        :param _builtins.str uri: URI to the data asset instance in the API.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "created_by_id", created_by_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_key", external_key)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_harvested", time_harvested)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type_key", type_key)
        pulumi.set(__self__, "updated_by_id", updated_by_id)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> _builtins.str:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> _builtins.str:
        """
        OCID of the user who created the resource.
        """
        return pulumi.get(self, "created_by_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Detailed description of the data asset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> _builtins.str:
        """
        Unique external identifier of this resource in the external source system.
        """
        return pulumi.get(self, "external_key")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Unique data asset key that is immutable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Mapping[str, _builtins.str]:
        """
        A map of maps that contains the properties which are specific to the asset type. Each data asset type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most data assets have required properties within the "default" category. Example: `{"properties": { "default": { "host": "host1", "port": "1521", "database": "orcl"}}}`
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time that the resource was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeHarvested")
    def time_harvested(self) -> _builtins.str:
        """
        The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_harvested")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time that the resource was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> _builtins.str:
        """
        The key of the object type.
        """
        return pulumi.get(self, "type_key")

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> _builtins.str:
        """
        OCID of the user who updated the resource.
        """
        return pulumi.get(self, "updated_by_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        URI to the data asset instance in the API.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDataAssetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMetastoreLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMetastoresFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMetastoresMetastoreResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 default_external_table_location: _builtins.str,
                 default_managed_table_location: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 locks: Sequence['outputs.GetMetastoresMetastoreLockResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment where you want to list resources.
        :param _builtins.str default_external_table_location: Location under which external tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        :param _builtins.str default_managed_table_location: Location under which managed tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The metastore's OCID.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetMetastoresMetastoreLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: Time at which the metastore was last modified. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "default_external_table_location", default_external_table_location)
        pulumi.set(__self__, "default_managed_table_location", default_managed_table_location)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where you want to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="defaultExternalTableLocation")
    def default_external_table_location(self) -> _builtins.str:
        """
        Location under which external tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        """
        return pulumi.get(self, "default_external_table_location")

    @_builtins.property
    @pulumi.getter(name="defaultManagedTableLocation")
    def default_managed_table_location(self) -> _builtins.str:
        """
        Location under which managed tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        """
        return pulumi.get(self, "default_managed_table_location")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The metastore's OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetMetastoresMetastoreLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time at which the metastore was last modified. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMetastoresMetastoreLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The id of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


