# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApplicationApplicationLogConfigArgs',
    'ApplicationApplicationLogConfigArgsDict',
    'ApplicationDriverShapeConfigArgs',
    'ApplicationDriverShapeConfigArgsDict',
    'ApplicationExecutorShapeConfigArgs',
    'ApplicationExecutorShapeConfigArgsDict',
    'ApplicationParameterArgs',
    'ApplicationParameterArgsDict',
    'InvokeRunApplicationLogConfigArgs',
    'InvokeRunApplicationLogConfigArgsDict',
    'InvokeRunDriverShapeConfigArgs',
    'InvokeRunDriverShapeConfigArgsDict',
    'InvokeRunExecutorShapeConfigArgs',
    'InvokeRunExecutorShapeConfigArgsDict',
    'InvokeRunParameterArgs',
    'InvokeRunParameterArgsDict',
    'PoolConfigurationArgs',
    'PoolConfigurationArgsDict',
    'PoolConfigurationShapeConfigArgs',
    'PoolConfigurationShapeConfigArgsDict',
    'PoolPoolMetricArgs',
    'PoolPoolMetricArgsDict',
    'PoolPoolMetricActivelyUsedNodeCountArgs',
    'PoolPoolMetricActivelyUsedNodeCountArgsDict',
    'PoolScheduleArgs',
    'PoolScheduleArgsDict',
    'PrivateEndpointScanDetailArgs',
    'PrivateEndpointScanDetailArgsDict',
    'RunStatementOutputArgs',
    'RunStatementOutputArgsDict',
    'RunStatementOutputDataArgs',
    'RunStatementOutputDataArgsDict',
    'SqlEndpointDriverShapeConfigArgs',
    'SqlEndpointDriverShapeConfigArgsDict',
    'SqlEndpointExecutorShapeConfigArgs',
    'SqlEndpointExecutorShapeConfigArgsDict',
    'SqlEndpointNetworkConfigurationArgs',
    'SqlEndpointNetworkConfigurationArgsDict',
    'SqlEndpointNetworkConfigurationAccessControlRuleArgs',
    'SqlEndpointNetworkConfigurationAccessControlRuleArgsDict',
    'GetApplicationsFilterArgs',
    'GetApplicationsFilterArgsDict',
    'GetInvokeRunsFilterArgs',
    'GetInvokeRunsFilterArgsDict',
    'GetPoolsFilterArgs',
    'GetPoolsFilterArgsDict',
    'GetPrivateEndpointsFilterArgs',
    'GetPrivateEndpointsFilterArgsDict',
    'GetRunLogsFilterArgs',
    'GetRunLogsFilterArgsDict',
    'GetRunStatementsFilterArgs',
    'GetRunStatementsFilterArgsDict',
    'GetSqlEndpointsFilterArgs',
    'GetSqlEndpointsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationApplicationLogConfigArgsDict(TypedDict):
        log_group_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        log_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
elif False:
    ApplicationApplicationLogConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationApplicationLogConfigArgs:
    def __init__(__self__, *,
                 log_group_id: pulumi.Input[_builtins.str],
                 log_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] log_group_id: (Updatable) The log group id for where log objects will be for Data Flow Runs.
        :param pulumi.Input[_builtins.str] log_id: (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")

    @log_id.setter
    def log_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_id", value)


if not MYPY:
    class ApplicationDriverShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    ApplicationDriverShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class ApplicationExecutorShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    ApplicationExecutorShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class ApplicationParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        value: pulumi.Input[_builtins.str]
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
elif False:
    ApplicationParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param pulumi.Input[_builtins.str] value: (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class InvokeRunApplicationLogConfigArgsDict(TypedDict):
        log_group_id: pulumi.Input[_builtins.str]
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        log_id: pulumi.Input[_builtins.str]
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
elif False:
    InvokeRunApplicationLogConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InvokeRunApplicationLogConfigArgs:
    def __init__(__self__, *,
                 log_group_id: pulumi.Input[_builtins.str],
                 log_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param pulumi.Input[_builtins.str] log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> pulumi.Input[_builtins.str]:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")

    @log_id.setter
    def log_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_id", value)


if not MYPY:
    class InvokeRunDriverShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    InvokeRunDriverShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InvokeRunDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class InvokeRunExecutorShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    InvokeRunExecutorShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InvokeRunExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class InvokeRunParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        value: pulumi.Input[_builtins.str]
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
elif False:
    InvokeRunParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InvokeRunParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param pulumi.Input[_builtins.str] value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class PoolConfigurationArgsDict(TypedDict):
        max: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        min: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        shape: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        shape_config: NotRequired[pulumi.Input['PoolConfigurationShapeConfigArgsDict']]
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
elif False:
    PoolConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolConfigurationArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[_builtins.int]] = None,
                 min: Optional[pulumi.Input[_builtins.int]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_config: Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.int] max: (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        :param pulumi.Input[_builtins.int] min: (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        :param pulumi.Input[_builtins.str] shape: (Updatable) The compute shape of the resources you would like to provision.
        :param pulumi.Input['PoolConfigurationShapeConfigArgs'] shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max", value)

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)


if not MYPY:
    class PoolConfigurationShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    PoolConfigurationShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolConfigurationShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class PoolPoolMetricArgsDict(TypedDict):
        active_runs_count: NotRequired[pulumi.Input[_builtins.str]]
        """
        The number of runs that are currently running that are using this pool.
        """
        actively_used_node_counts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgsDict']]]]
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        time_last_metrics_updated: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last time the mertics were updated for this.
        """
        time_last_started: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last time this pool was started.
        """
        time_last_stopped: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last time this pool was stopped.
        """
        time_last_used: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last time a run used this pool.
        """
elif False:
    PoolPoolMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolPoolMetricArgs:
    def __init__(__self__, *,
                 active_runs_count: Optional[pulumi.Input[_builtins.str]] = None,
                 actively_used_node_counts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]] = None,
                 time_last_metrics_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_started: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_stopped: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_used: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] active_runs_count: The number of runs that are currently running that are using this pool.
        :param pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param pulumi.Input[_builtins.str] time_last_metrics_updated: The last time the mertics were updated for this.
        :param pulumi.Input[_builtins.str] time_last_started: The last time this pool was started.
        :param pulumi.Input[_builtins.str] time_last_stopped: The last time this pool was stopped.
        :param pulumi.Input[_builtins.str] time_last_used: The last time a run used this pool.
        """
        if active_runs_count is not None:
            pulumi.set(__self__, "active_runs_count", active_runs_count)
        if actively_used_node_counts is not None:
            pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        if time_last_metrics_updated is not None:
            pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        if time_last_started is not None:
            pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped is not None:
            pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_last_used is not None:
            pulumi.set(__self__, "time_last_used", time_last_used)

    @_builtins.property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @active_runs_count.setter
    def active_runs_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "active_runs_count", value)

    @_builtins.property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]]:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @actively_used_node_counts.setter
    def actively_used_node_counts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]]):
        pulumi.set(self, "actively_used_node_counts", value)

    @_builtins.property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @time_last_metrics_updated.setter
    def time_last_metrics_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_metrics_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @time_last_started.setter
    def time_last_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_started", value)

    @_builtins.property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @time_last_stopped.setter
    def time_last_stopped(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_stopped", value)

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")

    @time_last_used.setter
    def time_last_used(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_used", value)


if not MYPY:
    class PoolPoolMetricActivelyUsedNodeCountArgsDict(TypedDict):
        logical_shape: NotRequired[pulumi.Input[_builtins.str]]
        """
        The compute shape of the nodes that the count is for.
        """
        pool_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The node count of this compute shape.
        """
elif False:
    PoolPoolMetricActivelyUsedNodeCountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolPoolMetricActivelyUsedNodeCountArgs:
    def __init__(__self__, *,
                 logical_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] logical_shape: The compute shape of the nodes that the count is for.
        :param pulumi.Input[_builtins.int] pool_count: The node count of this compute shape.
        """
        if logical_shape is not None:
            pulumi.set(__self__, "logical_shape", logical_shape)
        if pool_count is not None:
            pulumi.set(__self__, "pool_count", pool_count)

    @_builtins.property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @logical_shape.setter
    def logical_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logical_shape", value)

    @_builtins.property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")

    @pool_count.setter
    def pool_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pool_count", value)


if not MYPY:
    class PoolScheduleArgsDict(TypedDict):
        day_of_week: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Day of the week SUN-SAT
        """
        start_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        stop_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) Hour of the day to stop the pool.
        """
elif False:
    PoolScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] day_of_week: (Updatable) Day of the week SUN-SAT
        :param pulumi.Input[_builtins.int] start_time: (Updatable) Hour of the day to start or stop pool.
        :param pulumi.Input[_builtins.int] stop_time: (Updatable) Hour of the day to stop the pool.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if stop_time is not None:
            pulumi.set(__self__, "stop_time", stop_time)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")

    @stop_time.setter
    def stop_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_time", value)


if not MYPY:
    class PrivateEndpointScanDetailArgsDict(TypedDict):
        fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The port number of the FQDN
        """
elif False:
    PrivateEndpointScanDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateEndpointScanDetailArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] fqdn: (Updatable) A fully-qualified domain name (FQDN).
        :param pulumi.Input[_builtins.str] port: (Updatable) The port number of the FQDN
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The port number of the FQDN
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class RunStatementOutputArgsDict(TypedDict):
        datas: NotRequired[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgsDict']]]]
        """
        An object representing execution output of a statement.
        """
        error_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the error in the statement output.
        """
        error_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the error in the statement output.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Status of the statement output.
        """
        tracebacks: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The traceback of the statement output.
        """
elif False:
    RunStatementOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunStatementOutputArgs:
    def __init__(__self__, *,
                 datas: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]] = None,
                 error_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_value: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tracebacks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]] datas: An object representing execution output of a statement.
        :param pulumi.Input[_builtins.str] error_name: The name of the error in the statement output.
        :param pulumi.Input[_builtins.str] error_value: The value of the error in the statement output.
        :param pulumi.Input[_builtins.str] status: Status of the statement output.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tracebacks: The traceback of the statement output.
        """
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if error_name is not None:
            pulumi.set(__self__, "error_name", error_name)
        if error_value is not None:
            pulumi.set(__self__, "error_value", error_value)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tracebacks is not None:
            pulumi.set(__self__, "tracebacks", tracebacks)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]]:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]]):
        pulumi.set(self, "datas", value)

    @_builtins.property
    @pulumi.getter(name="errorName")
    def error_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @error_name.setter
    def error_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_name", value)

    @_builtins.property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @error_value.setter
    def error_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_value", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tracebacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")

    @tracebacks.setter
    def tracebacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tracebacks", value)


if not MYPY:
    class RunStatementOutputDataArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The statement code execution output in html format.
        """
elif False:
    RunStatementOutputDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RunStatementOutputDataArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param pulumi.Input[_builtins.str] value: The statement code execution output in html format.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class SqlEndpointDriverShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    SqlEndpointDriverShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlEndpointDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class SqlEndpointExecutorShapeConfigArgsDict(TypedDict):
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of memory used for the driver or executors.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.float]]
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
elif False:
    SqlEndpointExecutorShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlEndpointExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[_builtins.float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class SqlEndpointNetworkConfigurationArgsDict(TypedDict):
        network_type: pulumi.Input[_builtins.str]
        """
        The type of network configuration.
        """
        access_control_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgsDict']]]]
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        host_name_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The host name prefix.
        """
        nsg_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        private_endpoint_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip Address of private endpoint
        """
        public_endpoint_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip Address of public endpoint
        """
        subnet_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VCN Subnet OCID.
        """
        vcn_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VCN OCID.
        """
elif False:
    SqlEndpointNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlEndpointNetworkConfigurationArgs:
    def __init__(__self__, *,
                 network_type: pulumi.Input[_builtins.str],
                 access_control_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]] = None,
                 host_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] network_type: The type of network configuration.
        :param pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param pulumi.Input[_builtins.str] host_name_prefix: The host name prefix.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param pulumi.Input[_builtins.str] private_endpoint_ip: Ip Address of private endpoint
        :param pulumi.Input[_builtins.str] public_endpoint_ip: Ip Address of public endpoint
        :param pulumi.Input[_builtins.str] subnet_id: The VCN Subnet OCID.
        :param pulumi.Input[_builtins.str] vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "network_type", network_type)
        if access_control_rules is not None:
            pulumi.set(__self__, "access_control_rules", access_control_rules)
        if host_name_prefix is not None:
            pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if public_endpoint_ip is not None:
            pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]]:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @access_control_rules.setter
    def access_control_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]]):
        pulumi.set(self, "access_control_rules", value)

    @_builtins.property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @host_name_prefix.setter
    def host_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @public_endpoint_ip.setter
    def public_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_id", value)


if not MYPY:
    class SqlEndpointNetworkConfigurationAccessControlRuleArgsDict(TypedDict):
        ip_notation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of IP notation.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The associated value of the selected IP notation.
        """
        vcn_ips: NotRequired[pulumi.Input[_builtins.str]]
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
elif False:
    SqlEndpointNetworkConfigurationAccessControlRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlEndpointNetworkConfigurationAccessControlRuleArgs:
    def __init__(__self__, *,
                 ip_notation: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_ips: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_notation: The type of IP notation.
        :param pulumi.Input[_builtins.str] value: The associated value of the selected IP notation.
        :param pulumi.Input[_builtins.str] vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        if ip_notation is not None:
            pulumi.set(__self__, "ip_notation", ip_notation)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vcn_ips is not None:
            pulumi.set(__self__, "vcn_ips", vcn_ips)

    @_builtins.property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @ip_notation.setter
    def ip_notation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_notation", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")

    @vcn_ips.setter
    def vcn_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_ips", value)


if not MYPY:
    class GetApplicationsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetApplicationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetApplicationsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInvokeRunsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetInvokeRunsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInvokeRunsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetPoolsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetPoolsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPoolsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetPrivateEndpointsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetPrivateEndpointsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetRunLogsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetRunLogsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetRunLogsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetRunStatementsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetRunStatementsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetRunStatementsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetSqlEndpointsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetSqlEndpointsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSqlEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


