# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplicationsResult',
    'AwaitableGetApplicationsResult',
    'get_applications',
    'get_applications_output',
]

@pulumi.output_type
class GetApplicationsResult:
    """
    A collection of values returned by getApplications.
    """
    def __init__(__self__, applications=None, compartment_id=None, display_name=None, display_name_starts_with=None, filters=None, id=None, owner_principal_id=None, spark_version=None):
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_starts_with and not isinstance(display_name_starts_with, str):
            raise TypeError("Expected argument 'display_name_starts_with' to be a str")
        pulumi.set(__self__, "display_name_starts_with", display_name_starts_with)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if owner_principal_id and not isinstance(owner_principal_id, str):
            raise TypeError("Expected argument 'owner_principal_id' to be a str")
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        if spark_version and not isinstance(spark_version, str):
            raise TypeError("Expected argument 'spark_version' to be a str")
        pulumi.set(__self__, "spark_version", spark_version)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetApplicationsApplicationResult']:
        """
        The list of applications.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. This name is not necessarily unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="displayNameStartsWith")
    def display_name_starts_with(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name_starts_with")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[_builtins.str]:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")


class AwaitableGetApplicationsResult(GetApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationsResult(
            applications=self.applications,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_starts_with=self.display_name_starts_with,
            filters=self.filters,
            id=self.id,
            owner_principal_id=self.owner_principal_id,
            spark_version=self.spark_version)


def get_applications(compartment_id: Optional[_builtins.str] = None,
                     display_name: Optional[_builtins.str] = None,
                     display_name_starts_with: Optional[_builtins.str] = None,
                     filters: Optional[Sequence[Union['GetApplicationsFilterArgs', 'GetApplicationsFilterArgsDict']]] = None,
                     owner_principal_id: Optional[_builtins.str] = None,
                     spark_version: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationsResult:
    """
    This data source provides the list of Applications in Oracle Cloud Infrastructure Data Flow service.

    Lists all applications in the specified compartment. Only one parameter other than compartmentId may also be included in a query. The query must include compartmentId. If the query does not include compartmentId, or includes compartmentId but two or more other parameters an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_applications = oci.DataFlow.get_applications(compartment_id=compartment_id,
        display_name=application_display_name,
        display_name_starts_with=application_display_name_starts_with,
        owner_principal_id=test_owner_principal["id"],
        spark_version=application_spark_version)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str display_name: The query parameter for the Spark application name.
    :param _builtins.str display_name_starts_with: The displayName prefix.
    :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
    :param _builtins.str spark_version: The Spark version utilized to run the application.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameStartsWith'] = display_name_starts_with
    __args__['filters'] = filters
    __args__['ownerPrincipalId'] = owner_principal_id
    __args__['sparkVersion'] = spark_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getApplications:getApplications', __args__, opts=opts, typ=GetApplicationsResult).value

    return AwaitableGetApplicationsResult(
        applications=pulumi.get(__ret__, 'applications'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_starts_with=pulumi.get(__ret__, 'display_name_starts_with'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        owner_principal_id=pulumi.get(__ret__, 'owner_principal_id'),
        spark_version=pulumi.get(__ret__, 'spark_version'))
def get_applications_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                            display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            display_name_starts_with: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApplicationsFilterArgs', 'GetApplicationsFilterArgsDict']]]]] = None,
                            owner_principal_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            spark_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationsResult]:
    """
    This data source provides the list of Applications in Oracle Cloud Infrastructure Data Flow service.

    Lists all applications in the specified compartment. Only one parameter other than compartmentId may also be included in a query. The query must include compartmentId. If the query does not include compartmentId, or includes compartmentId but two or more other parameters an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_applications = oci.DataFlow.get_applications(compartment_id=compartment_id,
        display_name=application_display_name,
        display_name_starts_with=application_display_name_starts_with,
        owner_principal_id=test_owner_principal["id"],
        spark_version=application_spark_version)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str display_name: The query parameter for the Spark application name.
    :param _builtins.str display_name_starts_with: The displayName prefix.
    :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
    :param _builtins.str spark_version: The Spark version utilized to run the application.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameStartsWith'] = display_name_starts_with
    __args__['filters'] = filters
    __args__['ownerPrincipalId'] = owner_principal_id
    __args__['sparkVersion'] = spark_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataFlow/getApplications:getApplications', __args__, opts=opts, typ=GetApplicationsResult)
    return __ret__.apply(lambda __response__: GetApplicationsResult(
        applications=pulumi.get(__response__, 'applications'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_starts_with=pulumi.get(__response__, 'display_name_starts_with'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        owner_principal_id=pulumi.get(__response__, 'owner_principal_id'),
        spark_version=pulumi.get(__response__, 'spark_version')))
