# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceApplicationTaskScheduleArgs', 'WorkspaceApplicationTaskSchedule']

@pulumi.input_type
class WorkspaceApplicationTaskScheduleArgs:
    def __init__(__self__, *,
                 application_key: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_duration: Optional[pulumi.Input[_builtins.float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 object_version: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] = None,
                 retry_delay: Optional[pulumi.Input[_builtins.float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']] = None,
                 start_time_millis: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceApplicationTaskSchedule resource.
        :param pulumi.Input[_builtins.str] application_key: The application key.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[_builtins.str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[_builtins.str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[_builtins.float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[_builtins.str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[_builtins.bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[_builtins.bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[_builtins.str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs'] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[_builtins.str] start_time_millis: (Updatable) The start time in milliseconds.
        """
        pulumi.set(__self__, "application_key", application_key)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time_millis is not None:
            pulumi.set(__self__, "end_time_millis", end_time_millis)
        if expected_duration is not None:
            pulumi.set(__self__, "expected_duration", expected_duration)
        if expected_duration_unit is not None:
            pulumi.set(__self__, "expected_duration_unit", expected_duration_unit)
        if is_backfill_enabled is not None:
            pulumi.set(__self__, "is_backfill_enabled", is_backfill_enabled)
        if is_concurrent_allowed is not None:
            pulumi.set(__self__, "is_concurrent_allowed", is_concurrent_allowed)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_run_time_millis is not None:
            pulumi.set(__self__, "next_run_time_millis", next_run_time_millis)
        if number_of_retries is not None:
            pulumi.set(__self__, "number_of_retries", number_of_retries)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if retry_delay is not None:
            pulumi.set(__self__, "retry_delay", retry_delay)
        if retry_delay_unit is not None:
            pulumi.set(__self__, "retry_delay_unit", retry_delay_unit)
        if schedule_ref is not None:
            pulumi.set(__self__, "schedule_ref", schedule_ref)
        if start_time_millis is not None:
            pulumi.set(__self__, "start_time_millis", start_time_millis)

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[_builtins.str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_key", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_provider_delegate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @end_time_millis.setter
    def end_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time_millis", value)

    @_builtins.property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @expected_duration.setter
    def expected_duration(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "expected_duration", value)

    @_builtins.property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @expected_duration_unit.setter
    def expected_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @is_backfill_enabled.setter
    def is_backfill_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_backfill_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @is_concurrent_allowed.setter
    def is_concurrent_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_concurrent_allowed", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "next_run_time_millis")

    @next_run_time_millis.setter
    def next_run_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run_time_millis", value)

    @_builtins.property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @number_of_retries.setter
    def number_of_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_retries", value)

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_status", value)

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_version", value)

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @_builtins.property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @retry_delay.setter
    def retry_delay(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retry_delay", value)

    @_builtins.property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @retry_delay_unit.setter
    def retry_delay_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retry_delay_unit", value)

    @_builtins.property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @schedule_ref.setter
    def schedule_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]):
        pulumi.set(self, "schedule_ref", value)

    @_builtins.property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @start_time_millis.setter
    def start_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time_millis", value)


@pulumi.input_type
class _WorkspaceApplicationTaskScheduleState:
    def __init__(__self__, *,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_duration: Optional[pulumi.Input[_builtins.float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 last_run_details: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 object_version: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] = None,
                 retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_delay: Optional[pulumi.Input[_builtins.float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']] = None,
                 start_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplicationTaskSchedule resources.
        :param pulumi.Input[_builtins.str] application_key: The application key.
        :param pulumi.Input[_builtins.str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[_builtins.str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[_builtins.str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[_builtins.float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[_builtins.str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[_builtins.bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]] last_run_details: The last run details for the task run.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[_builtins.str] model_type: The type of the object.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts.
        :param pulumi.Input[_builtins.float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[_builtins.str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs'] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[_builtins.str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time_millis is not None:
            pulumi.set(__self__, "end_time_millis", end_time_millis)
        if expected_duration is not None:
            pulumi.set(__self__, "expected_duration", expected_duration)
        if expected_duration_unit is not None:
            pulumi.set(__self__, "expected_duration_unit", expected_duration_unit)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_backfill_enabled is not None:
            pulumi.set(__self__, "is_backfill_enabled", is_backfill_enabled)
        if is_concurrent_allowed is not None:
            pulumi.set(__self__, "is_concurrent_allowed", is_concurrent_allowed)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if last_run_details is not None:
            pulumi.set(__self__, "last_run_details", last_run_details)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_run_time_millis is not None:
            pulumi.set(__self__, "next_run_time_millis", next_run_time_millis)
        if number_of_retries is not None:
            pulumi.set(__self__, "number_of_retries", number_of_retries)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_delay is not None:
            pulumi.set(__self__, "retry_delay", retry_delay)
        if retry_delay_unit is not None:
            pulumi.set(__self__, "retry_delay_unit", retry_delay_unit)
        if schedule_ref is not None:
            pulumi.set(__self__, "schedule_ref", schedule_ref)
        if start_time_millis is not None:
            pulumi.set(__self__, "start_time_millis", start_time_millis)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_key", value)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_provider_delegate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @end_time_millis.setter
    def end_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time_millis", value)

    @_builtins.property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @expected_duration.setter
    def expected_duration(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "expected_duration", value)

    @_builtins.property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @expected_duration_unit.setter
    def expected_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_duration_unit", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @is_backfill_enabled.setter
    def is_backfill_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_backfill_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @is_concurrent_allowed.setter
    def is_concurrent_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_concurrent_allowed", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="lastRunDetails")
    def last_run_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]]:
        """
        The last run details for the task run.
        """
        return pulumi.get(self, "last_run_details")

    @last_run_details.setter
    def last_run_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]]):
        pulumi.set(self, "last_run_details", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "next_run_time_millis")

    @next_run_time_millis.setter
    def next_run_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run_time_millis", value)

    @_builtins.property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @number_of_retries.setter
    def number_of_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_retries", value)

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_status", value)

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_version", value)

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @_builtins.property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of retry attempts.
        """
        return pulumi.get(self, "retry_attempts")

    @retry_attempts.setter
    def retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @retry_delay.setter
    def retry_delay(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retry_delay", value)

    @_builtins.property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @retry_delay_unit.setter
    def retry_delay_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retry_delay_unit", value)

    @_builtins.property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @schedule_ref.setter
    def schedule_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]):
        pulumi.set(self, "schedule_ref", value)

    @_builtins.property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @start_time_millis.setter
    def start_time_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time_millis", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule")
class WorkspaceApplicationTaskSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_duration: Optional[pulumi.Input[_builtins.float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 object_version: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleParentRefArgs', 'WorkspaceApplicationTaskScheduleParentRefArgsDict']]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleRegistryMetadataArgs', 'WorkspaceApplicationTaskScheduleRegistryMetadataArgsDict']]] = None,
                 retry_delay: Optional[pulumi.Input[_builtins.float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleScheduleRefArgs', 'WorkspaceApplicationTaskScheduleScheduleRefArgsDict']]] = None,
                 start_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Application Task Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to be used create TaskSchedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_task_schedule = oci.dataintegration.WorkspaceApplicationTaskSchedule("test_workspace_application_task_schedule",
            application_key=workspace_application_task_schedule_application_key,
            identifier=workspace_application_task_schedule_identifier,
            name=workspace_application_task_schedule_name,
            workspace_id=test_workspace["id"],
            auth_mode=workspace_application_task_schedule_auth_mode,
            config_provider_delegate=workspace_application_task_schedule_config_provider_delegate,
            description=workspace_application_task_schedule_description,
            end_time_millis=workspace_application_task_schedule_end_time_millis,
            expected_duration=workspace_application_task_schedule_expected_duration,
            expected_duration_unit=workspace_application_task_schedule_expected_duration_unit,
            is_backfill_enabled=workspace_application_task_schedule_is_backfill_enabled,
            is_concurrent_allowed=workspace_application_task_schedule_is_concurrent_allowed,
            is_enabled=workspace_application_task_schedule_is_enabled,
            key=workspace_application_task_schedule_key,
            model_version=workspace_application_task_schedule_model_version,
            number_of_retries=workspace_application_task_schedule_number_of_retries,
            object_status=workspace_application_task_schedule_object_status,
            object_version=workspace_application_task_schedule_object_version,
            parent_ref={
                "parent": workspace_application_task_schedule_parent_ref_parent,
                "root_doc_id": test_root_doc["id"],
            },
            registry_metadata={
                "aggregator_key": workspace_application_task_schedule_registry_metadata_aggregator_key,
                "is_favorite": workspace_application_task_schedule_registry_metadata_is_favorite,
                "key": workspace_application_task_schedule_registry_metadata_key,
                "labels": workspace_application_task_schedule_registry_metadata_labels,
                "registry_version": workspace_application_task_schedule_registry_metadata_registry_version,
            },
            retry_delay=workspace_application_task_schedule_retry_delay,
            retry_delay_unit=workspace_application_task_schedule_retry_delay_unit,
            schedule_ref={
                "description": workspace_application_task_schedule_schedule_ref_description,
                "frequency_details": {
                    "model_type": workspace_application_task_schedule_schedule_ref_frequency_details_model_type,
                    "custom_expression": workspace_application_task_schedule_schedule_ref_frequency_details_custom_expression,
                    "day_of_week": workspace_application_task_schedule_schedule_ref_frequency_details_day_of_week,
                    "days": workspace_application_task_schedule_schedule_ref_frequency_details_days,
                    "frequency": workspace_application_task_schedule_schedule_ref_frequency_details_frequency,
                    "interval": workspace_application_task_schedule_schedule_ref_frequency_details_interval,
                    "time": {
                        "hour": workspace_application_task_schedule_schedule_ref_frequency_details_time_hour,
                        "minute": workspace_application_task_schedule_schedule_ref_frequency_details_time_minute,
                        "second": workspace_application_task_schedule_schedule_ref_frequency_details_time_second,
                    },
                    "week_of_month": workspace_application_task_schedule_schedule_ref_frequency_details_week_of_month,
                },
                "identifier": workspace_application_task_schedule_schedule_ref_identifier,
                "is_daylight_adjustment_enabled": workspace_application_task_schedule_schedule_ref_is_daylight_adjustment_enabled,
                "key": workspace_application_task_schedule_schedule_ref_key,
                "metadata": {
                    "aggregator": {
                        "description": workspace_application_task_schedule_schedule_ref_metadata_aggregator_description,
                        "identifier": workspace_application_task_schedule_schedule_ref_metadata_aggregator_identifier,
                        "key": workspace_application_task_schedule_schedule_ref_metadata_aggregator_key,
                        "name": workspace_application_task_schedule_schedule_ref_metadata_aggregator_name,
                        "type": workspace_application_task_schedule_schedule_ref_metadata_aggregator_type,
                    },
                    "aggregator_key": workspace_application_task_schedule_schedule_ref_metadata_aggregator_key,
                    "count_statistics": {
                        "object_type_count_lists": [{
                            "object_count": workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_count,
                            "object_type": workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_type,
                        }],
                    },
                    "created_by": workspace_application_task_schedule_schedule_ref_metadata_created_by,
                    "created_by_name": workspace_application_task_schedule_schedule_ref_metadata_created_by_name,
                    "identifier_path": workspace_application_task_schedule_schedule_ref_metadata_identifier_path,
                    "info_fields": workspace_application_task_schedule_schedule_ref_metadata_info_fields,
                    "is_favorite": workspace_application_task_schedule_schedule_ref_metadata_is_favorite,
                    "labels": workspace_application_task_schedule_schedule_ref_metadata_labels,
                    "registry_version": workspace_application_task_schedule_schedule_ref_metadata_registry_version,
                    "time_created": workspace_application_task_schedule_schedule_ref_metadata_time_created,
                    "time_updated": workspace_application_task_schedule_schedule_ref_metadata_time_updated,
                    "updated_by": workspace_application_task_schedule_schedule_ref_metadata_updated_by,
                    "updated_by_name": workspace_application_task_schedule_schedule_ref_metadata_updated_by_name,
                },
                "model_type": workspace_application_task_schedule_schedule_ref_model_type,
                "model_version": workspace_application_task_schedule_schedule_ref_model_version,
                "name": workspace_application_task_schedule_schedule_ref_name,
                "object_status": workspace_application_task_schedule_schedule_ref_object_status,
                "object_version": workspace_application_task_schedule_schedule_ref_object_version,
                "parent_ref": {
                    "parent": workspace_application_task_schedule_schedule_ref_parent_ref_parent,
                    "root_doc_id": test_root_doc["id"],
                },
                "timezone": workspace_application_task_schedule_schedule_ref_timezone,
            },
            start_time_millis=workspace_application_task_schedule_start_time_millis)
        ```

        ## Import

        WorkspaceApplicationTaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule test_workspace_application_task_schedule "workspaces/{workspaceId}/applications/{applicationKey}/taskSchedules/{taskScheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_key: The application key.
        :param pulumi.Input[_builtins.str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[_builtins.str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[_builtins.str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[_builtins.float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[_builtins.str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[_builtins.bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleParentRefArgs', 'WorkspaceApplicationTaskScheduleParentRefArgsDict']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleRegistryMetadataArgs', 'WorkspaceApplicationTaskScheduleRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[_builtins.str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleScheduleRefArgs', 'WorkspaceApplicationTaskScheduleScheduleRefArgsDict']] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[_builtins.str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationTaskScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Application Task Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to be used create TaskSchedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_task_schedule = oci.dataintegration.WorkspaceApplicationTaskSchedule("test_workspace_application_task_schedule",
            application_key=workspace_application_task_schedule_application_key,
            identifier=workspace_application_task_schedule_identifier,
            name=workspace_application_task_schedule_name,
            workspace_id=test_workspace["id"],
            auth_mode=workspace_application_task_schedule_auth_mode,
            config_provider_delegate=workspace_application_task_schedule_config_provider_delegate,
            description=workspace_application_task_schedule_description,
            end_time_millis=workspace_application_task_schedule_end_time_millis,
            expected_duration=workspace_application_task_schedule_expected_duration,
            expected_duration_unit=workspace_application_task_schedule_expected_duration_unit,
            is_backfill_enabled=workspace_application_task_schedule_is_backfill_enabled,
            is_concurrent_allowed=workspace_application_task_schedule_is_concurrent_allowed,
            is_enabled=workspace_application_task_schedule_is_enabled,
            key=workspace_application_task_schedule_key,
            model_version=workspace_application_task_schedule_model_version,
            number_of_retries=workspace_application_task_schedule_number_of_retries,
            object_status=workspace_application_task_schedule_object_status,
            object_version=workspace_application_task_schedule_object_version,
            parent_ref={
                "parent": workspace_application_task_schedule_parent_ref_parent,
                "root_doc_id": test_root_doc["id"],
            },
            registry_metadata={
                "aggregator_key": workspace_application_task_schedule_registry_metadata_aggregator_key,
                "is_favorite": workspace_application_task_schedule_registry_metadata_is_favorite,
                "key": workspace_application_task_schedule_registry_metadata_key,
                "labels": workspace_application_task_schedule_registry_metadata_labels,
                "registry_version": workspace_application_task_schedule_registry_metadata_registry_version,
            },
            retry_delay=workspace_application_task_schedule_retry_delay,
            retry_delay_unit=workspace_application_task_schedule_retry_delay_unit,
            schedule_ref={
                "description": workspace_application_task_schedule_schedule_ref_description,
                "frequency_details": {
                    "model_type": workspace_application_task_schedule_schedule_ref_frequency_details_model_type,
                    "custom_expression": workspace_application_task_schedule_schedule_ref_frequency_details_custom_expression,
                    "day_of_week": workspace_application_task_schedule_schedule_ref_frequency_details_day_of_week,
                    "days": workspace_application_task_schedule_schedule_ref_frequency_details_days,
                    "frequency": workspace_application_task_schedule_schedule_ref_frequency_details_frequency,
                    "interval": workspace_application_task_schedule_schedule_ref_frequency_details_interval,
                    "time": {
                        "hour": workspace_application_task_schedule_schedule_ref_frequency_details_time_hour,
                        "minute": workspace_application_task_schedule_schedule_ref_frequency_details_time_minute,
                        "second": workspace_application_task_schedule_schedule_ref_frequency_details_time_second,
                    },
                    "week_of_month": workspace_application_task_schedule_schedule_ref_frequency_details_week_of_month,
                },
                "identifier": workspace_application_task_schedule_schedule_ref_identifier,
                "is_daylight_adjustment_enabled": workspace_application_task_schedule_schedule_ref_is_daylight_adjustment_enabled,
                "key": workspace_application_task_schedule_schedule_ref_key,
                "metadata": {
                    "aggregator": {
                        "description": workspace_application_task_schedule_schedule_ref_metadata_aggregator_description,
                        "identifier": workspace_application_task_schedule_schedule_ref_metadata_aggregator_identifier,
                        "key": workspace_application_task_schedule_schedule_ref_metadata_aggregator_key,
                        "name": workspace_application_task_schedule_schedule_ref_metadata_aggregator_name,
                        "type": workspace_application_task_schedule_schedule_ref_metadata_aggregator_type,
                    },
                    "aggregator_key": workspace_application_task_schedule_schedule_ref_metadata_aggregator_key,
                    "count_statistics": {
                        "object_type_count_lists": [{
                            "object_count": workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_count,
                            "object_type": workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_type,
                        }],
                    },
                    "created_by": workspace_application_task_schedule_schedule_ref_metadata_created_by,
                    "created_by_name": workspace_application_task_schedule_schedule_ref_metadata_created_by_name,
                    "identifier_path": workspace_application_task_schedule_schedule_ref_metadata_identifier_path,
                    "info_fields": workspace_application_task_schedule_schedule_ref_metadata_info_fields,
                    "is_favorite": workspace_application_task_schedule_schedule_ref_metadata_is_favorite,
                    "labels": workspace_application_task_schedule_schedule_ref_metadata_labels,
                    "registry_version": workspace_application_task_schedule_schedule_ref_metadata_registry_version,
                    "time_created": workspace_application_task_schedule_schedule_ref_metadata_time_created,
                    "time_updated": workspace_application_task_schedule_schedule_ref_metadata_time_updated,
                    "updated_by": workspace_application_task_schedule_schedule_ref_metadata_updated_by,
                    "updated_by_name": workspace_application_task_schedule_schedule_ref_metadata_updated_by_name,
                },
                "model_type": workspace_application_task_schedule_schedule_ref_model_type,
                "model_version": workspace_application_task_schedule_schedule_ref_model_version,
                "name": workspace_application_task_schedule_schedule_ref_name,
                "object_status": workspace_application_task_schedule_schedule_ref_object_status,
                "object_version": workspace_application_task_schedule_schedule_ref_object_version,
                "parent_ref": {
                    "parent": workspace_application_task_schedule_schedule_ref_parent_ref_parent,
                    "root_doc_id": test_root_doc["id"],
                },
                "timezone": workspace_application_task_schedule_schedule_ref_timezone,
            },
            start_time_millis=workspace_application_task_schedule_start_time_millis)
        ```

        ## Import

        WorkspaceApplicationTaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule test_workspace_application_task_schedule "workspaces/{workspaceId}/applications/{applicationKey}/taskSchedules/{taskScheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationTaskScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationTaskScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_duration: Optional[pulumi.Input[_builtins.float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 object_version: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleParentRefArgs', 'WorkspaceApplicationTaskScheduleParentRefArgsDict']]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleRegistryMetadataArgs', 'WorkspaceApplicationTaskScheduleRegistryMetadataArgsDict']]] = None,
                 retry_delay: Optional[pulumi.Input[_builtins.float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleScheduleRefArgs', 'WorkspaceApplicationTaskScheduleScheduleRefArgsDict']]] = None,
                 start_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationTaskScheduleArgs.__new__(WorkspaceApplicationTaskScheduleArgs)

            if application_key is None and not opts.urn:
                raise TypeError("Missing required property 'application_key'")
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["auth_mode"] = auth_mode
            __props__.__dict__["config_provider_delegate"] = config_provider_delegate
            __props__.__dict__["description"] = description
            __props__.__dict__["end_time_millis"] = end_time_millis
            __props__.__dict__["expected_duration"] = expected_duration
            __props__.__dict__["expected_duration_unit"] = expected_duration_unit
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["is_backfill_enabled"] = is_backfill_enabled
            __props__.__dict__["is_concurrent_allowed"] = is_concurrent_allowed
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["key"] = key
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["next_run_time_millis"] = next_run_time_millis
            __props__.__dict__["number_of_retries"] = number_of_retries
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["object_version"] = object_version
            __props__.__dict__["parent_ref"] = parent_ref
            __props__.__dict__["registry_metadata"] = registry_metadata
            __props__.__dict__["retry_delay"] = retry_delay
            __props__.__dict__["retry_delay_unit"] = retry_delay_unit
            __props__.__dict__["schedule_ref"] = schedule_ref
            __props__.__dict__["start_time_millis"] = start_time_millis
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["last_run_details"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["model_type"] = None
            __props__.__dict__["retry_attempts"] = None
        super(WorkspaceApplicationTaskSchedule, __self__).__init__(
            'oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_key: Optional[pulumi.Input[_builtins.str]] = None,
            auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            config_provider_delegate: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            end_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
            expected_duration: Optional[pulumi.Input[_builtins.float]] = None,
            expected_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            is_backfill_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_concurrent_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            last_run_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceApplicationTaskScheduleLastRunDetailArgs', 'WorkspaceApplicationTaskScheduleLastRunDetailArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceApplicationTaskScheduleMetadataArgs', 'WorkspaceApplicationTaskScheduleMetadataArgsDict']]]]] = None,
            model_type: Optional[pulumi.Input[_builtins.str]] = None,
            model_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            next_run_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_retries: Optional[pulumi.Input[_builtins.int]] = None,
            object_status: Optional[pulumi.Input[_builtins.int]] = None,
            object_version: Optional[pulumi.Input[_builtins.int]] = None,
            parent_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleParentRefArgs', 'WorkspaceApplicationTaskScheduleParentRefArgsDict']]] = None,
            registry_metadata: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleRegistryMetadataArgs', 'WorkspaceApplicationTaskScheduleRegistryMetadataArgsDict']]] = None,
            retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            retry_delay: Optional[pulumi.Input[_builtins.float]] = None,
            retry_delay_unit: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_ref: Optional[pulumi.Input[Union['WorkspaceApplicationTaskScheduleScheduleRefArgs', 'WorkspaceApplicationTaskScheduleScheduleRefArgsDict']]] = None,
            start_time_millis: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceApplicationTaskSchedule':
        """
        Get an existing WorkspaceApplicationTaskSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_key: The application key.
        :param pulumi.Input[_builtins.str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[_builtins.str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[_builtins.str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[_builtins.float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[_builtins.str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[_builtins.bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceApplicationTaskScheduleLastRunDetailArgs', 'WorkspaceApplicationTaskScheduleLastRunDetailArgsDict']]]] last_run_details: The last run details for the task run.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceApplicationTaskScheduleMetadataArgs', 'WorkspaceApplicationTaskScheduleMetadataArgsDict']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[_builtins.str] model_type: The type of the object.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleParentRefArgs', 'WorkspaceApplicationTaskScheduleParentRefArgsDict']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleRegistryMetadataArgs', 'WorkspaceApplicationTaskScheduleRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts.
        :param pulumi.Input[_builtins.float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[_builtins.str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input[Union['WorkspaceApplicationTaskScheduleScheduleRefArgs', 'WorkspaceApplicationTaskScheduleScheduleRefArgsDict']] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[_builtins.str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationTaskScheduleState.__new__(_WorkspaceApplicationTaskScheduleState)

        __props__.__dict__["application_key"] = application_key
        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["config_provider_delegate"] = config_provider_delegate
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time_millis"] = end_time_millis
        __props__.__dict__["expected_duration"] = expected_duration
        __props__.__dict__["expected_duration_unit"] = expected_duration_unit
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["is_backfill_enabled"] = is_backfill_enabled
        __props__.__dict__["is_concurrent_allowed"] = is_concurrent_allowed
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["key"] = key
        __props__.__dict__["last_run_details"] = last_run_details
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["next_run_time_millis"] = next_run_time_millis
        __props__.__dict__["number_of_retries"] = number_of_retries
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_ref"] = parent_ref
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["retry_attempts"] = retry_attempts
        __props__.__dict__["retry_delay"] = retry_delay
        __props__.__dict__["retry_delay_unit"] = retry_delay_unit
        __props__.__dict__["schedule_ref"] = schedule_ref
        __props__.__dict__["start_time_millis"] = start_time_millis
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplicationTaskSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[_builtins.str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @_builtins.property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @_builtins.property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> pulumi.Output[_builtins.float]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @_builtins.property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @_builtins.property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Generated key that can be used in API calls to identify taskSchedule. On scenarios where reference to the taskSchedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastRunDetails")
    def last_run_details(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationTaskScheduleLastRunDetail']]:
        """
        The last run details for the task run.
        """
        return pulumi.get(self, "last_run_details")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationTaskScheduleMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "next_run_time_millis")

    @_builtins.property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleParentRef']:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleRegistryMetadata']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @_builtins.property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        The number of retry attempts.
        """
        return pulumi.get(self, "retry_attempts")

    @_builtins.property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> pulumi.Output[_builtins.float]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @_builtins.property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @_builtins.property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleScheduleRef']:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @_builtins.property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

