# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceExportRequestArgs', 'WorkspaceExportRequest']

@pulumi.input_type
class WorkspaceExportRequestArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 are_references_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_object_overwrite_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceExportRequest resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket where the object will be exported.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] are_references_included: This field controls if the references will be exported along with the objects
        :param pulumi.Input[_builtins.str] file_name: Name of the exported zip file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filters: Filters for exported objects
        :param pulumi.Input[_builtins.bool] is_object_overwrite_enabled: Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_keys: Field is used to specify which object keys to export
        :param pulumi.Input[_builtins.str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[_builtins.str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if are_references_included is not None:
            pulumi.set(__self__, "are_references_included", are_references_included)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if is_object_overwrite_enabled is not None:
            pulumi.set(__self__, "is_object_overwrite_enabled", is_object_overwrite_enabled)
        if object_keys is not None:
            pulumi.set(__self__, "object_keys", object_keys)
        if object_storage_region is not None:
            pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id is not None:
            pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Object Storage bucket where the object will be exported.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="areReferencesIncluded")
    def are_references_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field controls if the references will be exported along with the objects
        """
        return pulumi.get(self, "are_references_included")

    @are_references_included.setter
    def are_references_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_references_included", value)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the exported zip file.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Filters for exported objects
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="isObjectOverwriteEnabled")
    def is_object_overwrite_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        """
        return pulumi.get(self, "is_object_overwrite_enabled")

    @is_object_overwrite_enabled.setter
    def is_object_overwrite_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_object_overwrite_enabled", value)

    @_builtins.property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field is used to specify which object keys to export
        """
        return pulumi.get(self, "object_keys")

    @object_keys.setter
    def object_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_keys", value)

    @_builtins.property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @object_storage_region.setter
    def object_storage_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_storage_region", value)

    @_builtins.property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_storage_tenancy_id", value)


@pulumi.input_type
class _WorkspaceExportRequestState:
    def __init__(__self__, *,
                 are_references_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 error_messages: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 exported_items: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceExportRequestExportedItemArgs']]]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_object_overwrite_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 referenced_items: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_ended_in_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 time_started_in_millis: Optional[pulumi.Input[_builtins.str]] = None,
                 total_exported_object_count: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceExportRequest resources.
        :param pulumi.Input[_builtins.bool] are_references_included: This field controls if the references will be exported along with the objects
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket where the object will be exported.
        :param pulumi.Input[_builtins.str] created_by: Name of the user who initiated export request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] error_messages: Contains key of the error
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceExportRequestExportedItemArgs']]] exported_items: The array of exported object details.
        :param pulumi.Input[_builtins.str] file_name: Name of the exported zip file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filters: Filters for exported objects
        :param pulumi.Input[_builtins.bool] is_object_overwrite_enabled: Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        :param pulumi.Input[_builtins.str] key: Export object request key
        :param pulumi.Input[_builtins.str] name: Name of the export request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_keys: Field is used to specify which object keys to export
        :param pulumi.Input[_builtins.str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[_builtins.str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[_builtins.str] referenced_items: The array of exported referenced objects.
        :param pulumi.Input[_builtins.str] status: Export Objects request status.
        :param pulumi.Input[_builtins.str] time_ended_in_millis: Time at which the request was completely processed.
        :param pulumi.Input[_builtins.str] time_started_in_millis: Time at which the request started getting processed.
        :param pulumi.Input[_builtins.int] total_exported_object_count: Number of objects that are exported.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if are_references_included is not None:
            pulumi.set(__self__, "are_references_included", are_references_included)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if exported_items is not None:
            pulumi.set(__self__, "exported_items", exported_items)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if is_object_overwrite_enabled is not None:
            pulumi.set(__self__, "is_object_overwrite_enabled", is_object_overwrite_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_keys is not None:
            pulumi.set(__self__, "object_keys", object_keys)
        if object_storage_region is not None:
            pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id is not None:
            pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)
        if referenced_items is not None:
            pulumi.set(__self__, "referenced_items", referenced_items)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_ended_in_millis is not None:
            pulumi.set(__self__, "time_ended_in_millis", time_ended_in_millis)
        if time_started_in_millis is not None:
            pulumi.set(__self__, "time_started_in_millis", time_started_in_millis)
        if total_exported_object_count is not None:
            pulumi.set(__self__, "total_exported_object_count", total_exported_object_count)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="areReferencesIncluded")
    def are_references_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field controls if the references will be exported along with the objects
        """
        return pulumi.get(self, "are_references_included")

    @are_references_included.setter
    def are_references_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_references_included", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Object Storage bucket where the object will be exported.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user who initiated export request.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @error_messages.setter
    def error_messages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "error_messages", value)

    @_builtins.property
    @pulumi.getter(name="exportedItems")
    def exported_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceExportRequestExportedItemArgs']]]]:
        """
        The array of exported object details.
        """
        return pulumi.get(self, "exported_items")

    @exported_items.setter
    def exported_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceExportRequestExportedItemArgs']]]]):
        pulumi.set(self, "exported_items", value)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the exported zip file.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Filters for exported objects
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="isObjectOverwriteEnabled")
    def is_object_overwrite_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        """
        return pulumi.get(self, "is_object_overwrite_enabled")

    @is_object_overwrite_enabled.setter
    def is_object_overwrite_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_object_overwrite_enabled", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Export object request key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the export request.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field is used to specify which object keys to export
        """
        return pulumi.get(self, "object_keys")

    @object_keys.setter
    def object_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_keys", value)

    @_builtins.property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @object_storage_region.setter
    def object_storage_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_storage_region", value)

    @_builtins.property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_storage_tenancy_id", value)

    @_builtins.property
    @pulumi.getter(name="referencedItems")
    def referenced_items(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The array of exported referenced objects.
        """
        return pulumi.get(self, "referenced_items")

    @referenced_items.setter
    def referenced_items(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "referenced_items", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Export Objects request status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @time_ended_in_millis.setter
    def time_ended_in_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_ended_in_millis", value)

    @_builtins.property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @time_started_in_millis.setter
    def time_started_in_millis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_started_in_millis", value)

    @_builtins.property
    @pulumi.getter(name="totalExportedObjectCount")
    def total_exported_object_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of objects that are exported.
        """
        return pulumi.get(self, "total_exported_object_count")

    @total_exported_object_count.setter
    def total_exported_object_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_exported_object_count", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("oci:DataIntegration/workspaceExportRequest:WorkspaceExportRequest")
class WorkspaceExportRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_references_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_object_overwrite_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Export Request resource in Oracle Cloud Infrastructure Data Integration service.

        Export Metadata Object

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_export_request = oci.dataintegration.WorkspaceExportRequest("test_workspace_export_request",
            bucket=workspace_export_request_bucket,
            workspace_id=test_workspace["id"],
            are_references_included=workspace_export_request_are_references_included,
            file_name=workspace_export_request_file_name,
            filters=workspace_export_request_filters,
            is_object_overwrite_enabled=workspace_export_request_is_object_overwrite_enabled,
            object_keys=workspace_export_request_object_keys,
            object_storage_region=workspace_export_request_object_storage_region,
            object_storage_tenancy_id=test_tenancy["id"])
        ```

        ## Import

        WorkspaceExportRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceExportRequest:WorkspaceExportRequest test_workspace_export_request "workspaces/{workspaceId}/exportRequests/{exportRequestKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_references_included: This field controls if the references will be exported along with the objects
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket where the object will be exported.
        :param pulumi.Input[_builtins.str] file_name: Name of the exported zip file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filters: Filters for exported objects
        :param pulumi.Input[_builtins.bool] is_object_overwrite_enabled: Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_keys: Field is used to specify which object keys to export
        :param pulumi.Input[_builtins.str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[_builtins.str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceExportRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Export Request resource in Oracle Cloud Infrastructure Data Integration service.

        Export Metadata Object

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_export_request = oci.dataintegration.WorkspaceExportRequest("test_workspace_export_request",
            bucket=workspace_export_request_bucket,
            workspace_id=test_workspace["id"],
            are_references_included=workspace_export_request_are_references_included,
            file_name=workspace_export_request_file_name,
            filters=workspace_export_request_filters,
            is_object_overwrite_enabled=workspace_export_request_is_object_overwrite_enabled,
            object_keys=workspace_export_request_object_keys,
            object_storage_region=workspace_export_request_object_storage_region,
            object_storage_tenancy_id=test_tenancy["id"])
        ```

        ## Import

        WorkspaceExportRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceExportRequest:WorkspaceExportRequest test_workspace_export_request "workspaces/{workspaceId}/exportRequests/{exportRequestKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceExportRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceExportRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_references_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_object_overwrite_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceExportRequestArgs.__new__(WorkspaceExportRequestArgs)

            __props__.__dict__["are_references_included"] = are_references_included
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["file_name"] = file_name
            __props__.__dict__["filters"] = filters
            __props__.__dict__["is_object_overwrite_enabled"] = is_object_overwrite_enabled
            __props__.__dict__["object_keys"] = object_keys
            __props__.__dict__["object_storage_region"] = object_storage_region
            __props__.__dict__["object_storage_tenancy_id"] = object_storage_tenancy_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_by"] = None
            __props__.__dict__["error_messages"] = None
            __props__.__dict__["exported_items"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["referenced_items"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_ended_in_millis"] = None
            __props__.__dict__["time_started_in_millis"] = None
            __props__.__dict__["total_exported_object_count"] = None
        super(WorkspaceExportRequest, __self__).__init__(
            'oci:DataIntegration/workspaceExportRequest:WorkspaceExportRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_references_included: Optional[pulumi.Input[_builtins.bool]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            error_messages: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            exported_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceExportRequestExportedItemArgs', 'WorkspaceExportRequestExportedItemArgsDict']]]]] = None,
            file_name: Optional[pulumi.Input[_builtins.str]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_object_overwrite_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            object_storage_region: Optional[pulumi.Input[_builtins.str]] = None,
            object_storage_tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
            referenced_items: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            time_ended_in_millis: Optional[pulumi.Input[_builtins.str]] = None,
            time_started_in_millis: Optional[pulumi.Input[_builtins.str]] = None,
            total_exported_object_count: Optional[pulumi.Input[_builtins.int]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceExportRequest':
        """
        Get an existing WorkspaceExportRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_references_included: This field controls if the references will be exported along with the objects
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket where the object will be exported.
        :param pulumi.Input[_builtins.str] created_by: Name of the user who initiated export request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] error_messages: Contains key of the error
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceExportRequestExportedItemArgs', 'WorkspaceExportRequestExportedItemArgsDict']]]] exported_items: The array of exported object details.
        :param pulumi.Input[_builtins.str] file_name: Name of the exported zip file.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] filters: Filters for exported objects
        :param pulumi.Input[_builtins.bool] is_object_overwrite_enabled: Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        :param pulumi.Input[_builtins.str] key: Export object request key
        :param pulumi.Input[_builtins.str] name: Name of the export request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_keys: Field is used to specify which object keys to export
        :param pulumi.Input[_builtins.str] object_storage_region: Region of the object storage (if using object storage of different region)
        :param pulumi.Input[_builtins.str] object_storage_tenancy_id: Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        :param pulumi.Input[_builtins.str] referenced_items: The array of exported referenced objects.
        :param pulumi.Input[_builtins.str] status: Export Objects request status.
        :param pulumi.Input[_builtins.str] time_ended_in_millis: Time at which the request was completely processed.
        :param pulumi.Input[_builtins.str] time_started_in_millis: Time at which the request started getting processed.
        :param pulumi.Input[_builtins.int] total_exported_object_count: Number of objects that are exported.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceExportRequestState.__new__(_WorkspaceExportRequestState)

        __props__.__dict__["are_references_included"] = are_references_included
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["error_messages"] = error_messages
        __props__.__dict__["exported_items"] = exported_items
        __props__.__dict__["file_name"] = file_name
        __props__.__dict__["filters"] = filters
        __props__.__dict__["is_object_overwrite_enabled"] = is_object_overwrite_enabled
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["object_keys"] = object_keys
        __props__.__dict__["object_storage_region"] = object_storage_region
        __props__.__dict__["object_storage_tenancy_id"] = object_storage_tenancy_id
        __props__.__dict__["referenced_items"] = referenced_items
        __props__.__dict__["status"] = status
        __props__.__dict__["time_ended_in_millis"] = time_ended_in_millis
        __props__.__dict__["time_started_in_millis"] = time_started_in_millis
        __props__.__dict__["total_exported_object_count"] = total_exported_object_count
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceExportRequest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="areReferencesIncluded")
    def are_references_included(self) -> pulumi.Output[_builtins.bool]:
        """
        This field controls if the references will be exported along with the objects
        """
        return pulumi.get(self, "are_references_included")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Object Storage bucket where the object will be exported.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the user who initiated export request.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @_builtins.property
    @pulumi.getter(name="exportedItems")
    def exported_items(self) -> pulumi.Output[Sequence['outputs.WorkspaceExportRequestExportedItem']]:
        """
        The array of exported object details.
        """
        return pulumi.get(self, "exported_items")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the exported zip file.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Filters for exported objects
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="isObjectOverwriteEnabled")
    def is_object_overwrite_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        """
        return pulumi.get(self, "is_object_overwrite_enabled")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        Export object request key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the export request.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field is used to specify which object keys to export
        """
        return pulumi.get(self, "object_keys")

    @_builtins.property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @_builtins.property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @_builtins.property
    @pulumi.getter(name="referencedItems")
    def referenced_items(self) -> pulumi.Output[_builtins.str]:
        """
        The array of exported referenced objects.
        """
        return pulumi.get(self, "referenced_items")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Export Objects request status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @_builtins.property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @_builtins.property
    @pulumi.getter(name="totalExportedObjectCount")
    def total_exported_object_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of objects that are exported.
        """
        return pulumi.get(self, "total_exported_object_count")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

