# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAttributeSetAssociatedResourcesResult',
    'AwaitableGetAttributeSetAssociatedResourcesResult',
    'get_attribute_set_associated_resources',
    'get_attribute_set_associated_resources_output',
]

@pulumi.output_type
class GetAttributeSetAssociatedResourcesResult:
    """
    A collection of values returned by getAttributeSetAssociatedResources.
    """
    def __init__(__self__, associated_resource_collections=None, associated_resource_id=None, associated_resource_type=None, attribute_set_id=None, filters=None, id=None):
        if associated_resource_collections and not isinstance(associated_resource_collections, list):
            raise TypeError("Expected argument 'associated_resource_collections' to be a list")
        pulumi.set(__self__, "associated_resource_collections", associated_resource_collections)
        if associated_resource_id and not isinstance(associated_resource_id, str):
            raise TypeError("Expected argument 'associated_resource_id' to be a str")
        pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if associated_resource_type and not isinstance(associated_resource_type, str):
            raise TypeError("Expected argument 'associated_resource_type' to be a str")
        pulumi.set(__self__, "associated_resource_type", associated_resource_type)
        if attribute_set_id and not isinstance(attribute_set_id, str):
            raise TypeError("Expected argument 'attribute_set_id' to be a str")
        pulumi.set(__self__, "attribute_set_id", attribute_set_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="associatedResourceCollections")
    def associated_resource_collections(self) -> Sequence['outputs.GetAttributeSetAssociatedResourcesAssociatedResourceCollectionResult']:
        """
        The list of associated_resource_collection.
        """
        return pulumi.get(self, "associated_resource_collections")

    @_builtins.property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource that is associated with the attribute set.
        """
        return pulumi.get(self, "associated_resource_id")

    @_builtins.property
    @pulumi.getter(name="associatedResourceType")
    def associated_resource_type(self) -> Optional[_builtins.str]:
        """
        The resource type that is associated with the attribute set.
        """
        return pulumi.get(self, "associated_resource_type")

    @_builtins.property
    @pulumi.getter(name="attributeSetId")
    def attribute_set_id(self) -> _builtins.str:
        return pulumi.get(self, "attribute_set_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAttributeSetAssociatedResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAttributeSetAssociatedResourcesResult(GetAttributeSetAssociatedResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttributeSetAssociatedResourcesResult(
            associated_resource_collections=self.associated_resource_collections,
            associated_resource_id=self.associated_resource_id,
            associated_resource_type=self.associated_resource_type,
            attribute_set_id=self.attribute_set_id,
            filters=self.filters,
            id=self.id)


def get_attribute_set_associated_resources(associated_resource_id: Optional[_builtins.str] = None,
                                           associated_resource_type: Optional[_builtins.str] = None,
                                           attribute_set_id: Optional[_builtins.str] = None,
                                           filters: Optional[Sequence[Union['GetAttributeSetAssociatedResourcesFilterArgs', 'GetAttributeSetAssociatedResourcesFilterArgsDict']]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttributeSetAssociatedResourcesResult:
    """
    This data source provides the list of Attribute Set Associated Resources in Oracle Cloud Infrastructure Data Safe service.

    Returns list of all associated resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_set_associated_resources = oci.DataSafe.get_attribute_set_associated_resources(attribute_set_id=test_attribute_set["id"],
        associated_resource_id=test_resource["id"],
        associated_resource_type=attribute_set_associated_resource_associated_resource_type)
    ```


    :param _builtins.str associated_resource_id: A filter to return attribute set associated resource that matches the specified associated resource id query param.
    :param _builtins.str associated_resource_type: A filter to return attribute set associated resources that matches the specified resource type query param.
    :param _builtins.str attribute_set_id: OCID of an attribute set.
    """
    __args__ = dict()
    __args__['associatedResourceId'] = associated_resource_id
    __args__['associatedResourceType'] = associated_resource_type
    __args__['attributeSetId'] = attribute_set_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAttributeSetAssociatedResources:getAttributeSetAssociatedResources', __args__, opts=opts, typ=GetAttributeSetAssociatedResourcesResult).value

    return AwaitableGetAttributeSetAssociatedResourcesResult(
        associated_resource_collections=pulumi.get(__ret__, 'associated_resource_collections'),
        associated_resource_id=pulumi.get(__ret__, 'associated_resource_id'),
        associated_resource_type=pulumi.get(__ret__, 'associated_resource_type'),
        attribute_set_id=pulumi.get(__ret__, 'attribute_set_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_attribute_set_associated_resources_output(associated_resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  associated_resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  attribute_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAttributeSetAssociatedResourcesFilterArgs', 'GetAttributeSetAssociatedResourcesFilterArgsDict']]]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttributeSetAssociatedResourcesResult]:
    """
    This data source provides the list of Attribute Set Associated Resources in Oracle Cloud Infrastructure Data Safe service.

    Returns list of all associated resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_set_associated_resources = oci.DataSafe.get_attribute_set_associated_resources(attribute_set_id=test_attribute_set["id"],
        associated_resource_id=test_resource["id"],
        associated_resource_type=attribute_set_associated_resource_associated_resource_type)
    ```


    :param _builtins.str associated_resource_id: A filter to return attribute set associated resource that matches the specified associated resource id query param.
    :param _builtins.str associated_resource_type: A filter to return attribute set associated resources that matches the specified resource type query param.
    :param _builtins.str attribute_set_id: OCID of an attribute set.
    """
    __args__ = dict()
    __args__['associatedResourceId'] = associated_resource_id
    __args__['associatedResourceType'] = associated_resource_type
    __args__['attributeSetId'] = attribute_set_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAttributeSetAssociatedResources:getAttributeSetAssociatedResources', __args__, opts=opts, typ=GetAttributeSetAssociatedResourcesResult)
    return __ret__.apply(lambda __response__: GetAttributeSetAssociatedResourcesResult(
        associated_resource_collections=pulumi.get(__response__, 'associated_resource_collections'),
        associated_resource_id=pulumi.get(__response__, 'associated_resource_id'),
        associated_resource_type=pulumi.get(__response__, 'associated_resource_type'),
        attribute_set_id=pulumi.get(__response__, 'attribute_set_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
