# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoveryAnalyticResult',
    'AwaitableGetDiscoveryAnalyticResult',
    'get_discovery_analytic',
    'get_discovery_analytic_output',
]

@pulumi.output_type
class GetDiscoveryAnalyticResult:
    """
    A collection of values returned by getDiscoveryAnalytic.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, group_by=None, id=None, items=None, sensitive_data_model_id=None, target_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_by")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoveryAnalyticItemResult']:
        """
        An array of discovery analytics summary objects.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetDiscoveryAnalyticResult(GetDiscoveryAnalyticResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryAnalyticResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            group_by=self.group_by,
            id=self.id,
            items=self.items,
            sensitive_data_model_id=self.sensitive_data_model_id,
            target_id=self.target_id)


def get_discovery_analytic(compartment_id: Optional[_builtins.str] = None,
                           compartment_id_in_subtree: Optional[_builtins.bool] = None,
                           group_by: Optional[_builtins.str] = None,
                           sensitive_data_model_id: Optional[_builtins.str] = None,
                           target_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryAnalyticResult:
    """
    This data source provides details about a specific Discovery Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated discovery analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_analytic = oci.DataSafe.get_discovery_analytic(compartment_id=compartment_id,
        compartment_id_in_subtree=discovery_analytic_compartment_id_in_subtree,
        group_by=discovery_analytic_group_by,
        sensitive_data_model_id=test_sensitive_data_model["id"],
        target_id=test_target["id"])
    ```


    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str group_by: Attribute by which the discovery analytics data should be grouped.
    :param _builtins.str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBy'] = group_by
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDiscoveryAnalytic:getDiscoveryAnalytic', __args__, opts=opts, typ=GetDiscoveryAnalyticResult).value

    return AwaitableGetDiscoveryAnalyticResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_discovery_analytic_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  group_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  sensitive_data_model_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiscoveryAnalyticResult]:
    """
    This data source provides details about a specific Discovery Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated discovery analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_analytic = oci.DataSafe.get_discovery_analytic(compartment_id=compartment_id,
        compartment_id_in_subtree=discovery_analytic_compartment_id_in_subtree,
        group_by=discovery_analytic_group_by,
        sensitive_data_model_id=test_sensitive_data_model["id"],
        target_id=test_target["id"])
    ```


    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str group_by: Attribute by which the discovery analytics data should be grouped.
    :param _builtins.str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBy'] = group_by
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getDiscoveryAnalytic:getDiscoveryAnalytic', __args__, opts=opts, typ=GetDiscoveryAnalyticResult)
    return __ret__.apply(lambda __response__: GetDiscoveryAnalyticResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        group_by=pulumi.get(__response__, 'group_by'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id'),
        target_id=pulumi.get(__response__, 'target_id')))
