# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaskingPolicyHealthReportsResult',
    'AwaitableGetMaskingPolicyHealthReportsResult',
    'get_masking_policy_health_reports',
    'get_masking_policy_health_reports_output',
]

@pulumi.output_type
class GetMaskingPolicyHealthReportsResult:
    """
    A collection of values returned by getMaskingPolicyHealthReports.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, masking_policy_health_report_collections=None, masking_policy_health_report_id=None, masking_policy_id=None, state=None, target_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if masking_policy_health_report_collections and not isinstance(masking_policy_health_report_collections, list):
            raise TypeError("Expected argument 'masking_policy_health_report_collections' to be a list")
        pulumi.set(__self__, "masking_policy_health_report_collections", masking_policy_health_report_collections)
        if masking_policy_health_report_id and not isinstance(masking_policy_health_report_id, str):
            raise TypeError("Expected argument 'masking_policy_health_report_id' to be a str")
        pulumi.set(__self__, "masking_policy_health_report_id", masking_policy_health_report_id)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the health report.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the health report.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaskingPolicyHealthReportsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maskingPolicyHealthReportCollections")
    def masking_policy_health_report_collections(self) -> Sequence['outputs.GetMaskingPolicyHealthReportsMaskingPolicyHealthReportCollectionResult']:
        """
        The list of masking_policy_health_report_collection.
        """
        return pulumi.get(self, "masking_policy_health_report_collections")

    @_builtins.property
    @pulumi.getter(name="maskingPolicyHealthReportId")
    def masking_policy_health_report_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "masking_policy_health_report_id")

    @_builtins.property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the health report.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database for which this report was created.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetMaskingPolicyHealthReportsResult(GetMaskingPolicyHealthReportsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingPolicyHealthReportsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            masking_policy_health_report_collections=self.masking_policy_health_report_collections,
            masking_policy_health_report_id=self.masking_policy_health_report_id,
            masking_policy_id=self.masking_policy_id,
            state=self.state,
            target_id=self.target_id)


def get_masking_policy_health_reports(access_level: Optional[_builtins.str] = None,
                                      compartment_id: Optional[_builtins.str] = None,
                                      compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                      display_name: Optional[_builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetMaskingPolicyHealthReportsFilterArgs', 'GetMaskingPolicyHealthReportsFilterArgsDict']]] = None,
                                      masking_policy_health_report_id: Optional[_builtins.str] = None,
                                      masking_policy_id: Optional[_builtins.str] = None,
                                      state: Optional[_builtins.str] = None,
                                      target_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingPolicyHealthReportsResult:
    """
    This data source provides the list of Masking Policy Health Reports in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masking policy health reports based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy_health_reports = oci.DataSafe.get_masking_policy_health_reports(compartment_id=compartment_id,
        access_level=masking_policy_health_report_access_level,
        compartment_id_in_subtree=masking_policy_health_report_compartment_id_in_subtree,
        display_name=masking_policy_health_report_display_name,
        masking_policy_health_report_id=test_masking_policy_health_report["id"],
        masking_policy_id=test_masking_policy["id"],
        state=masking_policy_health_report_state,
        target_id=test_target["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str masking_policy_health_report_id: A filter to return only the resources that match the specified masking policy health report OCID.
    :param _builtins.str masking_policy_id: A filter to return only the resources that match the specified masking policy OCID.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle states.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['maskingPolicyHealthReportId'] = masking_policy_health_report_id
    __args__['maskingPolicyId'] = masking_policy_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingPolicyHealthReports:getMaskingPolicyHealthReports', __args__, opts=opts, typ=GetMaskingPolicyHealthReportsResult).value

    return AwaitableGetMaskingPolicyHealthReportsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        masking_policy_health_report_collections=pulumi.get(__ret__, 'masking_policy_health_report_collections'),
        masking_policy_health_report_id=pulumi.get(__ret__, 'masking_policy_health_report_id'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_masking_policy_health_reports_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMaskingPolicyHealthReportsFilterArgs', 'GetMaskingPolicyHealthReportsFilterArgsDict']]]]] = None,
                                             masking_policy_health_report_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             masking_policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaskingPolicyHealthReportsResult]:
    """
    This data source provides the list of Masking Policy Health Reports in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masking policy health reports based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy_health_reports = oci.DataSafe.get_masking_policy_health_reports(compartment_id=compartment_id,
        access_level=masking_policy_health_report_access_level,
        compartment_id_in_subtree=masking_policy_health_report_compartment_id_in_subtree,
        display_name=masking_policy_health_report_display_name,
        masking_policy_health_report_id=test_masking_policy_health_report["id"],
        masking_policy_id=test_masking_policy["id"],
        state=masking_policy_health_report_state,
        target_id=test_target["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str masking_policy_health_report_id: A filter to return only the resources that match the specified masking policy health report OCID.
    :param _builtins.str masking_policy_id: A filter to return only the resources that match the specified masking policy OCID.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle states.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['maskingPolicyHealthReportId'] = masking_policy_health_report_id
    __args__['maskingPolicyId'] = masking_policy_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getMaskingPolicyHealthReports:getMaskingPolicyHealthReports', __args__, opts=opts, typ=GetMaskingPolicyHealthReportsResult)
    return __ret__.apply(lambda __response__: GetMaskingPolicyHealthReportsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        masking_policy_health_report_collections=pulumi.get(__response__, 'masking_policy_health_report_collections'),
        masking_policy_health_report_id=pulumi.get(__response__, 'masking_policy_health_report_id'),
        masking_policy_id=pulumi.get(__response__, 'masking_policy_id'),
        state=pulumi.get(__response__, 'state'),
        target_id=pulumi.get(__response__, 'target_id')))
