# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUnifiedAuditPolicyResult',
    'AwaitableGetUnifiedAuditPolicyResult',
    'get_unified_audit_policy',
    'get_unified_audit_policy_output',
]

@pulumi.output_type
class GetUnifiedAuditPolicyResult:
    """
    A collection of values returned by getUnifiedAuditPolicy.
    """
    def __init__(__self__, compartment_id=None, conditions=None, defined_tags=None, description=None, display_name=None, enabled_entities=None, freeform_tags=None, id=None, is_seeded=None, lifecycle_details=None, security_policy_id=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None, unified_audit_policy_definition_id=None, unified_audit_policy_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enabled_entities and not isinstance(enabled_entities, str):
            raise TypeError("Expected argument 'enabled_entities' to be a str")
        pulumi.set(__self__, "enabled_entities", enabled_entities)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_seeded and not isinstance(is_seeded, bool):
            raise TypeError("Expected argument 'is_seeded' to be a bool")
        pulumi.set(__self__, "is_seeded", is_seeded)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if unified_audit_policy_definition_id and not isinstance(unified_audit_policy_definition_id, str):
            raise TypeError("Expected argument 'unified_audit_policy_definition_id' to be a str")
        pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)
        if unified_audit_policy_id and not isinstance(unified_audit_policy_id, str):
            raise TypeError("Expected argument 'unified_audit_policy_id' to be a str")
        pulumi.set(__self__, "unified_audit_policy_id", unified_audit_policy_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the unified audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetUnifiedAuditPolicyConditionResult']:
        """
        Lists the audit policy provisioning conditions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the unified audit policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the unified audit policy.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enabledEntities")
    def enabled_entities(self) -> _builtins.str:
        """
        Indicates on whom the audit policy is enabled.
        """
        return pulumi.get(self, "enabled_entities")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the unified audit policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> _builtins.bool:
        """
        Indicates whether the unified audit policy is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The details of the current state of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> _builtins.str:
        """
        The OCID of the security policy corresponding to the unified audit policy.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the unified audit policy.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates whether the policy has been enabled or disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the the unified audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> _builtins.str:
        """
        The OCID of the associated unified audit policy definition.
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyId")
    def unified_audit_policy_id(self) -> _builtins.str:
        return pulumi.get(self, "unified_audit_policy_id")


class AwaitableGetUnifiedAuditPolicyResult(GetUnifiedAuditPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUnifiedAuditPolicyResult(
            compartment_id=self.compartment_id,
            conditions=self.conditions,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            enabled_entities=self.enabled_entities,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_seeded=self.is_seeded,
            lifecycle_details=self.lifecycle_details,
            security_policy_id=self.security_policy_id,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            unified_audit_policy_definition_id=self.unified_audit_policy_definition_id,
            unified_audit_policy_id=self.unified_audit_policy_id)


def get_unified_audit_policy(unified_audit_policy_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUnifiedAuditPolicyResult:
    """
    This data source provides details about a specific Unified Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a Unified Audit policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_audit_policy = oci.DataSafe.get_unified_audit_policy(unified_audit_policy_id=test_unified_audit_policy_oci_data_safe_unified_audit_policy["id"])
    ```


    :param _builtins.str unified_audit_policy_id: The OCID of the Unified Audit policy resource.
    """
    __args__ = dict()
    __args__['unifiedAuditPolicyId'] = unified_audit_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUnifiedAuditPolicy:getUnifiedAuditPolicy', __args__, opts=opts, typ=GetUnifiedAuditPolicyResult).value

    return AwaitableGetUnifiedAuditPolicyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        conditions=pulumi.get(__ret__, 'conditions'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enabled_entities=pulumi.get(__ret__, 'enabled_entities'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_seeded=pulumi.get(__ret__, 'is_seeded'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        unified_audit_policy_definition_id=pulumi.get(__ret__, 'unified_audit_policy_definition_id'),
        unified_audit_policy_id=pulumi.get(__ret__, 'unified_audit_policy_id'))
def get_unified_audit_policy_output(unified_audit_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUnifiedAuditPolicyResult]:
    """
    This data source provides details about a specific Unified Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a Unified Audit policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_audit_policy = oci.DataSafe.get_unified_audit_policy(unified_audit_policy_id=test_unified_audit_policy_oci_data_safe_unified_audit_policy["id"])
    ```


    :param _builtins.str unified_audit_policy_id: The OCID of the Unified Audit policy resource.
    """
    __args__ = dict()
    __args__['unifiedAuditPolicyId'] = unified_audit_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getUnifiedAuditPolicy:getUnifiedAuditPolicy', __args__, opts=opts, typ=GetUnifiedAuditPolicyResult)
    return __ret__.apply(lambda __response__: GetUnifiedAuditPolicyResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        conditions=pulumi.get(__response__, 'conditions'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        enabled_entities=pulumi.get(__response__, 'enabled_entities'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_seeded=pulumi.get(__response__, 'is_seeded'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        unified_audit_policy_definition_id=pulumi.get(__response__, 'unified_audit_policy_definition_id'),
        unified_audit_policy_id=pulumi.get(__response__, 'unified_audit_policy_id')))
