# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UnifiedAuditPolicyArgs', 'UnifiedAuditPolicy']

@pulumi.input_type
class UnifiedAuditPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 conditions: pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]],
                 security_policy_id: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 unified_audit_policy_definition_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a UnifiedAuditPolicy resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment in which to create the unified audit policy.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]] conditions: (Updatable) Lists the audit policy provisioning conditions.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the unified audit policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the associated unified audit policy definition.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment in which to create the unified audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]]:
        """
        (Updatable) Lists the audit policy provisioning conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the security policy corresponding to the unified audit policy.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the associated unified audit policy definition.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @unified_audit_policy_definition_id.setter
    def unified_audit_policy_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unified_audit_policy_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _UnifiedAuditPolicyState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_entities: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_seeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UnifiedAuditPolicy resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment in which to create the unified audit policy.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]] conditions: (Updatable) Lists the audit policy provisioning conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[_builtins.str] enabled_entities: Indicates on whom the audit policy is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_seeded: Indicates whether the unified audit policy is seeded or not.
        :param pulumi.Input[_builtins.str] lifecycle_details: The details of the current state of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the unified audit policy.
        :param pulumi.Input[_builtins.str] state: The current state of the unified audit policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the the unified audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the associated unified audit policy definition.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled_entities is not None:
            pulumi.set(__self__, "enabled_entities", enabled_entities)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_seeded is not None:
            pulumi.set(__self__, "is_seeded", is_seeded)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if unified_audit_policy_definition_id is not None:
            pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment in which to create the unified audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]]]:
        """
        (Updatable) Lists the audit policy provisioning conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAuditPolicyConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enabledEntities")
    def enabled_entities(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates on whom the audit policy is enabled.
        """
        return pulumi.get(self, "enabled_entities")

    @enabled_entities.setter
    def enabled_entities(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled_entities", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the unified audit policy is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @is_seeded.setter
    def is_seeded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_seeded", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The details of the current state of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the security policy corresponding to the unified audit policy.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the unified audit policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the the unified audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the associated unified audit policy definition.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @unified_audit_policy_definition_id.setter
    def unified_audit_policy_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unified_audit_policy_definition_id", value)


@pulumi.type_token("oci:DataSafe/unifiedAuditPolicy:UnifiedAuditPolicy")
class UnifiedAuditPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnifiedAuditPolicyConditionArgs', 'UnifiedAuditPolicyConditionArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Unified Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Creates the specified unified audit policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_unified_audit_policy = oci.datasafe.UnifiedAuditPolicy("test_unified_audit_policy",
            compartment_id=compartment_id,
            conditions=[{
                "entity_selection": unified_audit_policy_conditions_entity_selection,
                "entity_type": unified_audit_policy_conditions_entity_type,
                "operation_status": unified_audit_policy_conditions_operation_status,
                "attribute_set_id": test_attribute_set["id"],
                "role_names": unified_audit_policy_conditions_role_names,
                "user_names": unified_audit_policy_conditions_user_names,
            }],
            security_policy_id=test_security_policy["id"],
            status=unified_audit_policy_status,
            unified_audit_policy_definition_id=test_unified_audit_policy_definition["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=unified_audit_policy_description,
            display_name=unified_audit_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        UnifiedAuditPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/unifiedAuditPolicy:UnifiedAuditPolicy test_unified_audit_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment in which to create the unified audit policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnifiedAuditPolicyConditionArgs', 'UnifiedAuditPolicyConditionArgsDict']]]] conditions: (Updatable) Lists the audit policy provisioning conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the unified audit policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the associated unified audit policy definition.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UnifiedAuditPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Unified Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Creates the specified unified audit policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_unified_audit_policy = oci.datasafe.UnifiedAuditPolicy("test_unified_audit_policy",
            compartment_id=compartment_id,
            conditions=[{
                "entity_selection": unified_audit_policy_conditions_entity_selection,
                "entity_type": unified_audit_policy_conditions_entity_type,
                "operation_status": unified_audit_policy_conditions_operation_status,
                "attribute_set_id": test_attribute_set["id"],
                "role_names": unified_audit_policy_conditions_role_names,
                "user_names": unified_audit_policy_conditions_user_names,
            }],
            security_policy_id=test_security_policy["id"],
            status=unified_audit_policy_status,
            unified_audit_policy_definition_id=test_unified_audit_policy_definition["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=unified_audit_policy_description,
            display_name=unified_audit_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        UnifiedAuditPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/unifiedAuditPolicy:UnifiedAuditPolicy test_unified_audit_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param UnifiedAuditPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UnifiedAuditPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnifiedAuditPolicyConditionArgs', 'UnifiedAuditPolicyConditionArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UnifiedAuditPolicyArgs.__new__(UnifiedAuditPolicyArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if unified_audit_policy_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'unified_audit_policy_definition_id'")
            __props__.__dict__["unified_audit_policy_definition_id"] = unified_audit_policy_definition_id
            __props__.__dict__["enabled_entities"] = None
            __props__.__dict__["is_seeded"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(UnifiedAuditPolicy, __self__).__init__(
            'oci:DataSafe/unifiedAuditPolicy:UnifiedAuditPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnifiedAuditPolicyConditionArgs', 'UnifiedAuditPolicyConditionArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled_entities: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_seeded: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UnifiedAuditPolicy':
        """
        Get an existing UnifiedAuditPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment in which to create the unified audit policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnifiedAuditPolicyConditionArgs', 'UnifiedAuditPolicyConditionArgsDict']]]] conditions: (Updatable) Lists the audit policy provisioning conditions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[_builtins.str] enabled_entities: Indicates on whom the audit policy is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_seeded: Indicates whether the unified audit policy is seeded or not.
        :param pulumi.Input[_builtins.str] lifecycle_details: The details of the current state of the unified audit policy in Data Safe.
        :param pulumi.Input[_builtins.str] security_policy_id: The OCID of the security policy corresponding to the unified audit policy.
        :param pulumi.Input[_builtins.str] state: The current state of the unified audit policy.
        :param pulumi.Input[_builtins.str] status: (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the the unified audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the associated unified audit policy definition.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UnifiedAuditPolicyState.__new__(_UnifiedAuditPolicyState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled_entities"] = enabled_entities
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_seeded"] = is_seeded
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["unified_audit_policy_definition_id"] = unified_audit_policy_definition_id
        return UnifiedAuditPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment in which to create the unified audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.UnifiedAuditPolicyCondition']]:
        """
        (Updatable) Lists the audit policy provisioning conditions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the unified audit policy in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enabledEntities")
    def enabled_entities(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates on whom the audit policy is enabled.
        """
        return pulumi.get(self, "enabled_entities")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the unified audit policy is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        The details of the current state of the unified audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the security policy corresponding to the unified audit policy.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the unified audit policy.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Indicates whether the unified audit policy has been enabled or disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the the unified audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the associated unified audit policy definition.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

