# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetModelGroupsResult',
    'AwaitableGetModelGroupsResult',
    'get_model_groups',
    'get_model_groups_output',
]

@pulumi.output_type
class GetModelGroupsResult:
    """
    A collection of values returned by getModelGroups.
    """
    def __init__(__self__, compartment_id=None, created_by=None, display_name=None, filters=None, id=None, model_group_version_history_id=None, model_groups=None, project_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_group_version_history_id and not isinstance(model_group_version_history_id, str):
            raise TypeError("Expected argument 'model_group_version_history_id' to be a str")
        pulumi.set(__self__, "model_group_version_history_id", model_group_version_history_id)
        if model_groups and not isinstance(model_groups, list):
            raise TypeError("Expected argument 'model_groups' to be a list")
        pulumi.set(__self__, "model_groups", model_groups)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetModelGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modelGroupVersionHistoryId")
    def model_group_version_history_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
        """
        return pulumi.get(self, "model_group_version_history_id")

    @_builtins.property
    @pulumi.getter(name="modelGroups")
    def model_groups(self) -> Sequence['outputs.GetModelGroupsModelGroupResult']:
        """
        The list of model_groups.
        """
        return pulumi.get(self, "model_groups")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the modelGroup.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of the modelGroup.
        """
        return pulumi.get(self, "state")


class AwaitableGetModelGroupsResult(GetModelGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelGroupsResult(
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            model_group_version_history_id=self.model_group_version_history_id,
            model_groups=self.model_groups,
            project_id=self.project_id,
            state=self.state)


def get_model_groups(compartment_id: Optional[_builtins.str] = None,
                     created_by: Optional[_builtins.str] = None,
                     display_name: Optional[_builtins.str] = None,
                     filters: Optional[Sequence[Union['GetModelGroupsFilterArgs', 'GetModelGroupsFilterArgsDict']]] = None,
                     id: Optional[_builtins.str] = None,
                     model_group_version_history_id: Optional[_builtins.str] = None,
                     project_id: Optional[_builtins.str] = None,
                     state: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelGroupsResult:
    """
    This data source provides the list of Model Groups in Oracle Cloud Infrastructure Data Science service.

    Lists all the modelGroups in the specified compartment. The query must include compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_groups = oci.DataScience.get_model_groups(compartment_id=compartment_id,
        created_by=model_group_created_by,
        display_name=model_group_display_name,
        id=model_group_id,
        model_group_version_history_id=test_model_group_version_history["id"],
        project_id=test_project["id"],
        state=model_group_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str id: <b>Filter</b> results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resource type.
    :param _builtins.str model_group_version_history_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroupVersionHistory.
    :param _builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param _builtins.str state: A filter to return resources matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelGroupVersionHistoryId'] = model_group_version_history_id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModelGroups:getModelGroups', __args__, opts=opts, typ=GetModelGroupsResult).value

    return AwaitableGetModelGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        model_group_version_history_id=pulumi.get(__ret__, 'model_group_version_history_id'),
        model_groups=pulumi.get(__ret__, 'model_groups'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'))
def get_model_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                            created_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetModelGroupsFilterArgs', 'GetModelGroupsFilterArgsDict']]]]] = None,
                            id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            model_group_version_history_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelGroupsResult]:
    """
    This data source provides the list of Model Groups in Oracle Cloud Infrastructure Data Science service.

    Lists all the modelGroups in the specified compartment. The query must include compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_groups = oci.DataScience.get_model_groups(compartment_id=compartment_id,
        created_by=model_group_created_by,
        display_name=model_group_display_name,
        id=model_group_id,
        model_group_version_history_id=test_model_group_version_history["id"],
        project_id=test_project["id"],
        state=model_group_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str id: <b>Filter</b> results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resource type.
    :param _builtins.str model_group_version_history_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroupVersionHistory.
    :param _builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param _builtins.str state: A filter to return resources matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelGroupVersionHistoryId'] = model_group_version_history_id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getModelGroups:getModelGroups', __args__, opts=opts, typ=GetModelGroupsResult)
    return __ret__.apply(lambda __response__: GetModelGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        model_group_version_history_id=pulumi.get(__response__, 'model_group_version_history_id'),
        model_groups=pulumi.get(__response__, 'model_groups'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state')))
