# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateEndpointsResult',
    'AwaitableGetPrivateEndpointsResult',
    'get_private_endpoints',
    'get_private_endpoints_output',
]

@pulumi.output_type
class GetPrivateEndpointsResult:
    """
    A collection of values returned by getPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, created_by=None, data_science_private_endpoints=None, data_science_resource_type=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if data_science_private_endpoints and not isinstance(data_science_private_endpoints, list):
            raise TypeError("Expected argument 'data_science_private_endpoints' to be a list")
        pulumi.set(__self__, "data_science_private_endpoints", data_science_private_endpoints)
        if data_science_resource_type and not isinstance(data_science_resource_type, str):
            raise TypeError("Expected argument 'data_science_resource_type' to be a str")
        pulumi.set(__self__, "data_science_resource_type", data_science_resource_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create private endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user that created the private endpoint.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="dataSciencePrivateEndpoints")
    def data_science_private_endpoints(self) -> Sequence['outputs.GetPrivateEndpointsDataSciencePrivateEndpointResult']:
        """
        The list of data_science_private_endpoints.
        """
        return pulumi.get(self, "data_science_private_endpoints")

    @_builtins.property
    @pulumi.getter(name="dataScienceResourceType")
    def data_science_resource_type(self) -> Optional[_builtins.str]:
        """
        Data Science resource type.
        """
        return pulumi.get(self, "data_science_resource_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the Data Science private endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetPrivateEndpointsResult(GetPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            data_science_private_endpoints=self.data_science_private_endpoints,
            data_science_resource_type=self.data_science_resource_type,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                          created_by: Optional[_builtins.str] = None,
                          data_science_resource_type: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetPrivateEndpointsFilterArgs', 'GetPrivateEndpointsFilterArgsDict']]] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateEndpointsResult:
    """
    This data source provides the list of Data Science Private Endpoints in Oracle Cloud Infrastructure Data Science service.

    Lists all Data Science private endpoints in the specified compartment. The query must include compartmentId. The query can also include one other parameter. If the query doesn't include compartmentId, or includes compartmentId with two or more other parameters, then an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_science_private_endpoints = oci.DataScience.get_private_endpoints(compartment_id=compartment_id,
        created_by=data_science_private_endpoint_created_by,
        data_science_resource_type=data_science_private_endpoint_data_science_resource_type,
        display_name=data_science_private_endpoint_display_name,
        state=data_science_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param _builtins.str data_science_resource_type: Resource types in the Data Science service such as notebooks.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str state: The lifecycle state of the private endpoint.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['dataScienceResourceType'] = data_science_resource_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getPrivateEndpoints:getPrivateEndpoints', __args__, opts=opts, typ=GetPrivateEndpointsResult).value

    return AwaitableGetPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        data_science_private_endpoints=pulumi.get(__ret__, 'data_science_private_endpoints'),
        data_science_resource_type=pulumi.get(__ret__, 'data_science_resource_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_private_endpoints_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 created_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 data_science_resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPrivateEndpointsFilterArgs', 'GetPrivateEndpointsFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateEndpointsResult]:
    """
    This data source provides the list of Data Science Private Endpoints in Oracle Cloud Infrastructure Data Science service.

    Lists all Data Science private endpoints in the specified compartment. The query must include compartmentId. The query can also include one other parameter. If the query doesn't include compartmentId, or includes compartmentId with two or more other parameters, then an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_science_private_endpoints = oci.DataScience.get_private_endpoints(compartment_id=compartment_id,
        created_by=data_science_private_endpoint_created_by,
        data_science_resource_type=data_science_private_endpoint_data_science_resource_type,
        display_name=data_science_private_endpoint_display_name,
        state=data_science_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param _builtins.str data_science_resource_type: Resource types in the Data Science service such as notebooks.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str state: The lifecycle state of the private endpoint.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['dataScienceResourceType'] = data_science_resource_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getPrivateEndpoints:getPrivateEndpoints', __args__, opts=opts, typ=GetPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        data_science_private_endpoints=pulumi.get(__response__, 'data_science_private_endpoints'),
        data_science_resource_type=pulumi.get(__response__, 'data_science_resource_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
