# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MlApplicationImplementationArgs', 'MlApplicationImplementation']

@pulumi.input_type
class MlApplicationImplementationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 ml_application_id: pulumi.Input[_builtins.str],
                 allowed_migration_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']] = None,
                 ml_application_package: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_ml_app_package_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MlApplicationImplementation resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where ML Application Implementation is created.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of the ML Application implemented by this ML Application Implementation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_migration_destinations: (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['MlApplicationImplementationLoggingArgs'] logging: (Updatable) Configuration of Logging for ML Application Implementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ml_application_package: (Updatable) Configuration of The ML Application Package to upload.
        :param pulumi.Input[_builtins.str] name: ML Application Implementation name which is unique for given ML Application.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] opc_ml_app_package_args: (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if allowed_migration_destinations is not None:
            pulumi.set(__self__, "allowed_migration_destinations", allowed_migration_destinations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if ml_application_package is not None:
            pulumi.set(__self__, "ml_application_package", ml_application_package)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opc_ml_app_package_args is not None:
            pulumi.set(__self__, "opc_ml_app_package_args", opc_ml_app_package_args)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where ML Application Implementation is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the ML Application implemented by this ML Application Implementation
        """
        return pulumi.get(self, "ml_application_id")

    @ml_application_id.setter
    def ml_application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ml_application_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedMigrationDestinations")
    def allowed_migration_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        """
        return pulumi.get(self, "allowed_migration_destinations")

    @allowed_migration_destinations.setter
    def allowed_migration_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_migration_destinations", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']]:
        """
        (Updatable) Configuration of Logging for ML Application Implementation.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationPackage")
    def ml_application_package(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Configuration of The ML Application Package to upload.
        """
        return pulumi.get(self, "ml_application_package")

    @ml_application_package.setter
    def ml_application_package(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ml_application_package", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ML Application Implementation name which is unique for given ML Application.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="opcMlAppPackageArgs")
    def opc_ml_app_package_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        """
        return pulumi.get(self, "opc_ml_app_package_args")

    @opc_ml_app_package_args.setter
    def opc_ml_app_package_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "opc_ml_app_package_args", value)


@pulumi.input_type
class _MlApplicationImplementationState:
    def __init__(__self__, *,
                 allowed_migration_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 application_components: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationApplicationComponentArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationConfigurationSchemaArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_package: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ml_application_package_arguments: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationMlApplicationPackageArgumentArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_ml_app_package_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 package_version: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MlApplicationImplementation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_migration_destinations: (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationApplicationComponentArgs']]] application_components: List of application components (OCI resources shared for all MlApplicationInstances). These have been created automatically based on their definitions in the ML Application package.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where ML Application Implementation is created.
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationConfigurationSchemaArgs']]] configuration_schemas: Schema of configuration which needs to be provided for each ML Application Instance. It is defined in the ML Application package descriptor.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: short description of the argument
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['MlApplicationImplementationLoggingArgs'] logging: (Updatable) Configuration of Logging for ML Application Implementation.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of the ML Application implemented by this ML Application Implementation
        :param pulumi.Input[_builtins.str] ml_application_name: The name of ML Application (based on mlApplicationId)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ml_application_package: (Updatable) Configuration of The ML Application Package to upload.
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationMlApplicationPackageArgumentArgs']]] ml_application_package_arguments: List of ML Application package arguments provided during ML Application package upload.
        :param pulumi.Input[_builtins.str] name: ML Application Implementation name which is unique for given ML Application.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] opc_ml_app_package_args: (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        :param pulumi.Input[_builtins.str] package_version: The version of ML Application Package (e.g. "1.2" or "2.0.4") defined in ML Application package descriptor. Value is not mandatory only for CREATING state otherwise it must be always presented.
        :param pulumi.Input[_builtins.str] state: The current state of the MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Creation time of MlApplicationImplementation creation in the format defined by RFC 3339.
        :param pulumi.Input[_builtins.str] time_updated: Time of last MlApplicationImplementation update in the format defined by RFC 3339.
        """
        if allowed_migration_destinations is not None:
            pulumi.set(__self__, "allowed_migration_destinations", allowed_migration_destinations)
        if application_components is not None:
            pulumi.set(__self__, "application_components", application_components)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_schemas is not None:
            pulumi.set(__self__, "configuration_schemas", configuration_schemas)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if ml_application_id is not None:
            pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_name is not None:
            pulumi.set(__self__, "ml_application_name", ml_application_name)
        if ml_application_package is not None:
            pulumi.set(__self__, "ml_application_package", ml_application_package)
        if ml_application_package_arguments is not None:
            pulumi.set(__self__, "ml_application_package_arguments", ml_application_package_arguments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opc_ml_app_package_args is not None:
            pulumi.set(__self__, "opc_ml_app_package_args", opc_ml_app_package_args)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="allowedMigrationDestinations")
    def allowed_migration_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        """
        return pulumi.get(self, "allowed_migration_destinations")

    @allowed_migration_destinations.setter
    def allowed_migration_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_migration_destinations", value)

    @_builtins.property
    @pulumi.getter(name="applicationComponents")
    def application_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationApplicationComponentArgs']]]]:
        """
        List of application components (OCI resources shared for all MlApplicationInstances). These have been created automatically based on their definitions in the ML Application package.
        """
        return pulumi.get(self, "application_components")

    @application_components.setter
    def application_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationApplicationComponentArgs']]]]):
        pulumi.set(self, "application_components", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where ML Application Implementation is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationSchemas")
    def configuration_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationConfigurationSchemaArgs']]]]:
        """
        Schema of configuration which needs to be provided for each ML Application Instance. It is defined in the ML Application package descriptor.
        """
        return pulumi.get(self, "configuration_schemas")

    @configuration_schemas.setter
    def configuration_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationConfigurationSchemaArgs']]]]):
        pulumi.set(self, "configuration_schemas", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        short description of the argument
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']]:
        """
        (Updatable) Configuration of Logging for ML Application Implementation.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['MlApplicationImplementationLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the ML Application implemented by this ML Application Implementation
        """
        return pulumi.get(self, "ml_application_id")

    @ml_application_id.setter
    def ml_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of ML Application (based on mlApplicationId)
        """
        return pulumi.get(self, "ml_application_name")

    @ml_application_name.setter
    def ml_application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_name", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationPackage")
    def ml_application_package(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Configuration of The ML Application Package to upload.
        """
        return pulumi.get(self, "ml_application_package")

    @ml_application_package.setter
    def ml_application_package(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ml_application_package", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationPackageArguments")
    def ml_application_package_arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationMlApplicationPackageArgumentArgs']]]]:
        """
        List of ML Application package arguments provided during ML Application package upload.
        """
        return pulumi.get(self, "ml_application_package_arguments")

    @ml_application_package_arguments.setter
    def ml_application_package_arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationImplementationMlApplicationPackageArgumentArgs']]]]):
        pulumi.set(self, "ml_application_package_arguments", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ML Application Implementation name which is unique for given ML Application.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="opcMlAppPackageArgs")
    def opc_ml_app_package_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        """
        return pulumi.get(self, "opc_ml_app_package_args")

    @opc_ml_app_package_args.setter
    def opc_ml_app_package_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "opc_ml_app_package_args", value)

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of ML Application Package (e.g. "1.2" or "2.0.4") defined in ML Application package descriptor. Value is not mandatory only for CREATING state otherwise it must be always presented.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_version", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the MlApplicationImplementation.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time of MlApplicationImplementation creation in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of last MlApplicationImplementation update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataScience/mlApplicationImplementation:MlApplicationImplementation")
class MlApplicationImplementation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_migration_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input[Union['MlApplicationImplementationLoggingArgs', 'MlApplicationImplementationLoggingArgsDict']]] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_package: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_ml_app_package_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Ml Application Implementation resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new MlApplicationImplementation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ml_application_implementation = oci.datascience.MlApplicationImplementation("test_ml_application_implementation",
            compartment_id=compartment_id,
            ml_application_id=test_ml_application["id"],
            name=ml_application_implementation_name,
            ml_application_package={
                "source_type": ml_application_package_source_type,
                "uri": ml_application_package_uri,
            },
            opc_ml_app_package_args=opc_ml_app_package_args,
            allowed_migration_destinations=ml_application_implementation_allowed_migration_destinations,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            logging={
                "aggregated_instance_view_log": {
                    "enable_logging": ml_application_implementation_logging_aggregated_instance_view_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
                "implementation_log": {
                    "enable_logging": ml_application_implementation_logging_implementation_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
                "trigger_log": {
                    "enable_logging": ml_application_implementation_logging_trigger_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
            })
        ```

        ## Import

        MlApplicationImplementations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/mlApplicationImplementation:MlApplicationImplementation test_ml_application_implementation "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_migration_destinations: (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where ML Application Implementation is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['MlApplicationImplementationLoggingArgs', 'MlApplicationImplementationLoggingArgsDict']] logging: (Updatable) Configuration of Logging for ML Application Implementation.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of the ML Application implemented by this ML Application Implementation
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ml_application_package: (Updatable) Configuration of The ML Application Package to upload.
        :param pulumi.Input[_builtins.str] name: ML Application Implementation name which is unique for given ML Application.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] opc_ml_app_package_args: (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MlApplicationImplementationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ml Application Implementation resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new MlApplicationImplementation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ml_application_implementation = oci.datascience.MlApplicationImplementation("test_ml_application_implementation",
            compartment_id=compartment_id,
            ml_application_id=test_ml_application["id"],
            name=ml_application_implementation_name,
            ml_application_package={
                "source_type": ml_application_package_source_type,
                "uri": ml_application_package_uri,
            },
            opc_ml_app_package_args=opc_ml_app_package_args,
            allowed_migration_destinations=ml_application_implementation_allowed_migration_destinations,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            logging={
                "aggregated_instance_view_log": {
                    "enable_logging": ml_application_implementation_logging_aggregated_instance_view_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
                "implementation_log": {
                    "enable_logging": ml_application_implementation_logging_implementation_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
                "trigger_log": {
                    "enable_logging": ml_application_implementation_logging_trigger_log_enable_logging,
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
            })
        ```

        ## Import

        MlApplicationImplementations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/mlApplicationImplementation:MlApplicationImplementation test_ml_application_implementation "id"
        ```

        :param str resource_name: The name of the resource.
        :param MlApplicationImplementationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MlApplicationImplementationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_migration_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging: Optional[pulumi.Input[Union['MlApplicationImplementationLoggingArgs', 'MlApplicationImplementationLoggingArgsDict']]] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_package: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opc_ml_app_package_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MlApplicationImplementationArgs.__new__(MlApplicationImplementationArgs)

            __props__.__dict__["allowed_migration_destinations"] = allowed_migration_destinations
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["logging"] = logging
            if ml_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'ml_application_id'")
            __props__.__dict__["ml_application_id"] = ml_application_id
            __props__.__dict__["ml_application_package"] = ml_application_package
            __props__.__dict__["name"] = name
            __props__.__dict__["opc_ml_app_package_args"] = opc_ml_app_package_args
            __props__.__dict__["application_components"] = None
            __props__.__dict__["configuration_schemas"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ml_application_name"] = None
            __props__.__dict__["ml_application_package_arguments"] = None
            __props__.__dict__["package_version"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MlApplicationImplementation, __self__).__init__(
            'oci:DataScience/mlApplicationImplementation:MlApplicationImplementation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_migration_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            application_components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationApplicationComponentArgs', 'MlApplicationImplementationApplicationComponentArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationConfigurationSchemaArgs', 'MlApplicationImplementationConfigurationSchemaArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            logging: Optional[pulumi.Input[Union['MlApplicationImplementationLoggingArgs', 'MlApplicationImplementationLoggingArgsDict']]] = None,
            ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_name: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_package: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ml_application_package_arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationMlApplicationPackageArgumentArgs', 'MlApplicationImplementationMlApplicationPackageArgumentArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            opc_ml_app_package_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            package_version: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'MlApplicationImplementation':
        """
        Get an existing MlApplicationImplementation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_migration_destinations: (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationApplicationComponentArgs', 'MlApplicationImplementationApplicationComponentArgsDict']]]] application_components: List of application components (OCI resources shared for all MlApplicationInstances). These have been created automatically based on their definitions in the ML Application package.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where ML Application Implementation is created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationConfigurationSchemaArgs', 'MlApplicationImplementationConfigurationSchemaArgsDict']]]] configuration_schemas: Schema of configuration which needs to be provided for each ML Application Instance. It is defined in the ML Application package descriptor.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: short description of the argument
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Union['MlApplicationImplementationLoggingArgs', 'MlApplicationImplementationLoggingArgsDict']] logging: (Updatable) Configuration of Logging for ML Application Implementation.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of the ML Application implemented by this ML Application Implementation
        :param pulumi.Input[_builtins.str] ml_application_name: The name of ML Application (based on mlApplicationId)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ml_application_package: (Updatable) Configuration of The ML Application Package to upload.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationImplementationMlApplicationPackageArgumentArgs', 'MlApplicationImplementationMlApplicationPackageArgumentArgsDict']]]] ml_application_package_arguments: List of ML Application package arguments provided during ML Application package upload.
        :param pulumi.Input[_builtins.str] name: ML Application Implementation name which is unique for given ML Application.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] opc_ml_app_package_args: (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        :param pulumi.Input[_builtins.str] package_version: The version of ML Application Package (e.g. "1.2" or "2.0.4") defined in ML Application package descriptor. Value is not mandatory only for CREATING state otherwise it must be always presented.
        :param pulumi.Input[_builtins.str] state: The current state of the MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Creation time of MlApplicationImplementation creation in the format defined by RFC 3339.
        :param pulumi.Input[_builtins.str] time_updated: Time of last MlApplicationImplementation update in the format defined by RFC 3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MlApplicationImplementationState.__new__(_MlApplicationImplementationState)

        __props__.__dict__["allowed_migration_destinations"] = allowed_migration_destinations
        __props__.__dict__["application_components"] = application_components
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_schemas"] = configuration_schemas
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["logging"] = logging
        __props__.__dict__["ml_application_id"] = ml_application_id
        __props__.__dict__["ml_application_name"] = ml_application_name
        __props__.__dict__["ml_application_package"] = ml_application_package
        __props__.__dict__["ml_application_package_arguments"] = ml_application_package_arguments
        __props__.__dict__["name"] = name
        __props__.__dict__["opc_ml_app_package_args"] = opc_ml_app_package_args
        __props__.__dict__["package_version"] = package_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MlApplicationImplementation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedMigrationDestinations")
    def allowed_migration_destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        """
        return pulumi.get(self, "allowed_migration_destinations")

    @_builtins.property
    @pulumi.getter(name="applicationComponents")
    def application_components(self) -> pulumi.Output[Sequence['outputs.MlApplicationImplementationApplicationComponent']]:
        """
        List of application components (OCI resources shared for all MlApplicationInstances). These have been created automatically based on their definitions in the ML Application package.
        """
        return pulumi.get(self, "application_components")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where ML Application Implementation is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationSchemas")
    def configuration_schemas(self) -> pulumi.Output[Sequence['outputs.MlApplicationImplementationConfigurationSchema']]:
        """
        Schema of configuration which needs to be provided for each ML Application Instance. It is defined in the ML Application package descriptor.
        """
        return pulumi.get(self, "configuration_schemas")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        short description of the argument
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.MlApplicationImplementationLogging']:
        """
        (Updatable) Configuration of Logging for ML Application Implementation.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the ML Application implemented by this ML Application Implementation
        """
        return pulumi.get(self, "ml_application_id")

    @_builtins.property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of ML Application (based on mlApplicationId)
        """
        return pulumi.get(self, "ml_application_name")

    @_builtins.property
    @pulumi.getter(name="mlApplicationPackage")
    def ml_application_package(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Configuration of The ML Application Package to upload.
        """
        return pulumi.get(self, "ml_application_package")

    @_builtins.property
    @pulumi.getter(name="mlApplicationPackageArguments")
    def ml_application_package_arguments(self) -> pulumi.Output[Sequence['outputs.MlApplicationImplementationMlApplicationPackageArgument']]:
        """
        List of ML Application package arguments provided during ML Application package upload.
        """
        return pulumi.get(self, "ml_application_package_arguments")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        ML Application Implementation name which is unique for given ML Application.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="opcMlAppPackageArgs")
    def opc_ml_app_package_args(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        (Updatable) ML Application package arguments required during ML Application package upload. Each argument is a simple key-value pair.
        """
        return pulumi.get(self, "opc_ml_app_package_args")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of ML Application Package (e.g. "1.2" or "2.0.4") defined in ML Application package descriptor. Value is not mandatory only for CREATING state otherwise it must be always presented.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the MlApplicationImplementation.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time of MlApplicationImplementation creation in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time of last MlApplicationImplementation update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

