# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrPlansResult',
    'AwaitableGetDrPlansResult',
    'get_dr_plans',
    'get_dr_plans_output',
]

@pulumi.output_type
class GetDrPlansResult:
    """
    A collection of values returned by getDrPlans.
    """
    def __init__(__self__, display_name=None, dr_plan_collections=None, dr_plan_id=None, dr_plan_type=None, dr_protection_group_id=None, filters=None, id=None, lifecycle_sub_state=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_plan_collections and not isinstance(dr_plan_collections, list):
            raise TypeError("Expected argument 'dr_plan_collections' to be a list")
        pulumi.set(__self__, "dr_plan_collections", dr_plan_collections)
        if dr_plan_id and not isinstance(dr_plan_id, str):
            raise TypeError("Expected argument 'dr_plan_id' to be a str")
        pulumi.set(__self__, "dr_plan_id", dr_plan_id)
        if dr_plan_type and not isinstance(dr_plan_type, str):
            raise TypeError("Expected argument 'dr_plan_type' to be a str")
        pulumi.set(__self__, "dr_plan_type", dr_plan_type)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the group.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="drPlanCollections")
    def dr_plan_collections(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionResult']:
        """
        The list of dr_plan_collection.
        """
        return pulumi.get(self, "dr_plan_collections")

    @_builtins.property
    @pulumi.getter(name="drPlanId")
    def dr_plan_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dr_plan_id")

    @_builtins.property
    @pulumi.getter(name="drPlanType")
    def dr_plan_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dr_plan_type")

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> _builtins.str:
        """
        The OCID of the DR protection group to which this DR plan belongs.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrPlansFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[_builtins.str]:
        """
        The current state of the DR plan.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the DR plan.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrPlansResult(GetDrPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrPlansResult(
            display_name=self.display_name,
            dr_plan_collections=self.dr_plan_collections,
            dr_plan_id=self.dr_plan_id,
            dr_plan_type=self.dr_plan_type,
            dr_protection_group_id=self.dr_protection_group_id,
            filters=self.filters,
            id=self.id,
            lifecycle_sub_state=self.lifecycle_sub_state,
            state=self.state)


def get_dr_plans(display_name: Optional[_builtins.str] = None,
                 dr_plan_id: Optional[_builtins.str] = None,
                 dr_plan_type: Optional[_builtins.str] = None,
                 dr_protection_group_id: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetDrPlansFilterArgs', 'GetDrPlansFilterArgsDict']]] = None,
                 lifecycle_sub_state: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrPlansResult:
    """
    This data source provides the list of Dr Plans in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR plans for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plans = oci.DisasterRecovery.get_dr_plans(dr_protection_group_id=test_dr_protection_group["id"],
        display_name=dr_plan_display_name,
        dr_plan_id=test_dr_plan["id"],
        dr_plan_type=dr_plan_dr_plan_type,
        lifecycle_sub_state=dr_plan_lifecycle_sub_state,
        state=dr_plan_state)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param _builtins.str dr_plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID`
    :param _builtins.str dr_plan_type: The DR plan type.
    :param _builtins.str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param _builtins.str lifecycle_sub_state: A filter to return only DR plans that match the given lifecycle sub-state.
    :param _builtins.str state: A filter to return only DR plans that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drPlanId'] = dr_plan_id
    __args__['drPlanType'] = dr_plan_type
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['lifecycleSubState'] = lifecycle_sub_state
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrPlans:getDrPlans', __args__, opts=opts, typ=GetDrPlansResult).value

    return AwaitableGetDrPlansResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_plan_collections=pulumi.get(__ret__, 'dr_plan_collections'),
        dr_plan_id=pulumi.get(__ret__, 'dr_plan_id'),
        dr_plan_type=pulumi.get(__ret__, 'dr_plan_type'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        state=pulumi.get(__ret__, 'state'))
def get_dr_plans_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dr_plan_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dr_plan_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDrPlansFilterArgs', 'GetDrPlansFilterArgsDict']]]]] = None,
                        lifecycle_sub_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDrPlansResult]:
    """
    This data source provides the list of Dr Plans in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR plans for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plans = oci.DisasterRecovery.get_dr_plans(dr_protection_group_id=test_dr_protection_group["id"],
        display_name=dr_plan_display_name,
        dr_plan_id=test_dr_plan["id"],
        dr_plan_type=dr_plan_dr_plan_type,
        lifecycle_sub_state=dr_plan_lifecycle_sub_state,
        state=dr_plan_state)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param _builtins.str dr_plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID`
    :param _builtins.str dr_plan_type: The DR plan type.
    :param _builtins.str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param _builtins.str lifecycle_sub_state: A filter to return only DR plans that match the given lifecycle sub-state.
    :param _builtins.str state: A filter to return only DR plans that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drPlanId'] = dr_plan_id
    __args__['drPlanType'] = dr_plan_type
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['lifecycleSubState'] = lifecycle_sub_state
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DisasterRecovery/getDrPlans:getDrPlans', __args__, opts=opts, typ=GetDrPlansResult)
    return __ret__.apply(lambda __response__: GetDrPlansResult(
        display_name=pulumi.get(__response__, 'display_name'),
        dr_plan_collections=pulumi.get(__response__, 'dr_plan_collections'),
        dr_plan_id=pulumi.get(__response__, 'dr_plan_id'),
        dr_plan_type=pulumi.get(__response__, 'dr_plan_type'),
        dr_protection_group_id=pulumi.get(__response__, 'dr_protection_group_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        state=pulumi.get(__response__, 'state')))
