# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDedicatedAiClustersResult',
    'AwaitableGetDedicatedAiClustersResult',
    'get_dedicated_ai_clusters',
    'get_dedicated_ai_clusters_output',
]

@pulumi.output_type
class GetDedicatedAiClustersResult:
    """
    A collection of values returned by getDedicatedAiClusters.
    """
    def __init__(__self__, compartment_id=None, dedicated_ai_cluster_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dedicated_ai_cluster_collections and not isinstance(dedicated_ai_cluster_collections, list):
            raise TypeError("Expected argument 'dedicated_ai_cluster_collections' to be a list")
        pulumi.set(__self__, "dedicated_ai_cluster_collections", dedicated_ai_cluster_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedAiClusterCollections")
    def dedicated_ai_cluster_collections(self) -> Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionResult']:
        """
        The list of dedicated_ai_cluster_collection.
        """
        return pulumi.get(self, "dedicated_ai_cluster_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDedicatedAiClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "state")


class AwaitableGetDedicatedAiClustersResult(GetDedicatedAiClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedAiClustersResult(
            compartment_id=self.compartment_id,
            dedicated_ai_cluster_collections=self.dedicated_ai_cluster_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_dedicated_ai_clusters(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetDedicatedAiClustersFilterArgs', 'GetDedicatedAiClustersFilterArgsDict']]] = None,
                              id: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedAiClustersResult:
    """
    This data source provides the list of Dedicated Ai Clusters in Oracle Cloud Infrastructure Generative AI service.

    Lists the dedicated AI clusters in a specific compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_clusters = oci.GenerativeAi.get_dedicated_ai_clusters(compartment_id=compartment_id,
        display_name=dedicated_ai_cluster_display_name,
        id=dedicated_ai_cluster_id,
        state=dedicated_ai_cluster_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    :param _builtins.str state: A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getDedicatedAiClusters:getDedicatedAiClusters', __args__, opts=opts, typ=GetDedicatedAiClustersResult).value

    return AwaitableGetDedicatedAiClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dedicated_ai_cluster_collections=pulumi.get(__ret__, 'dedicated_ai_cluster_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_dedicated_ai_clusters_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDedicatedAiClustersFilterArgs', 'GetDedicatedAiClustersFilterArgsDict']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDedicatedAiClustersResult]:
    """
    This data source provides the list of Dedicated Ai Clusters in Oracle Cloud Infrastructure Generative AI service.

    Lists the dedicated AI clusters in a specific compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_clusters = oci.GenerativeAi.get_dedicated_ai_clusters(compartment_id=compartment_id,
        display_name=dedicated_ai_cluster_display_name,
        id=dedicated_ai_cluster_id,
        state=dedicated_ai_cluster_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    :param _builtins.str state: A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getDedicatedAiClusters:getDedicatedAiClusters', __args__, opts=opts, typ=GetDedicatedAiClustersResult)
    return __ret__.apply(lambda __response__: GetDedicatedAiClustersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dedicated_ai_cluster_collections=pulumi.get(__response__, 'dedicated_ai_cluster_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
