# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelinesResult',
    'AwaitableGetPipelinesResult',
    'get_pipelines',
    'get_pipelines_output',
]

@pulumi.output_type
class GetPipelinesResult:
    """
    A collection of values returned by getPipelines.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, lifecycle_sub_state=None, pipeline_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if pipeline_collections and not isinstance(pipeline_collections, list):
            raise TypeError("Expected argument 'pipeline_collections' to be a list")
        pulumi.set(__self__, "pipeline_collections", pipeline_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPipelinesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[_builtins.str]:
        """
        Possible lifecycle substates when retrieving a pipeline.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @_builtins.property
    @pulumi.getter(name="pipelineCollections")
    def pipeline_collections(self) -> Sequence['outputs.GetPipelinesPipelineCollectionResult']:
        """
        The list of pipeline_collection.
        """
        return pulumi.get(self, "pipeline_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        Lifecycle state of the pipeline.
        """
        return pulumi.get(self, "state")


class AwaitableGetPipelinesResult(GetPipelinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelinesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            lifecycle_sub_state=self.lifecycle_sub_state,
            pipeline_collections=self.pipeline_collections,
            state=self.state)


def get_pipelines(compartment_id: Optional[_builtins.str] = None,
                  display_name: Optional[_builtins.str] = None,
                  filters: Optional[Sequence[Union['GetPipelinesFilterArgs', 'GetPipelinesFilterArgsDict']]] = None,
                  lifecycle_sub_state: Optional[_builtins.str] = None,
                  state: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelinesResult:
    """
    This data source provides the list of Pipelines in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Pipelines in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipelines = oci.GoldenGate.get_pipelines(compartment_id=compartment_id,
        display_name=pipeline_display_name,
        lifecycle_sub_state=pipeline_lifecycle_sub_state,
        state=pipeline_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param _builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param _builtins.str lifecycle_sub_state: A filtered list of pipelines to return for a given lifecycleSubState.
    :param _builtins.str state: A filtered list of pipelines to return for a given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['lifecycleSubState'] = lifecycle_sub_state
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getPipelines:getPipelines', __args__, opts=opts, typ=GetPipelinesResult).value

    return AwaitableGetPipelinesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        pipeline_collections=pulumi.get(__ret__, 'pipeline_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_pipelines_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                         display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPipelinesFilterArgs', 'GetPipelinesFilterArgsDict']]]]] = None,
                         lifecycle_sub_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelinesResult]:
    """
    This data source provides the list of Pipelines in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Pipelines in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipelines = oci.GoldenGate.get_pipelines(compartment_id=compartment_id,
        display_name=pipeline_display_name,
        lifecycle_sub_state=pipeline_lifecycle_sub_state,
        state=pipeline_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param _builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param _builtins.str lifecycle_sub_state: A filtered list of pipelines to return for a given lifecycleSubState.
    :param _builtins.str state: A filtered list of pipelines to return for a given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['lifecycleSubState'] = lifecycle_sub_state
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getPipelines:getPipelines', __args__, opts=opts, typ=GetPipelinesResult)
    return __ret__.apply(lambda __response__: GetPipelinesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        pipeline_collections=pulumi.get(__response__, 'pipeline_collections'),
        state=pulumi.get(__response__, 'state')))
