# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHttpMonitorsFilterResult',
    'GetHttpMonitorsHttpMonitorResult',
    'GetHttpProbeResultsFilterResult',
    'GetHttpProbeResultsHttpProbeResultResult',
    'GetHttpProbeResultsHttpProbeResultConnectionResult',
    'GetHttpProbeResultsHttpProbeResultDnResult',
    'GetPingMonitorsFilterResult',
    'GetPingMonitorsPingMonitorResult',
    'GetPingProbeResultsFilterResult',
    'GetPingProbeResultsPingProbeResultResult',
    'GetPingProbeResultsPingProbeResultConnectionResult',
    'GetPingProbeResultsPingProbeResultDnResult',
    'GetVantagePointsFilterResult',
    'GetVantagePointsHealthChecksVantagePointResult',
    'GetVantagePointsHealthChecksVantagePointGeoResult',
    'GetVantagePointsHealthChecksVantagePointRoutingResult',
]

@pulumi.output_type
class GetHttpMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpMonitorsHttpMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 headers: Mapping[str, _builtins.str],
                 home_region: _builtins.str,
                 id: _builtins.str,
                 interval_in_seconds: _builtins.int,
                 is_enabled: _builtins.bool,
                 method: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 results_url: _builtins.str,
                 targets: Sequence[_builtins.str],
                 time_created: _builtins.str,
                 timeout_in_seconds: _builtins.int,
                 vantage_point_names: Sequence[_builtins.str]):
        """
        :param _builtins.str compartment_id: Filters results by compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param Mapping[str, _builtins.str] headers: A dictionary of HTTP request headers.
        :param _builtins.str home_region: Filters results that match the `homeRegion`.
        :param _builtins.str id: The OCID of the resource.
        :param _builtins.int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param _builtins.bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param _builtins.str method: The supported HTTP methods available for probes.
        :param _builtins.str path: The optional URL path to probe, including query parameters.
        :param _builtins.int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param _builtins.str protocol: The supported protocols available for HTTP probes.
        :param _builtins.str results_url: A URL for fetching the probe results.
        :param Sequence[_builtins.str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param _builtins.str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param _builtins.int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[_builtins.str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "home_region", home_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "results_url", results_url)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Mapping[str, _builtins.str]:
        """
        A dictionary of HTTP request headers.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> _builtins.str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> _builtins.int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> _builtins.str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence[_builtins.str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> _builtins.int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[_builtins.str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetHttpProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultResult(dict):
    def __init__(__self__, *,
                 connect_end: _builtins.float,
                 connect_start: _builtins.float,
                 connections: Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult'],
                 domain_lookup_end: _builtins.float,
                 domain_lookup_start: _builtins.float,
                 duration: _builtins.float,
                 encoded_body_size: _builtins.int,
                 error_category: _builtins.str,
                 error_message: _builtins.str,
                 fetch_start: _builtins.float,
                 is_healthy: _builtins.bool,
                 is_timed_out: _builtins.bool,
                 key: _builtins.str,
                 probe_configuration_id: _builtins.str,
                 protocol: _builtins.str,
                 request_start: _builtins.float,
                 response_end: _builtins.float,
                 response_start: _builtins.float,
                 secure_connection_start: _builtins.float,
                 start_time: _builtins.float,
                 status_code: _builtins.int,
                 target: _builtins.str,
                 vantage_point_name: _builtins.str):
        """
        :param _builtins.float connect_end: The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        :param _builtins.float connect_start: The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        :param Sequence['GetHttpProbeResultsHttpProbeResultConnectionArgs'] connections: TCP connection results.  All durations are in milliseconds.
        :param Sequence['GetHttpProbeResultsHttpProbeResultDnArgs'] dns: The DNS resolution results.
        :param _builtins.float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param _builtins.float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param _builtins.float duration: The total duration from start of request until response is fully consumed or the connection is closed.
        :param _builtins.int encoded_body_size: The size, in octets, of the payload body prior to removing any applied content-codings.
        :param _builtins.str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param _builtins.str error_message: The error information indicating why a probe execution failed.
        :param _builtins.float fetch_start: The time immediately before the vantage point starts to fetch the resource.
        :param _builtins.bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param _builtins.bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param _builtins.str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param _builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param _builtins.str protocol: The supported protocols available for HTTP probes.
        :param _builtins.float request_start: The time immediately before the vantage point starts requesting the resource from the server.
        :param _builtins.float response_end: The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        :param _builtins.float response_start: The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        :param _builtins.float secure_connection_start: The time immediately before the vantage point starts the handshake process to secure the current connection.
        :param _builtins.float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param _builtins.int status_code: The HTTP response status code.
        :param _builtins.str target: Filters results that match the `target`.
        :param _builtins.str vantage_point_name: The name of the vantage point that executed the probe.
        """
        pulumi.set(__self__, "connect_end", connect_end)
        pulumi.set(__self__, "connect_start", connect_start)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "domain_lookup_end", domain_lookup_end)
        pulumi.set(__self__, "domain_lookup_start", domain_lookup_start)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "encoded_body_size", encoded_body_size)
        pulumi.set(__self__, "error_category", error_category)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "fetch_start", fetch_start)
        pulumi.set(__self__, "is_healthy", is_healthy)
        pulumi.set(__self__, "is_timed_out", is_timed_out)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "request_start", request_start)
        pulumi.set(__self__, "response_end", response_end)
        pulumi.set(__self__, "response_start", response_start)
        pulumi.set(__self__, "secure_connection_start", secure_connection_start)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "vantage_point_name", vantage_point_name)

    @_builtins.property
    @pulumi.getter(name="connectEnd")
    def connect_end(self) -> _builtins.float:
        """
        The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_end")

    @_builtins.property
    @pulumi.getter(name="connectStart")
    def connect_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_start")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult']:
        """
        TCP connection results.  All durations are in milliseconds.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> _builtins.float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @_builtins.property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.float:
        """
        The total duration from start of request until response is fully consumed or the connection is closed.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="encodedBodySize")
    def encoded_body_size(self) -> _builtins.int:
        """
        The size, in octets, of the payload body prior to removing any applied content-codings.
        """
        return pulumi.get(self, "encoded_body_size")

    @_builtins.property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> _builtins.str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="fetchStart")
    def fetch_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts to fetch the resource.
        """
        return pulumi.get(self, "fetch_start")

    @_builtins.property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> _builtins.bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @_builtins.property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> _builtins.bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> _builtins.str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="requestStart")
    def request_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts requesting the resource from the server.
        """
        return pulumi.get(self, "request_start")

    @_builtins.property
    @pulumi.getter(name="responseEnd")
    def response_end(self) -> _builtins.float:
        """
        The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        """
        return pulumi.get(self, "response_end")

    @_builtins.property
    @pulumi.getter(name="responseStart")
    def response_start(self) -> _builtins.float:
        """
        The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        """
        return pulumi.get(self, "response_start")

    @_builtins.property
    @pulumi.getter(name="secureConnectionStart")
    def secure_connection_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts the handshake process to secure the current connection.
        """
        return pulumi.get(self, "secure_connection_start")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The HTTP response status code.
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> _builtins.str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 connect_duration: _builtins.float,
                 port: _builtins.int,
                 secure_connect_duration: _builtins.float):
        """
        :param _builtins.str address: The connection IP address.
        :param _builtins.float connect_duration: Total connect duration, calculated using `connectEnd` minus `connectStart`.
        :param _builtins.int port: The port.
        :param _builtins.float secure_connect_duration: The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "connect_duration", connect_duration)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "secure_connect_duration", secure_connect_duration)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="connectDuration")
    def connect_duration(self) -> _builtins.float:
        """
        Total connect duration, calculated using `connectEnd` minus `connectStart`.
        """
        return pulumi.get(self, "connect_duration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="secureConnectDuration")
    def secure_connect_duration(self) -> _builtins.float:
        """
        The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        return pulumi.get(self, "secure_connect_duration")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[_builtins.str],
                 domain_lookup_duration: _builtins.float):
        """
        :param Sequence[_builtins.str] addresses: The addresses returned by DNS resolution.
        :param _builtins.float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "domain_lookup_duration", domain_lookup_duration)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Sequence[_builtins.str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> _builtins.float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetPingMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingMonitorsPingMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 home_region: _builtins.str,
                 id: _builtins.str,
                 interval_in_seconds: _builtins.int,
                 is_enabled: _builtins.bool,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 results_url: _builtins.str,
                 targets: Sequence[_builtins.str],
                 time_created: _builtins.str,
                 timeout_in_seconds: _builtins.int,
                 vantage_point_names: Sequence[_builtins.str]):
        """
        :param _builtins.str compartment_id: Filters results by compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str home_region: Filters results that match the `homeRegion`.
        :param _builtins.str id: The OCID of the resource.
        :param _builtins.int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param _builtins.bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param _builtins.int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param _builtins.str protocol: The protocols for ping probes.
        :param _builtins.str results_url: A URL for fetching the probe results.
        :param Sequence[_builtins.str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param _builtins.str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param _builtins.int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[_builtins.str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "home_region", home_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "results_url", results_url)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        pulumi.set(__self__, "vantage_point_names", vantage_point_names)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> _builtins.str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> _builtins.int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> _builtins.str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence[_builtins.str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> _builtins.int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[_builtins.str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetPingProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultResult(dict):
    def __init__(__self__, *,
                 connections: Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult'],
                 domain_lookup_end: _builtins.float,
                 domain_lookup_start: _builtins.float,
                 error_category: _builtins.str,
                 error_message: _builtins.str,
                 icmp_code: _builtins.int,
                 is_healthy: _builtins.bool,
                 is_timed_out: _builtins.bool,
                 key: _builtins.str,
                 latency_in_ms: _builtins.float,
                 probe_configuration_id: _builtins.str,
                 protocol: _builtins.str,
                 start_time: _builtins.float,
                 target: _builtins.str,
                 vantage_point_name: _builtins.str):
        """
        :param Sequence['GetPingProbeResultsPingProbeResultConnectionArgs'] connections: The network connection results.
        :param Sequence['GetPingProbeResultsPingProbeResultDnArgs'] dns: The DNS resolution results.
        :param _builtins.float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param _builtins.float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param _builtins.str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param _builtins.str error_message: The error information indicating why a probe execution failed.
        :param _builtins.int icmp_code: The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        :param _builtins.bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param _builtins.bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param _builtins.str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param _builtins.float latency_in_ms: The latency of the probe execution, in milliseconds.
        :param _builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param _builtins.str protocol: The protocols for ping probes.
        :param _builtins.float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param _builtins.str target: Filters results that match the `target`.
        :param _builtins.str vantage_point_name: The name of the vantage point that executed the probe.
        """
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "domain_lookup_end", domain_lookup_end)
        pulumi.set(__self__, "domain_lookup_start", domain_lookup_start)
        pulumi.set(__self__, "error_category", error_category)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "is_healthy", is_healthy)
        pulumi.set(__self__, "is_timed_out", is_timed_out)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "latency_in_ms", latency_in_ms)
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "vantage_point_name", vantage_point_name)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult']:
        """
        The network connection results.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> _builtins.float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @_builtins.property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> _builtins.float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @_builtins.property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> _builtins.str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> _builtins.int:
        """
        The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        """
        return pulumi.get(self, "icmp_code")

    @_builtins.property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> _builtins.bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @_builtins.property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> _builtins.bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="latencyInMs")
    def latency_in_ms(self) -> _builtins.float:
        """
        The latency of the probe execution, in milliseconds.
        """
        return pulumi.get(self, "latency_in_ms")

    @_builtins.property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> _builtins.str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> _builtins.str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str address: The connection IP address.
        :param _builtins.int port: The port.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[_builtins.str],
                 domain_lookup_duration: _builtins.float):
        """
        :param Sequence[_builtins.str] addresses: The addresses returned by DNS resolution.
        :param _builtins.float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "domain_lookup_duration", domain_lookup_duration)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Sequence[_builtins.str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> _builtins.float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetVantagePointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Filters results that exactly match the `name` field.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 geos: Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult'],
                 name: _builtins.str,
                 provider_name: _builtins.str,
                 routings: Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']):
        """
        :param _builtins.str display_name: Filters results that exactly match the `displayName` field.
        :param Sequence['GetVantagePointsHealthChecksVantagePointGeoArgs'] geos: Geographic information about a vantage point.
        :param _builtins.str name: Filters results that exactly match the `name` field.
        :param _builtins.str provider_name: The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        :param Sequence['GetVantagePointsHealthChecksVantagePointRoutingArgs'] routings: An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "geos", geos)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "routings", routings)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def geos(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult']:
        """
        Geographic information about a vantage point.
        """
        return pulumi.get(self, "geos")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> _builtins.str:
        """
        The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def routings(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']:
        """
        An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointGeoResult(dict):
    def __init__(__self__, *,
                 admin_div_code: _builtins.str,
                 city_name: _builtins.str,
                 country_code: _builtins.str,
                 country_name: _builtins.str,
                 geo_key: _builtins.str,
                 latitude: _builtins.float,
                 longitude: _builtins.float):
        """
        :param _builtins.str admin_div_code: The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param _builtins.str city_name: Common English-language name for the city.
        :param _builtins.str country_code: The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param _builtins.str country_name: The common English-language name for the country.
        :param _builtins.str geo_key: An opaque identifier for the geographic location of the vantage point.
        :param _builtins.float latitude: Degrees north of the Equator.
        :param _builtins.float longitude: Degrees east of the prime meridian.
        """
        pulumi.set(__self__, "admin_div_code", admin_div_code)
        pulumi.set(__self__, "city_name", city_name)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "geo_key", geo_key)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @_builtins.property
    @pulumi.getter(name="adminDivCode")
    def admin_div_code(self) -> _builtins.str:
        """
        The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "admin_div_code")

    @_builtins.property
    @pulumi.getter(name="cityName")
    def city_name(self) -> _builtins.str:
        """
        Common English-language name for the city.
        """
        return pulumi.get(self, "city_name")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> _builtins.str:
        """
        The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="countryName")
    def country_name(self) -> _builtins.str:
        """
        The common English-language name for the country.
        """
        return pulumi.get(self, "country_name")

    @_builtins.property
    @pulumi.getter(name="geoKey")
    def geo_key(self) -> _builtins.str:
        """
        An opaque identifier for the geographic location of the vantage point.
        """
        return pulumi.get(self, "geo_key")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> _builtins.float:
        """
        Degrees north of the Equator.
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> _builtins.float:
        """
        Degrees east of the prime meridian.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointRoutingResult(dict):
    def __init__(__self__, *,
                 as_label: _builtins.str,
                 asn: _builtins.int,
                 prefix: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str as_label: The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        :param _builtins.int asn: The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        :param _builtins.str prefix: An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        :param _builtins.int weight: An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        pulumi.set(__self__, "as_label", as_label)
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="asLabel")
    def as_label(self) -> _builtins.str:
        """
        The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        """
        return pulumi.get(self, "as_label")

    @_builtins.property
    @pulumi.getter
    def asn(self) -> _builtins.int:
        """
        The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        return pulumi.get(self, "weight")


