# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsSettingArgs', 'DomainsSetting']

@pulumi.input_type
class DomainsSettingArgs:
    def __init__(__self__, *,
                 csr_access: pulumi.Input[_builtins.str],
                 idcs_endpoint: pulumi.Input[_builtins.str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 setting_id: pulumi.Input[_builtins.str],
                 account_always_trust_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_forgot_password_flow_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_notification_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_event_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_validation: Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']] = None,
                 cloud_gate_cors_settings: Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']] = None,
                 cloud_migration_custom_url: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_migration_url_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 company_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]] = None,
                 contact_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_css_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_translation: Optional[pulumi.Input[_builtins.str]] = None,
                 default_trust_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostic_level: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnostic_record_for_search_identifies_returned_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_terms_of_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_upst_session_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]] = None,
                 is_hosted_page: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]] = None,
                 max_no_of_app_cmva_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 max_no_of_app_role_members_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 prev_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_policy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]] = None,
                 re_auth_factors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 re_auth_when_changing_my_authentication_factors: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[_builtins.str]] = None,
                 service_admin_cannot_list_other_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 signing_cert_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 sub_mapping_attr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]] = None,
                 tenant_custom_claims: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]] = None,
                 terms_of_use_url: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainsSetting resource.
        :param pulumi.Input[_builtins.str] csr_access: (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] setting_id: ID of the resource
        :param pulumi.Input[_builtins.bool] account_always_trust_scope: (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.
               
               **Added In:** 18.1.6
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_forgot_password_flow_return_urls: (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_notification_redirect_urls: (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.
               
               **Added In:** 2009041201
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[_builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[_builtins.int] audit_event_retention_period: (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
        :param pulumi.Input[_builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input['DomainsSettingCertificateValidationArgs'] certificate_validation: (Updatable) Certificate Validation Config
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs'] cloud_gate_cors_settings: (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_migration_custom_url: (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[_builtins.bool] cloud_migration_url_enabled: (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]] company_names: (Updatable) Name of the company in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_emails: (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] custom_branding: (Updatable) Indicates if the branding is default or custom
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] custom_css_location: (Updatable) Storage URL location where the sanitized custom css is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_html_location: (Updatable) Storage URL location where the sanitized custom html is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_translation: (Updatable) Custom translations (JSON String)
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] default_trust_scope: (Updatable) **Deprecated Since: 18.3.6**
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string Indicates the default trust scope for all apps
        :param pulumi.Input[_builtins.int] diagnostic_level: (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] diagnostic_record_for_search_identifies_returned_resources: (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] enable_terms_of_use: (Updatable) Indicates if Terms of Use is enabled in UI
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.int] iam_upst_session_expiry: (Updatable) Maximum duration for IAM User Principal Session Token expiry
               
               **Added In:** 2307071836
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]] images: (Updatable) References to various images
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.bool] is_hosted_page: (Updatable) Indicates if 'hosted' option was selected
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] issuer: (Updatable) Tenant issuer.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] locale: (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]] login_texts: (Updatable) Login text in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.int] max_no_of_app_cmva_to_return: (Updatable) Limit the maximum return of CMVA for an App
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.int] max_no_of_app_role_members_to_return: (Updatable) Limit the maximum return of members for an AppRole
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[_builtins.str] preferred_language: (Updatable) Preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] prev_issuer: (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]] purge_configs: (Updatable) Purge Configs for different Resource Types
               
               **Deprecated Since: 19.1.6**
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [resourceName]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] re_auth_factors: (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] re_auth_when_changing_my_authentication_factors: (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[_builtins.bool] service_admin_cannot_list_other_users: (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.
               
               **Added In:** 2108190438
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.bool] signing_cert_public_access: (Updatable) Indicates if access on SigningCert is allowed to public or not
               
               **Added In:** 17.3.4
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] sub_mapping_attr: (Updatable) **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]] tenant_custom_claims: (Updatable) Custom claims associated with the specific tenant
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] terms_of_use_url: (Updatable) Terms of Use URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "csr_access", csr_access)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "setting_id", setting_id)
        if account_always_trust_scope is not None:
            pulumi.set(__self__, "account_always_trust_scope", account_always_trust_scope)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_forgot_password_flow_return_urls is not None:
            pulumi.set(__self__, "allowed_forgot_password_flow_return_urls", allowed_forgot_password_flow_return_urls)
        if allowed_notification_redirect_urls is not None:
            pulumi.set(__self__, "allowed_notification_redirect_urls", allowed_notification_redirect_urls)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if audit_event_retention_period is not None:
            pulumi.set(__self__, "audit_event_retention_period", audit_event_retention_period)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate_validation is not None:
            pulumi.set(__self__, "certificate_validation", certificate_validation)
        if cloud_gate_cors_settings is not None:
            pulumi.set(__self__, "cloud_gate_cors_settings", cloud_gate_cors_settings)
        if cloud_migration_custom_url is not None:
            pulumi.set(__self__, "cloud_migration_custom_url", cloud_migration_custom_url)
        if cloud_migration_url_enabled is not None:
            pulumi.set(__self__, "cloud_migration_url_enabled", cloud_migration_url_enabled)
        if company_names is not None:
            pulumi.set(__self__, "company_names", company_names)
        if contact_emails is not None:
            pulumi.set(__self__, "contact_emails", contact_emails)
        if custom_branding is not None:
            pulumi.set(__self__, "custom_branding", custom_branding)
        if custom_css_location is not None:
            pulumi.set(__self__, "custom_css_location", custom_css_location)
        if custom_html_location is not None:
            pulumi.set(__self__, "custom_html_location", custom_html_location)
        if custom_translation is not None:
            pulumi.set(__self__, "custom_translation", custom_translation)
        if default_trust_scope is not None:
            pulumi.set(__self__, "default_trust_scope", default_trust_scope)
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)
        if diagnostic_record_for_search_identifies_returned_resources is not None:
            pulumi.set(__self__, "diagnostic_record_for_search_identifies_returned_resources", diagnostic_record_for_search_identifies_returned_resources)
        if enable_terms_of_use is not None:
            pulumi.set(__self__, "enable_terms_of_use", enable_terms_of_use)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if iam_upst_session_expiry is not None:
            pulumi.set(__self__, "iam_upst_session_expiry", iam_upst_session_expiry)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if is_hosted_page is not None:
            pulumi.set(__self__, "is_hosted_page", is_hosted_page)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if login_texts is not None:
            pulumi.set(__self__, "login_texts", login_texts)
        if max_no_of_app_cmva_to_return is not None:
            pulumi.set(__self__, "max_no_of_app_cmva_to_return", max_no_of_app_cmva_to_return)
        if max_no_of_app_role_members_to_return is not None:
            pulumi.set(__self__, "max_no_of_app_role_members_to_return", max_no_of_app_role_members_to_return)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if prev_issuer is not None:
            pulumi.set(__self__, "prev_issuer", prev_issuer)
        if privacy_policy_url is not None:
            pulumi.set(__self__, "privacy_policy_url", privacy_policy_url)
        if purge_configs is not None:
            pulumi.set(__self__, "purge_configs", purge_configs)
        if re_auth_factors is not None:
            pulumi.set(__self__, "re_auth_factors", re_auth_factors)
        if re_auth_when_changing_my_authentication_factors is not None:
            pulumi.set(__self__, "re_auth_when_changing_my_authentication_factors", re_auth_when_changing_my_authentication_factors)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if service_admin_cannot_list_other_users is not None:
            pulumi.set(__self__, "service_admin_cannot_list_other_users", service_admin_cannot_list_other_users)
        if signing_cert_public_access is not None:
            pulumi.set(__self__, "signing_cert_public_access", signing_cert_public_access)
        if sub_mapping_attr is not None:
            pulumi.set(__self__, "sub_mapping_attr", sub_mapping_attr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_custom_claims is not None:
            pulumi.set(__self__, "tenant_custom_claims", tenant_custom_claims)
        if terms_of_use_url is not None:
            pulumi.set(__self__, "terms_of_use_url", terms_of_use_url)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="csrAccess")
    def csr_access(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        """
        return pulumi.get(self, "csr_access")

    @csr_access.setter
    def csr_access(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "csr_access", value)

    @_builtins.property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "setting_id", value)

    @_builtins.property
    @pulumi.getter(name="accountAlwaysTrustScope")
    def account_always_trust_scope(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "account_always_trust_scope")

    @account_always_trust_scope.setter
    def account_always_trust_scope(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "account_always_trust_scope", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedForgotPasswordFlowReturnUrls")
    def allowed_forgot_password_flow_return_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_forgot_password_flow_return_urls")

    @allowed_forgot_password_flow_return_urls.setter
    def allowed_forgot_password_flow_return_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_forgot_password_flow_return_urls", value)

    @_builtins.property
    @pulumi.getter(name="allowedNotificationRedirectUrls")
    def allowed_notification_redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.

        **Added In:** 2009041201

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_notification_redirect_urls")

    @allowed_notification_redirect_urls.setter
    def allowed_notification_redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_notification_redirect_urls", value)

    @_builtins.property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="auditEventRetentionPeriod")
    def audit_event_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        """
        return pulumi.get(self, "audit_event_retention_period")

    @audit_event_retention_period.setter
    def audit_event_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "audit_event_retention_period", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="certificateValidation")
    def certificate_validation(self) -> Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']]:
        """
        (Updatable) Certificate Validation Config

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificate_validation")

    @certificate_validation.setter
    def certificate_validation(self, value: Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']]):
        pulumi.set(self, "certificate_validation", value)

    @_builtins.property
    @pulumi.getter(name="cloudGateCorsSettings")
    def cloud_gate_cors_settings(self) -> Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']]:
        """
        (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_gate_cors_settings")

    @cloud_gate_cors_settings.setter
    def cloud_gate_cors_settings(self, value: Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']]):
        pulumi.set(self, "cloud_gate_cors_settings", value)

    @_builtins.property
    @pulumi.getter(name="cloudMigrationCustomUrl")
    def cloud_migration_custom_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "cloud_migration_custom_url")

    @cloud_migration_custom_url.setter
    def cloud_migration_custom_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_migration_custom_url", value)

    @_builtins.property
    @pulumi.getter(name="cloudMigrationUrlEnabled")
    def cloud_migration_url_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_migration_url_enabled")

    @cloud_migration_url_enabled.setter
    def cloud_migration_url_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_migration_url_enabled", value)

    @_builtins.property
    @pulumi.getter(name="companyNames")
    def company_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]]:
        """
        (Updatable) Name of the company in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "company_names")

    @company_names.setter
    def company_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]]):
        pulumi.set(self, "company_names", value)

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_emails")

    @contact_emails.setter
    def contact_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "contact_emails", value)

    @_builtins.property
    @pulumi.getter(name="customBranding")
    def custom_branding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the branding is default or custom

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "custom_branding")

    @custom_branding.setter
    def custom_branding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "custom_branding", value)

    @_builtins.property
    @pulumi.getter(name="customCssLocation")
    def custom_css_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_css_location")

    @custom_css_location.setter
    def custom_css_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_css_location", value)

    @_builtins.property
    @pulumi.getter(name="customHtmlLocation")
    def custom_html_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_html_location")

    @custom_html_location.setter
    def custom_html_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_html_location", value)

    @_builtins.property
    @pulumi.getter(name="customTranslation")
    def custom_translation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_translation")

    @custom_translation.setter
    def custom_translation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_translation", value)

    @_builtins.property
    @pulumi.getter(name="defaultTrustScope")
    def default_trust_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) **Deprecated Since: 18.3.6**

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string Indicates the default trust scope for all apps
        """
        return pulumi.get(self, "default_trust_scope")

    @default_trust_scope.setter
    def default_trust_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_trust_scope", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_level")

    @diagnostic_level.setter
    def diagnostic_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "diagnostic_level", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticRecordForSearchIdentifiesReturnedResources")
    def diagnostic_record_for_search_identifies_returned_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_record_for_search_identifies_returned_resources")

    @diagnostic_record_for_search_identifies_returned_resources.setter
    def diagnostic_record_for_search_identifies_returned_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "diagnostic_record_for_search_identifies_returned_resources", value)

    @_builtins.property
    @pulumi.getter(name="enableTermsOfUse")
    def enable_terms_of_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enable_terms_of_use")

    @enable_terms_of_use.setter
    def enable_terms_of_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_terms_of_use", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamUpstSessionExpiry")
    def iam_upst_session_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Maximum duration for IAM User Principal Session Token expiry

        **Added In:** 2307071836

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "iam_upst_session_expiry")

    @iam_upst_session_expiry.setter
    def iam_upst_session_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iam_upst_session_expiry", value)

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]]:
        """
        (Updatable) References to various images

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]]):
        pulumi.set(self, "images", value)

    @_builtins.property
    @pulumi.getter(name="isHostedPage")
    def is_hosted_page(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_hosted_page")

    @is_hosted_page.setter
    def is_hosted_page(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hosted_page", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Tenant issuer.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="loginTexts")
    def login_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]]:
        """
        (Updatable) Login text in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "login_texts")

    @login_texts.setter
    def login_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]]):
        pulumi.set(self, "login_texts", value)

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppCmvaToReturn")
    def max_no_of_app_cmva_to_return(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Limit the maximum return of CMVA for an App

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_cmva_to_return")

    @max_no_of_app_cmva_to_return.setter
    def max_no_of_app_cmva_to_return(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_no_of_app_cmva_to_return", value)

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppRoleMembersToReturn")
    def max_no_of_app_role_members_to_return(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Limit the maximum return of members for an AppRole

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_role_members_to_return")

    @max_no_of_app_role_members_to_return.setter
    def max_no_of_app_role_members_to_return(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_no_of_app_role_members_to_return", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @_builtins.property
    @pulumi.getter(name="prevIssuer")
    def prev_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "prev_issuer")

    @prev_issuer.setter
    def prev_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prev_issuer", value)

    @_builtins.property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @privacy_policy_url.setter
    def privacy_policy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privacy_policy_url", value)

    @_builtins.property
    @pulumi.getter(name="purgeConfigs")
    def purge_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]]:
        """
        (Updatable) Purge Configs for different Resource Types

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
        * idcsCompositeKey: [resourceName]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "purge_configs")

    @purge_configs.setter
    def purge_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]]):
        pulumi.set(self, "purge_configs", value)

    @_builtins.property
    @pulumi.getter(name="reAuthFactors")
    def re_auth_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        """
        return pulumi.get(self, "re_auth_factors")

    @re_auth_factors.setter
    def re_auth_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "re_auth_factors", value)

    @_builtins.property
    @pulumi.getter(name="reAuthWhenChangingMyAuthenticationFactors")
    def re_auth_when_changing_my_authentication_factors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "re_auth_when_changing_my_authentication_factors")

    @re_auth_when_changing_my_authentication_factors.setter
    def re_auth_when_changing_my_authentication_factors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "re_auth_when_changing_my_authentication_factors", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @_builtins.property
    @pulumi.getter(name="serviceAdminCannotListOtherUsers")
    def service_admin_cannot_list_other_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.

        **Added In:** 2108190438

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "service_admin_cannot_list_other_users")

    @service_admin_cannot_list_other_users.setter
    def service_admin_cannot_list_other_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_admin_cannot_list_other_users", value)

    @_builtins.property
    @pulumi.getter(name="signingCertPublicAccess")
    def signing_cert_public_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if access on SigningCert is allowed to public or not

        **Added In:** 17.3.4

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "signing_cert_public_access")

    @signing_cert_public_access.setter
    def signing_cert_public_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "signing_cert_public_access", value)

    @_builtins.property
    @pulumi.getter(name="subMappingAttr")
    def sub_mapping_attr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        """
        return pulumi.get(self, "sub_mapping_attr")

    @sub_mapping_attr.setter
    def sub_mapping_attr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_mapping_attr", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantCustomClaims")
    def tenant_custom_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]]:
        """
        (Updatable) Custom claims associated with the specific tenant

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tenant_custom_claims")

    @tenant_custom_claims.setter
    def tenant_custom_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]]):
        pulumi.set(self, "tenant_custom_claims", value)

    @_builtins.property
    @pulumi.getter(name="termsOfUseUrl")
    def terms_of_use_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_use_url")

    @terms_of_use_url.setter
    def terms_of_use_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "terms_of_use_url", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _DomainsSettingState:
    def __init__(__self__, *,
                 account_always_trust_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_forgot_password_flow_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_notification_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_event_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_validation: Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']] = None,
                 cloud_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_gate_cors_settings: Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']] = None,
                 cloud_migration_custom_url: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_migration_url_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 company_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]] = None,
                 compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 contact_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 csr_access: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_css_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_translation: Optional[pulumi.Input[_builtins.str]] = None,
                 default_company_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultCompanyNameArgs']]]] = None,
                 default_images: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultImageArgs']]]] = None,
                 default_login_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultLoginTextArgs']]]] = None,
                 default_trust_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[_builtins.bool]] = None,
                 diagnostic_level: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnostic_record_for_search_identifies_returned_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 diagnostic_tracing_upto: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_terms_of_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_upst_session_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[_builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]] = None,
                 is_hosted_page: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login_texts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]] = None,
                 max_no_of_app_cmva_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 max_no_of_app_role_members_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingMetaArgs']]]] = None,
                 migration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 on_premises_provisioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 prev_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_policy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]] = None,
                 re_auth_factors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 re_auth_when_changing_my_authentication_factors: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_admin_cannot_list_other_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_cert_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 sub_mapping_attr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_custom_claims: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]] = None,
                 terms_of_use_url: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsSetting resources.
        :param pulumi.Input[_builtins.bool] account_always_trust_scope: (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.
               
               **Added In:** 18.1.6
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_forgot_password_flow_return_urls: (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_notification_redirect_urls: (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.
               
               **Added In:** 2009041201
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[_builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[_builtins.int] audit_event_retention_period: (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
        :param pulumi.Input[_builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input['DomainsSettingCertificateValidationArgs'] certificate_validation: (Updatable) Certificate Validation Config
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_account_name: (Updatable) The attribute to store the cloud account name
               
               **Deprecated Since: 2011192329**
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs'] cloud_gate_cors_settings: (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_migration_custom_url: (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[_builtins.bool] cloud_migration_url_enabled: (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]] company_names: (Updatable) Name of the company in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_emails: (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] csr_access: (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] custom_branding: (Updatable) Indicates if the branding is default or custom
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] custom_css_location: (Updatable) Storage URL location where the sanitized custom css is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_html_location: (Updatable) Storage URL location where the sanitized custom html is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_translation: (Updatable) Custom translations (JSON String)
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultCompanyNameArgs']]] default_company_names: (Updatable) Default name of the Company in different locales
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultImageArgs']]] default_images: (Updatable) References to various images
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultLoginTextArgs']]] default_login_texts: (Updatable) Default Login text in different locales
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] default_trust_scope: (Updatable) **Deprecated Since: 18.3.6**
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string Indicates the default trust scope for all apps
        :param pulumi.Input[_builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.int] diagnostic_level: (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] diagnostic_record_for_search_identifies_returned_resources: (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] diagnostic_tracing_upto: (Updatable) The end time up to which diagnostic recording is switched on
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[_builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] enable_terms_of_use: (Updatable) Indicates if Terms of Use is enabled in UI
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.int] iam_upst_session_expiry: (Updatable) Maximum duration for IAM User Principal Session Token expiry
               
               **Added In:** 2307071836
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]] images: (Updatable) References to various images
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.bool] is_hosted_page: (Updatable) Indicates if 'hosted' option was selected
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] issuer: (Updatable) Tenant issuer.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] locale: (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]] login_texts: (Updatable) Login text in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.int] max_no_of_app_cmva_to_return: (Updatable) Limit the maximum return of CMVA for an App
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.int] max_no_of_app_role_members_to_return: (Updatable) Limit the maximum return of members for an AppRole
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[_builtins.str] migration_status: (Updatable) Database Migration Status
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[_builtins.bool] on_premises_provisioning: (Updatable) On-Premises provisioning feature toggle.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] preferred_language: (Updatable) Preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] prev_issuer: (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]] purge_configs: (Updatable) Purge Configs for different Resource Types
               
               **Deprecated Since: 19.1.6**
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [resourceName]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] re_auth_factors: (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] re_auth_when_changing_my_authentication_factors: (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] service_admin_cannot_list_other_users: (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.
               
               **Added In:** 2108190438
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] setting_id: ID of the resource
        :param pulumi.Input[_builtins.bool] signing_cert_public_access: (Updatable) Indicates if access on SigningCert is allowed to public or not
               
               **Added In:** 17.3.4
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] sub_mapping_attr: (Updatable) **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]] tenant_custom_claims: (Updatable) Custom claims associated with the specific tenant
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] terms_of_use_url: (Updatable) Terms of Use URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if account_always_trust_scope is not None:
            pulumi.set(__self__, "account_always_trust_scope", account_always_trust_scope)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_forgot_password_flow_return_urls is not None:
            pulumi.set(__self__, "allowed_forgot_password_flow_return_urls", allowed_forgot_password_flow_return_urls)
        if allowed_notification_redirect_urls is not None:
            pulumi.set(__self__, "allowed_notification_redirect_urls", allowed_notification_redirect_urls)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if audit_event_retention_period is not None:
            pulumi.set(__self__, "audit_event_retention_period", audit_event_retention_period)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate_validation is not None:
            pulumi.set(__self__, "certificate_validation", certificate_validation)
        if cloud_account_name is not None:
            pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        if cloud_gate_cors_settings is not None:
            pulumi.set(__self__, "cloud_gate_cors_settings", cloud_gate_cors_settings)
        if cloud_migration_custom_url is not None:
            pulumi.set(__self__, "cloud_migration_custom_url", cloud_migration_custom_url)
        if cloud_migration_url_enabled is not None:
            pulumi.set(__self__, "cloud_migration_url_enabled", cloud_migration_url_enabled)
        if company_names is not None:
            pulumi.set(__self__, "company_names", company_names)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if contact_emails is not None:
            pulumi.set(__self__, "contact_emails", contact_emails)
        if csr_access is not None:
            pulumi.set(__self__, "csr_access", csr_access)
        if custom_branding is not None:
            pulumi.set(__self__, "custom_branding", custom_branding)
        if custom_css_location is not None:
            pulumi.set(__self__, "custom_css_location", custom_css_location)
        if custom_html_location is not None:
            pulumi.set(__self__, "custom_html_location", custom_html_location)
        if custom_translation is not None:
            pulumi.set(__self__, "custom_translation", custom_translation)
        if default_company_names is not None:
            pulumi.set(__self__, "default_company_names", default_company_names)
        if default_images is not None:
            pulumi.set(__self__, "default_images", default_images)
        if default_login_texts is not None:
            pulumi.set(__self__, "default_login_texts", default_login_texts)
        if default_trust_scope is not None:
            pulumi.set(__self__, "default_trust_scope", default_trust_scope)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)
        if diagnostic_record_for_search_identifies_returned_resources is not None:
            pulumi.set(__self__, "diagnostic_record_for_search_identifies_returned_resources", diagnostic_record_for_search_identifies_returned_resources)
        if diagnostic_tracing_upto is not None:
            pulumi.set(__self__, "diagnostic_tracing_upto", diagnostic_tracing_upto)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if enable_terms_of_use is not None:
            pulumi.set(__self__, "enable_terms_of_use", enable_terms_of_use)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if iam_upst_session_expiry is not None:
            pulumi.set(__self__, "iam_upst_session_expiry", iam_upst_session_expiry)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if is_hosted_page is not None:
            pulumi.set(__self__, "is_hosted_page", is_hosted_page)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if login_texts is not None:
            pulumi.set(__self__, "login_texts", login_texts)
        if max_no_of_app_cmva_to_return is not None:
            pulumi.set(__self__, "max_no_of_app_cmva_to_return", max_no_of_app_cmva_to_return)
        if max_no_of_app_role_members_to_return is not None:
            pulumi.set(__self__, "max_no_of_app_role_members_to_return", max_no_of_app_role_members_to_return)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if migration_status is not None:
            pulumi.set(__self__, "migration_status", migration_status)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if on_premises_provisioning is not None:
            pulumi.set(__self__, "on_premises_provisioning", on_premises_provisioning)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if prev_issuer is not None:
            pulumi.set(__self__, "prev_issuer", prev_issuer)
        if privacy_policy_url is not None:
            pulumi.set(__self__, "privacy_policy_url", privacy_policy_url)
        if purge_configs is not None:
            pulumi.set(__self__, "purge_configs", purge_configs)
        if re_auth_factors is not None:
            pulumi.set(__self__, "re_auth_factors", re_auth_factors)
        if re_auth_when_changing_my_authentication_factors is not None:
            pulumi.set(__self__, "re_auth_when_changing_my_authentication_factors", re_auth_when_changing_my_authentication_factors)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if service_admin_cannot_list_other_users is not None:
            pulumi.set(__self__, "service_admin_cannot_list_other_users", service_admin_cannot_list_other_users)
        if setting_id is not None:
            pulumi.set(__self__, "setting_id", setting_id)
        if signing_cert_public_access is not None:
            pulumi.set(__self__, "signing_cert_public_access", signing_cert_public_access)
        if sub_mapping_attr is not None:
            pulumi.set(__self__, "sub_mapping_attr", sub_mapping_attr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if tenant_custom_claims is not None:
            pulumi.set(__self__, "tenant_custom_claims", tenant_custom_claims)
        if terms_of_use_url is not None:
            pulumi.set(__self__, "terms_of_use_url", terms_of_use_url)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="accountAlwaysTrustScope")
    def account_always_trust_scope(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "account_always_trust_scope")

    @account_always_trust_scope.setter
    def account_always_trust_scope(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "account_always_trust_scope", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedForgotPasswordFlowReturnUrls")
    def allowed_forgot_password_flow_return_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_forgot_password_flow_return_urls")

    @allowed_forgot_password_flow_return_urls.setter
    def allowed_forgot_password_flow_return_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_forgot_password_flow_return_urls", value)

    @_builtins.property
    @pulumi.getter(name="allowedNotificationRedirectUrls")
    def allowed_notification_redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.

        **Added In:** 2009041201

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_notification_redirect_urls")

    @allowed_notification_redirect_urls.setter
    def allowed_notification_redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_notification_redirect_urls", value)

    @_builtins.property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="auditEventRetentionPeriod")
    def audit_event_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        """
        return pulumi.get(self, "audit_event_retention_period")

    @audit_event_retention_period.setter
    def audit_event_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "audit_event_retention_period", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="certificateValidation")
    def certificate_validation(self) -> Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']]:
        """
        (Updatable) Certificate Validation Config

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificate_validation")

    @certificate_validation.setter
    def certificate_validation(self, value: Optional[pulumi.Input['DomainsSettingCertificateValidationArgs']]):
        pulumi.set(self, "certificate_validation", value)

    @_builtins.property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The attribute to store the cloud account name

        **Deprecated Since: 2011192329**

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_account_name")

    @cloud_account_name.setter
    def cloud_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_account_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudGateCorsSettings")
    def cloud_gate_cors_settings(self) -> Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']]:
        """
        (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_gate_cors_settings")

    @cloud_gate_cors_settings.setter
    def cloud_gate_cors_settings(self, value: Optional[pulumi.Input['DomainsSettingCloudGateCorsSettingsArgs']]):
        pulumi.set(self, "cloud_gate_cors_settings", value)

    @_builtins.property
    @pulumi.getter(name="cloudMigrationCustomUrl")
    def cloud_migration_custom_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "cloud_migration_custom_url")

    @cloud_migration_custom_url.setter
    def cloud_migration_custom_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_migration_custom_url", value)

    @_builtins.property
    @pulumi.getter(name="cloudMigrationUrlEnabled")
    def cloud_migration_url_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_migration_url_enabled")

    @cloud_migration_url_enabled.setter
    def cloud_migration_url_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_migration_url_enabled", value)

    @_builtins.property
    @pulumi.getter(name="companyNames")
    def company_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]]:
        """
        (Updatable) Name of the company in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "company_names")

    @company_names.setter
    def company_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingCompanyNameArgs']]]]):
        pulumi.set(self, "company_names", value)

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_emails")

    @contact_emails.setter
    def contact_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "contact_emails", value)

    @_builtins.property
    @pulumi.getter(name="csrAccess")
    def csr_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        """
        return pulumi.get(self, "csr_access")

    @csr_access.setter
    def csr_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr_access", value)

    @_builtins.property
    @pulumi.getter(name="customBranding")
    def custom_branding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the branding is default or custom

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "custom_branding")

    @custom_branding.setter
    def custom_branding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "custom_branding", value)

    @_builtins.property
    @pulumi.getter(name="customCssLocation")
    def custom_css_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_css_location")

    @custom_css_location.setter
    def custom_css_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_css_location", value)

    @_builtins.property
    @pulumi.getter(name="customHtmlLocation")
    def custom_html_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_html_location")

    @custom_html_location.setter
    def custom_html_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_html_location", value)

    @_builtins.property
    @pulumi.getter(name="customTranslation")
    def custom_translation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_translation")

    @custom_translation.setter
    def custom_translation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_translation", value)

    @_builtins.property
    @pulumi.getter(name="defaultCompanyNames")
    def default_company_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultCompanyNameArgs']]]]:
        """
        (Updatable) Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_company_names")

    @default_company_names.setter
    def default_company_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultCompanyNameArgs']]]]):
        pulumi.set(self, "default_company_names", value)

    @_builtins.property
    @pulumi.getter(name="defaultImages")
    def default_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultImageArgs']]]]:
        """
        (Updatable) References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_images")

    @default_images.setter
    def default_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultImageArgs']]]]):
        pulumi.set(self, "default_images", value)

    @_builtins.property
    @pulumi.getter(name="defaultLoginTexts")
    def default_login_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultLoginTextArgs']]]]:
        """
        (Updatable) Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_login_texts")

    @default_login_texts.setter
    def default_login_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingDefaultLoginTextArgs']]]]):
        pulumi.set(self, "default_login_texts", value)

    @_builtins.property
    @pulumi.getter(name="defaultTrustScope")
    def default_trust_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) **Deprecated Since: 18.3.6**

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string Indicates the default trust scope for all apps
        """
        return pulumi.get(self, "default_trust_scope")

    @default_trust_scope.setter
    def default_trust_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_trust_scope", value)

    @_builtins.property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_level")

    @diagnostic_level.setter
    def diagnostic_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "diagnostic_level", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticRecordForSearchIdentifiesReturnedResources")
    def diagnostic_record_for_search_identifies_returned_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_record_for_search_identifies_returned_resources")

    @diagnostic_record_for_search_identifies_returned_resources.setter
    def diagnostic_record_for_search_identifies_returned_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "diagnostic_record_for_search_identifies_returned_resources", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticTracingUpto")
    def diagnostic_tracing_upto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The end time up to which diagnostic recording is switched on

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_tracing_upto")

    @diagnostic_tracing_upto.setter
    def diagnostic_tracing_upto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "diagnostic_tracing_upto", value)

    @_builtins.property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @_builtins.property
    @pulumi.getter(name="enableTermsOfUse")
    def enable_terms_of_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enable_terms_of_use")

    @enable_terms_of_use.setter
    def enable_terms_of_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_terms_of_use", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="iamUpstSessionExpiry")
    def iam_upst_session_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Maximum duration for IAM User Principal Session Token expiry

        **Added In:** 2307071836

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "iam_upst_session_expiry")

    @iam_upst_session_expiry.setter
    def iam_upst_session_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iam_upst_session_expiry", value)

    @_builtins.property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @_builtins.property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @_builtins.property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @_builtins.property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]]:
        """
        (Updatable) References to various images

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingImageArgs']]]]):
        pulumi.set(self, "images", value)

    @_builtins.property
    @pulumi.getter(name="isHostedPage")
    def is_hosted_page(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_hosted_page")

    @is_hosted_page.setter
    def is_hosted_page(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hosted_page", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Tenant issuer.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="loginTexts")
    def login_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]]:
        """
        (Updatable) Login text in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "login_texts")

    @login_texts.setter
    def login_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingLoginTextArgs']]]]):
        pulumi.set(self, "login_texts", value)

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppCmvaToReturn")
    def max_no_of_app_cmva_to_return(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Limit the maximum return of CMVA for an App

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_cmva_to_return")

    @max_no_of_app_cmva_to_return.setter
    def max_no_of_app_cmva_to_return(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_no_of_app_cmva_to_return", value)

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppRoleMembersToReturn")
    def max_no_of_app_role_members_to_return(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Limit the maximum return of members for an AppRole

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_role_members_to_return")

    @max_no_of_app_role_members_to_return.setter
    def max_no_of_app_role_members_to_return(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_no_of_app_role_members_to_return", value)

    @_builtins.property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @_builtins.property
    @pulumi.getter(name="migrationStatus")
    def migration_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Database Migration Status

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "migration_status")

    @migration_status.setter
    def migration_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_status", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="onPremisesProvisioning")
    def on_premises_provisioning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) On-Premises provisioning feature toggle.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "on_premises_provisioning")

    @on_premises_provisioning.setter
    def on_premises_provisioning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_premises_provisioning", value)

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @_builtins.property
    @pulumi.getter(name="prevIssuer")
    def prev_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "prev_issuer")

    @prev_issuer.setter
    def prev_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prev_issuer", value)

    @_builtins.property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @privacy_policy_url.setter
    def privacy_policy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privacy_policy_url", value)

    @_builtins.property
    @pulumi.getter(name="purgeConfigs")
    def purge_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]]:
        """
        (Updatable) Purge Configs for different Resource Types

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
        * idcsCompositeKey: [resourceName]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "purge_configs")

    @purge_configs.setter
    def purge_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingPurgeConfigArgs']]]]):
        pulumi.set(self, "purge_configs", value)

    @_builtins.property
    @pulumi.getter(name="reAuthFactors")
    def re_auth_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        """
        return pulumi.get(self, "re_auth_factors")

    @re_auth_factors.setter
    def re_auth_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "re_auth_factors", value)

    @_builtins.property
    @pulumi.getter(name="reAuthWhenChangingMyAuthenticationFactors")
    def re_auth_when_changing_my_authentication_factors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "re_auth_when_changing_my_authentication_factors")

    @re_auth_when_changing_my_authentication_factors.setter
    def re_auth_when_changing_my_authentication_factors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "re_auth_when_changing_my_authentication_factors", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @_builtins.property
    @pulumi.getter(name="serviceAdminCannotListOtherUsers")
    def service_admin_cannot_list_other_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.

        **Added In:** 2108190438

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "service_admin_cannot_list_other_users")

    @service_admin_cannot_list_other_users.setter
    def service_admin_cannot_list_other_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_admin_cannot_list_other_users", value)

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the resource
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "setting_id", value)

    @_builtins.property
    @pulumi.getter(name="signingCertPublicAccess")
    def signing_cert_public_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if access on SigningCert is allowed to public or not

        **Added In:** 17.3.4

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "signing_cert_public_access")

    @signing_cert_public_access.setter
    def signing_cert_public_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "signing_cert_public_access", value)

    @_builtins.property
    @pulumi.getter(name="subMappingAttr")
    def sub_mapping_attr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        """
        return pulumi.get(self, "sub_mapping_attr")

    @sub_mapping_attr.setter
    def sub_mapping_attr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_mapping_attr", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @_builtins.property
    @pulumi.getter(name="tenantCustomClaims")
    def tenant_custom_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]]:
        """
        (Updatable) Custom claims associated with the specific tenant

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tenant_custom_claims")

    @tenant_custom_claims.setter
    def tenant_custom_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSettingTenantCustomClaimArgs']]]]):
        pulumi.set(self, "tenant_custom_claims", value)

    @_builtins.property
    @pulumi.getter(name="termsOfUseUrl")
    def terms_of_use_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_use_url")

    @terms_of_use_url.setter
    def terms_of_use_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "terms_of_use_url", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("oci:Identity/domainsSetting:DomainsSetting")
class DomainsSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_always_trust_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_forgot_password_flow_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_notification_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_event_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_validation: Optional[pulumi.Input[Union['DomainsSettingCertificateValidationArgs', 'DomainsSettingCertificateValidationArgsDict']]] = None,
                 cloud_gate_cors_settings: Optional[pulumi.Input[Union['DomainsSettingCloudGateCorsSettingsArgs', 'DomainsSettingCloudGateCorsSettingsArgsDict']]] = None,
                 cloud_migration_custom_url: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_migration_url_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 company_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingCompanyNameArgs', 'DomainsSettingCompanyNameArgsDict']]]]] = None,
                 contact_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 csr_access: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_css_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_translation: Optional[pulumi.Input[_builtins.str]] = None,
                 default_trust_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostic_level: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnostic_record_for_search_identifies_returned_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_terms_of_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_upst_session_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 idcs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingImageArgs', 'DomainsSettingImageArgsDict']]]]] = None,
                 is_hosted_page: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingLoginTextArgs', 'DomainsSettingLoginTextArgsDict']]]]] = None,
                 max_no_of_app_cmva_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 max_no_of_app_role_members_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 prev_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_policy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingPurgeConfigArgs', 'DomainsSettingPurgeConfigArgsDict']]]]] = None,
                 re_auth_factors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 re_auth_when_changing_my_authentication_factors: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_admin_cannot_list_other_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_cert_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 sub_mapping_attr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTagArgs', 'DomainsSettingTagArgsDict']]]]] = None,
                 tenant_custom_claims: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTenantCustomClaimArgs', 'DomainsSettingTenantCustomClaimArgsDict']]]]] = None,
                 terms_of_use_url: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace Settings

        ## Import

        Settings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSetting:DomainsSetting test_setting "idcsEndpoint/{idcsEndpoint}/settings/{settingId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] account_always_trust_scope: (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.
               
               **Added In:** 18.1.6
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_forgot_password_flow_return_urls: (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_notification_redirect_urls: (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.
               
               **Added In:** 2009041201
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[_builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[_builtins.int] audit_event_retention_period: (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
        :param pulumi.Input[_builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[Union['DomainsSettingCertificateValidationArgs', 'DomainsSettingCertificateValidationArgsDict']] certificate_validation: (Updatable) Certificate Validation Config
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsSettingCloudGateCorsSettingsArgs', 'DomainsSettingCloudGateCorsSettingsArgsDict']] cloud_gate_cors_settings: (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_migration_custom_url: (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[_builtins.bool] cloud_migration_url_enabled: (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingCompanyNameArgs', 'DomainsSettingCompanyNameArgsDict']]]] company_names: (Updatable) Name of the company in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_emails: (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] csr_access: (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] custom_branding: (Updatable) Indicates if the branding is default or custom
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] custom_css_location: (Updatable) Storage URL location where the sanitized custom css is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_html_location: (Updatable) Storage URL location where the sanitized custom html is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_translation: (Updatable) Custom translations (JSON String)
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] default_trust_scope: (Updatable) **Deprecated Since: 18.3.6**
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string Indicates the default trust scope for all apps
        :param pulumi.Input[_builtins.int] diagnostic_level: (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] diagnostic_record_for_search_identifies_returned_resources: (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] enable_terms_of_use: (Updatable) Indicates if Terms of Use is enabled in UI
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.int] iam_upst_session_expiry: (Updatable) Maximum duration for IAM User Principal Session Token expiry
               
               **Added In:** 2307071836
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingImageArgs', 'DomainsSettingImageArgsDict']]]] images: (Updatable) References to various images
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.bool] is_hosted_page: (Updatable) Indicates if 'hosted' option was selected
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] issuer: (Updatable) Tenant issuer.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] locale: (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingLoginTextArgs', 'DomainsSettingLoginTextArgsDict']]]] login_texts: (Updatable) Login text in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.int] max_no_of_app_cmva_to_return: (Updatable) Limit the maximum return of CMVA for an App
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.int] max_no_of_app_role_members_to_return: (Updatable) Limit the maximum return of members for an AppRole
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[_builtins.str] preferred_language: (Updatable) Preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] prev_issuer: (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingPurgeConfigArgs', 'DomainsSettingPurgeConfigArgsDict']]]] purge_configs: (Updatable) Purge Configs for different Resource Types
               
               **Deprecated Since: 19.1.6**
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [resourceName]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] re_auth_factors: (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] re_auth_when_changing_my_authentication_factors: (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] service_admin_cannot_list_other_users: (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.
               
               **Added In:** 2108190438
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] setting_id: ID of the resource
        :param pulumi.Input[_builtins.bool] signing_cert_public_access: (Updatable) Indicates if access on SigningCert is allowed to public or not
               
               **Added In:** 17.3.4
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] sub_mapping_attr: (Updatable) **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTagArgs', 'DomainsSettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTenantCustomClaimArgs', 'DomainsSettingTenantCustomClaimArgsDict']]]] tenant_custom_claims: (Updatable) Custom claims associated with the specific tenant
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] terms_of_use_url: (Updatable) Terms of Use URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace Settings

        ## Import

        Settings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsSetting:DomainsSetting test_setting "idcsEndpoint/{idcsEndpoint}/settings/{settingId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_always_trust_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_forgot_password_flow_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_notification_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_event_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 authorization: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_validation: Optional[pulumi.Input[Union['DomainsSettingCertificateValidationArgs', 'DomainsSettingCertificateValidationArgsDict']]] = None,
                 cloud_gate_cors_settings: Optional[pulumi.Input[Union['DomainsSettingCloudGateCorsSettingsArgs', 'DomainsSettingCloudGateCorsSettingsArgsDict']]] = None,
                 cloud_migration_custom_url: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_migration_url_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 company_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingCompanyNameArgs', 'DomainsSettingCompanyNameArgsDict']]]]] = None,
                 contact_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 csr_access: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_css_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_html_location: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_translation: Optional[pulumi.Input[_builtins.str]] = None,
                 default_trust_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostic_level: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnostic_record_for_search_identifies_returned_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_terms_of_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_upst_session_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 idcs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingImageArgs', 'DomainsSettingImageArgsDict']]]]] = None,
                 is_hosted_page: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingLoginTextArgs', 'DomainsSettingLoginTextArgsDict']]]]] = None,
                 max_no_of_app_cmva_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 max_no_of_app_role_members_to_return: Optional[pulumi.Input[_builtins.int]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 prev_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_policy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingPurgeConfigArgs', 'DomainsSettingPurgeConfigArgsDict']]]]] = None,
                 re_auth_factors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 re_auth_when_changing_my_authentication_factors: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_admin_cannot_list_other_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_cert_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 sub_mapping_attr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTagArgs', 'DomainsSettingTagArgsDict']]]]] = None,
                 tenant_custom_claims: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTenantCustomClaimArgs', 'DomainsSettingTenantCustomClaimArgsDict']]]]] = None,
                 terms_of_use_url: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsSettingArgs.__new__(DomainsSettingArgs)

            __props__.__dict__["account_always_trust_scope"] = account_always_trust_scope
            __props__.__dict__["allowed_domains"] = allowed_domains
            __props__.__dict__["allowed_forgot_password_flow_return_urls"] = None if allowed_forgot_password_flow_return_urls is None else pulumi.Output.secret(allowed_forgot_password_flow_return_urls)
            __props__.__dict__["allowed_notification_redirect_urls"] = allowed_notification_redirect_urls
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["audit_event_retention_period"] = audit_event_retention_period
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["certificate_validation"] = certificate_validation
            __props__.__dict__["cloud_gate_cors_settings"] = cloud_gate_cors_settings
            __props__.__dict__["cloud_migration_custom_url"] = cloud_migration_custom_url
            __props__.__dict__["cloud_migration_url_enabled"] = cloud_migration_url_enabled
            __props__.__dict__["company_names"] = company_names
            __props__.__dict__["contact_emails"] = contact_emails
            if csr_access is None and not opts.urn:
                raise TypeError("Missing required property 'csr_access'")
            __props__.__dict__["csr_access"] = csr_access
            __props__.__dict__["custom_branding"] = custom_branding
            __props__.__dict__["custom_css_location"] = custom_css_location
            __props__.__dict__["custom_html_location"] = custom_html_location
            __props__.__dict__["custom_translation"] = custom_translation
            __props__.__dict__["default_trust_scope"] = default_trust_scope
            __props__.__dict__["diagnostic_level"] = diagnostic_level
            __props__.__dict__["diagnostic_record_for_search_identifies_returned_resources"] = diagnostic_record_for_search_identifies_returned_resources
            __props__.__dict__["enable_terms_of_use"] = enable_terms_of_use
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["iam_upst_session_expiry"] = iam_upst_session_expiry
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["images"] = images
            __props__.__dict__["is_hosted_page"] = is_hosted_page
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["locale"] = locale
            __props__.__dict__["login_texts"] = login_texts
            __props__.__dict__["max_no_of_app_cmva_to_return"] = max_no_of_app_cmva_to_return
            __props__.__dict__["max_no_of_app_role_members_to_return"] = max_no_of_app_role_members_to_return
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["preferred_language"] = preferred_language
            __props__.__dict__["prev_issuer"] = prev_issuer
            __props__.__dict__["privacy_policy_url"] = privacy_policy_url
            __props__.__dict__["purge_configs"] = purge_configs
            __props__.__dict__["re_auth_factors"] = re_auth_factors
            __props__.__dict__["re_auth_when_changing_my_authentication_factors"] = re_auth_when_changing_my_authentication_factors
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["service_admin_cannot_list_other_users"] = service_admin_cannot_list_other_users
            if setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'setting_id'")
            __props__.__dict__["setting_id"] = setting_id
            __props__.__dict__["signing_cert_public_access"] = signing_cert_public_access
            __props__.__dict__["sub_mapping_attr"] = sub_mapping_attr
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_custom_claims"] = tenant_custom_claims
            __props__.__dict__["terms_of_use_url"] = terms_of_use_url
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["cloud_account_name"] = None
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["default_company_names"] = None
            __props__.__dict__["default_images"] = None
            __props__.__dict__["default_login_texts"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["diagnostic_tracing_upto"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["migration_status"] = None
            __props__.__dict__["on_premises_provisioning"] = None
            __props__.__dict__["tenancy_ocid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["allowedForgotPasswordFlowReturnUrls"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainsSetting, __self__).__init__(
            'oci:Identity/domainsSetting:DomainsSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_always_trust_scope: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_forgot_password_flow_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_notification_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            attributes: Optional[pulumi.Input[_builtins.str]] = None,
            audit_event_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            authorization: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_validation: Optional[pulumi.Input[Union['DomainsSettingCertificateValidationArgs', 'DomainsSettingCertificateValidationArgsDict']]] = None,
            cloud_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_gate_cors_settings: Optional[pulumi.Input[Union['DomainsSettingCloudGateCorsSettingsArgs', 'DomainsSettingCloudGateCorsSettingsArgsDict']]] = None,
            cloud_migration_custom_url: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_migration_url_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            company_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingCompanyNameArgs', 'DomainsSettingCompanyNameArgsDict']]]]] = None,
            compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            contact_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            csr_access: Optional[pulumi.Input[_builtins.str]] = None,
            custom_branding: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_css_location: Optional[pulumi.Input[_builtins.str]] = None,
            custom_html_location: Optional[pulumi.Input[_builtins.str]] = None,
            custom_translation: Optional[pulumi.Input[_builtins.str]] = None,
            default_company_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultCompanyNameArgs', 'DomainsSettingDefaultCompanyNameArgsDict']]]]] = None,
            default_images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultImageArgs', 'DomainsSettingDefaultImageArgsDict']]]]] = None,
            default_login_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultLoginTextArgs', 'DomainsSettingDefaultLoginTextArgsDict']]]]] = None,
            default_trust_scope: Optional[pulumi.Input[_builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[_builtins.bool]] = None,
            diagnostic_level: Optional[pulumi.Input[_builtins.int]] = None,
            diagnostic_record_for_search_identifies_returned_resources: Optional[pulumi.Input[_builtins.bool]] = None,
            diagnostic_tracing_upto: Optional[pulumi.Input[_builtins.str]] = None,
            domain_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            enable_terms_of_use: Optional[pulumi.Input[_builtins.bool]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            iam_upst_session_expiry: Optional[pulumi.Input[_builtins.int]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingIdcsCreatedByArgs', 'DomainsSettingIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingIdcsLastModifiedByArgs', 'DomainsSettingIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[_builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingImageArgs', 'DomainsSettingImageArgsDict']]]]] = None,
            is_hosted_page: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            login_texts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingLoginTextArgs', 'DomainsSettingLoginTextArgsDict']]]]] = None,
            max_no_of_app_cmva_to_return: Optional[pulumi.Input[_builtins.int]] = None,
            max_no_of_app_role_members_to_return: Optional[pulumi.Input[_builtins.int]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingMetaArgs', 'DomainsSettingMetaArgsDict']]]]] = None,
            migration_status: Optional[pulumi.Input[_builtins.str]] = None,
            ocid: Optional[pulumi.Input[_builtins.str]] = None,
            on_premises_provisioning: Optional[pulumi.Input[_builtins.bool]] = None,
            preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
            prev_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            privacy_policy_url: Optional[pulumi.Input[_builtins.str]] = None,
            purge_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingPurgeConfigArgs', 'DomainsSettingPurgeConfigArgsDict']]]]] = None,
            re_auth_factors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            re_auth_when_changing_my_authentication_factors: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_type_schema_version: Optional[pulumi.Input[_builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_admin_cannot_list_other_users: Optional[pulumi.Input[_builtins.bool]] = None,
            setting_id: Optional[pulumi.Input[_builtins.str]] = None,
            signing_cert_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
            sub_mapping_attr: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTagArgs', 'DomainsSettingTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_custom_claims: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTenantCustomClaimArgs', 'DomainsSettingTenantCustomClaimArgsDict']]]]] = None,
            terms_of_use_url: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainsSetting':
        """
        Get an existing DomainsSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] account_always_trust_scope: (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.
               
               **Added In:** 18.1.6
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_forgot_password_flow_return_urls: (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_notification_redirect_urls: (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.
               
               **Added In:** 2009041201
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[_builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[_builtins.int] audit_event_retention_period: (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
        :param pulumi.Input[_builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[Union['DomainsSettingCertificateValidationArgs', 'DomainsSettingCertificateValidationArgsDict']] certificate_validation: (Updatable) Certificate Validation Config
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_account_name: (Updatable) The attribute to store the cloud account name
               
               **Deprecated Since: 2011192329**
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsSettingCloudGateCorsSettingsArgs', 'DomainsSettingCloudGateCorsSettingsArgsDict']] cloud_gate_cors_settings: (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] cloud_migration_custom_url: (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
        :param pulumi.Input[_builtins.bool] cloud_migration_url_enabled: (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingCompanyNameArgs', 'DomainsSettingCompanyNameArgsDict']]]] company_names: (Updatable) Name of the company in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_emails: (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] csr_access: (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] custom_branding: (Updatable) Indicates if the branding is default or custom
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] custom_css_location: (Updatable) Storage URL location where the sanitized custom css is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_html_location: (Updatable) Storage URL location where the sanitized custom html is located
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] custom_translation: (Updatable) Custom translations (JSON String)
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultCompanyNameArgs', 'DomainsSettingDefaultCompanyNameArgsDict']]]] default_company_names: (Updatable) Default name of the Company in different locales
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultImageArgs', 'DomainsSettingDefaultImageArgsDict']]]] default_images: (Updatable) References to various images
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingDefaultLoginTextArgs', 'DomainsSettingDefaultLoginTextArgsDict']]]] default_login_texts: (Updatable) Default Login text in different locales
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] default_trust_scope: (Updatable) **Deprecated Since: 18.3.6**
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string Indicates the default trust scope for all apps
        :param pulumi.Input[_builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.int] diagnostic_level: (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] diagnostic_record_for_search_identifies_returned_resources: (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] diagnostic_tracing_upto: (Updatable) The end time up to which diagnostic recording is switched on
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[_builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] enable_terms_of_use: (Updatable) Indicates if Terms of Use is enabled in UI
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.int] iam_upst_session_expiry: (Updatable) Maximum duration for IAM User Principal Session Token expiry
               
               **Added In:** 2307071836
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingIdcsCreatedByArgs', 'DomainsSettingIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingIdcsLastModifiedByArgs', 'DomainsSettingIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingImageArgs', 'DomainsSettingImageArgsDict']]]] images: (Updatable) References to various images
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.bool] is_hosted_page: (Updatable) Indicates if 'hosted' option was selected
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] issuer: (Updatable) Tenant issuer.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] locale: (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingLoginTextArgs', 'DomainsSettingLoginTextArgsDict']]]] login_texts: (Updatable) Login text in different locales
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [locale]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[_builtins.int] max_no_of_app_cmva_to_return: (Updatable) Limit the maximum return of CMVA for an App
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[_builtins.int] max_no_of_app_role_members_to_return: (Updatable) Limit the maximum return of members for an AppRole
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * idcsMinValue: 0
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingMetaArgs', 'DomainsSettingMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[_builtins.str] migration_status: (Updatable) Database Migration Status
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[_builtins.bool] on_premises_provisioning: (Updatable) On-Premises provisioning feature toggle.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] preferred_language: (Updatable) Preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] prev_issuer: (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingPurgeConfigArgs', 'DomainsSettingPurgeConfigArgsDict']]]] purge_configs: (Updatable) Purge Configs for different Resource Types
               
               **Deprecated Since: 19.1.6**
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [resourceName]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] re_auth_factors: (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
        :param pulumi.Input[_builtins.bool] re_auth_when_changing_my_authentication_factors: (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[_builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.bool] service_admin_cannot_list_other_users: (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.
               
               **Added In:** 2108190438
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] setting_id: ID of the resource
        :param pulumi.Input[_builtins.bool] signing_cert_public_access: (Updatable) Indicates if access on SigningCert is allowed to public or not
               
               **Added In:** 17.3.4
               
               **SCIM++ Properties:**
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
        :param pulumi.Input[_builtins.str] sub_mapping_attr: (Updatable) **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTagArgs', 'DomainsSettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsSettingTenantCustomClaimArgs', 'DomainsSettingTenantCustomClaimArgsDict']]]] tenant_custom_claims: (Updatable) Custom claims associated with the specific tenant
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[_builtins.str] terms_of_use_url: (Updatable) Terms of Use URL
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[_builtins.str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsSettingState.__new__(_DomainsSettingState)

        __props__.__dict__["account_always_trust_scope"] = account_always_trust_scope
        __props__.__dict__["allowed_domains"] = allowed_domains
        __props__.__dict__["allowed_forgot_password_flow_return_urls"] = allowed_forgot_password_flow_return_urls
        __props__.__dict__["allowed_notification_redirect_urls"] = allowed_notification_redirect_urls
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["audit_event_retention_period"] = audit_event_retention_period
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["certificate_validation"] = certificate_validation
        __props__.__dict__["cloud_account_name"] = cloud_account_name
        __props__.__dict__["cloud_gate_cors_settings"] = cloud_gate_cors_settings
        __props__.__dict__["cloud_migration_custom_url"] = cloud_migration_custom_url
        __props__.__dict__["cloud_migration_url_enabled"] = cloud_migration_url_enabled
        __props__.__dict__["company_names"] = company_names
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["contact_emails"] = contact_emails
        __props__.__dict__["csr_access"] = csr_access
        __props__.__dict__["custom_branding"] = custom_branding
        __props__.__dict__["custom_css_location"] = custom_css_location
        __props__.__dict__["custom_html_location"] = custom_html_location
        __props__.__dict__["custom_translation"] = custom_translation
        __props__.__dict__["default_company_names"] = default_company_names
        __props__.__dict__["default_images"] = default_images
        __props__.__dict__["default_login_texts"] = default_login_texts
        __props__.__dict__["default_trust_scope"] = default_trust_scope
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["diagnostic_level"] = diagnostic_level
        __props__.__dict__["diagnostic_record_for_search_identifies_returned_resources"] = diagnostic_record_for_search_identifies_returned_resources
        __props__.__dict__["diagnostic_tracing_upto"] = diagnostic_tracing_upto
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["enable_terms_of_use"] = enable_terms_of_use
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["iam_upst_session_expiry"] = iam_upst_session_expiry
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["images"] = images
        __props__.__dict__["is_hosted_page"] = is_hosted_page
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["locale"] = locale
        __props__.__dict__["login_texts"] = login_texts
        __props__.__dict__["max_no_of_app_cmva_to_return"] = max_no_of_app_cmva_to_return
        __props__.__dict__["max_no_of_app_role_members_to_return"] = max_no_of_app_role_members_to_return
        __props__.__dict__["metas"] = metas
        __props__.__dict__["migration_status"] = migration_status
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["on_premises_provisioning"] = on_premises_provisioning
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["prev_issuer"] = prev_issuer
        __props__.__dict__["privacy_policy_url"] = privacy_policy_url
        __props__.__dict__["purge_configs"] = purge_configs
        __props__.__dict__["re_auth_factors"] = re_auth_factors
        __props__.__dict__["re_auth_when_changing_my_authentication_factors"] = re_auth_when_changing_my_authentication_factors
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["service_admin_cannot_list_other_users"] = service_admin_cannot_list_other_users
        __props__.__dict__["setting_id"] = setting_id
        __props__.__dict__["signing_cert_public_access"] = signing_cert_public_access
        __props__.__dict__["sub_mapping_attr"] = sub_mapping_attr
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["tenant_custom_claims"] = tenant_custom_claims
        __props__.__dict__["terms_of_use_url"] = terms_of_use_url
        __props__.__dict__["timezone"] = timezone
        return DomainsSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountAlwaysTrustScope")
    def account_always_trust_scope(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "account_always_trust_scope")

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_domains")

    @_builtins.property
    @pulumi.getter(name="allowedForgotPasswordFlowReturnUrls")
    def allowed_forgot_password_flow_return_urls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) If specified, indicates the set of Urls which can be returned to after successful forgot password flow

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_forgot_password_flow_return_urls")

    @_builtins.property
    @pulumi.getter(name="allowedNotificationRedirectUrls")
    def allowed_notification_redirect_urls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\"notificationRedirectUrl\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.

        **Added In:** 2009041201

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "allowed_notification_redirect_urls")

    @_builtins.property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="auditEventRetentionPeriod")
    def audit_event_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        """
        return pulumi.get(self, "audit_event_retention_period")

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter(name="certificateValidation")
    def certificate_validation(self) -> pulumi.Output['outputs.DomainsSettingCertificateValidation']:
        """
        (Updatable) Certificate Validation Config

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificate_validation")

    @_builtins.property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The attribute to store the cloud account name

        **Deprecated Since: 2011192329**

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_account_name")

    @_builtins.property
    @pulumi.getter(name="cloudGateCorsSettings")
    def cloud_gate_cors_settings(self) -> pulumi.Output['outputs.DomainsSettingCloudGateCorsSettings']:
        """
        (Updatable) A complex attribute that specifies the Cloud Gate cross origin resource sharing settings.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_gate_cors_settings")

    @_builtins.property
    @pulumi.getter(name="cloudMigrationCustomUrl")
    def cloud_migration_custom_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        """
        return pulumi.get(self, "cloud_migration_custom_url")

    @_builtins.property
    @pulumi.getter(name="cloudMigrationUrlEnabled")
    def cloud_migration_url_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) CloudAccountMigration: Enable Custom SIM Migrator Url.

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_migration_url_enabled")

    @_builtins.property
    @pulumi.getter(name="companyNames")
    def company_names(self) -> pulumi.Output[Sequence['outputs.DomainsSettingCompanyName']]:
        """
        (Updatable) Name of the company in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "company_names")

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Contact emails used to notify tenants. Can be one or more user or group alias emails.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter(name="csrAccess")
    def csr_access(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        """
        return pulumi.get(self, "csr_access")

    @_builtins.property
    @pulumi.getter(name="customBranding")
    def custom_branding(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if the branding is default or custom

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "custom_branding")

    @_builtins.property
    @pulumi.getter(name="customCssLocation")
    def custom_css_location(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_css_location")

    @_builtins.property
    @pulumi.getter(name="customHtmlLocation")
    def custom_html_location(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_html_location")

    @_builtins.property
    @pulumi.getter(name="customTranslation")
    def custom_translation(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "custom_translation")

    @_builtins.property
    @pulumi.getter(name="defaultCompanyNames")
    def default_company_names(self) -> pulumi.Output[Sequence['outputs.DomainsSettingDefaultCompanyName']]:
        """
        (Updatable) Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_company_names")

    @_builtins.property
    @pulumi.getter(name="defaultImages")
    def default_images(self) -> pulumi.Output[Sequence['outputs.DomainsSettingDefaultImage']]:
        """
        (Updatable) References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_images")

    @_builtins.property
    @pulumi.getter(name="defaultLoginTexts")
    def default_login_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSettingDefaultLoginText']]:
        """
        (Updatable) Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "default_login_texts")

    @_builtins.property
    @pulumi.getter(name="defaultTrustScope")
    def default_trust_scope(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) **Deprecated Since: 18.3.6**

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string Indicates the default trust scope for all apps
        """
        return pulumi.get(self, "default_trust_scope")

    @_builtins.property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @_builtins.property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_level")

    @_builtins.property
    @pulumi.getter(name="diagnosticRecordForSearchIdentifiesReturnedResources")
    def diagnostic_record_for_search_identifies_returned_resources(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_record_for_search_identifies_returned_resources")

    @_builtins.property
    @pulumi.getter(name="diagnosticTracingUpto")
    def diagnostic_tracing_upto(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The end time up to which diagnostic recording is switched on

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "diagnostic_tracing_upto")

    @_builtins.property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @_builtins.property
    @pulumi.getter(name="enableTermsOfUse")
    def enable_terms_of_use(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enable_terms_of_use")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="iamUpstSessionExpiry")
    def iam_upst_session_expiry(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Maximum duration for IAM User Principal Session Token expiry

        **Added In:** 2307071836

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "iam_upst_session_expiry")

    @_builtins.property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSettingIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @_builtins.property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @_builtins.property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSettingIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @_builtins.property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @_builtins.property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @_builtins.property
    @pulumi.getter
    def images(self) -> pulumi.Output[Sequence['outputs.DomainsSettingImage']]:
        """
        (Updatable) References to various images

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="isHostedPage")
    def is_hosted_page(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_hosted_page")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Tenant issuer.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "locales" and attrValues.value eq "$(locale)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter(name="loginTexts")
    def login_texts(self) -> pulumi.Output[Sequence['outputs.DomainsSettingLoginText']]:
        """
        (Updatable) Login text in different locales

        **SCIM++ Properties:**
        * idcsCompositeKey: [locale]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "login_texts")

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppCmvaToReturn")
    def max_no_of_app_cmva_to_return(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Limit the maximum return of CMVA for an App

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_cmva_to_return")

    @_builtins.property
    @pulumi.getter(name="maxNoOfAppRoleMembersToReturn")
    def max_no_of_app_role_members_to_return(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Limit the maximum return of members for an AppRole

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * idcsMinValue: 0
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_no_of_app_role_members_to_return")

    @_builtins.property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsSettingMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @_builtins.property
    @pulumi.getter(name="migrationStatus")
    def migration_status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Database Migration Status

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "migration_status")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="onPremisesProvisioning")
    def on_premises_provisioning(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) On-Premises provisioning feature toggle.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "on_premises_provisioning")

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "languages" and attrValues.value eq "$(preferredLanguage)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @_builtins.property
    @pulumi.getter(name="prevIssuer")
    def prev_issuer(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "prev_issuer")

    @_builtins.property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @_builtins.property
    @pulumi.getter(name="purgeConfigs")
    def purge_configs(self) -> pulumi.Output[Sequence['outputs.DomainsSettingPurgeConfig']]:
        """
        (Updatable) Purge Configs for different Resource Types

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
        * idcsCompositeKey: [resourceName]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "purge_configs")

    @_builtins.property
    @pulumi.getter(name="reAuthFactors")
    def re_auth_factors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\"password\\".

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        """
        return pulumi.get(self, "re_auth_factors")

    @_builtins.property
    @pulumi.getter(name="reAuthWhenChangingMyAuthenticationFactors")
    def re_auth_when_changing_my_authentication_factors(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "re_auth_when_changing_my_authentication_factors")

    @_builtins.property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @_builtins.property
    @pulumi.getter(name="serviceAdminCannotListOtherUsers")
    def service_admin_cannot_list_other_users(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.

        **Added In:** 2108190438

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "service_admin_cannot_list_other_users")

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "setting_id")

    @_builtins.property
    @pulumi.getter(name="signingCertPublicAccess")
    def signing_cert_public_access(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if access on SigningCert is allowed to public or not

        **Added In:** 17.3.4

        **SCIM++ Properties:**
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        """
        return pulumi.get(self, "signing_cert_public_access")

    @_builtins.property
    @pulumi.getter(name="subMappingAttr")
    def sub_mapping_attr(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.
        """
        return pulumi.get(self, "sub_mapping_attr")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsSettingTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @_builtins.property
    @pulumi.getter(name="tenantCustomClaims")
    def tenant_custom_claims(self) -> pulumi.Output[Sequence['outputs.DomainsSettingTenantCustomClaim']]:
        """
        (Updatable) Custom claims associated with the specific tenant

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tenant_custom_claims")

    @_builtins.property
    @pulumi.getter(name="termsOfUseUrl")
    def terms_of_use_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_use_url")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

