# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsApprovalWorkflowStepResult',
    'AwaitableGetDomainsApprovalWorkflowStepResult',
    'get_domains_approval_workflow_step',
    'get_domains_approval_workflow_step_output',
]

@pulumi.output_type
class GetDomainsApprovalWorkflowStepResult:
    """
    A collection of values returned by getDomainsApprovalWorkflowStep.
    """
    def __init__(__self__, approval_workflow_step_id=None, approvers=None, approvers_expressions=None, attribute_sets=None, attributes=None, authorization=None, compartment_ocid=None, delete_in_progress=None, domain_ocid=None, id=None, idcs_created_bies=None, idcs_endpoint=None, idcs_last_modified_bies=None, idcs_last_upgraded_in_release=None, idcs_prevented_operations=None, metas=None, minimum_approvals=None, ocid=None, order=None, resource_type_schema_version=None, schemas=None, tags=None, tenancy_ocid=None, type=None):
        if approval_workflow_step_id and not isinstance(approval_workflow_step_id, str):
            raise TypeError("Expected argument 'approval_workflow_step_id' to be a str")
        pulumi.set(__self__, "approval_workflow_step_id", approval_workflow_step_id)
        if approvers and not isinstance(approvers, list):
            raise TypeError("Expected argument 'approvers' to be a list")
        pulumi.set(__self__, "approvers", approvers)
        if approvers_expressions and not isinstance(approvers_expressions, list):
            raise TypeError("Expected argument 'approvers_expressions' to be a list")
        pulumi.set(__self__, "approvers_expressions", approvers_expressions)
        if attribute_sets and not isinstance(attribute_sets, list):
            raise TypeError("Expected argument 'attribute_sets' to be a list")
        pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes and not isinstance(attributes, str):
            raise TypeError("Expected argument 'attributes' to be a str")
        pulumi.set(__self__, "attributes", attributes)
        if authorization and not isinstance(authorization, str):
            raise TypeError("Expected argument 'authorization' to be a str")
        pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid and not isinstance(compartment_ocid, str):
            raise TypeError("Expected argument 'compartment_ocid' to be a str")
        pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress and not isinstance(delete_in_progress, bool):
            raise TypeError("Expected argument 'delete_in_progress' to be a bool")
        pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid and not isinstance(domain_ocid, str):
            raise TypeError("Expected argument 'domain_ocid' to be a str")
        pulumi.set(__self__, "domain_ocid", domain_ocid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_created_bies and not isinstance(idcs_created_bies, list):
            raise TypeError("Expected argument 'idcs_created_bies' to be a list")
        pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint and not isinstance(idcs_endpoint, str):
            raise TypeError("Expected argument 'idcs_endpoint' to be a str")
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies and not isinstance(idcs_last_modified_bies, list):
            raise TypeError("Expected argument 'idcs_last_modified_bies' to be a list")
        pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release and not isinstance(idcs_last_upgraded_in_release, str):
            raise TypeError("Expected argument 'idcs_last_upgraded_in_release' to be a str")
        pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations and not isinstance(idcs_prevented_operations, list):
            raise TypeError("Expected argument 'idcs_prevented_operations' to be a list")
        pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if metas and not isinstance(metas, list):
            raise TypeError("Expected argument 'metas' to be a list")
        pulumi.set(__self__, "metas", metas)
        if minimum_approvals and not isinstance(minimum_approvals, int):
            raise TypeError("Expected argument 'minimum_approvals' to be a int")
        pulumi.set(__self__, "minimum_approvals", minimum_approvals)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if order and not isinstance(order, int):
            raise TypeError("Expected argument 'order' to be a int")
        pulumi.set(__self__, "order", order)
        if resource_type_schema_version and not isinstance(resource_type_schema_version, str):
            raise TypeError("Expected argument 'resource_type_schema_version' to be a str")
        pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenancy_ocid and not isinstance(tenancy_ocid, str):
            raise TypeError("Expected argument 'tenancy_ocid' to be a str")
        pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="approvalWorkflowStepId")
    def approval_workflow_step_id(self) -> _builtins.str:
        return pulumi.get(self, "approval_workflow_step_id")

    @_builtins.property
    @pulumi.getter
    def approvers(self) -> Sequence['outputs.GetDomainsApprovalWorkflowStepApproverResult']:
        """
        Approvers of the ApprovalWorkflowStep.
        """
        return pulumi.get(self, "approvers")

    @_builtins.property
    @pulumi.getter(name="approversExpressions")
    def approvers_expressions(self) -> Sequence[_builtins.str]:
        """
        approversExpressions of ApprovalWorkflowStep
        """
        return pulumi.get(self, "approvers_expressions")

    @_builtins.property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "attribute_sets")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "compartment_ocid")

    @_builtins.property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> _builtins.bool:
        """
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
        """
        return pulumi.get(self, "delete_in_progress")

    @_builtins.property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "domain_ocid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Sequence['outputs.GetDomainsApprovalWorkflowStepIdcsCreatedByResult']:
        """
        The User or App who created the Resource
        """
        return pulumi.get(self, "idcs_created_bies")

    @_builtins.property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "idcs_endpoint")

    @_builtins.property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Sequence['outputs.GetDomainsApprovalWorkflowStepIdcsLastModifiedByResult']:
        """
        The User or App who modified the Resource
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @_builtins.property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> _builtins.str:
        """
        The release number when the resource was upgraded.
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @_builtins.property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Sequence[_builtins.str]:
        """
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @_builtins.property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetDomainsApprovalWorkflowStepMetaResult']:
        """
        A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
        """
        return pulumi.get(self, "metas")

    @_builtins.property
    @pulumi.getter(name="minimumApprovals")
    def minimum_approvals(self) -> _builtins.int:
        """
        Minimum number of Approvals required for this step.
        """
        return pulumi.get(self, "minimum_approvals")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        """
        Order of the ApprovalWorkflowStep.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_type_schema_version")

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> Sequence[_builtins.str]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
        """
        return pulumi.get(self, "schemas")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetDomainsApprovalWorkflowStepTagResult']:
        """
        A list of tags on this resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "tenancy_ocid")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of ApprovalWorkflowStep
        """
        return pulumi.get(self, "type")


class AwaitableGetDomainsApprovalWorkflowStepResult(GetDomainsApprovalWorkflowStepResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsApprovalWorkflowStepResult(
            approval_workflow_step_id=self.approval_workflow_step_id,
            approvers=self.approvers,
            approvers_expressions=self.approvers_expressions,
            attribute_sets=self.attribute_sets,
            attributes=self.attributes,
            authorization=self.authorization,
            compartment_ocid=self.compartment_ocid,
            delete_in_progress=self.delete_in_progress,
            domain_ocid=self.domain_ocid,
            id=self.id,
            idcs_created_bies=self.idcs_created_bies,
            idcs_endpoint=self.idcs_endpoint,
            idcs_last_modified_bies=self.idcs_last_modified_bies,
            idcs_last_upgraded_in_release=self.idcs_last_upgraded_in_release,
            idcs_prevented_operations=self.idcs_prevented_operations,
            metas=self.metas,
            minimum_approvals=self.minimum_approvals,
            ocid=self.ocid,
            order=self.order,
            resource_type_schema_version=self.resource_type_schema_version,
            schemas=self.schemas,
            tags=self.tags,
            tenancy_ocid=self.tenancy_ocid,
            type=self.type)


def get_domains_approval_workflow_step(approval_workflow_step_id: Optional[_builtins.str] = None,
                                       attribute_sets: Optional[Sequence[_builtins.str]] = None,
                                       attributes: Optional[_builtins.str] = None,
                                       authorization: Optional[_builtins.str] = None,
                                       idcs_endpoint: Optional[_builtins.str] = None,
                                       resource_type_schema_version: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsApprovalWorkflowStepResult:
    """
    This data source provides details about a specific Approval Workflow Step resource in Oracle Cloud Infrastructure Identity Domains service.

    Get ApprovalWorkflowStep

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_approval_workflow_step = oci.Identity.get_domains_approval_workflow_step(approval_workflow_step_id=test_approval_workflow_step_oci_identity_domains_approval_workflow_step["id"],
        idcs_endpoint=test_domain["url"],
        attribute_sets=["all"],
        attributes="",
        authorization=approval_workflow_step_authorization,
        resource_type_schema_version=approval_workflow_step_resource_type_schema_version)
    ```


    :param _builtins.str approval_workflow_step_id: ID of the resource
    :param Sequence[_builtins.str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param _builtins.str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param _builtins.str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param _builtins.str idcs_endpoint: The basic endpoint for the identity domain
    :param _builtins.str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['approvalWorkflowStepId'] = approval_workflow_step_id
    __args__['attributeSets'] = attribute_sets
    __args__['attributes'] = attributes
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomainsApprovalWorkflowStep:getDomainsApprovalWorkflowStep', __args__, opts=opts, typ=GetDomainsApprovalWorkflowStepResult).value

    return AwaitableGetDomainsApprovalWorkflowStepResult(
        approval_workflow_step_id=pulumi.get(__ret__, 'approval_workflow_step_id'),
        approvers=pulumi.get(__ret__, 'approvers'),
        approvers_expressions=pulumi.get(__ret__, 'approvers_expressions'),
        attribute_sets=pulumi.get(__ret__, 'attribute_sets'),
        attributes=pulumi.get(__ret__, 'attributes'),
        authorization=pulumi.get(__ret__, 'authorization'),
        compartment_ocid=pulumi.get(__ret__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__ret__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__ret__, 'domain_ocid'),
        id=pulumi.get(__ret__, 'id'),
        idcs_created_bies=pulumi.get(__ret__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__ret__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__ret__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__ret__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__ret__, 'idcs_prevented_operations'),
        metas=pulumi.get(__ret__, 'metas'),
        minimum_approvals=pulumi.get(__ret__, 'minimum_approvals'),
        ocid=pulumi.get(__ret__, 'ocid'),
        order=pulumi.get(__ret__, 'order'),
        resource_type_schema_version=pulumi.get(__ret__, 'resource_type_schema_version'),
        schemas=pulumi.get(__ret__, 'schemas'),
        tags=pulumi.get(__ret__, 'tags'),
        tenancy_ocid=pulumi.get(__ret__, 'tenancy_ocid'),
        type=pulumi.get(__ret__, 'type'))
def get_domains_approval_workflow_step_output(approval_workflow_step_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              attribute_sets: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                              attributes: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              authorization: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              idcs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                                              resource_type_schema_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsApprovalWorkflowStepResult]:
    """
    This data source provides details about a specific Approval Workflow Step resource in Oracle Cloud Infrastructure Identity Domains service.

    Get ApprovalWorkflowStep

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_approval_workflow_step = oci.Identity.get_domains_approval_workflow_step(approval_workflow_step_id=test_approval_workflow_step_oci_identity_domains_approval_workflow_step["id"],
        idcs_endpoint=test_domain["url"],
        attribute_sets=["all"],
        attributes="",
        authorization=approval_workflow_step_authorization,
        resource_type_schema_version=approval_workflow_step_resource_type_schema_version)
    ```


    :param _builtins.str approval_workflow_step_id: ID of the resource
    :param Sequence[_builtins.str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param _builtins.str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param _builtins.str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param _builtins.str idcs_endpoint: The basic endpoint for the identity domain
    :param _builtins.str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['approvalWorkflowStepId'] = approval_workflow_step_id
    __args__['attributeSets'] = attribute_sets
    __args__['attributes'] = attributes
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getDomainsApprovalWorkflowStep:getDomainsApprovalWorkflowStep', __args__, opts=opts, typ=GetDomainsApprovalWorkflowStepResult)
    return __ret__.apply(lambda __response__: GetDomainsApprovalWorkflowStepResult(
        approval_workflow_step_id=pulumi.get(__response__, 'approval_workflow_step_id'),
        approvers=pulumi.get(__response__, 'approvers'),
        approvers_expressions=pulumi.get(__response__, 'approvers_expressions'),
        attribute_sets=pulumi.get(__response__, 'attribute_sets'),
        attributes=pulumi.get(__response__, 'attributes'),
        authorization=pulumi.get(__response__, 'authorization'),
        compartment_ocid=pulumi.get(__response__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__response__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__response__, 'domain_ocid'),
        id=pulumi.get(__response__, 'id'),
        idcs_created_bies=pulumi.get(__response__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__response__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__response__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__response__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__response__, 'idcs_prevented_operations'),
        metas=pulumi.get(__response__, 'metas'),
        minimum_approvals=pulumi.get(__response__, 'minimum_approvals'),
        ocid=pulumi.get(__response__, 'ocid'),
        order=pulumi.get(__response__, 'order'),
        resource_type_schema_version=pulumi.get(__response__, 'resource_type_schema_version'),
        schemas=pulumi.get(__response__, 'schemas'),
        tags=pulumi.get(__response__, 'tags'),
        tenancy_ocid=pulumi.get(__response__, 'tenancy_ocid'),
        type=pulumi.get(__response__, 'type')))
