# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetAdvancedFeatureConfigurationArgs', 'FleetAdvancedFeatureConfiguration']

@pulumi.input_type
class FleetAdvancedFeatureConfigurationArgs:
    def __init__(__self__, *,
                 fleet_id: pulumi.Input[_builtins.str],
                 advanced_usage_tracking: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']] = None,
                 analytic_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytic_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_event_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']] = None,
                 java_migration_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']] = None,
                 jfr_recording: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']] = None,
                 lcm: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']] = None,
                 performance_tuning_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']] = None):
        """
        The set of arguments for constructing a FleetAdvancedFeatureConfiguration resource.
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs'] advanced_usage_tracking: (Updatable) AdvancedUsageTracking configuration
        :param pulumi.Input[_builtins.str] analytic_bucket_name: (Updatable) Bucket name required to store JFR and related data.
        :param pulumi.Input[_builtins.str] analytic_namespace: (Updatable) Namespace for the Fleet advanced feature.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs'] crypto_event_analysis: (Updatable) CryptoEventAnalysis configuration
        :param pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs'] java_migration_analysis: (Updatable) JavaMigrationAnalysis configuration
        :param pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs'] jfr_recording: (Updatable) JfrRecording configuration
        :param pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs'] lcm: (Updatable) Enable lifecycle management and set post action configurations.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs'] performance_tuning_analysis: (Updatable) Performance tuning analysis configuration
        """
        pulumi.set(__self__, "fleet_id", fleet_id)
        if advanced_usage_tracking is not None:
            pulumi.set(__self__, "advanced_usage_tracking", advanced_usage_tracking)
        if analytic_bucket_name is not None:
            pulumi.set(__self__, "analytic_bucket_name", analytic_bucket_name)
        if analytic_namespace is not None:
            pulumi.set(__self__, "analytic_namespace", analytic_namespace)
        if crypto_event_analysis is not None:
            pulumi.set(__self__, "crypto_event_analysis", crypto_event_analysis)
        if java_migration_analysis is not None:
            pulumi.set(__self__, "java_migration_analysis", java_migration_analysis)
        if jfr_recording is not None:
            pulumi.set(__self__, "jfr_recording", jfr_recording)
        if lcm is not None:
            pulumi.set(__self__, "lcm", lcm)
        if performance_tuning_analysis is not None:
            pulumi.set(__self__, "performance_tuning_analysis", performance_tuning_analysis)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="advancedUsageTracking")
    def advanced_usage_tracking(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']]:
        """
        (Updatable) AdvancedUsageTracking configuration
        """
        return pulumi.get(self, "advanced_usage_tracking")

    @advanced_usage_tracking.setter
    def advanced_usage_tracking(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']]):
        pulumi.set(self, "advanced_usage_tracking", value)

    @_builtins.property
    @pulumi.getter(name="analyticBucketName")
    def analytic_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Bucket name required to store JFR and related data.
        """
        return pulumi.get(self, "analytic_bucket_name")

    @analytic_bucket_name.setter
    def analytic_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytic_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="analyticNamespace")
    def analytic_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Namespace for the Fleet advanced feature.
        """
        return pulumi.get(self, "analytic_namespace")

    @analytic_namespace.setter
    def analytic_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytic_namespace", value)

    @_builtins.property
    @pulumi.getter(name="cryptoEventAnalysis")
    def crypto_event_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']]:
        """
        (Updatable) CryptoEventAnalysis configuration
        """
        return pulumi.get(self, "crypto_event_analysis")

    @crypto_event_analysis.setter
    def crypto_event_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']]):
        pulumi.set(self, "crypto_event_analysis", value)

    @_builtins.property
    @pulumi.getter(name="javaMigrationAnalysis")
    def java_migration_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']]:
        """
        (Updatable) JavaMigrationAnalysis configuration
        """
        return pulumi.get(self, "java_migration_analysis")

    @java_migration_analysis.setter
    def java_migration_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']]):
        pulumi.set(self, "java_migration_analysis", value)

    @_builtins.property
    @pulumi.getter(name="jfrRecording")
    def jfr_recording(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']]:
        """
        (Updatable) JfrRecording configuration
        """
        return pulumi.get(self, "jfr_recording")

    @jfr_recording.setter
    def jfr_recording(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']]):
        pulumi.set(self, "jfr_recording", value)

    @_builtins.property
    @pulumi.getter
    def lcm(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']]:
        """
        (Updatable) Enable lifecycle management and set post action configurations.
        """
        return pulumi.get(self, "lcm")

    @lcm.setter
    def lcm(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']]):
        pulumi.set(self, "lcm", value)

    @_builtins.property
    @pulumi.getter(name="performanceTuningAnalysis")
    def performance_tuning_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']]:
        """
        (Updatable) Performance tuning analysis configuration
        """
        return pulumi.get(self, "performance_tuning_analysis")

    @performance_tuning_analysis.setter
    def performance_tuning_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']]):
        pulumi.set(self, "performance_tuning_analysis", value)


@pulumi.input_type
class _FleetAdvancedFeatureConfigurationState:
    def __init__(__self__, *,
                 advanced_usage_tracking: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']] = None,
                 analytic_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytic_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_event_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 java_migration_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']] = None,
                 jfr_recording: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']] = None,
                 lcm: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']] = None,
                 performance_tuning_analysis: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']] = None,
                 time_last_modified: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FleetAdvancedFeatureConfiguration resources.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs'] advanced_usage_tracking: (Updatable) AdvancedUsageTracking configuration
        :param pulumi.Input[_builtins.str] analytic_bucket_name: (Updatable) Bucket name required to store JFR and related data.
        :param pulumi.Input[_builtins.str] analytic_namespace: (Updatable) Namespace for the Fleet advanced feature.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs'] crypto_event_analysis: (Updatable) CryptoEventAnalysis configuration
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs'] java_migration_analysis: (Updatable) JavaMigrationAnalysis configuration
        :param pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs'] jfr_recording: (Updatable) JfrRecording configuration
        :param pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs'] lcm: (Updatable) Enable lifecycle management and set post action configurations.
        :param pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs'] performance_tuning_analysis: (Updatable) Performance tuning analysis configuration
        :param pulumi.Input[_builtins.str] time_last_modified: The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        if advanced_usage_tracking is not None:
            pulumi.set(__self__, "advanced_usage_tracking", advanced_usage_tracking)
        if analytic_bucket_name is not None:
            pulumi.set(__self__, "analytic_bucket_name", analytic_bucket_name)
        if analytic_namespace is not None:
            pulumi.set(__self__, "analytic_namespace", analytic_namespace)
        if crypto_event_analysis is not None:
            pulumi.set(__self__, "crypto_event_analysis", crypto_event_analysis)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if java_migration_analysis is not None:
            pulumi.set(__self__, "java_migration_analysis", java_migration_analysis)
        if jfr_recording is not None:
            pulumi.set(__self__, "jfr_recording", jfr_recording)
        if lcm is not None:
            pulumi.set(__self__, "lcm", lcm)
        if performance_tuning_analysis is not None:
            pulumi.set(__self__, "performance_tuning_analysis", performance_tuning_analysis)
        if time_last_modified is not None:
            pulumi.set(__self__, "time_last_modified", time_last_modified)

    @_builtins.property
    @pulumi.getter(name="advancedUsageTracking")
    def advanced_usage_tracking(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']]:
        """
        (Updatable) AdvancedUsageTracking configuration
        """
        return pulumi.get(self, "advanced_usage_tracking")

    @advanced_usage_tracking.setter
    def advanced_usage_tracking(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs']]):
        pulumi.set(self, "advanced_usage_tracking", value)

    @_builtins.property
    @pulumi.getter(name="analyticBucketName")
    def analytic_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Bucket name required to store JFR and related data.
        """
        return pulumi.get(self, "analytic_bucket_name")

    @analytic_bucket_name.setter
    def analytic_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytic_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="analyticNamespace")
    def analytic_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Namespace for the Fleet advanced feature.
        """
        return pulumi.get(self, "analytic_namespace")

    @analytic_namespace.setter
    def analytic_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytic_namespace", value)

    @_builtins.property
    @pulumi.getter(name="cryptoEventAnalysis")
    def crypto_event_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']]:
        """
        (Updatable) CryptoEventAnalysis configuration
        """
        return pulumi.get(self, "crypto_event_analysis")

    @crypto_event_analysis.setter
    def crypto_event_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs']]):
        pulumi.set(self, "crypto_event_analysis", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="javaMigrationAnalysis")
    def java_migration_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']]:
        """
        (Updatable) JavaMigrationAnalysis configuration
        """
        return pulumi.get(self, "java_migration_analysis")

    @java_migration_analysis.setter
    def java_migration_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs']]):
        pulumi.set(self, "java_migration_analysis", value)

    @_builtins.property
    @pulumi.getter(name="jfrRecording")
    def jfr_recording(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']]:
        """
        (Updatable) JfrRecording configuration
        """
        return pulumi.get(self, "jfr_recording")

    @jfr_recording.setter
    def jfr_recording(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationJfrRecordingArgs']]):
        pulumi.set(self, "jfr_recording", value)

    @_builtins.property
    @pulumi.getter
    def lcm(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']]:
        """
        (Updatable) Enable lifecycle management and set post action configurations.
        """
        return pulumi.get(self, "lcm")

    @lcm.setter
    def lcm(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationLcmArgs']]):
        pulumi.set(self, "lcm", value)

    @_builtins.property
    @pulumi.getter(name="performanceTuningAnalysis")
    def performance_tuning_analysis(self) -> Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']]:
        """
        (Updatable) Performance tuning analysis configuration
        """
        return pulumi.get(self, "performance_tuning_analysis")

    @performance_tuning_analysis.setter
    def performance_tuning_analysis(self, value: Optional[pulumi.Input['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs']]):
        pulumi.set(self, "performance_tuning_analysis", value)

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")

    @time_last_modified.setter
    def time_last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_modified", value)


@pulumi.type_token("oci:Jms/fleetAdvancedFeatureConfiguration:FleetAdvancedFeatureConfiguration")
class FleetAdvancedFeatureConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_usage_tracking: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs', 'FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgsDict']]] = None,
                 analytic_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytic_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_event_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs', 'FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgsDict']]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 java_migration_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs', 'FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgsDict']]] = None,
                 jfr_recording: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJfrRecordingArgs', 'FleetAdvancedFeatureConfigurationJfrRecordingArgsDict']]] = None,
                 lcm: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationLcmArgs', 'FleetAdvancedFeatureConfigurationLcmArgsDict']]] = None,
                 performance_tuning_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs', 'FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Fleet Advanced Feature Configuration resource in Oracle Cloud Infrastructure Jms service.

        Update advanced feature configurations for the Fleet.
        Ensure that the namespace and bucket storage are created prior to turning on the JfrRecording or CryptoEventAnalysis feature.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_advanced_feature_configuration = oci.jms.FleetAdvancedFeatureConfiguration("test_fleet_advanced_feature_configuration",
            fleet_id=test_fleet["id"],
            advanced_usage_tracking={
                "is_enabled": fleet_advanced_feature_configuration_advanced_usage_tracking_is_enabled,
            },
            analytic_bucket_name=test_bucket["name"],
            analytic_namespace=fleet_advanced_feature_configuration_analytic_namespace,
            crypto_event_analysis={
                "is_enabled": fleet_advanced_feature_configuration_crypto_event_analysis_is_enabled,
                "summarized_events_log": {
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
            },
            java_migration_analysis={
                "is_enabled": fleet_advanced_feature_configuration_java_migration_analysis_is_enabled,
            },
            jfr_recording={
                "is_enabled": fleet_advanced_feature_configuration_jfr_recording_is_enabled,
            },
            lcm={
                "is_enabled": fleet_advanced_feature_configuration_lcm_is_enabled,
                "post_installation_actions": {
                    "add_logging_handler": fleet_advanced_feature_configuration_lcm_post_installation_actions_add_logging_handler,
                    "disabled_tls_versions": fleet_advanced_feature_configuration_lcm_post_installation_actions_disabled_tls_versions,
                    "global_logging_level": fleet_advanced_feature_configuration_lcm_post_installation_actions_global_logging_level,
                    "minimum_key_size_settings": {
                        "certpaths": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_certpath_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_certpath_name,
                        }],
                        "jars": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_jar_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_jar_name,
                        }],
                        "tls": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_tls_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_tls_name,
                        }],
                    },
                    "proxies": {
                        "ftp_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_ftp_proxy_host,
                        "ftp_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_ftp_proxy_port,
                        "http_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_http_proxy_host,
                        "http_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_http_proxy_port,
                        "https_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_https_proxy_host,
                        "https_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_https_proxy_port,
                        "socks_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_socks_proxy_host,
                        "socks_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_socks_proxy_port,
                        "use_system_proxies": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_use_system_proxies,
                    },
                    "should_replace_certificates_operating_system": fleet_advanced_feature_configuration_lcm_post_installation_actions_should_replace_certificates_operating_system,
                },
            },
            performance_tuning_analysis={
                "is_enabled": fleet_advanced_feature_configuration_performance_tuning_analysis_is_enabled,
            })
        ```

        ## Import

        FleetAdvancedFeatureConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleetAdvancedFeatureConfiguration:FleetAdvancedFeatureConfiguration test_fleet_advanced_feature_configuration "fleets/{fleetId}/advancedFeatureConfiguration"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs', 'FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgsDict']] advanced_usage_tracking: (Updatable) AdvancedUsageTracking configuration
        :param pulumi.Input[_builtins.str] analytic_bucket_name: (Updatable) Bucket name required to store JFR and related data.
        :param pulumi.Input[_builtins.str] analytic_namespace: (Updatable) Namespace for the Fleet advanced feature.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs', 'FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgsDict']] crypto_event_analysis: (Updatable) CryptoEventAnalysis configuration
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs', 'FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgsDict']] java_migration_analysis: (Updatable) JavaMigrationAnalysis configuration
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationJfrRecordingArgs', 'FleetAdvancedFeatureConfigurationJfrRecordingArgsDict']] jfr_recording: (Updatable) JfrRecording configuration
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationLcmArgs', 'FleetAdvancedFeatureConfigurationLcmArgsDict']] lcm: (Updatable) Enable lifecycle management and set post action configurations.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs', 'FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgsDict']] performance_tuning_analysis: (Updatable) Performance tuning analysis configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetAdvancedFeatureConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fleet Advanced Feature Configuration resource in Oracle Cloud Infrastructure Jms service.

        Update advanced feature configurations for the Fleet.
        Ensure that the namespace and bucket storage are created prior to turning on the JfrRecording or CryptoEventAnalysis feature.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_advanced_feature_configuration = oci.jms.FleetAdvancedFeatureConfiguration("test_fleet_advanced_feature_configuration",
            fleet_id=test_fleet["id"],
            advanced_usage_tracking={
                "is_enabled": fleet_advanced_feature_configuration_advanced_usage_tracking_is_enabled,
            },
            analytic_bucket_name=test_bucket["name"],
            analytic_namespace=fleet_advanced_feature_configuration_analytic_namespace,
            crypto_event_analysis={
                "is_enabled": fleet_advanced_feature_configuration_crypto_event_analysis_is_enabled,
                "summarized_events_log": {
                    "log_group_id": test_log_group["id"],
                    "log_id": test_log["id"],
                },
            },
            java_migration_analysis={
                "is_enabled": fleet_advanced_feature_configuration_java_migration_analysis_is_enabled,
            },
            jfr_recording={
                "is_enabled": fleet_advanced_feature_configuration_jfr_recording_is_enabled,
            },
            lcm={
                "is_enabled": fleet_advanced_feature_configuration_lcm_is_enabled,
                "post_installation_actions": {
                    "add_logging_handler": fleet_advanced_feature_configuration_lcm_post_installation_actions_add_logging_handler,
                    "disabled_tls_versions": fleet_advanced_feature_configuration_lcm_post_installation_actions_disabled_tls_versions,
                    "global_logging_level": fleet_advanced_feature_configuration_lcm_post_installation_actions_global_logging_level,
                    "minimum_key_size_settings": {
                        "certpaths": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_certpath_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_certpath_name,
                        }],
                        "jars": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_jar_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_jar_name,
                        }],
                        "tls": [{
                            "key_size": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_tls_key_size,
                            "name": fleet_advanced_feature_configuration_lcm_post_installation_actions_minimum_key_size_settings_tls_name,
                        }],
                    },
                    "proxies": {
                        "ftp_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_ftp_proxy_host,
                        "ftp_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_ftp_proxy_port,
                        "http_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_http_proxy_host,
                        "http_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_http_proxy_port,
                        "https_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_https_proxy_host,
                        "https_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_https_proxy_port,
                        "socks_proxy_host": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_socks_proxy_host,
                        "socks_proxy_port": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_socks_proxy_port,
                        "use_system_proxies": fleet_advanced_feature_configuration_lcm_post_installation_actions_proxies_use_system_proxies,
                    },
                    "should_replace_certificates_operating_system": fleet_advanced_feature_configuration_lcm_post_installation_actions_should_replace_certificates_operating_system,
                },
            },
            performance_tuning_analysis={
                "is_enabled": fleet_advanced_feature_configuration_performance_tuning_analysis_is_enabled,
            })
        ```

        ## Import

        FleetAdvancedFeatureConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleetAdvancedFeatureConfiguration:FleetAdvancedFeatureConfiguration test_fleet_advanced_feature_configuration "fleets/{fleetId}/advancedFeatureConfiguration"
        ```

        :param str resource_name: The name of the resource.
        :param FleetAdvancedFeatureConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetAdvancedFeatureConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_usage_tracking: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs', 'FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgsDict']]] = None,
                 analytic_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytic_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_event_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs', 'FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgsDict']]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 java_migration_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs', 'FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgsDict']]] = None,
                 jfr_recording: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJfrRecordingArgs', 'FleetAdvancedFeatureConfigurationJfrRecordingArgsDict']]] = None,
                 lcm: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationLcmArgs', 'FleetAdvancedFeatureConfigurationLcmArgsDict']]] = None,
                 performance_tuning_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs', 'FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetAdvancedFeatureConfigurationArgs.__new__(FleetAdvancedFeatureConfigurationArgs)

            __props__.__dict__["advanced_usage_tracking"] = advanced_usage_tracking
            __props__.__dict__["analytic_bucket_name"] = analytic_bucket_name
            __props__.__dict__["analytic_namespace"] = analytic_namespace
            __props__.__dict__["crypto_event_analysis"] = crypto_event_analysis
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            __props__.__dict__["java_migration_analysis"] = java_migration_analysis
            __props__.__dict__["jfr_recording"] = jfr_recording
            __props__.__dict__["lcm"] = lcm
            __props__.__dict__["performance_tuning_analysis"] = performance_tuning_analysis
            __props__.__dict__["time_last_modified"] = None
        super(FleetAdvancedFeatureConfiguration, __self__).__init__(
            'oci:Jms/fleetAdvancedFeatureConfiguration:FleetAdvancedFeatureConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_usage_tracking: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs', 'FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgsDict']]] = None,
            analytic_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            analytic_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_event_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs', 'FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgsDict']]] = None,
            fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            java_migration_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs', 'FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgsDict']]] = None,
            jfr_recording: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationJfrRecordingArgs', 'FleetAdvancedFeatureConfigurationJfrRecordingArgsDict']]] = None,
            lcm: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationLcmArgs', 'FleetAdvancedFeatureConfigurationLcmArgsDict']]] = None,
            performance_tuning_analysis: Optional[pulumi.Input[Union['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs', 'FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgsDict']]] = None,
            time_last_modified: Optional[pulumi.Input[_builtins.str]] = None) -> 'FleetAdvancedFeatureConfiguration':
        """
        Get an existing FleetAdvancedFeatureConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgs', 'FleetAdvancedFeatureConfigurationAdvancedUsageTrackingArgsDict']] advanced_usage_tracking: (Updatable) AdvancedUsageTracking configuration
        :param pulumi.Input[_builtins.str] analytic_bucket_name: (Updatable) Bucket name required to store JFR and related data.
        :param pulumi.Input[_builtins.str] analytic_namespace: (Updatable) Namespace for the Fleet advanced feature.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgs', 'FleetAdvancedFeatureConfigurationCryptoEventAnalysisArgsDict']] crypto_event_analysis: (Updatable) CryptoEventAnalysis configuration
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgs', 'FleetAdvancedFeatureConfigurationJavaMigrationAnalysisArgsDict']] java_migration_analysis: (Updatable) JavaMigrationAnalysis configuration
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationJfrRecordingArgs', 'FleetAdvancedFeatureConfigurationJfrRecordingArgsDict']] jfr_recording: (Updatable) JfrRecording configuration
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationLcmArgs', 'FleetAdvancedFeatureConfigurationLcmArgsDict']] lcm: (Updatable) Enable lifecycle management and set post action configurations.
        :param pulumi.Input[Union['FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgs', 'FleetAdvancedFeatureConfigurationPerformanceTuningAnalysisArgsDict']] performance_tuning_analysis: (Updatable) Performance tuning analysis configuration
        :param pulumi.Input[_builtins.str] time_last_modified: The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetAdvancedFeatureConfigurationState.__new__(_FleetAdvancedFeatureConfigurationState)

        __props__.__dict__["advanced_usage_tracking"] = advanced_usage_tracking
        __props__.__dict__["analytic_bucket_name"] = analytic_bucket_name
        __props__.__dict__["analytic_namespace"] = analytic_namespace
        __props__.__dict__["crypto_event_analysis"] = crypto_event_analysis
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["java_migration_analysis"] = java_migration_analysis
        __props__.__dict__["jfr_recording"] = jfr_recording
        __props__.__dict__["lcm"] = lcm
        __props__.__dict__["performance_tuning_analysis"] = performance_tuning_analysis
        __props__.__dict__["time_last_modified"] = time_last_modified
        return FleetAdvancedFeatureConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedUsageTracking")
    def advanced_usage_tracking(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationAdvancedUsageTracking']:
        """
        (Updatable) AdvancedUsageTracking configuration
        """
        return pulumi.get(self, "advanced_usage_tracking")

    @_builtins.property
    @pulumi.getter(name="analyticBucketName")
    def analytic_bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Bucket name required to store JFR and related data.
        """
        return pulumi.get(self, "analytic_bucket_name")

    @_builtins.property
    @pulumi.getter(name="analyticNamespace")
    def analytic_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Namespace for the Fleet advanced feature.
        """
        return pulumi.get(self, "analytic_namespace")

    @_builtins.property
    @pulumi.getter(name="cryptoEventAnalysis")
    def crypto_event_analysis(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationCryptoEventAnalysis']:
        """
        (Updatable) CryptoEventAnalysis configuration
        """
        return pulumi.get(self, "crypto_event_analysis")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="javaMigrationAnalysis")
    def java_migration_analysis(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationJavaMigrationAnalysis']:
        """
        (Updatable) JavaMigrationAnalysis configuration
        """
        return pulumi.get(self, "java_migration_analysis")

    @_builtins.property
    @pulumi.getter(name="jfrRecording")
    def jfr_recording(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationJfrRecording']:
        """
        (Updatable) JfrRecording configuration
        """
        return pulumi.get(self, "jfr_recording")

    @_builtins.property
    @pulumi.getter
    def lcm(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationLcm']:
        """
        (Updatable) Enable lifecycle management and set post action configurations.
        """
        return pulumi.get(self, "lcm")

    @_builtins.property
    @pulumi.getter(name="performanceTuningAnalysis")
    def performance_tuning_analysis(self) -> pulumi.Output['outputs.FleetAdvancedFeatureConfigurationPerformanceTuningAnalysis']:
        """
        (Updatable) Performance tuning analysis configuration
        """
        return pulumi.get(self, "performance_tuning_analysis")

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")

