# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetBlocklistsResult',
    'AwaitableGetFleetBlocklistsResult',
    'get_fleet_blocklists',
    'get_fleet_blocklists_output',
]

@pulumi.output_type
class GetFleetBlocklistsResult:
    """
    A collection of values returned by getFleetBlocklists.
    """
    def __init__(__self__, filters=None, fleet_id=None, id=None, items=None, managed_instance_id=None, operation=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetBlocklistsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFleetBlocklistsItemResult']:
        """
        The blocklist
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[_builtins.str]:
        """
        The operation type
        """
        return pulumi.get(self, "operation")


class AwaitableGetFleetBlocklistsResult(GetFleetBlocklistsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetBlocklistsResult(
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            items=self.items,
            managed_instance_id=self.managed_instance_id,
            operation=self.operation)


def get_fleet_blocklists(filters: Optional[Sequence[Union['GetFleetBlocklistsFilterArgs', 'GetFleetBlocklistsFilterArgsDict']]] = None,
                         fleet_id: Optional[_builtins.str] = None,
                         managed_instance_id: Optional[_builtins.str] = None,
                         operation: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetBlocklistsResult:
    """
    This data source provides the list of Fleet Blocklists in Oracle Cloud Infrastructure Jms service.

    Returns a list of blocklist entities contained by a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_blocklists = oci.Jms.get_fleet_blocklists(fleet_id=test_fleet["id"],
        managed_instance_id=fleet_blocklist_managed_instance_id,
        operation=fleet_blocklist_operation)
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param _builtins.str operation: The operation type.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['operation'] = operation
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetBlocklists:getFleetBlocklists', __args__, opts=opts, typ=GetFleetBlocklistsResult).value

    return AwaitableGetFleetBlocklistsResult(
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        operation=pulumi.get(__ret__, 'operation'))
def get_fleet_blocklists_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetBlocklistsFilterArgs', 'GetFleetBlocklistsFilterArgsDict']]]]] = None,
                                fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                operation: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetBlocklistsResult]:
    """
    This data source provides the list of Fleet Blocklists in Oracle Cloud Infrastructure Jms service.

    Returns a list of blocklist entities contained by a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_blocklists = oci.Jms.get_fleet_blocklists(fleet_id=test_fleet["id"],
        managed_instance_id=fleet_blocklist_managed_instance_id,
        operation=fleet_blocklist_operation)
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param _builtins.str operation: The operation type.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['operation'] = operation
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetBlocklists:getFleetBlocklists', __args__, opts=opts, typ=GetFleetBlocklistsResult)
    return __ret__.apply(lambda __response__: GetFleetBlocklistsResult(
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        operation=pulumi.get(__response__, 'operation')))
