# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPluginErrorsResult',
    'AwaitableGetPluginErrorsResult',
    'get_plugin_errors',
    'get_plugin_errors_output',
]

@pulumi.output_type
class GetPluginErrorsResult:
    """
    A collection of values returned by getPluginErrors.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, managed_instance_id=None, plugin_error_collections=None, time_first_seen_greater_than_or_equal_to=None, time_first_seen_less_than_or_equal_to=None, time_last_seen_greater_than_or_equal_to=None, time_last_seen_less_than_or_equal_to=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if plugin_error_collections and not isinstance(plugin_error_collections, list):
            raise TypeError("Expected argument 'plugin_error_collections' to be a list")
        pulumi.set(__self__, "plugin_error_collections", plugin_error_collections)
        if time_first_seen_greater_than_or_equal_to and not isinstance(time_first_seen_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_first_seen_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_first_seen_greater_than_or_equal_to", time_first_seen_greater_than_or_equal_to)
        if time_first_seen_less_than_or_equal_to and not isinstance(time_first_seen_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_first_seen_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_first_seen_less_than_or_equal_to", time_first_seen_less_than_or_equal_to)
        if time_last_seen_greater_than_or_equal_to and not isinstance(time_last_seen_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_last_seen_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_last_seen_greater_than_or_equal_to", time_last_seen_greater_than_or_equal_to)
        if time_last_seen_less_than_or_equal_to and not isinstance(time_last_seen_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_last_seen_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_last_seen_less_than_or_equal_to", time_last_seen_less_than_or_equal_to)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPluginErrorsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Instance running the plugin.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="pluginErrorCollections")
    def plugin_error_collections(self) -> Sequence['outputs.GetPluginErrorsPluginErrorCollectionResult']:
        """
        The list of plugin_error_collection.
        """
        return pulumi.get(self, "plugin_error_collections")

    @_builtins.property
    @pulumi.getter(name="timeFirstSeenGreaterThanOrEqualTo")
    def time_first_seen_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_first_seen_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeFirstSeenLessThanOrEqualTo")
    def time_first_seen_less_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_first_seen_less_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeLastSeenGreaterThanOrEqualTo")
    def time_last_seen_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_last_seen_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeLastSeenLessThanOrEqualTo")
    def time_last_seen_less_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_last_seen_less_than_or_equal_to")


class AwaitableGetPluginErrorsResult(GetPluginErrorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluginErrorsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            plugin_error_collections=self.plugin_error_collections,
            time_first_seen_greater_than_or_equal_to=self.time_first_seen_greater_than_or_equal_to,
            time_first_seen_less_than_or_equal_to=self.time_first_seen_less_than_or_equal_to,
            time_last_seen_greater_than_or_equal_to=self.time_last_seen_greater_than_or_equal_to,
            time_last_seen_less_than_or_equal_to=self.time_last_seen_less_than_or_equal_to)


def get_plugin_errors(compartment_id: Optional[_builtins.str] = None,
                      compartment_id_in_subtree: Optional[_builtins.bool] = None,
                      filters: Optional[Sequence[Union['GetPluginErrorsFilterArgs', 'GetPluginErrorsFilterArgsDict']]] = None,
                      managed_instance_id: Optional[_builtins.str] = None,
                      time_first_seen_greater_than_or_equal_to: Optional[_builtins.str] = None,
                      time_first_seen_less_than_or_equal_to: Optional[_builtins.str] = None,
                      time_last_seen_greater_than_or_equal_to: Optional[_builtins.str] = None,
                      time_last_seen_less_than_or_equal_to: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluginErrorsResult:
    """
    This data source provides the list of Plugin Errors in Oracle Cloud Infrastructure Jms service.

    Returns a list of plugin errors that describe all detected errors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_plugin_errors = oci.Jms.get_plugin_errors(compartment_id=compartment_id,
        compartment_id_in_subtree=plugin_error_compartment_id_in_subtree,
        managed_instance_id=test_managed_instance["id"],
        time_first_seen_greater_than_or_equal_to=plugin_error_time_first_seen_greater_than_or_equal_to,
        time_first_seen_less_than_or_equal_to=plugin_error_time_first_seen_less_than_or_equal_to,
        time_last_seen_greater_than_or_equal_to=plugin_error_time_last_seen_greater_than_or_equal_to,
        time_last_seen_less_than_or_equal_to=plugin_error_time_last_seen_less_than_or_equal_to)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_first_seen_greater_than_or_equal_to: If specified, only errors with a first seen time later than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_first_seen_less_than_or_equal_to: If specified, only errors with a first seen time earlier than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_last_seen_greater_than_or_equal_to: If specified, only errors with a last seen time later than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_last_seen_less_than_or_equal_to: If specified, only errors with a last seen time earlier than this parameter will be included in the search (formatted according to RFC3339).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeFirstSeenGreaterThanOrEqualTo'] = time_first_seen_greater_than_or_equal_to
    __args__['timeFirstSeenLessThanOrEqualTo'] = time_first_seen_less_than_or_equal_to
    __args__['timeLastSeenGreaterThanOrEqualTo'] = time_last_seen_greater_than_or_equal_to
    __args__['timeLastSeenLessThanOrEqualTo'] = time_last_seen_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getPluginErrors:getPluginErrors', __args__, opts=opts, typ=GetPluginErrorsResult).value

    return AwaitableGetPluginErrorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        plugin_error_collections=pulumi.get(__ret__, 'plugin_error_collections'),
        time_first_seen_greater_than_or_equal_to=pulumi.get(__ret__, 'time_first_seen_greater_than_or_equal_to'),
        time_first_seen_less_than_or_equal_to=pulumi.get(__ret__, 'time_first_seen_less_than_or_equal_to'),
        time_last_seen_greater_than_or_equal_to=pulumi.get(__ret__, 'time_last_seen_greater_than_or_equal_to'),
        time_last_seen_less_than_or_equal_to=pulumi.get(__ret__, 'time_last_seen_less_than_or_equal_to'))
def get_plugin_errors_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPluginErrorsFilterArgs', 'GetPluginErrorsFilterArgsDict']]]]] = None,
                             managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             time_first_seen_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             time_first_seen_less_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             time_last_seen_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             time_last_seen_less_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluginErrorsResult]:
    """
    This data source provides the list of Plugin Errors in Oracle Cloud Infrastructure Jms service.

    Returns a list of plugin errors that describe all detected errors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_plugin_errors = oci.Jms.get_plugin_errors(compartment_id=compartment_id,
        compartment_id_in_subtree=plugin_error_compartment_id_in_subtree,
        managed_instance_id=test_managed_instance["id"],
        time_first_seen_greater_than_or_equal_to=plugin_error_time_first_seen_greater_than_or_equal_to,
        time_first_seen_less_than_or_equal_to=plugin_error_time_first_seen_less_than_or_equal_to,
        time_last_seen_greater_than_or_equal_to=plugin_error_time_last_seen_greater_than_or_equal_to,
        time_last_seen_less_than_or_equal_to=plugin_error_time_last_seen_less_than_or_equal_to)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_first_seen_greater_than_or_equal_to: If specified, only errors with a first seen time later than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_first_seen_less_than_or_equal_to: If specified, only errors with a first seen time earlier than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_last_seen_greater_than_or_equal_to: If specified, only errors with a last seen time later than this parameter will be included in the search (formatted according to RFC3339).
    :param _builtins.str time_last_seen_less_than_or_equal_to: If specified, only errors with a last seen time earlier than this parameter will be included in the search (formatted according to RFC3339).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeFirstSeenGreaterThanOrEqualTo'] = time_first_seen_greater_than_or_equal_to
    __args__['timeFirstSeenLessThanOrEqualTo'] = time_first_seen_less_than_or_equal_to
    __args__['timeLastSeenGreaterThanOrEqualTo'] = time_last_seen_greater_than_or_equal_to
    __args__['timeLastSeenLessThanOrEqualTo'] = time_last_seen_less_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getPluginErrors:getPluginErrors', __args__, opts=opts, typ=GetPluginErrorsResult)
    return __ret__.apply(lambda __response__: GetPluginErrorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        plugin_error_collections=pulumi.get(__response__, 'plugin_error_collections'),
        time_first_seen_greater_than_or_equal_to=pulumi.get(__response__, 'time_first_seen_greater_than_or_equal_to'),
        time_first_seen_less_than_or_equal_to=pulumi.get(__response__, 'time_first_seen_less_than_or_equal_to'),
        time_last_seen_greater_than_or_equal_to=pulumi.get(__response__, 'time_last_seen_greater_than_or_equal_to'),
        time_last_seen_less_than_or_equal_to=pulumi.get(__response__, 'time_last_seen_less_than_or_equal_to')))
