# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GeneratedKeyKeyShapeArgs',
    'GeneratedKeyKeyShapeArgsDict',
    'KeyAutoKeyRotationDetailsArgs',
    'KeyAutoKeyRotationDetailsArgsDict',
    'KeyExternalKeyReferenceArgs',
    'KeyExternalKeyReferenceArgsDict',
    'KeyExternalKeyReferenceDetailArgs',
    'KeyExternalKeyReferenceDetailArgsDict',
    'KeyKeyShapeArgs',
    'KeyKeyShapeArgsDict',
    'KeyReplicaDetailArgs',
    'KeyReplicaDetailArgsDict',
    'KeyRestoreFromFileArgs',
    'KeyRestoreFromFileArgsDict',
    'KeyRestoreFromObjectStoreArgs',
    'KeyRestoreFromObjectStoreArgsDict',
    'KeyVersionExternalKeyReferenceDetailArgs',
    'KeyVersionExternalKeyReferenceDetailArgsDict',
    'KeyVersionReplicaDetailArgs',
    'KeyVersionReplicaDetailArgsDict',
    'VaultExternalKeyManagerMetadataArgs',
    'VaultExternalKeyManagerMetadataArgsDict',
    'VaultExternalKeyManagerMetadataOauthMetadataArgs',
    'VaultExternalKeyManagerMetadataOauthMetadataArgsDict',
    'VaultExternalKeyManagerMetadataSummaryArgs',
    'VaultExternalKeyManagerMetadataSummaryArgsDict',
    'VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs',
    'VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgsDict',
    'VaultReplicaDetailArgs',
    'VaultReplicaDetailArgsDict',
    'VaultRestoreFromFileArgs',
    'VaultRestoreFromFileArgsDict',
    'VaultRestoreFromObjectStoreArgs',
    'VaultRestoreFromObjectStoreArgsDict',
    'VaultVerificationReplicaVaultMetadataArgs',
    'VaultVerificationReplicaVaultMetadataArgsDict',
    'GetEkmsPrivateEndpointsFilterArgs',
    'GetEkmsPrivateEndpointsFilterArgsDict',
    'GetKeyVersionsFilterArgs',
    'GetKeyVersionsFilterArgsDict',
    'GetKeysFilterArgs',
    'GetKeysFilterArgsDict',
    'GetVaultReplicasFilterArgs',
    'GetVaultReplicasFilterArgsDict',
    'GetVaultsFilterArgs',
    'GetVaultsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class GeneratedKeyKeyShapeArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        length: pulumi.Input[_builtins.int]
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        curve_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Supported curve IDs for ECDSA keys.
        """
elif False:
    GeneratedKeyKeyShapeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GeneratedKeyKeyShapeArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 length: pulumi.Input[_builtins.int],
                 curve_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param pulumi.Input[_builtins.int] length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param pulumi.Input[_builtins.str] curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Input[_builtins.int]:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "length", value)

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @curve_id.setter
    def curve_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curve_id", value)


if not MYPY:
    class KeyAutoKeyRotationDetailsArgsDict(TypedDict):
        last_rotation_message: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The last execution status message of auto key rotation.
        """
        last_rotation_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The status of last execution of auto key rotation.
        """
        rotation_interval_in_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        """
        time_of_last_rotation: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        """
        time_of_next_rotation: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        """
        time_of_schedule_start: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
elif False:
    KeyAutoKeyRotationDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyAutoKeyRotationDetailsArgs:
    def __init__(__self__, *,
                 last_rotation_message: Optional[pulumi.Input[_builtins.str]] = None,
                 last_rotation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_interval_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 time_of_last_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_next_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_schedule_start: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] last_rotation_message: (Updatable) The last execution status message of auto key rotation.
        :param pulumi.Input[_builtins.str] last_rotation_status: (Updatable) The status of last execution of auto key rotation.
        :param pulumi.Input[_builtins.int] rotation_interval_in_days: (Updatable) The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        :param pulumi.Input[_builtins.str] time_of_last_rotation: (Updatable) A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        :param pulumi.Input[_builtins.str] time_of_next_rotation: (Updatable) A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        :param pulumi.Input[_builtins.str] time_of_schedule_start: (Updatable) A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        if last_rotation_message is not None:
            pulumi.set(__self__, "last_rotation_message", last_rotation_message)
        if last_rotation_status is not None:
            pulumi.set(__self__, "last_rotation_status", last_rotation_status)
        if rotation_interval_in_days is not None:
            pulumi.set(__self__, "rotation_interval_in_days", rotation_interval_in_days)
        if time_of_last_rotation is not None:
            pulumi.set(__self__, "time_of_last_rotation", time_of_last_rotation)
        if time_of_next_rotation is not None:
            pulumi.set(__self__, "time_of_next_rotation", time_of_next_rotation)
        if time_of_schedule_start is not None:
            pulumi.set(__self__, "time_of_schedule_start", time_of_schedule_start)

    @_builtins.property
    @pulumi.getter(name="lastRotationMessage")
    def last_rotation_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The last execution status message of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_message")

    @last_rotation_message.setter
    def last_rotation_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_rotation_message", value)

    @_builtins.property
    @pulumi.getter(name="lastRotationStatus")
    def last_rotation_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The status of last execution of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_status")

    @last_rotation_status.setter
    def last_rotation_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_rotation_status", value)

    @_builtins.property
    @pulumi.getter(name="rotationIntervalInDays")
    def rotation_interval_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        """
        return pulumi.get(self, "rotation_interval_in_days")

    @rotation_interval_in_days.setter
    def rotation_interval_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_interval_in_days", value)

    @_builtins.property
    @pulumi.getter(name="timeOfLastRotation")
    def time_of_last_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        """
        return pulumi.get(self, "time_of_last_rotation")

    @time_of_last_rotation.setter
    def time_of_last_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_last_rotation", value)

    @_builtins.property
    @pulumi.getter(name="timeOfNextRotation")
    def time_of_next_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        """
        return pulumi.get(self, "time_of_next_rotation")

    @time_of_next_rotation.setter
    def time_of_next_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_next_rotation", value)

    @_builtins.property
    @pulumi.getter(name="timeOfScheduleStart")
    def time_of_schedule_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        return pulumi.get(self, "time_of_schedule_start")

    @time_of_schedule_start.setter
    def time_of_schedule_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_schedule_start", value)


if not MYPY:
    class KeyExternalKeyReferenceArgsDict(TypedDict):
        external_key_id: pulumi.Input[_builtins.str]
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
elif False:
    KeyExternalKeyReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyExternalKeyReferenceArgs:
    def __init__(__self__, *,
                 external_key_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        pulumi.set(__self__, "external_key_id", external_key_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        return pulumi.get(self, "external_key_id")

    @external_key_id.setter
    def external_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_key_id", value)


if not MYPY:
    class KeyExternalKeyReferenceDetailArgsDict(TypedDict):
        external_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        external_key_version_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Key version ID associated with the external key.
        """
elif False:
    KeyExternalKeyReferenceDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyExternalKeyReferenceDetailArgs:
    def __init__(__self__, *,
                 external_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        """
        if external_key_id is not None:
            pulumi.set(__self__, "external_key_id", external_key_id)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @external_key_id.setter
    def external_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_id", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @external_key_version_id.setter
    def external_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_version_id", value)


if not MYPY:
    class KeyKeyShapeArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        length: pulumi.Input[_builtins.int]
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        curve_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Supported curve IDs for ECDSA keys.
        """
elif False:
    KeyKeyShapeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyKeyShapeArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 length: pulumi.Input[_builtins.int],
                 curve_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param pulumi.Input[_builtins.int] length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param pulumi.Input[_builtins.str] curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Input[_builtins.int]:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "length", value)

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @curve_id.setter
    def curve_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curve_id", value)


if not MYPY:
    class KeyReplicaDetailArgsDict(TypedDict):
        replication_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ReplicationId associated with a key operation
        """
elif False:
    KeyReplicaDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] replication_id: ReplicationId associated with a key operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_id", value)


if not MYPY:
    class KeyRestoreFromFileArgsDict(TypedDict):
        content_length: pulumi.Input[_builtins.str]
        """
        (Updatable) content length of key's backup binary file
        """
        restore_key_from_file_details: pulumi.Input[_builtins.str]
        """
        Key backup file content.
        """
        content_md5: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) content md5 hashed value of key's backup file
        """
elif False:
    KeyRestoreFromFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyRestoreFromFileArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[_builtins.str],
                 restore_key_from_file_details: pulumi.Input[_builtins.str],
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] content_length: (Updatable) content length of key's backup binary file
        :param pulumi.Input[_builtins.str] restore_key_from_file_details: Key backup file content.
        :param pulumi.Input[_builtins.str] content_md5: (Updatable) content md5 hashed value of key's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_length", value)

    @_builtins.property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> pulumi.Input[_builtins.str]:
        """
        Key backup file content.
        """
        return pulumi.get(self, "restore_key_from_file_details")

    @restore_key_from_file_details.setter
    def restore_key_from_file_details(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_key_from_file_details", value)

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_md5", value)


if not MYPY:
    class KeyRestoreFromObjectStoreArgsDict(TypedDict):
        destination: pulumi.Input[_builtins.str]
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Name of the bucket where key was backed up
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Object containing the backup
        """
        uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
elif False:
    KeyRestoreFromObjectStoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyRestoreFromObjectStoreArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param pulumi.Input[_builtins.str] bucket: (Updatable) Name of the bucket where key was backed up
        :param pulumi.Input[_builtins.str] namespace: (Updatable) Namespace of the bucket where key was backed up
        :param pulumi.Input[_builtins.str] object: (Updatable) Object containing the backup
        :param pulumi.Input[_builtins.str] uri: (Updatable) Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class KeyVersionExternalKeyReferenceDetailArgsDict(TypedDict):
        external_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        external_key_version_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Key version ID associated with the external key.
        """
elif False:
    KeyVersionExternalKeyReferenceDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyVersionExternalKeyReferenceDetailArgs:
    def __init__(__self__, *,
                 external_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        """
        if external_key_id is not None:
            pulumi.set(__self__, "external_key_id", external_key_id)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @external_key_id.setter
    def external_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_id", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @external_key_version_id.setter
    def external_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_version_id", value)


if not MYPY:
    class KeyVersionReplicaDetailArgsDict(TypedDict):
        replication_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ReplicationId associated with a key version operation
        """
elif False:
    KeyVersionReplicaDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyVersionReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] replication_id: ReplicationId associated with a key version operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_id", value)


if not MYPY:
    class VaultExternalKeyManagerMetadataArgsDict(TypedDict):
        external_vault_endpoint_url: pulumi.Input[_builtins.str]
        """
        URI of the vault on external key manager.
        """
        oauth_metadata: pulumi.Input['VaultExternalKeyManagerMetadataOauthMetadataArgsDict']
        """
        Authorization details required to get access token from IDP for accessing protected resources.
        """
        private_endpoint_id: pulumi.Input[_builtins.str]
        """
        OCID of private endpoint created by customer.
        """
elif False:
    VaultExternalKeyManagerMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultExternalKeyManagerMetadataArgs:
    def __init__(__self__, *,
                 external_vault_endpoint_url: pulumi.Input[_builtins.str],
                 oauth_metadata: pulumi.Input['VaultExternalKeyManagerMetadataOauthMetadataArgs'],
                 private_endpoint_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] external_vault_endpoint_url: URI of the vault on external key manager.
        :param pulumi.Input['VaultExternalKeyManagerMetadataOauthMetadataArgs'] oauth_metadata: Authorization details required to get access token from IDP for accessing protected resources.
        :param pulumi.Input[_builtins.str] private_endpoint_id: OCID of private endpoint created by customer.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadata", oauth_metadata)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> pulumi.Input[_builtins.str]:
        """
        URI of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @external_vault_endpoint_url.setter
    def external_vault_endpoint_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_vault_endpoint_url", value)

    @_builtins.property
    @pulumi.getter(name="oauthMetadata")
    def oauth_metadata(self) -> pulumi.Input['VaultExternalKeyManagerMetadataOauthMetadataArgs']:
        """
        Authorization details required to get access token from IDP for accessing protected resources.
        """
        return pulumi.get(self, "oauth_metadata")

    @oauth_metadata.setter
    def oauth_metadata(self, value: pulumi.Input['VaultExternalKeyManagerMetadataOauthMetadataArgs']):
        pulumi.set(self, "oauth_metadata", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        OCID of private endpoint created by customer.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_endpoint_id", value)


if not MYPY:
    class VaultExternalKeyManagerMetadataOauthMetadataArgsDict(TypedDict):
        client_app_id: pulumi.Input[_builtins.str]
        """
        ID of the client app created in IDP.
        """
        client_app_secret: pulumi.Input[_builtins.str]
        """
        Secret of the client app created in IDP.
        """
        idcs_account_name_url: pulumi.Input[_builtins.str]
        """
        Base URL of the IDCS account where confidential client app is created.
        """
elif False:
    VaultExternalKeyManagerMetadataOauthMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultExternalKeyManagerMetadataOauthMetadataArgs:
    def __init__(__self__, *,
                 client_app_id: pulumi.Input[_builtins.str],
                 client_app_secret: pulumi.Input[_builtins.str],
                 idcs_account_name_url: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] client_app_id: ID of the client app created in IDP.
        :param pulumi.Input[_builtins.str] client_app_secret: Secret of the client app created in IDP.
        :param pulumi.Input[_builtins.str] idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "client_app_secret", client_app_secret)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_app_id", value)

    @_builtins.property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> pulumi.Input[_builtins.str]:
        """
        Secret of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_secret")

    @client_app_secret.setter
    def client_app_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_app_secret", value)

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> pulumi.Input[_builtins.str]:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")

    @idcs_account_name_url.setter
    def idcs_account_name_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "idcs_account_name_url", value)


if not MYPY:
    class VaultExternalKeyManagerMetadataSummaryArgsDict(TypedDict):
        external_vault_endpoint_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        URL of the vault on external key manager.
        """
        oauth_metadata_summaries: NotRequired[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgsDict']]]]
        """
        Summary about authorization to be returned to the customer as a response.
        """
        private_endpoint_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        OCID of the private endpoint.
        """
        vendor: NotRequired[pulumi.Input[_builtins.str]]
        """
        Vendor of the external key manager.
        """
elif False:
    VaultExternalKeyManagerMetadataSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultExternalKeyManagerMetadataSummaryArgs:
    def __init__(__self__, *,
                 external_vault_endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_metadata_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs']]]] = None,
                 private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] external_vault_endpoint_url: URL of the vault on external key manager.
        :param pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs']]] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param pulumi.Input[_builtins.str] private_endpoint_id: OCID of the private endpoint.
        :param pulumi.Input[_builtins.str] vendor: Vendor of the external key manager.
        """
        if external_vault_endpoint_url is not None:
            pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        if oauth_metadata_summaries is not None:
            pulumi.set(__self__, "oauth_metadata_summaries", oauth_metadata_summaries)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @external_vault_endpoint_url.setter
    def external_vault_endpoint_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_vault_endpoint_url", value)

    @_builtins.property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs']]]]:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @oauth_metadata_summaries.setter
    def oauth_metadata_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs']]]]):
        pulumi.set(self, "oauth_metadata_summaries", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vendor", value)


if not MYPY:
    class VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgsDict(TypedDict):
        client_app_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the client app created in IDP.
        """
        idcs_account_name_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        Base URL of the IDCS account where confidential client app is created.
        """
elif False:
    VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs:
    def __init__(__self__, *,
                 client_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 idcs_account_name_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] client_app_id: ID of the client app created in IDP.
        :param pulumi.Input[_builtins.str] idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        if client_app_id is not None:
            pulumi.set(__self__, "client_app_id", client_app_id)
        if idcs_account_name_url is not None:
            pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_app_id", value)

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")

    @idcs_account_name_url.setter
    def idcs_account_name_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_account_name_url", value)


if not MYPY:
    class VaultReplicaDetailArgsDict(TypedDict):
        replication_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ReplicationId associated with a vault operation
        """
elif False:
    VaultReplicaDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultReplicaDetailArgs:
    def __init__(__self__, *,
                 replication_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] replication_id: ReplicationId associated with a vault operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_id", value)


if not MYPY:
    class VaultRestoreFromFileArgsDict(TypedDict):
        content_length: pulumi.Input[_builtins.str]
        """
        content length of vault's backup binary file
        """
        restore_vault_from_file_details: pulumi.Input[_builtins.str]
        """
        Vault backup file content
        """
        content_md5: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
elif False:
    VaultRestoreFromFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultRestoreFromFileArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[_builtins.str],
                 restore_vault_from_file_details: pulumi.Input[_builtins.str],
                 content_md5: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] content_length: content length of vault's backup binary file
        :param pulumi.Input[_builtins.str] restore_vault_from_file_details: Vault backup file content
        :param pulumi.Input[_builtins.str] content_md5: (Updatable) content md5 hashed value of vault's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[_builtins.str]:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_length", value)

    @_builtins.property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> pulumi.Input[_builtins.str]:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")

    @restore_vault_from_file_details.setter
    def restore_vault_from_file_details(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_vault_from_file_details", value)

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_md5", value)


if not MYPY:
    class VaultRestoreFromObjectStoreArgsDict(TypedDict):
        destination: pulumi.Input[_builtins.str]
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Object containing the backup
        """
        uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
elif False:
    VaultRestoreFromObjectStoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultRestoreFromObjectStoreArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param pulumi.Input[_builtins.str] bucket: (Updatable) Name of the bucket where vault was backed up
        :param pulumi.Input[_builtins.str] namespace: (Updatable) Namespace of the bucket where vault was backed up
        :param pulumi.Input[_builtins.str] object: (Updatable) Object containing the backup
        :param pulumi.Input[_builtins.str] uri: (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class VaultVerificationReplicaVaultMetadataArgsDict(TypedDict):
        idcs_account_name_url: pulumi.Input[_builtins.str]
        private_endpoint_id: pulumi.Input[_builtins.str]
        vault_type: pulumi.Input[_builtins.str]
elif False:
    VaultVerificationReplicaVaultMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultVerificationReplicaVaultMetadataArgs:
    def __init__(__self__, *,
                 idcs_account_name_url: pulumi.Input[_builtins.str],
                 private_endpoint_id: pulumi.Input[_builtins.str],
                 vault_type: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "vault_type", vault_type)

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "idcs_account_name_url")

    @idcs_account_name_url.setter
    def idcs_account_name_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "idcs_account_name_url", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "vault_type")

    @vault_type.setter
    def vault_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_type", value)


if not MYPY:
    class GetEkmsPrivateEndpointsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetEkmsPrivateEndpointsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetEkmsPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetKeyVersionsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetKeyVersionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetKeyVersionsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetKeysFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetKeysFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetKeysFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetVaultReplicasFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetVaultReplicasFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVaultReplicasFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetVaultsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetVaultsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVaultsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


