# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEkmsPrivateEndpointsResult',
    'AwaitableGetEkmsPrivateEndpointsResult',
    'get_ekms_private_endpoints',
    'get_ekms_private_endpoints_output',
]

@pulumi.output_type
class GetEkmsPrivateEndpointsResult:
    """
    A collection of values returned by getEkmsPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, ekms_private_endpoints=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if ekms_private_endpoints and not isinstance(ekms_private_endpoints, list):
            raise TypeError("Expected argument 'ekms_private_endpoints' to be a list")
        pulumi.set(__self__, "ekms_private_endpoints", ekms_private_endpoints)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Identifier of the compartment this EKMS private endpoint belongs to
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="ekmsPrivateEndpoints")
    def ekms_private_endpoints(self) -> Sequence['outputs.GetEkmsPrivateEndpointsEkmsPrivateEndpointResult']:
        """
        The list of ekms_private_endpoints.
        """
        return pulumi.get(self, "ekms_private_endpoints")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEkmsPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetEkmsPrivateEndpointsResult(GetEkmsPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEkmsPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            ekms_private_endpoints=self.ekms_private_endpoints,
            filters=self.filters,
            id=self.id)


def get_ekms_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                               filters: Optional[Sequence[Union['GetEkmsPrivateEndpointsFilterArgs', 'GetEkmsPrivateEndpointsFilterArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEkmsPrivateEndpointsResult:
    """
    This data source provides the list of Ekms Private Endpoints in Oracle Cloud Infrastructure Kms service.

    Returns a list of all the EKMS private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ekms_private_endpoints = oci.Kms.get_ekms_private_endpoints(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getEkmsPrivateEndpoints:getEkmsPrivateEndpoints', __args__, opts=opts, typ=GetEkmsPrivateEndpointsResult).value

    return AwaitableGetEkmsPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        ekms_private_endpoints=pulumi.get(__ret__, 'ekms_private_endpoints'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_ekms_private_endpoints_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEkmsPrivateEndpointsFilterArgs', 'GetEkmsPrivateEndpointsFilterArgsDict']]]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEkmsPrivateEndpointsResult]:
    """
    This data source provides the list of Ekms Private Endpoints in Oracle Cloud Infrastructure Kms service.

    Returns a list of all the EKMS private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ekms_private_endpoints = oci.Kms.get_ekms_private_endpoints(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Kms/getEkmsPrivateEndpoints:getEkmsPrivateEndpoints', __args__, opts=opts, typ=GetEkmsPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetEkmsPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        ekms_private_endpoints=pulumi.get(__response__, 'ekms_private_endpoints'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
