# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEncryptedDataResult',
    'AwaitableGetEncryptedDataResult',
    'get_encrypted_data',
    'get_encrypted_data_output',
]

@pulumi.output_type
class GetEncryptedDataResult:
    """
    A collection of values returned by getEncryptedData.
    """
    def __init__(__self__, associated_data=None, ciphertext=None, crypto_endpoint=None, id=None, key_id=None, plaintext=None):
        if associated_data and not isinstance(associated_data, dict):
            raise TypeError("Expected argument 'associated_data' to be a dict")
        pulumi.set(__self__, "associated_data", associated_data)
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crypto_endpoint and not isinstance(crypto_endpoint, str):
            raise TypeError("Expected argument 'crypto_endpoint' to be a str")
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @_builtins.property
    @pulumi.getter(name="associatedData")
    def associated_data(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "associated_data")

    @_builtins.property
    @pulumi.getter
    def ciphertext(self) -> _builtins.str:
        """
        The encrypted data.
        """
        return pulumi.get(self, "ciphertext")

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "crypto_endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> _builtins.str:
        return pulumi.get(self, "plaintext")


class AwaitableGetEncryptedDataResult(GetEncryptedDataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEncryptedDataResult(
            associated_data=self.associated_data,
            ciphertext=self.ciphertext,
            crypto_endpoint=self.crypto_endpoint,
            id=self.id,
            key_id=self.key_id,
            plaintext=self.plaintext)


def get_encrypted_data(associated_data: Optional[Mapping[str, _builtins.str]] = None,
                       crypto_endpoint: Optional[_builtins.str] = None,
                       key_id: Optional[_builtins.str] = None,
                       plaintext: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEncryptedDataResult:
    """
    The `Kms.EncryptedData` data source provides details about a specific EncryptedData

    Encrypts data using the given EncryptDataDetails resource.
    Plaintext included in the example request is a base64-encoded value
    of a UTF-8 string.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_encrypted_data = oci.Kms.get_encrypted_data(crypto_endpoint=encrypted_data_crypto_endpoint,
        key_id=test_key["id"],
        plaintext=encrypted_data_plaintext,
        associated_data=encrypted_data_associated_data)
    ```


    :param Mapping[str, _builtins.str] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associatedData must be fewer than 4096 characters.
    :param _builtins.str crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
    :param _builtins.str key_id: The OCID of the key to encrypt with.
    :param _builtins.str plaintext: The plaintext data to encrypt.
    """
    __args__ = dict()
    __args__['associatedData'] = associated_data
    __args__['cryptoEndpoint'] = crypto_endpoint
    __args__['keyId'] = key_id
    __args__['plaintext'] = plaintext
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getEncryptedData:getEncryptedData', __args__, opts=opts, typ=GetEncryptedDataResult).value

    return AwaitableGetEncryptedDataResult(
        associated_data=pulumi.get(__ret__, 'associated_data'),
        ciphertext=pulumi.get(__ret__, 'ciphertext'),
        crypto_endpoint=pulumi.get(__ret__, 'crypto_endpoint'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        plaintext=pulumi.get(__ret__, 'plaintext'))
def get_encrypted_data_output(associated_data: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                              key_id: Optional[pulumi.Input[_builtins.str]] = None,
                              plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEncryptedDataResult]:
    """
    The `Kms.EncryptedData` data source provides details about a specific EncryptedData

    Encrypts data using the given EncryptDataDetails resource.
    Plaintext included in the example request is a base64-encoded value
    of a UTF-8 string.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_encrypted_data = oci.Kms.get_encrypted_data(crypto_endpoint=encrypted_data_crypto_endpoint,
        key_id=test_key["id"],
        plaintext=encrypted_data_plaintext,
        associated_data=encrypted_data_associated_data)
    ```


    :param Mapping[str, _builtins.str] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associatedData must be fewer than 4096 characters.
    :param _builtins.str crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
    :param _builtins.str key_id: The OCID of the key to encrypt with.
    :param _builtins.str plaintext: The plaintext data to encrypt.
    """
    __args__ = dict()
    __args__['associatedData'] = associated_data
    __args__['cryptoEndpoint'] = crypto_endpoint
    __args__['keyId'] = key_id
    __args__['plaintext'] = plaintext
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Kms/getEncryptedData:getEncryptedData', __args__, opts=opts, typ=GetEncryptedDataResult)
    return __ret__.apply(lambda __response__: GetEncryptedDataResult(
        associated_data=pulumi.get(__response__, 'associated_data'),
        ciphertext=pulumi.get(__response__, 'ciphertext'),
        crypto_endpoint=pulumi.get(__response__, 'crypto_endpoint'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        plaintext=pulumi.get(__response__, 'plaintext')))
