# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKeyVersionsResult',
    'AwaitableGetKeyVersionsResult',
    'get_key_versions',
    'get_key_versions_output',
]

@pulumi.output_type
class GetKeyVersionsResult:
    """
    A collection of values returned by getKeyVersions.
    """
    def __init__(__self__, filters=None, id=None, key_id=None, key_versions=None, management_endpoint=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_versions and not isinstance(key_versions, list):
            raise TypeError("Expected argument 'key_versions' to be a list")
        pulumi.set(__self__, "key_versions", key_versions)
        if management_endpoint and not isinstance(management_endpoint, str):
            raise TypeError("Expected argument 'management_endpoint' to be a str")
        pulumi.set(__self__, "management_endpoint", management_endpoint)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKeyVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the master encryption key associated with this key version.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyVersions")
    def key_versions(self) -> Sequence['outputs.GetKeyVersionsKeyVersionResult']:
        """
        The list of key_versions.
        """
        return pulumi.get(self, "key_versions")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "management_endpoint")


class AwaitableGetKeyVersionsResult(GetKeyVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyVersionsResult(
            filters=self.filters,
            id=self.id,
            key_id=self.key_id,
            key_versions=self.key_versions,
            management_endpoint=self.management_endpoint)


def get_key_versions(filters: Optional[Sequence[Union['GetKeyVersionsFilterArgs', 'GetKeyVersionsFilterArgsDict']]] = None,
                     key_id: Optional[_builtins.str] = None,
                     management_endpoint: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyVersionsResult:
    """
    This data source provides the list of Key Versions in Oracle Cloud Infrastructure Kms service.

    Lists all [KeyVersion](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/KeyVersion/) resources for the specified
    master encryption key.

    As a management operation, this call is subject to a Key Management limit that applies to the total number
    of requests across all management read operations. Key Management might throttle this call to reject an
    otherwise valid request when the total rate of management read operations exceeds 10 requests per second
    for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_versions = oci.Kms.get_key_versions(key_id=test_key["id"],
        management_endpoint=key_version_management_endpoint)
    ```


    :param _builtins.str key_id: The OCID of the key.
    :param _builtins.str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['keyId'] = key_id
    __args__['managementEndpoint'] = management_endpoint
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getKeyVersions:getKeyVersions', __args__, opts=opts, typ=GetKeyVersionsResult).value

    return AwaitableGetKeyVersionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        key_versions=pulumi.get(__ret__, 'key_versions'),
        management_endpoint=pulumi.get(__ret__, 'management_endpoint'))
def get_key_versions_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetKeyVersionsFilterArgs', 'GetKeyVersionsFilterArgsDict']]]]] = None,
                            key_id: Optional[pulumi.Input[_builtins.str]] = None,
                            management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyVersionsResult]:
    """
    This data source provides the list of Key Versions in Oracle Cloud Infrastructure Kms service.

    Lists all [KeyVersion](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/KeyVersion/) resources for the specified
    master encryption key.

    As a management operation, this call is subject to a Key Management limit that applies to the total number
    of requests across all management read operations. Key Management might throttle this call to reject an
    otherwise valid request when the total rate of management read operations exceeds 10 requests per second
    for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_versions = oci.Kms.get_key_versions(key_id=test_key["id"],
        management_endpoint=key_version_management_endpoint)
    ```


    :param _builtins.str key_id: The OCID of the key.
    :param _builtins.str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['keyId'] = key_id
    __args__['managementEndpoint'] = management_endpoint
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Kms/getKeyVersions:getKeyVersions', __args__, opts=opts, typ=GetKeyVersionsResult)
    return __ret__.apply(lambda __response__: GetKeyVersionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        key_versions=pulumi.get(__response__, 'key_versions'),
        management_endpoint=pulumi.get(__response__, 'management_endpoint')))
