# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 key_shape: pulumi.Input['KeyKeyShapeArgs'],
                 management_endpoint: pulumi.Input[_builtins.str],
                 auto_key_rotation_details: Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_reference: Optional[pulumi.Input['KeyExternalKeyReferenceArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_from_file: Optional[pulumi.Input['KeyRestoreFromFileArgs']] = None,
                 restore_from_object_store: Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the master encryption key.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input['KeyKeyShapeArgs'] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input['KeyAutoKeyRotationDetailsArgs'] auto_key_rotation_details: (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] desired_state: (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        :param pulumi.Input['KeyExternalKeyReferenceArgs'] external_key_reference: A reference to the key on external key manager.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_rotation_enabled: (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        :param pulumi.Input[_builtins.str] protection_mode: The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param pulumi.Input['KeyRestoreFromFileArgs'] restore_from_file: (Updatable) Details where key was backed up.
        :param pulumi.Input['KeyRestoreFromObjectStoreArgs'] restore_from_object_store: (Updatable) Details where key was backed up
        :param pulumi.Input[_builtins.bool] restore_trigger: (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "key_shape", key_shape)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        if auto_key_rotation_details is not None:
            pulumi.set(__self__, "auto_key_rotation_details", auto_key_rotation_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if external_key_reference is not None:
            pulumi.set(__self__, "external_key_reference", external_key_reference)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_rotation_enabled is not None:
            pulumi.set(__self__, "is_auto_rotation_enabled", is_auto_rotation_enabled)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if restore_from_file is not None:
            pulumi.set(__self__, "restore_from_file", restore_from_file)
        if restore_from_object_store is not None:
            pulumi.set(__self__, "restore_from_object_store", restore_from_object_store)
        if restore_trigger is not None:
            pulumi.set(__self__, "restore_trigger", restore_trigger)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the master encryption key.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> pulumi.Input['KeyKeyShapeArgs']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @key_shape.setter
    def key_shape(self, value: pulumi.Input['KeyKeyShapeArgs']):
        pulumi.set(self, "key_shape", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationDetails")
    def auto_key_rotation_details(self) -> Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']]:
        """
        (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        """
        return pulumi.get(self, "auto_key_rotation_details")

    @auto_key_rotation_details.setter
    def auto_key_rotation_details(self, value: Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']]):
        pulumi.set(self, "auto_key_rotation_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyReference")
    def external_key_reference(self) -> Optional[pulumi.Input['KeyExternalKeyReferenceArgs']]:
        """
        A reference to the key on external key manager.
        """
        return pulumi.get(self, "external_key_reference")

    @external_key_reference.setter
    def external_key_reference(self, value: Optional[pulumi.Input['KeyExternalKeyReferenceArgs']]):
        pulumi.set(self, "external_key_reference", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAutoRotationEnabled")
    def is_auto_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        """
        return pulumi.get(self, "is_auto_rotation_enabled")

    @is_auto_rotation_enabled.setter
    def is_auto_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_mode", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> Optional[pulumi.Input['KeyRestoreFromFileArgs']]:
        """
        (Updatable) Details where key was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @restore_from_file.setter
    def restore_from_file(self, value: Optional[pulumi.Input['KeyRestoreFromFileArgs']]):
        pulumi.set(self, "restore_from_file", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']]:
        """
        (Updatable) Details where key was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @restore_from_object_store.setter
    def restore_from_object_store(self, value: Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']]):
        pulumi.set(self, "restore_from_object_store", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "restore_trigger")

    @restore_trigger.setter
    def restore_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_trigger", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 auto_key_rotation_details: Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 current_key_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_reference: Optional[pulumi.Input['KeyExternalKeyReferenceArgs']] = None,
                 external_key_reference_details: Optional[pulumi.Input[Sequence[pulumi.Input['KeyExternalKeyReferenceDetailArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_shape: Optional[pulumi.Input['KeyKeyShapeArgs']] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_details: Optional[pulumi.Input[Sequence[pulumi.Input['KeyReplicaDetailArgs']]]] = None,
                 restore_from_file: Optional[pulumi.Input['KeyRestoreFromFileArgs']] = None,
                 restore_from_object_store: Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 restored_from_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input['KeyAutoKeyRotationDetailsArgs'] auto_key_rotation_details: (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the master encryption key.
        :param pulumi.Input[_builtins.str] current_key_version: The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] desired_state: (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input['KeyExternalKeyReferenceArgs'] external_key_reference: A reference to the key on external key manager.
        :param pulumi.Input[Sequence[pulumi.Input['KeyExternalKeyReferenceDetailArgs']]] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_rotation_enabled: (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        :param pulumi.Input['KeyKeyShapeArgs'] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] protection_mode: The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param pulumi.Input[Sequence[pulumi.Input['KeyReplicaDetailArgs']]] replica_details: Key replica details
        :param pulumi.Input['KeyRestoreFromFileArgs'] restore_from_file: (Updatable) Details where key was backed up.
        :param pulumi.Input['KeyRestoreFromObjectStoreArgs'] restore_from_object_store: (Updatable) Details where key was backed up
        :param pulumi.Input[_builtins.bool] restore_trigger: (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        :param pulumi.Input[_builtins.str] restored_from_key_id: The OCID of the key from which this key was restored.
        :param pulumi.Input[_builtins.str] state: The key's current lifecycle state.  Example: `ENABLED`
        :param pulumi.Input[_builtins.str] time_created: The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault that contains this key.
        """
        if auto_key_rotation_details is not None:
            pulumi.set(__self__, "auto_key_rotation_details", auto_key_rotation_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if current_key_version is not None:
            pulumi.set(__self__, "current_key_version", current_key_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_key_reference is not None:
            pulumi.set(__self__, "external_key_reference", external_key_reference)
        if external_key_reference_details is not None:
            pulumi.set(__self__, "external_key_reference_details", external_key_reference_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_rotation_enabled is not None:
            pulumi.set(__self__, "is_auto_rotation_enabled", is_auto_rotation_enabled)
        if is_primary is not None:
            pulumi.set(__self__, "is_primary", is_primary)
        if key_shape is not None:
            pulumi.set(__self__, "key_shape", key_shape)
        if management_endpoint is not None:
            pulumi.set(__self__, "management_endpoint", management_endpoint)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if replica_details is not None:
            pulumi.set(__self__, "replica_details", replica_details)
        if restore_from_file is not None:
            pulumi.set(__self__, "restore_from_file", restore_from_file)
        if restore_from_object_store is not None:
            pulumi.set(__self__, "restore_from_object_store", restore_from_object_store)
        if restore_trigger is not None:
            pulumi.set(__self__, "restore_trigger", restore_trigger)
        if restored_from_key_id is not None:
            pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationDetails")
    def auto_key_rotation_details(self) -> Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']]:
        """
        (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        """
        return pulumi.get(self, "auto_key_rotation_details")

    @auto_key_rotation_details.setter
    def auto_key_rotation_details(self, value: Optional[pulumi.Input['KeyAutoKeyRotationDetailsArgs']]):
        pulumi.set(self, "auto_key_rotation_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where you want to create the master encryption key.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="currentKeyVersion")
    def current_key_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        """
        return pulumi.get(self, "current_key_version")

    @current_key_version.setter
    def current_key_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_key_version", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyReference")
    def external_key_reference(self) -> Optional[pulumi.Input['KeyExternalKeyReferenceArgs']]:
        """
        A reference to the key on external key manager.
        """
        return pulumi.get(self, "external_key_reference")

    @external_key_reference.setter
    def external_key_reference(self, value: Optional[pulumi.Input['KeyExternalKeyReferenceArgs']]):
        pulumi.set(self, "external_key_reference", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyExternalKeyReferenceDetailArgs']]]]:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @external_key_reference_details.setter
    def external_key_reference_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyExternalKeyReferenceDetailArgs']]]]):
        pulumi.set(self, "external_key_reference_details", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAutoRotationEnabled")
    def is_auto_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        """
        return pulumi.get(self, "is_auto_rotation_enabled")

    @is_auto_rotation_enabled.setter
    def is_auto_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_primary", value)

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> Optional[pulumi.Input['KeyKeyShapeArgs']]:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @key_shape.setter
    def key_shape(self, value: Optional[pulumi.Input['KeyKeyShapeArgs']]):
        pulumi.set(self, "key_shape", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_mode", value)

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyReplicaDetailArgs']]]]:
        """
        Key replica details
        """
        return pulumi.get(self, "replica_details")

    @replica_details.setter
    def replica_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyReplicaDetailArgs']]]]):
        pulumi.set(self, "replica_details", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> Optional[pulumi.Input['KeyRestoreFromFileArgs']]:
        """
        (Updatable) Details where key was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @restore_from_file.setter
    def restore_from_file(self, value: Optional[pulumi.Input['KeyRestoreFromFileArgs']]):
        pulumi.set(self, "restore_from_file", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']]:
        """
        (Updatable) Details where key was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @restore_from_object_store.setter
    def restore_from_object_store(self, value: Optional[pulumi.Input['KeyRestoreFromObjectStoreArgs']]):
        pulumi.set(self, "restore_from_object_store", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "restore_trigger")

    @restore_trigger.setter
    def restore_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_trigger", value)

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key from which this key was restored.
        """
        return pulumi.get(self, "restored_from_key_id")

    @restored_from_key_id.setter
    def restored_from_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restored_from_key_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the vault that contains this key.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("oci:Kms/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_key_rotation_details: Optional[pulumi.Input[Union['KeyAutoKeyRotationDetailsArgs', 'KeyAutoKeyRotationDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_reference: Optional[pulumi.Input[Union['KeyExternalKeyReferenceArgs', 'KeyExternalKeyReferenceArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_shape: Optional[pulumi.Input[Union['KeyKeyShapeArgs', 'KeyKeyShapeArgsDict']]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_from_file: Optional[pulumi.Input[Union['KeyRestoreFromFileArgs', 'KeyRestoreFromFileArgsDict']]] = None,
                 restore_from_object_store: Optional[pulumi.Input[Union['KeyRestoreFromObjectStoreArgs', 'KeyRestoreFromObjectStoreArgsDict']]] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Key resource in Oracle Cloud Infrastructure Kms service.

        Creates a new master encryption key.

        As a management operation, this call is subject to a Key Management limit that applies to the total
        number of requests across all management write operations. Key Management might throttle this call
        to reject an otherwise valid request when the total rate of management write operations exceeds 10
        requests per second for a given tenancy.

        ## Import

        Keys can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/key:Key test_key "managementEndpoint/{managementEndpoint}/keys/{keyId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KeyAutoKeyRotationDetailsArgs', 'KeyAutoKeyRotationDetailsArgsDict']] auto_key_rotation_details: (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the master encryption key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] desired_state: (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Union['KeyExternalKeyReferenceArgs', 'KeyExternalKeyReferenceArgsDict']] external_key_reference: A reference to the key on external key manager.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_rotation_enabled: (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        :param pulumi.Input[Union['KeyKeyShapeArgs', 'KeyKeyShapeArgsDict']] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] protection_mode: The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param pulumi.Input[Union['KeyRestoreFromFileArgs', 'KeyRestoreFromFileArgsDict']] restore_from_file: (Updatable) Details where key was backed up.
        :param pulumi.Input[Union['KeyRestoreFromObjectStoreArgs', 'KeyRestoreFromObjectStoreArgsDict']] restore_from_object_store: (Updatable) Details where key was backed up
        :param pulumi.Input[_builtins.bool] restore_trigger: (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Key resource in Oracle Cloud Infrastructure Kms service.

        Creates a new master encryption key.

        As a management operation, this call is subject to a Key Management limit that applies to the total
        number of requests across all management write operations. Key Management might throttle this call
        to reject an otherwise valid request when the total rate of management write operations exceeds 10
        requests per second for a given tenancy.

        ## Import

        Keys can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/key:Key test_key "managementEndpoint/{managementEndpoint}/keys/{keyId}"
        ```

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_key_rotation_details: Optional[pulumi.Input[Union['KeyAutoKeyRotationDetailsArgs', 'KeyAutoKeyRotationDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_reference: Optional[pulumi.Input[Union['KeyExternalKeyReferenceArgs', 'KeyExternalKeyReferenceArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_shape: Optional[pulumi.Input[Union['KeyKeyShapeArgs', 'KeyKeyShapeArgsDict']]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_from_file: Optional[pulumi.Input[Union['KeyRestoreFromFileArgs', 'KeyRestoreFromFileArgsDict']]] = None,
                 restore_from_object_store: Optional[pulumi.Input[Union['KeyRestoreFromObjectStoreArgs', 'KeyRestoreFromObjectStoreArgsDict']]] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            __props__.__dict__["auto_key_rotation_details"] = auto_key_rotation_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["desired_state"] = desired_state
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_key_reference"] = external_key_reference
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_rotation_enabled"] = is_auto_rotation_enabled
            if key_shape is None and not opts.urn:
                raise TypeError("Missing required property 'key_shape'")
            __props__.__dict__["key_shape"] = key_shape
            if management_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'management_endpoint'")
            __props__.__dict__["management_endpoint"] = management_endpoint
            __props__.__dict__["protection_mode"] = protection_mode
            __props__.__dict__["restore_from_file"] = restore_from_file
            __props__.__dict__["restore_from_object_store"] = restore_from_object_store
            __props__.__dict__["restore_trigger"] = restore_trigger
            __props__.__dict__["time_of_deletion"] = time_of_deletion
            __props__.__dict__["current_key_version"] = None
            __props__.__dict__["external_key_reference_details"] = None
            __props__.__dict__["is_primary"] = None
            __props__.__dict__["replica_details"] = None
            __props__.__dict__["restored_from_key_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vault_id"] = None
        super(Key, __self__).__init__(
            'oci:Kms/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_key_rotation_details: Optional[pulumi.Input[Union['KeyAutoKeyRotationDetailsArgs', 'KeyAutoKeyRotationDetailsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            current_key_version: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_key_reference: Optional[pulumi.Input[Union['KeyExternalKeyReferenceArgs', 'KeyExternalKeyReferenceArgsDict']]] = None,
            external_key_reference_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyExternalKeyReferenceDetailArgs', 'KeyExternalKeyReferenceDetailArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_auto_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
            key_shape: Optional[pulumi.Input[Union['KeyKeyShapeArgs', 'KeyKeyShapeArgsDict']]] = None,
            management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            protection_mode: Optional[pulumi.Input[_builtins.str]] = None,
            replica_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyReplicaDetailArgs', 'KeyReplicaDetailArgsDict']]]]] = None,
            restore_from_file: Optional[pulumi.Input[Union['KeyRestoreFromFileArgs', 'KeyRestoreFromFileArgsDict']]] = None,
            restore_from_object_store: Optional[pulumi.Input[Union['KeyRestoreFromObjectStoreArgs', 'KeyRestoreFromObjectStoreArgsDict']]] = None,
            restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            restored_from_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KeyAutoKeyRotationDetailsArgs', 'KeyAutoKeyRotationDetailsArgsDict']] auto_key_rotation_details: (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the master encryption key.
        :param pulumi.Input[_builtins.str] current_key_version: The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] desired_state: (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Union['KeyExternalKeyReferenceArgs', 'KeyExternalKeyReferenceArgsDict']] external_key_reference: A reference to the key on external key manager.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyExternalKeyReferenceDetailArgs', 'KeyExternalKeyReferenceDetailArgsDict']]]] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_rotation_enabled: (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        :param pulumi.Input[Union['KeyKeyShapeArgs', 'KeyKeyShapeArgsDict']] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] protection_mode: The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyReplicaDetailArgs', 'KeyReplicaDetailArgsDict']]]] replica_details: Key replica details
        :param pulumi.Input[Union['KeyRestoreFromFileArgs', 'KeyRestoreFromFileArgsDict']] restore_from_file: (Updatable) Details where key was backed up.
        :param pulumi.Input[Union['KeyRestoreFromObjectStoreArgs', 'KeyRestoreFromObjectStoreArgsDict']] restore_from_object_store: (Updatable) Details where key was backed up
        :param pulumi.Input[_builtins.bool] restore_trigger: (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        :param pulumi.Input[_builtins.str] restored_from_key_id: The OCID of the key from which this key was restored.
        :param pulumi.Input[_builtins.str] state: The key's current lifecycle state.  Example: `ENABLED`
        :param pulumi.Input[_builtins.str] time_created: The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault that contains this key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["auto_key_rotation_details"] = auto_key_rotation_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["current_key_version"] = current_key_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_key_reference"] = external_key_reference
        __props__.__dict__["external_key_reference_details"] = external_key_reference_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_rotation_enabled"] = is_auto_rotation_enabled
        __props__.__dict__["is_primary"] = is_primary
        __props__.__dict__["key_shape"] = key_shape
        __props__.__dict__["management_endpoint"] = management_endpoint
        __props__.__dict__["protection_mode"] = protection_mode
        __props__.__dict__["replica_details"] = replica_details
        __props__.__dict__["restore_from_file"] = restore_from_file
        __props__.__dict__["restore_from_object_store"] = restore_from_object_store
        __props__.__dict__["restore_trigger"] = restore_trigger
        __props__.__dict__["restored_from_key_id"] = restored_from_key_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["vault_id"] = vault_id
        return Key(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationDetails")
    def auto_key_rotation_details(self) -> pulumi.Output['outputs.KeyAutoKeyRotationDetails']:
        """
        (Updatable) The details of auto rotation schedule for the Key being create updated or imported.
        """
        return pulumi.get(self, "auto_key_rotation_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the master encryption key.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentKeyVersion")
    def current_key_version(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        """
        return pulumi.get(self, "current_key_version")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Desired state of the key. Possible values : `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKeyReference")
    def external_key_reference(self) -> pulumi.Output['outputs.KeyExternalKeyReference']:
        """
        A reference to the key on external key manager.
        """
        return pulumi.get(self, "external_key_reference")

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> pulumi.Output[Sequence['outputs.KeyExternalKeyReferenceDetail']]:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isAutoRotationEnabled")
    def is_auto_rotation_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A parameter specifying whether the auto key rotation is enabled or not.
        """
        return pulumi.get(self, "is_auto_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Output[_builtins.bool]:
        """
        A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> pulumi.Output['outputs.KeyKeyShape']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. By default, a key's protection mode is set to `HSM`. You can't change a key's protection mode after the key is created or imported. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        """
        return pulumi.get(self, "protection_mode")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> pulumi.Output[Sequence['outputs.KeyReplicaDetail']]:
        """
        Key replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> pulumi.Output[Optional['outputs.KeyRestoreFromFile']]:
        """
        (Updatable) Details where key was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> pulumi.Output[Optional['outputs.KeyRestoreFromObjectStore']]:
        """
        (Updatable) Details where key was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "restore_trigger")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key from which this key was restored.
        """
        return pulumi.get(self, "restored_from_key_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The key's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional property for the deletion time of the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the vault that contains this key.
        """
        return pulumi.get(self, "vault_id")

