# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GeneratedKeyKeyShape',
    'KeyAutoKeyRotationDetails',
    'KeyExternalKeyReference',
    'KeyExternalKeyReferenceDetail',
    'KeyKeyShape',
    'KeyReplicaDetail',
    'KeyRestoreFromFile',
    'KeyRestoreFromObjectStore',
    'KeyVersionExternalKeyReferenceDetail',
    'KeyVersionReplicaDetail',
    'VaultExternalKeyManagerMetadata',
    'VaultExternalKeyManagerMetadataOauthMetadata',
    'VaultExternalKeyManagerMetadataSummary',
    'VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary',
    'VaultReplicaDetail',
    'VaultRestoreFromFile',
    'VaultRestoreFromObjectStore',
    'VaultVerificationReplicaVaultMetadata',
    'GetEkmsPrivateEndpointsEkmsPrivateEndpointResult',
    'GetEkmsPrivateEndpointsFilterResult',
    'GetKeyAutoKeyRotationDetailResult',
    'GetKeyExternalKeyReferenceResult',
    'GetKeyExternalKeyReferenceDetailResult',
    'GetKeyKeyShapeResult',
    'GetKeyReplicaDetailResult',
    'GetKeyRestoreFromFileResult',
    'GetKeyRestoreFromObjectStoreResult',
    'GetKeyVersionExternalKeyReferenceDetailResult',
    'GetKeyVersionReplicaDetailResult',
    'GetKeyVersionsFilterResult',
    'GetKeyVersionsKeyVersionResult',
    'GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult',
    'GetKeyVersionsKeyVersionReplicaDetailResult',
    'GetKeysFilterResult',
    'GetKeysKeyResult',
    'GetKeysKeyAutoKeyRotationDetailResult',
    'GetKeysKeyExternalKeyReferenceResult',
    'GetKeysKeyExternalKeyReferenceDetailResult',
    'GetKeysKeyKeyShapeResult',
    'GetKeysKeyReplicaDetailResult',
    'GetKeysKeyRestoreFromFileResult',
    'GetKeysKeyRestoreFromObjectStoreResult',
    'GetReplicationStatusReplicaDetailResult',
    'GetVaultExternalKeyManagerMetadataResult',
    'GetVaultExternalKeyManagerMetadataOauthMetadataResult',
    'GetVaultExternalKeyManagerMetadataSummaryResult',
    'GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult',
    'GetVaultReplicaDetailResult',
    'GetVaultReplicasFilterResult',
    'GetVaultReplicasVaultReplicaResult',
    'GetVaultRestoreFromFileResult',
    'GetVaultRestoreFromObjectStoreResult',
    'GetVaultsFilterResult',
    'GetVaultsVaultResult',
    'GetVaultsVaultExternalKeyManagerMetadataResult',
    'GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult',
    'GetVaultsVaultExternalKeyManagerMetadataSummaryResult',
    'GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult',
    'GetVaultsVaultReplicaDetailResult',
    'GetVaultsVaultRestoreFromFileResult',
    'GetVaultsVaultRestoreFromObjectStoreResult',
]

@pulumi.output_type
class GeneratedKeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeneratedKeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 length: _builtins.int,
                 curve_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param _builtins.int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param _builtins.str curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[_builtins.str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyAutoKeyRotationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRotationMessage":
            suggest = "last_rotation_message"
        elif key == "lastRotationStatus":
            suggest = "last_rotation_status"
        elif key == "rotationIntervalInDays":
            suggest = "rotation_interval_in_days"
        elif key == "timeOfLastRotation":
            suggest = "time_of_last_rotation"
        elif key == "timeOfNextRotation":
            suggest = "time_of_next_rotation"
        elif key == "timeOfScheduleStart":
            suggest = "time_of_schedule_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyAutoKeyRotationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyAutoKeyRotationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyAutoKeyRotationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_rotation_message: Optional[_builtins.str] = None,
                 last_rotation_status: Optional[_builtins.str] = None,
                 rotation_interval_in_days: Optional[_builtins.int] = None,
                 time_of_last_rotation: Optional[_builtins.str] = None,
                 time_of_next_rotation: Optional[_builtins.str] = None,
                 time_of_schedule_start: Optional[_builtins.str] = None):
        """
        :param _builtins.str last_rotation_message: (Updatable) The last execution status message of auto key rotation.
        :param _builtins.str last_rotation_status: (Updatable) The status of last execution of auto key rotation.
        :param _builtins.int rotation_interval_in_days: (Updatable) The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        :param _builtins.str time_of_last_rotation: (Updatable) A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        :param _builtins.str time_of_next_rotation: (Updatable) A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        :param _builtins.str time_of_schedule_start: (Updatable) A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        if last_rotation_message is not None:
            pulumi.set(__self__, "last_rotation_message", last_rotation_message)
        if last_rotation_status is not None:
            pulumi.set(__self__, "last_rotation_status", last_rotation_status)
        if rotation_interval_in_days is not None:
            pulumi.set(__self__, "rotation_interval_in_days", rotation_interval_in_days)
        if time_of_last_rotation is not None:
            pulumi.set(__self__, "time_of_last_rotation", time_of_last_rotation)
        if time_of_next_rotation is not None:
            pulumi.set(__self__, "time_of_next_rotation", time_of_next_rotation)
        if time_of_schedule_start is not None:
            pulumi.set(__self__, "time_of_schedule_start", time_of_schedule_start)

    @_builtins.property
    @pulumi.getter(name="lastRotationMessage")
    def last_rotation_message(self) -> Optional[_builtins.str]:
        """
        (Updatable) The last execution status message of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_message")

    @_builtins.property
    @pulumi.getter(name="lastRotationStatus")
    def last_rotation_status(self) -> Optional[_builtins.str]:
        """
        (Updatable) The status of last execution of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_status")

    @_builtins.property
    @pulumi.getter(name="rotationIntervalInDays")
    def rotation_interval_in_days(self) -> Optional[_builtins.int]:
        """
        (Updatable) The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        """
        return pulumi.get(self, "rotation_interval_in_days")

    @_builtins.property
    @pulumi.getter(name="timeOfLastRotation")
    def time_of_last_rotation(self) -> Optional[_builtins.str]:
        """
        (Updatable) A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        """
        return pulumi.get(self, "time_of_last_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfNextRotation")
    def time_of_next_rotation(self) -> Optional[_builtins.str]:
        """
        (Updatable) A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        """
        return pulumi.get(self, "time_of_next_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfScheduleStart")
    def time_of_schedule_start(self) -> Optional[_builtins.str]:
        """
        (Updatable) A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        return pulumi.get(self, "time_of_schedule_start")


@pulumi.output_type
class KeyExternalKeyReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyExternalKeyReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyExternalKeyReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyExternalKeyReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        pulumi.set(__self__, "external_key_id", external_key_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class KeyExternalKeyReferenceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"
        elif key == "externalKeyVersionId":
            suggest = "external_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyExternalKeyReferenceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyExternalKeyReferenceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyExternalKeyReferenceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: Optional[_builtins.str] = None,
                 external_key_version_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        if external_key_id is not None:
            pulumi.set(__self__, "external_key_id", external_key_id)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[_builtins.str]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[_builtins.str]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class KeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 length: _builtins.int,
                 curve_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param _builtins.int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param _builtins.str curve_id: Supported curve IDs for ECDSA keys.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "length", length)
        if curve_id is not None:
            pulumi.set(__self__, "curve_id", curve_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[_builtins.str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[_builtins.str]:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class KeyRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreKeyFromFileDetails":
            suggest = "restore_key_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: _builtins.str,
                 restore_key_from_file_details: _builtins.str,
                 content_md5: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_length: (Updatable) content length of key's backup binary file
        :param _builtins.str restore_key_from_file_details: Key backup file content.
        :param _builtins.str content_md5: (Updatable) content md5 hashed value of key's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        """
        (Updatable) content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> _builtins.str:
        """
        Key backup file content.
        """
        return pulumi.get(self, "restore_key_from_file_details")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[_builtins.str]:
        """
        (Updatable) content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class KeyRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 bucket: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param _builtins.str bucket: (Updatable) Name of the bucket where key was backed up
        :param _builtins.str namespace: (Updatable) Namespace of the bucket where key was backed up
        :param _builtins.str object: (Updatable) Object containing the backup
        :param _builtins.str uri: (Updatable) Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        (Updatable) Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class KeyVersionExternalKeyReferenceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"
        elif key == "externalKeyVersionId":
            suggest = "external_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionExternalKeyReferenceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionExternalKeyReferenceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionExternalKeyReferenceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: Optional[_builtins.str] = None,
                 external_key_version_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        if external_key_id is not None:
            pulumi.set(__self__, "external_key_id", external_key_id)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[_builtins.str]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[_builtins.str]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class KeyVersionReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key version operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[_builtins.str]:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultExternalKeyManagerMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalVaultEndpointUrl":
            suggest = "external_vault_endpoint_url"
        elif key == "oauthMetadata":
            suggest = "oauth_metadata"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_vault_endpoint_url: _builtins.str,
                 oauth_metadata: 'outputs.VaultExternalKeyManagerMetadataOauthMetadata',
                 private_endpoint_id: _builtins.str):
        """
        :param _builtins.str external_vault_endpoint_url: URI of the vault on external key manager.
        :param 'VaultExternalKeyManagerMetadataOauthMetadataArgs' oauth_metadata: Authorization details required to get access token from IDP for accessing protected resources.
        :param _builtins.str private_endpoint_id: OCID of private endpoint created by customer.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadata", oauth_metadata)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> _builtins.str:
        """
        URI of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadata")
    def oauth_metadata(self) -> 'outputs.VaultExternalKeyManagerMetadataOauthMetadata':
        """
        Authorization details required to get access token from IDP for accessing protected resources.
        """
        return pulumi.get(self, "oauth_metadata")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        OCID of private endpoint created by customer.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class VaultExternalKeyManagerMetadataOauthMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAppId":
            suggest = "client_app_id"
        elif key == "clientAppSecret":
            suggest = "client_app_secret"
        elif key == "idcsAccountNameUrl":
            suggest = "idcs_account_name_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataOauthMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataOauthMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataOauthMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_app_id: _builtins.str,
                 client_app_secret: _builtins.str,
                 idcs_account_name_url: _builtins.str):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str client_app_secret: Secret of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "client_app_secret", client_app_secret)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> _builtins.str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> _builtins.str:
        """
        Secret of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_secret")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class VaultExternalKeyManagerMetadataSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalVaultEndpointUrl":
            suggest = "external_vault_endpoint_url"
        elif key == "oauthMetadataSummaries":
            suggest = "oauth_metadata_summaries"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_vault_endpoint_url: Optional[_builtins.str] = None,
                 oauth_metadata_summaries: Optional[Sequence['outputs.VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary']] = None,
                 private_endpoint_id: Optional[_builtins.str] = None,
                 vendor: Optional[_builtins.str] = None):
        """
        :param _builtins.str external_vault_endpoint_url: URL of the vault on external key manager.
        :param Sequence['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param _builtins.str private_endpoint_id: OCID of the private endpoint.
        :param _builtins.str vendor: Vendor of the external key manager.
        """
        if external_vault_endpoint_url is not None:
            pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        if oauth_metadata_summaries is not None:
            pulumi.set(__self__, "oauth_metadata_summaries", oauth_metadata_summaries)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> Optional[_builtins.str]:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Optional[Sequence['outputs.VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary']]:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[_builtins.str]:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> Optional[_builtins.str]:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAppId":
            suggest = "client_app_id"
        elif key == "idcsAccountNameUrl":
            suggest = "idcs_account_name_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_app_id: Optional[_builtins.str] = None,
                 idcs_account_name_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        if client_app_id is not None:
            pulumi.set(__self__, "client_app_id", client_app_id)
        if idcs_account_name_url is not None:
            pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> Optional[_builtins.str]:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> Optional[_builtins.str]:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class VaultReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str replication_id: ReplicationId associated with a vault operation
        """
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[_builtins.str]:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreVaultFromFileDetails":
            suggest = "restore_vault_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: _builtins.str,
                 restore_vault_from_file_details: _builtins.str,
                 content_md5: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_length: content length of vault's backup binary file
        :param _builtins.str restore_vault_from_file_details: Vault backup file content
        :param _builtins.str content_md5: (Updatable) content md5 hashed value of vault's backup file
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> _builtins.str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[_builtins.str]:
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class VaultRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 bucket: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param _builtins.str bucket: (Updatable) Name of the bucket where vault was backed up
        :param _builtins.str namespace: (Updatable) Namespace of the bucket where vault was backed up
        :param _builtins.str object: (Updatable) Object containing the backup
        :param _builtins.str uri: (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        pulumi.set(__self__, "destination", destination)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class VaultVerificationReplicaVaultMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idcsAccountNameUrl":
            suggest = "idcs_account_name_url"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"
        elif key == "vaultType":
            suggest = "vault_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultVerificationReplicaVaultMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultVerificationReplicaVaultMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultVerificationReplicaVaultMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idcs_account_name_url: _builtins.str,
                 private_endpoint_id: _builtins.str,
                 vault_type: _builtins.str):
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "vault_type", vault_type)

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        return pulumi.get(self, "idcs_account_name_url")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> _builtins.str:
        return pulumi.get(self, "vault_type")


@pulumi.output_type
class GetEkmsPrivateEndpointsEkmsPrivateEndpointResult(dict):
    def __init__(__self__, *,
                 ca_bundle: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 external_key_manager_ip: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 port: _builtins.int,
                 private_endpoint_ip: _builtins.str,
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str ca_bundle: CABundle to validate TLS certificate of the external key manager system in PEM format
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: Mutable name of the EKMS private endpoint
        :param _builtins.str external_key_manager_ip: Private IP of the external key manager system to connect to from the EKMS private endpoint
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: Unique identifier that is immutable
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param _builtins.int port: The port of the external key manager system
        :param _builtins.str private_endpoint_ip: The IP address in the customer's VCN for the EKMS private endpoint. This is taken from subnet
        :param _builtins.str state: The current state of the EKMS private endpoint resource.
        :param _builtins.str subnet_id: Subnet Identifier
        :param _builtins.str time_created: The time the EKMS private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param _builtins.str time_updated: The time the EKMS private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "ca_bundle", ca_bundle)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_key_manager_ip", external_key_manager_ip)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> _builtins.str:
        """
        CABundle to validate TLS certificate of the external key manager system in PEM format
        """
        return pulumi.get(self, "ca_bundle")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Mutable name of the EKMS private endpoint
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerIp")
    def external_key_manager_ip(self) -> _builtins.str:
        """
        Private IP of the external key manager system to connect to from the EKMS private endpoint
        """
        return pulumi.get(self, "external_key_manager_ip")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of the external key manager system
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        The IP address in the customer's VCN for the EKMS private endpoint. This is taken from subnet
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the EKMS private endpoint resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the EKMS private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the EKMS private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEkmsPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeyAutoKeyRotationDetailResult(dict):
    def __init__(__self__, *,
                 last_rotation_message: _builtins.str,
                 last_rotation_status: _builtins.str,
                 rotation_interval_in_days: _builtins.int,
                 time_of_last_rotation: _builtins.str,
                 time_of_next_rotation: _builtins.str,
                 time_of_schedule_start: _builtins.str):
        """
        :param _builtins.str last_rotation_message: The last execution status message of auto key rotation.
        :param _builtins.str last_rotation_status: The status of last execution of auto key rotation.
        :param _builtins.int rotation_interval_in_days: The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        :param _builtins.str time_of_last_rotation: A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        :param _builtins.str time_of_next_rotation: A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        :param _builtins.str time_of_schedule_start: A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        pulumi.set(__self__, "last_rotation_message", last_rotation_message)
        pulumi.set(__self__, "last_rotation_status", last_rotation_status)
        pulumi.set(__self__, "rotation_interval_in_days", rotation_interval_in_days)
        pulumi.set(__self__, "time_of_last_rotation", time_of_last_rotation)
        pulumi.set(__self__, "time_of_next_rotation", time_of_next_rotation)
        pulumi.set(__self__, "time_of_schedule_start", time_of_schedule_start)

    @_builtins.property
    @pulumi.getter(name="lastRotationMessage")
    def last_rotation_message(self) -> _builtins.str:
        """
        The last execution status message of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_message")

    @_builtins.property
    @pulumi.getter(name="lastRotationStatus")
    def last_rotation_status(self) -> _builtins.str:
        """
        The status of last execution of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_status")

    @_builtins.property
    @pulumi.getter(name="rotationIntervalInDays")
    def rotation_interval_in_days(self) -> _builtins.int:
        """
        The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        """
        return pulumi.get(self, "rotation_interval_in_days")

    @_builtins.property
    @pulumi.getter(name="timeOfLastRotation")
    def time_of_last_rotation(self) -> _builtins.str:
        """
        A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        """
        return pulumi.get(self, "time_of_last_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfNextRotation")
    def time_of_next_rotation(self) -> _builtins.str:
        """
        A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        """
        return pulumi.get(self, "time_of_next_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfScheduleStart")
    def time_of_schedule_start(self) -> _builtins.str:
        """
        A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        return pulumi.get(self, "time_of_schedule_start")


@pulumi.output_type
class GetKeyExternalKeyReferenceResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class GetKeyExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str,
                 external_key_version_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)
        pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> _builtins.str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 curve_id: _builtins.str,
                 length: _builtins.int):
        """
        :param _builtins.str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param _builtins.str curve_id: Supported curve IDs for ECDSA keys.
        :param _builtins.int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "curve_id", curve_id)
        pulumi.set(__self__, "length", length)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> _builtins.str:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: _builtins.str,
                 content_md5: _builtins.str,
                 restore_key_from_file_details: _builtins.str):
        """
        :param _builtins.str content_length: content length of key's backup binary file
        :param _builtins.str content_md5: content md5 hashed value of key's backup file
        :param _builtins.str restore_key_from_file_details: Key backup file content
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        """
        content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        """
        content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> _builtins.str:
        """
        Key backup file content
        """
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 destination: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str bucket: Name of the bucket where key was backed up
        :param _builtins.str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param _builtins.str namespace: Namespace of the bucket where key was backed up
        :param _builtins.str object: Object containing the backup
        :param _builtins.str uri: Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetKeyVersionExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str,
                 external_key_version_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)
        pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> _builtins.str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key version operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeyVersionsKeyVersionResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 external_key_reference_details: Sequence['outputs.GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult'],
                 external_key_version_id: _builtins.str,
                 id: _builtins.str,
                 is_auto_rotated: _builtins.bool,
                 is_primary: _builtins.bool,
                 key_id: _builtins.str,
                 key_version_id: _builtins.str,
                 management_endpoint: _builtins.str,
                 public_key: _builtins.str,
                 replica_details: Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult'],
                 restored_from_key_id: _builtins.str,
                 restored_from_key_version_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_of_deletion: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment that contains this key version.
        :param Sequence['GetKeyVersionsKeyVersionExternalKeyReferenceDetailArgs'] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        :param _builtins.str id: The OCID of the key version.
        :param _builtins.bool is_auto_rotated: An optional property indicating whether this keyversion is generated from auto rotatation.
        :param _builtins.bool is_primary: A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        :param _builtins.str key_id: The OCID of the key.
        :param _builtins.str key_version_id: The OCID of the key version.
        :param _builtins.str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param _builtins.str public_key: The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        :param Sequence['GetKeyVersionsKeyVersionReplicaDetailArgs'] replica_details: KeyVersion replica details
        :param _builtins.str restored_from_key_version_id: The OCID of the key version from which this key version was restored.
        :param _builtins.str state: The key version's current lifecycle state.  Example: `ENABLED`
        :param _builtins.str time_created: The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        :param _builtins.str time_of_deletion: An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str vault_id: The OCID of the vault that contains this key version.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "external_key_reference_details", external_key_reference_details)
        pulumi.set(__self__, "external_key_version_id", external_key_version_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_rotated", is_auto_rotated)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version_id", key_version_id)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        pulumi.set(__self__, "restored_from_key_version_id", restored_from_key_version_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Sequence['outputs.GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult']:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> _builtins.str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoRotated")
    def is_auto_rotated(self) -> _builtins.bool:
        """
        An optional property indicating whether this keyversion is generated from auto rotatation.
        """
        return pulumi.get(self, "is_auto_rotated")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> _builtins.bool:
        """
        A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> _builtins.str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "key_version_id")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> _builtins.str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult']:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> _builtins.str:
        return pulumi.get(self, "restored_from_key_id")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> _builtins.str:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> _builtins.str:
        """
        An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str,
                 external_key_version_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)
        pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> _builtins.str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyVersionsKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key version operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeysKeyResult(dict):
    def __init__(__self__, *,
                 auto_key_rotation_details: Sequence['outputs.GetKeysKeyAutoKeyRotationDetailResult'],
                 compartment_id: _builtins.str,
                 current_key_version: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 desired_state: _builtins.str,
                 display_name: _builtins.str,
                 external_key_reference_details: Sequence['outputs.GetKeysKeyExternalKeyReferenceDetailResult'],
                 external_key_references: Sequence['outputs.GetKeysKeyExternalKeyReferenceResult'],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_auto_rotation_enabled: _builtins.bool,
                 is_primary: _builtins.bool,
                 key_shapes: Sequence['outputs.GetKeysKeyKeyShapeResult'],
                 management_endpoint: _builtins.str,
                 protection_mode: _builtins.str,
                 replica_details: Sequence['outputs.GetKeysKeyReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetKeysKeyRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult'],
                 restore_trigger: _builtins.bool,
                 restored_from_key_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_of_deletion: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param Sequence['GetKeysKeyAutoKeyRotationDetailArgs'] auto_key_rotation_details: The details of auto rotation schedule for the Key being create updated or imported.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str current_key_version: The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Sequence['GetKeysKeyExternalKeyReferenceDetailArgs'] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the key.
        :param _builtins.bool is_auto_rotation_enabled: A parameter specifying whether the auto key rotation is enabled or not.
        :param _builtins.bool is_primary: A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        :param Sequence['GetKeysKeyKeyShapeArgs'] key_shapes: The cryptographic properties of a key.
        :param _builtins.str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param _builtins.str protection_mode: A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param Sequence['GetKeysKeyReplicaDetailArgs'] replica_details: Key replica details
        :param _builtins.str state: The key's current lifecycle state.  Example: `ENABLED`
        :param _builtins.str time_created: The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_of_deletion: An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param _builtins.str vault_id: The OCID of the vault that contains this key.
        """
        pulumi.set(__self__, "auto_key_rotation_details", auto_key_rotation_details)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "current_key_version", current_key_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_key_reference_details", external_key_reference_details)
        pulumi.set(__self__, "external_key_references", external_key_references)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_rotation_enabled", is_auto_rotation_enabled)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "key_shapes", key_shapes)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "protection_mode", protection_mode)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restore_from_files", restore_from_files)
        pulumi.set(__self__, "restore_from_object_stores", restore_from_object_stores)
        pulumi.set(__self__, "restore_trigger", restore_trigger)
        pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="autoKeyRotationDetails")
    def auto_key_rotation_details(self) -> Sequence['outputs.GetKeysKeyAutoKeyRotationDetailResult']:
        """
        The details of auto rotation schedule for the Key being create updated or imported.
        """
        return pulumi.get(self, "auto_key_rotation_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentKeyVersion")
    def current_key_version(self) -> _builtins.str:
        """
        The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        """
        return pulumi.get(self, "current_key_version")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> _builtins.str:
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Sequence['outputs.GetKeysKeyExternalKeyReferenceDetailResult']:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @_builtins.property
    @pulumi.getter(name="externalKeyReferences")
    def external_key_references(self) -> Sequence['outputs.GetKeysKeyExternalKeyReferenceResult']:
        return pulumi.get(self, "external_key_references")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoRotationEnabled")
    def is_auto_rotation_enabled(self) -> _builtins.bool:
        """
        A parameter specifying whether the auto key rotation is enabled or not.
        """
        return pulumi.get(self, "is_auto_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> _builtins.bool:
        """
        A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="keyShapes")
    def key_shapes(self) -> Sequence['outputs.GetKeysKeyKeyShapeResult']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shapes")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> _builtins.str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> _builtins.str:
        """
        A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        """
        return pulumi.get(self, "protection_mode")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeysKeyReplicaDetailResult']:
        """
        Key replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetKeysKeyRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> _builtins.bool:
        return pulumi.get(self, "restore_trigger")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> _builtins.str:
        return pulumi.get(self, "restored_from_key_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The key's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> _builtins.str:
        """
        An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The OCID of the vault that contains this key.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeysKeyAutoKeyRotationDetailResult(dict):
    def __init__(__self__, *,
                 last_rotation_message: _builtins.str,
                 last_rotation_status: _builtins.str,
                 rotation_interval_in_days: _builtins.int,
                 time_of_last_rotation: _builtins.str,
                 time_of_next_rotation: _builtins.str,
                 time_of_schedule_start: _builtins.str):
        """
        :param _builtins.str last_rotation_message: The last execution status message of auto key rotation.
        :param _builtins.str last_rotation_status: The status of last execution of auto key rotation.
        :param _builtins.int rotation_interval_in_days: The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        :param _builtins.str time_of_last_rotation: A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        :param _builtins.str time_of_next_rotation: A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        :param _builtins.str time_of_schedule_start: A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        pulumi.set(__self__, "last_rotation_message", last_rotation_message)
        pulumi.set(__self__, "last_rotation_status", last_rotation_status)
        pulumi.set(__self__, "rotation_interval_in_days", rotation_interval_in_days)
        pulumi.set(__self__, "time_of_last_rotation", time_of_last_rotation)
        pulumi.set(__self__, "time_of_next_rotation", time_of_next_rotation)
        pulumi.set(__self__, "time_of_schedule_start", time_of_schedule_start)

    @_builtins.property
    @pulumi.getter(name="lastRotationMessage")
    def last_rotation_message(self) -> _builtins.str:
        """
        The last execution status message of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_message")

    @_builtins.property
    @pulumi.getter(name="lastRotationStatus")
    def last_rotation_status(self) -> _builtins.str:
        """
        The status of last execution of auto key rotation.
        """
        return pulumi.get(self, "last_rotation_status")

    @_builtins.property
    @pulumi.getter(name="rotationIntervalInDays")
    def rotation_interval_in_days(self) -> _builtins.int:
        """
        The interval of auto key rotation. For auto key rotation the interval should between 60 day and 365 days (1 year). Note: User must specify this parameter when creating a new schedule.
        """
        return pulumi.get(self, "rotation_interval_in_days")

    @_builtins.property
    @pulumi.getter(name="timeOfLastRotation")
    def time_of_last_rotation(self) -> _builtins.str:
        """
        A property indicating Last rotation Date. Example: `2023-04-04T00:00:00Z`.
        """
        return pulumi.get(self, "time_of_last_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfNextRotation")
    def time_of_next_rotation(self) -> _builtins.str:
        """
        A property indicating Next estimated scheduled Time, as per the interval, expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z`. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z.
        """
        return pulumi.get(self, "time_of_next_rotation")

    @_builtins.property
    @pulumi.getter(name="timeOfScheduleStart")
    def time_of_schedule_start(self) -> _builtins.str:
        """
        A property indicating  scheduled start date expressed as date YYYY-MM-DD String. Example: `2023-04-04T00:00:00Z. The time has no significance when scheduling an auto key rotation as this can be done anytime approximately the scheduled day, KMS ignores the time and replaces it with 00:00, for example 2023-04-04T15:14:13Z will be used as 2023-04-04T00:00:00Z . Note : Today’s date will be used if not specified by customer.
        """
        return pulumi.get(self, "time_of_schedule_start")


@pulumi.output_type
class GetKeysKeyExternalKeyReferenceResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class GetKeysKeyExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: _builtins.str,
                 external_key_version_id: _builtins.str):
        """
        :param _builtins.str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param _builtins.str external_key_version_id: Key version ID associated with the external key.
        """
        pulumi.set(__self__, "external_key_id", external_key_id)
        pulumi.set(__self__, "external_key_version_id", external_key_version_id)

    @_builtins.property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> _builtins.str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> _builtins.str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeysKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 curve_id: _builtins.str,
                 length: _builtins.int):
        """
        :param _builtins.str algorithm: The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        :param _builtins.str curve_id: The curve ID of the keys. (This pertains only to ECDSA keys.)
        :param _builtins.int length: The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "curve_id", curve_id)
        pulumi.set(__self__, "length", length)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> _builtins.str:
        """
        The curve ID of the keys. (This pertains only to ECDSA keys.)
        """
        return pulumi.get(self, "curve_id")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeysKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a key operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: _builtins.str,
                 content_md5: _builtins.str,
                 restore_key_from_file_details: _builtins.str):
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_key_from_file_details", restore_key_from_file_details)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> _builtins.str:
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeysKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 destination: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 uri: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetReplicationStatusReplicaDetailResult(dict):
    def __init__(__self__, *,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str region: The replica region
        :param _builtins.str status: Replication status associated with a replicationId
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The replica region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Replication status associated with a replicationId
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: _builtins.str,
                 oauth_metadatas: Sequence['outputs.GetVaultExternalKeyManagerMetadataOauthMetadataResult'],
                 private_endpoint_id: _builtins.str):
        """
        :param _builtins.str external_vault_endpoint_url: URL of the vault on external key manager.
        :param _builtins.str private_endpoint_id: OCID of the private endpoint.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadatas", oauth_metadatas)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> _builtins.str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadatas")
    def oauth_metadatas(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataOauthMetadataResult']:
        return pulumi.get(self, "oauth_metadatas")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataOauthMetadataResult(dict):
    def __init__(__self__, *,
                 client_app_id: _builtins.str,
                 client_app_secret: _builtins.str,
                 idcs_account_name_url: _builtins.str):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "client_app_secret", client_app_secret)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> _builtins.str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> _builtins.str:
        return pulumi.get(self, "client_app_secret")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: _builtins.str,
                 oauth_metadata_summaries: Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
                 private_endpoint_id: _builtins.str,
                 vendor: _builtins.str):
        """
        :param _builtins.str external_vault_endpoint_url: URL of the vault on external key manager.
        :param Sequence['GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param _builtins.str private_endpoint_id: OCID of the private endpoint.
        :param _builtins.str vendor: Vendor of the external key manager.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadata_summaries", oauth_metadata_summaries)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> _builtins.str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult']:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> _builtins.str:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 client_app_id: _builtins.str,
                 idcs_account_name_url: _builtins.str):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> _builtins.str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a vault operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultReplicasFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultReplicasVaultReplicaResult(dict):
    def __init__(__self__, *,
                 crypto_endpoint: _builtins.str,
                 management_endpoint: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str crypto_endpoint: The vault replica's crypto endpoint
        :param _builtins.str management_endpoint: The vault replica's management endpoint
        :param _builtins.str region: Region to which vault is replicated to
        :param _builtins.str status: Status of the Vault
        """
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> _builtins.str:
        """
        The vault replica's crypto endpoint
        """
        return pulumi.get(self, "crypto_endpoint")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> _builtins.str:
        """
        The vault replica's management endpoint
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region to which vault is replicated to
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Vault
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: _builtins.str,
                 content_md5: _builtins.str,
                 restore_vault_from_file_details: _builtins.str):
        """
        :param _builtins.str content_length: content length of vault's backup binary file
        :param _builtins.str content_md5: content md5 hashed value of vault's backup file
        :param _builtins.str restore_vault_from_file_details: Vault backup file content
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        """
        content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> _builtins.str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 destination: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str bucket: Name of the bucket where vault was backed up
        :param _builtins.str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param _builtins.str namespace: Namespace of the bucket where vault was backed up
        :param _builtins.str object: Object containing the backup
        :param _builtins.str uri: Pre-authenticated-request-uri of the backup
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetVaultsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 crypto_endpoint: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 external_key_manager_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryResult'],
                 external_key_manager_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataResult'],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_primary: _builtins.bool,
                 is_vault_replicable: _builtins.bool,
                 management_endpoint: _builtins.str,
                 replica_details: Sequence['outputs.GetVaultsVaultReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetVaultsVaultRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult'],
                 restore_trigger: _builtins.bool,
                 restored_from_vault_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_of_deletion: _builtins.str,
                 vault_type: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param _builtins.str crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Sequence['GetVaultsVaultExternalKeyManagerMetadataSummaryArgs'] external_key_manager_metadata_summaries: Summary about metadata of external key manager to be returned to the customer as a response.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the vault.
        :param _builtins.bool is_primary: A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        :param _builtins.bool is_vault_replicable: A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        :param _builtins.str management_endpoint: The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        :param Sequence['GetVaultsVaultReplicaDetailArgs'] replica_details: Vault replica details
        :param _builtins.str restored_from_vault_id: The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        :param _builtins.str state: The vault's current lifecycle state.  Example: `DELETED`
        :param _builtins.str time_created: The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_of_deletion: An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str vault_type: The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_key_manager_metadata_summaries", external_key_manager_metadata_summaries)
        pulumi.set(__self__, "external_key_manager_metadatas", external_key_manager_metadatas)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "is_vault_replicable", is_vault_replicable)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "replica_details", replica_details)
        pulumi.set(__self__, "restore_from_files", restore_from_files)
        pulumi.set(__self__, "restore_from_object_stores", restore_from_object_stores)
        pulumi.set(__self__, "restore_trigger", restore_trigger)
        pulumi.set(__self__, "restored_from_vault_id", restored_from_vault_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        pulumi.set(__self__, "vault_type", vault_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> _builtins.str:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadataSummaries")
    def external_key_manager_metadata_summaries(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryResult']:
        """
        Summary about metadata of external key manager to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_manager_metadata_summaries")

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadatas")
    def external_key_manager_metadatas(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataResult']:
        return pulumi.get(self, "external_key_manager_metadatas")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> _builtins.bool:
        """
        A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="isVaultReplicable")
    def is_vault_replicable(self) -> _builtins.bool:
        """
        A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        """
        return pulumi.get(self, "is_vault_replicable")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> _builtins.str:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetVaultsVaultReplicaDetailResult']:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetVaultsVaultRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> _builtins.bool:
        return pulumi.get(self, "restore_trigger")

    @_builtins.property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> _builtins.str:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> _builtins.str:
        """
        An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> _builtins.str:
        """
        The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: _builtins.str,
                 oauth_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult'],
                 private_endpoint_id: _builtins.str):
        """
        :param _builtins.str external_vault_endpoint_url: URL of the vault on external key manager.
        :param _builtins.str private_endpoint_id: OCID of the private endpoint.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadatas", oauth_metadatas)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> _builtins.str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadatas")
    def oauth_metadatas(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult']:
        return pulumi.get(self, "oauth_metadatas")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult(dict):
    def __init__(__self__, *,
                 client_app_id: _builtins.str,
                 client_app_secret: _builtins.str,
                 idcs_account_name_url: _builtins.str):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "client_app_secret", client_app_secret)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> _builtins.str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> _builtins.str:
        return pulumi.get(self, "client_app_secret")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: _builtins.str,
                 oauth_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
                 private_endpoint_id: _builtins.str,
                 vendor: _builtins.str):
        """
        :param _builtins.str external_vault_endpoint_url: URL of the vault on external key manager.
        :param Sequence['GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param _builtins.str private_endpoint_id: OCID of the private endpoint.
        :param _builtins.str vendor: Vendor of the external key manager.
        """
        pulumi.set(__self__, "external_vault_endpoint_url", external_vault_endpoint_url)
        pulumi.set(__self__, "oauth_metadata_summaries", oauth_metadata_summaries)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> _builtins.str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult']:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> _builtins.str:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 client_app_id: _builtins.str,
                 idcs_account_name_url: _builtins.str):
        """
        :param _builtins.str client_app_id: ID of the client app created in IDP.
        :param _builtins.str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "idcs_account_name_url", idcs_account_name_url)

    @_builtins.property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> _builtins.str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @_builtins.property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> _builtins.str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultsVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: _builtins.str):
        """
        :param _builtins.str replication_id: ReplicationId associated with a vault operation
        """
        pulumi.set(__self__, "replication_id", replication_id)

    @_builtins.property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> _builtins.str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultsVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: _builtins.str,
                 content_md5: _builtins.str,
                 restore_vault_from_file_details: _builtins.str):
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "restore_vault_from_file_details", restore_vault_from_file_details)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> _builtins.str:
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultsVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 destination: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 uri: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        return pulumi.get(self, "uri")


