# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VaultArgs', 'Vault']

@pulumi.input_type
class VaultArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 vault_type: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_key_manager_metadata: Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 restore_from_file: Optional[pulumi.Input['VaultRestoreFromFileArgs']] = None,
                 restore_from_object_store: Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Vault resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create this vault.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] vault_type: The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input['VaultExternalKeyManagerMetadataArgs'] external_key_manager_metadata: Metadata required for accessing External Key manager
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['VaultRestoreFromFileArgs'] restore_from_file: (Updatable) Details where vault was backed up.
        :param pulumi.Input['VaultRestoreFromObjectStoreArgs'] restore_from_object_store: (Updatable) Details where vault was backed up
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "vault_type", vault_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if external_key_manager_metadata is not None:
            pulumi.set(__self__, "external_key_manager_metadata", external_key_manager_metadata)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if restore_from_file is not None:
            pulumi.set(__self__, "restore_from_file", restore_from_file)
        if restore_from_object_store is not None:
            pulumi.set(__self__, "restore_from_object_store", restore_from_object_store)
        if restore_trigger is not None:
            pulumi.set(__self__, "restore_trigger", restore_trigger)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create this vault.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")

    @vault_type.setter
    def vault_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadata")
    def external_key_manager_metadata(self) -> Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']]:
        """
        Metadata required for accessing External Key manager
        """
        return pulumi.get(self, "external_key_manager_metadata")

    @external_key_manager_metadata.setter
    def external_key_manager_metadata(self, value: Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']]):
        pulumi.set(self, "external_key_manager_metadata", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> Optional[pulumi.Input['VaultRestoreFromFileArgs']]:
        """
        (Updatable) Details where vault was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @restore_from_file.setter
    def restore_from_file(self, value: Optional[pulumi.Input['VaultRestoreFromFileArgs']]):
        pulumi.set(self, "restore_from_file", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']]:
        """
        (Updatable) Details where vault was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @restore_from_object_store.setter
    def restore_from_object_store(self, value: Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']]):
        pulumi.set(self, "restore_from_object_store", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "restore_trigger")

    @restore_trigger.setter
    def restore_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_trigger", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)


@pulumi.input_type
class _VaultState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_manager_metadata: Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']] = None,
                 external_key_manager_metadata_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vault_replicable: Optional[pulumi.Input[_builtins.bool]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_details: Optional[pulumi.Input[Sequence[pulumi.Input['VaultReplicaDetailArgs']]]] = None,
                 restore_from_file: Optional[pulumi.Input['VaultRestoreFromFileArgs']] = None,
                 restore_from_object_store: Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 restored_from_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vault resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create this vault.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input['VaultExternalKeyManagerMetadataArgs'] external_key_manager_metadata: Metadata required for accessing External Key manager
        :param pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryArgs']]] external_key_manager_metadata_summaries: Summary about metadata of external key manager to be returned to the customer as a response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        :param pulumi.Input[_builtins.bool] is_vault_replicable: A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        :param pulumi.Input[Sequence[pulumi.Input['VaultReplicaDetailArgs']]] replica_details: Vault replica details
        :param pulumi.Input['VaultRestoreFromFileArgs'] restore_from_file: (Updatable) Details where vault was backed up.
        :param pulumi.Input['VaultRestoreFromObjectStoreArgs'] restore_from_object_store: (Updatable) Details where vault was backed up
        :param pulumi.Input[_builtins.str] restored_from_vault_id: The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        :param pulumi.Input[_builtins.str] state: The vault's current lifecycle state.  Example: `DELETED`
        :param pulumi.Input[_builtins.str] time_created: The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_type: The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if crypto_endpoint is not None:
            pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_key_manager_metadata is not None:
            pulumi.set(__self__, "external_key_manager_metadata", external_key_manager_metadata)
        if external_key_manager_metadata_summaries is not None:
            pulumi.set(__self__, "external_key_manager_metadata_summaries", external_key_manager_metadata_summaries)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_primary is not None:
            pulumi.set(__self__, "is_primary", is_primary)
        if is_vault_replicable is not None:
            pulumi.set(__self__, "is_vault_replicable", is_vault_replicable)
        if management_endpoint is not None:
            pulumi.set(__self__, "management_endpoint", management_endpoint)
        if replica_details is not None:
            pulumi.set(__self__, "replica_details", replica_details)
        if restore_from_file is not None:
            pulumi.set(__self__, "restore_from_file", restore_from_file)
        if restore_from_object_store is not None:
            pulumi.set(__self__, "restore_from_object_store", restore_from_object_store)
        if restore_trigger is not None:
            pulumi.set(__self__, "restore_trigger", restore_trigger)
        if restored_from_vault_id is not None:
            pulumi.set(__self__, "restored_from_vault_id", restored_from_vault_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_type is not None:
            pulumi.set(__self__, "vault_type", vault_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where you want to create this vault.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @crypto_endpoint.setter
    def crypto_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadata")
    def external_key_manager_metadata(self) -> Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']]:
        """
        Metadata required for accessing External Key manager
        """
        return pulumi.get(self, "external_key_manager_metadata")

    @external_key_manager_metadata.setter
    def external_key_manager_metadata(self, value: Optional[pulumi.Input['VaultExternalKeyManagerMetadataArgs']]):
        pulumi.set(self, "external_key_manager_metadata", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadataSummaries")
    def external_key_manager_metadata_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryArgs']]]]:
        """
        Summary about metadata of external key manager to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_manager_metadata_summaries")

    @external_key_manager_metadata_summaries.setter
    def external_key_manager_metadata_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultExternalKeyManagerMetadataSummaryArgs']]]]):
        pulumi.set(self, "external_key_manager_metadata_summaries", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_primary", value)

    @_builtins.property
    @pulumi.getter(name="isVaultReplicable")
    def is_vault_replicable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        """
        return pulumi.get(self, "is_vault_replicable")

    @is_vault_replicable.setter
    def is_vault_replicable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vault_replicable", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultReplicaDetailArgs']]]]:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @replica_details.setter
    def replica_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultReplicaDetailArgs']]]]):
        pulumi.set(self, "replica_details", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> Optional[pulumi.Input['VaultRestoreFromFileArgs']]:
        """
        (Updatable) Details where vault was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @restore_from_file.setter
    def restore_from_file(self, value: Optional[pulumi.Input['VaultRestoreFromFileArgs']]):
        pulumi.set(self, "restore_from_file", value)

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']]:
        """
        (Updatable) Details where vault was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @restore_from_object_store.setter
    def restore_from_object_store(self, value: Optional[pulumi.Input['VaultRestoreFromObjectStoreArgs']]):
        pulumi.set(self, "restore_from_object_store", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "restore_trigger")

    @restore_trigger.setter
    def restore_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restore_trigger", value)

    @_builtins.property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @restored_from_vault_id.setter
    def restored_from_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restored_from_vault_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")

    @vault_type.setter
    def vault_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_type", value)


@pulumi.type_token("oci:Kms/vault:Vault")
class Vault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_manager_metadata: Optional[pulumi.Input[Union['VaultExternalKeyManagerMetadataArgs', 'VaultExternalKeyManagerMetadataArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 restore_from_file: Optional[pulumi.Input[Union['VaultRestoreFromFileArgs', 'VaultRestoreFromFileArgsDict']]] = None,
                 restore_from_object_store: Optional[pulumi.Input[Union['VaultRestoreFromObjectStoreArgs', 'VaultRestoreFromObjectStoreArgsDict']]] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Vault resource in Oracle Cloud Infrastructure Kms service.

        Creates a new vault. The type of vault you create determines key placement, pricing, and
        available options. Options include storage isolation, a dedicated service endpoint instead
        of a shared service endpoint for API calls, and either a dedicated hardware security module
        (HSM) or a multitenant HSM.

        As a provisioning operation, this call is subject to a Key Management limit that applies to
        the total number of requests across all provisioning write operations. Key Management might
        throttle this call to reject an otherwise valid request when the total rate of provisioning
        write operations exceeds 10 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vault = oci.kms.Vault("test_vault",
            compartment_id=compartment_id,
            display_name=vault_display_name,
            vault_type=vault_vault_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            external_key_manager_metadata={
                "external_vault_endpoint_url": vault_external_key_manager_metadata_external_vault_endpoint_url,
                "oauth_metadata": {
                    "client_app_id": test_client_app["id"],
                    "client_app_secret": vault_external_key_manager_metadata_oauth_metadata_client_app_secret,
                    "idcs_account_name_url": vault_external_key_manager_metadata_oauth_metadata_idcs_account_name_url,
                },
                "private_endpoint_id": test_private_endpoint["id"],
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Vaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/vault:Vault test_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create this vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Union['VaultExternalKeyManagerMetadataArgs', 'VaultExternalKeyManagerMetadataArgsDict']] external_key_manager_metadata: Metadata required for accessing External Key manager
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['VaultRestoreFromFileArgs', 'VaultRestoreFromFileArgsDict']] restore_from_file: (Updatable) Details where vault was backed up.
        :param pulumi.Input[Union['VaultRestoreFromObjectStoreArgs', 'VaultRestoreFromObjectStoreArgsDict']] restore_from_object_store: (Updatable) Details where vault was backed up
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_type: The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vault resource in Oracle Cloud Infrastructure Kms service.

        Creates a new vault. The type of vault you create determines key placement, pricing, and
        available options. Options include storage isolation, a dedicated service endpoint instead
        of a shared service endpoint for API calls, and either a dedicated hardware security module
        (HSM) or a multitenant HSM.

        As a provisioning operation, this call is subject to a Key Management limit that applies to
        the total number of requests across all provisioning write operations. Key Management might
        throttle this call to reject an otherwise valid request when the total rate of provisioning
        write operations exceeds 10 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vault = oci.kms.Vault("test_vault",
            compartment_id=compartment_id,
            display_name=vault_display_name,
            vault_type=vault_vault_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            external_key_manager_metadata={
                "external_vault_endpoint_url": vault_external_key_manager_metadata_external_vault_endpoint_url,
                "oauth_metadata": {
                    "client_app_id": test_client_app["id"],
                    "client_app_secret": vault_external_key_manager_metadata_oauth_metadata_client_app_secret,
                    "idcs_account_name_url": vault_external_key_manager_metadata_oauth_metadata_idcs_account_name_url,
                },
                "private_endpoint_id": test_private_endpoint["id"],
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Vaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/vault:Vault test_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param VaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_manager_metadata: Optional[pulumi.Input[Union['VaultExternalKeyManagerMetadataArgs', 'VaultExternalKeyManagerMetadataArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 restore_from_file: Optional[pulumi.Input[Union['VaultRestoreFromFileArgs', 'VaultRestoreFromFileArgsDict']]] = None,
                 restore_from_object_store: Optional[pulumi.Input[Union['VaultRestoreFromObjectStoreArgs', 'VaultRestoreFromObjectStoreArgsDict']]] = None,
                 restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultArgs.__new__(VaultArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_key_manager_metadata"] = external_key_manager_metadata
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["restore_from_file"] = restore_from_file
            __props__.__dict__["restore_from_object_store"] = restore_from_object_store
            __props__.__dict__["restore_trigger"] = restore_trigger
            __props__.__dict__["time_of_deletion"] = time_of_deletion
            if vault_type is None and not opts.urn:
                raise TypeError("Missing required property 'vault_type'")
            __props__.__dict__["vault_type"] = vault_type
            __props__.__dict__["crypto_endpoint"] = None
            __props__.__dict__["external_key_manager_metadata_summaries"] = None
            __props__.__dict__["is_primary"] = None
            __props__.__dict__["is_vault_replicable"] = None
            __props__.__dict__["management_endpoint"] = None
            __props__.__dict__["replica_details"] = None
            __props__.__dict__["restored_from_vault_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Vault, __self__).__init__(
            'oci:Kms/vault:Vault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_key_manager_metadata: Optional[pulumi.Input[Union['VaultExternalKeyManagerMetadataArgs', 'VaultExternalKeyManagerMetadataArgsDict']]] = None,
            external_key_manager_metadata_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultExternalKeyManagerMetadataSummaryArgs', 'VaultExternalKeyManagerMetadataSummaryArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
            is_vault_replicable: Optional[pulumi.Input[_builtins.bool]] = None,
            management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            replica_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultReplicaDetailArgs', 'VaultReplicaDetailArgsDict']]]]] = None,
            restore_from_file: Optional[pulumi.Input[Union['VaultRestoreFromFileArgs', 'VaultRestoreFromFileArgsDict']]] = None,
            restore_from_object_store: Optional[pulumi.Input[Union['VaultRestoreFromObjectStoreArgs', 'VaultRestoreFromObjectStoreArgsDict']]] = None,
            restore_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            restored_from_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            vault_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Vault':
        """
        Get an existing Vault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create this vault.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Union['VaultExternalKeyManagerMetadataArgs', 'VaultExternalKeyManagerMetadataArgsDict']] external_key_manager_metadata: Metadata required for accessing External Key manager
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultExternalKeyManagerMetadataSummaryArgs', 'VaultExternalKeyManagerMetadataSummaryArgsDict']]]] external_key_manager_metadata_summaries: Summary about metadata of external key manager to be returned to the customer as a response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        :param pulumi.Input[_builtins.bool] is_vault_replicable: A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultReplicaDetailArgs', 'VaultReplicaDetailArgsDict']]]] replica_details: Vault replica details
        :param pulumi.Input[Union['VaultRestoreFromFileArgs', 'VaultRestoreFromFileArgsDict']] restore_from_file: (Updatable) Details where vault was backed up.
        :param pulumi.Input[Union['VaultRestoreFromObjectStoreArgs', 'VaultRestoreFromObjectStoreArgsDict']] restore_from_object_store: (Updatable) Details where vault was backed up
        :param pulumi.Input[_builtins.str] restored_from_vault_id: The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        :param pulumi.Input[_builtins.str] state: The vault's current lifecycle state.  Example: `DELETED`
        :param pulumi.Input[_builtins.str] time_created: The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_type: The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultState.__new__(_VaultState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["crypto_endpoint"] = crypto_endpoint
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_key_manager_metadata"] = external_key_manager_metadata
        __props__.__dict__["external_key_manager_metadata_summaries"] = external_key_manager_metadata_summaries
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_primary"] = is_primary
        __props__.__dict__["is_vault_replicable"] = is_vault_replicable
        __props__.__dict__["management_endpoint"] = management_endpoint
        __props__.__dict__["replica_details"] = replica_details
        __props__.__dict__["restore_from_file"] = restore_from_file
        __props__.__dict__["restore_from_object_store"] = restore_from_object_store
        __props__.__dict__["restore_trigger"] = restore_trigger
        __props__.__dict__["restored_from_vault_id"] = restored_from_vault_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["vault_type"] = vault_type
        return Vault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create this vault.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadata")
    def external_key_manager_metadata(self) -> pulumi.Output['outputs.VaultExternalKeyManagerMetadata']:
        """
        Metadata required for accessing External Key manager
        """
        return pulumi.get(self, "external_key_manager_metadata")

    @_builtins.property
    @pulumi.getter(name="externalKeyManagerMetadataSummaries")
    def external_key_manager_metadata_summaries(self) -> pulumi.Output[Sequence['outputs.VaultExternalKeyManagerMetadataSummary']]:
        """
        Summary about metadata of external key manager to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_manager_metadata_summaries")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Output[_builtins.bool]:
        """
        A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="isVaultReplicable")
    def is_vault_replicable(self) -> pulumi.Output[_builtins.bool]:
        """
        A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        """
        return pulumi.get(self, "is_vault_replicable")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> pulumi.Output[Sequence['outputs.VaultReplicaDetail']]:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoreFromFile")
    def restore_from_file(self) -> pulumi.Output[Optional['outputs.VaultRestoreFromFile']]:
        """
        (Updatable) Details where vault was backed up.
        """
        return pulumi.get(self, "restore_from_file")

    @_builtins.property
    @pulumi.getter(name="restoreFromObjectStore")
    def restore_from_object_store(self) -> pulumi.Output[Optional['outputs.VaultRestoreFromObjectStore']]:
        """
        (Updatable) Details where vault was backed up
        """
        return pulumi.get(self, "restore_from_object_store")

    @_builtins.property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "restore_trigger")

    @_builtins.property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional property for the deletion time of the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of vault to create. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")

