# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'QuotaLockArgs',
    'QuotaLockArgsDict',
    'GetLimitDefinitionsFilterArgs',
    'GetLimitDefinitionsFilterArgsDict',
    'GetLimitValuesFilterArgs',
    'GetLimitValuesFilterArgsDict',
    'GetQuotasFilterArgs',
    'GetQuotasFilterArgsDict',
    'GetServicesFilterArgs',
    'GetServicesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class QuotaLockArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Lock type.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
elif False:
    QuotaLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaLockArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Lock type.
        :param pulumi.Input[_builtins.str] message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param pulumi.Input[_builtins.str] time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class GetLimitDefinitionsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Optional field, filter for a specific resource limit.
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetLimitDefinitionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLimitDefinitionsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional field, filter for a specific resource limit.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, filter for a specific resource limit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetLimitValuesFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Optional field, can be used to see a specific resource limit value.
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetLimitValuesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLimitValuesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional field, can be used to see a specific resource limit value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, can be used to see a specific resource limit value.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetQuotasFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        name
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetQuotasFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetQuotasFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetServicesFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The service name. Use this when calling other APIs.
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetServicesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServicesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The service name. Use this when calling other APIs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The service name. Use this when calling other APIs.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


