# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRuleSetResult',
    'AwaitableGetRuleSetResult',
    'get_rule_set',
    'get_rule_set_output',
]

@pulumi.output_type
class GetRuleSetResult:
    """
    A collection of values returned by getRuleSet.
    """
    def __init__(__self__, id=None, items=None, load_balancer_id=None, name=None, state=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRuleSetItemResult']:
        """
        An array of rules that compose the rule set.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


class AwaitableGetRuleSetResult(GetRuleSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleSetResult(
            id=self.id,
            items=self.items,
            load_balancer_id=self.load_balancer_id,
            name=self.name,
            state=self.state)


def get_rule_set(load_balancer_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleSetResult:
    """
    This data source provides details about a specific Rule Set resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the specified set of rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_rule_set = oci.LoadBalancer.get_rule_set(load_balancer_id=test_load_balancer["id"],
        name=rule_set_name)
    ```


    :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
    :param _builtins.str name: The name of the rule set to retrieve.  Example: `example_rule_set`
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getRuleSet:getRuleSet', __args__, opts=opts, typ=GetRuleSetResult).value

    return AwaitableGetRuleSetResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_rule_set_output(load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                        name: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleSetResult]:
    """
    This data source provides details about a specific Rule Set resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the specified set of rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_rule_set = oci.LoadBalancer.get_rule_set(load_balancer_id=test_load_balancer["id"],
        name=rule_set_name)
    ```


    :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
    :param _builtins.str name: The name of the rule set to retrieve.  Example: `example_rule_set`
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LoadBalancer/getRuleSet:getRuleSet', __args__, opts=opts, typ=GetRuleSetResult)
    return __ret__.apply(lambda __response__: GetRuleSetResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
