# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsEntityTypeResult',
    'AwaitableGetLogAnalyticsEntityTypeResult',
    'get_log_analytics_entity_type',
    'get_log_analytics_entity_type_output',
]

@pulumi.output_type
class GetLogAnalyticsEntityTypeResult:
    """
    A collection of values returned by getLogAnalyticsEntityType.
    """
    def __init__(__self__, category=None, cloud_type=None, entity_type_name=None, id=None, internal_name=None, management_agent_eligibility_status=None, name=None, namespace=None, properties=None, state=None, time_created=None, time_updated=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if cloud_type and not isinstance(cloud_type, str):
            raise TypeError("Expected argument 'cloud_type' to be a str")
        pulumi.set(__self__, "cloud_type", cloud_type)
        if entity_type_name and not isinstance(entity_type_name, str):
            raise TypeError("Expected argument 'entity_type_name' to be a str")
        pulumi.set(__self__, "entity_type_name", entity_type_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_name and not isinstance(internal_name, str):
            raise TypeError("Expected argument 'internal_name' to be a str")
        pulumi.set(__self__, "internal_name", internal_name)
        if management_agent_eligibility_status and not isinstance(management_agent_eligibility_status, str):
            raise TypeError("Expected argument 'management_agent_eligibility_status' to be a str")
        pulumi.set(__self__, "management_agent_eligibility_status", management_agent_eligibility_status)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        Log analytics entity type category. Category will be used for grouping and filtering.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> _builtins.str:
        """
        Log analytics entity type group. That can be CLOUD (OCI) or NON_CLOUD otherwise.
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> _builtins.str:
        return pulumi.get(self, "entity_type_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalName")
    def internal_name(self) -> _builtins.str:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "internal_name")

    @_builtins.property
    @pulumi.getter(name="managementAgentEligibilityStatus")
    def management_agent_eligibility_status(self) -> _builtins.str:
        return pulumi.get(self, "management_agent_eligibility_status")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Log analytics entity type property name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetLogAnalyticsEntityTypePropertyResult']:
        """
        The parameters used in file patterns specified in log sources for this log analytics entity type.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the log analytics entity type.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time the log analytics entity type was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time the log analytics entity type was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetLogAnalyticsEntityTypeResult(GetLogAnalyticsEntityTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntityTypeResult(
            category=self.category,
            cloud_type=self.cloud_type,
            entity_type_name=self.entity_type_name,
            id=self.id,
            internal_name=self.internal_name,
            management_agent_eligibility_status=self.management_agent_eligibility_status,
            name=self.name,
            namespace=self.namespace,
            properties=self.properties,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_log_analytics_entity_type(entity_type_name: Optional[_builtins.str] = None,
                                  namespace: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntityTypeResult:
    """
    This data source provides details about a specific Log Analytics Entity Type resource in Oracle Cloud Infrastructure Log Analytics service.

    Retrieve the log analytics entity type with the given name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_type = oci.LogAnalytics.get_log_analytics_entity_type(entity_type_name=log_analytics_entity_type_name,
        namespace=log_analytics_entity_type_namespace)
    ```


    :param _builtins.str entity_type_name: Log analytics entity type name.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['entityTypeName'] = entity_type_name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntityType:getLogAnalyticsEntityType', __args__, opts=opts, typ=GetLogAnalyticsEntityTypeResult).value

    return AwaitableGetLogAnalyticsEntityTypeResult(
        category=pulumi.get(__ret__, 'category'),
        cloud_type=pulumi.get(__ret__, 'cloud_type'),
        entity_type_name=pulumi.get(__ret__, 'entity_type_name'),
        id=pulumi.get(__ret__, 'id'),
        internal_name=pulumi.get(__ret__, 'internal_name'),
        management_agent_eligibility_status=pulumi.get(__ret__, 'management_agent_eligibility_status'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_log_analytics_entity_type_output(entity_type_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsEntityTypeResult]:
    """
    This data source provides details about a specific Log Analytics Entity Type resource in Oracle Cloud Infrastructure Log Analytics service.

    Retrieve the log analytics entity type with the given name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_type = oci.LogAnalytics.get_log_analytics_entity_type(entity_type_name=log_analytics_entity_type_name,
        namespace=log_analytics_entity_type_namespace)
    ```


    :param _builtins.str entity_type_name: Log analytics entity type name.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['entityTypeName'] = entity_type_name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsEntityType:getLogAnalyticsEntityType', __args__, opts=opts, typ=GetLogAnalyticsEntityTypeResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsEntityTypeResult(
        category=pulumi.get(__response__, 'category'),
        cloud_type=pulumi.get(__response__, 'cloud_type'),
        entity_type_name=pulumi.get(__response__, 'entity_type_name'),
        id=pulumi.get(__response__, 'id'),
        internal_name=pulumi.get(__response__, 'internal_name'),
        management_agent_eligibility_status=pulumi.get(__response__, 'management_agent_eligibility_status'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        properties=pulumi.get(__response__, 'properties'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
