# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogAnalyticsLogGroupsResult',
    'AwaitableGetLogAnalyticsLogGroupsResult',
    'get_log_analytics_log_groups',
    'get_log_analytics_log_groups_output',
]

@pulumi.output_type
class GetLogAnalyticsLogGroupsResult:
    """
    A collection of values returned by getLogAnalyticsLogGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, log_analytics_log_group_summary_collections=None, namespace=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_log_group_summary_collections and not isinstance(log_analytics_log_group_summary_collections, list):
            raise TypeError("Expected argument 'log_analytics_log_group_summary_collections' to be a list")
        pulumi.set(__self__, "log_analytics_log_group_summary_collections", log_analytics_log_group_summary_collections)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name that is changeable and that does not have to be unique. Format: a leading alphanumeric, followed by zero or more alphanumerics, underscores, spaces, backslashes, or hyphens in any order). No trailing spaces allowed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogAnalyticsLogGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsLogGroupSummaryCollections")
    def log_analytics_log_group_summary_collections(self) -> Sequence['outputs.GetLogAnalyticsLogGroupsLogAnalyticsLogGroupSummaryCollectionResult']:
        """
        The list of log_analytics_log_group_summary_collection.
        """
        return pulumi.get(self, "log_analytics_log_group_summary_collections")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")


class AwaitableGetLogAnalyticsLogGroupsResult(GetLogAnalyticsLogGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsLogGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            log_analytics_log_group_summary_collections=self.log_analytics_log_group_summary_collections,
            namespace=self.namespace)


def get_log_analytics_log_groups(compartment_id: Optional[_builtins.str] = None,
                                 display_name: Optional[_builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetLogAnalyticsLogGroupsFilterArgs', 'GetLogAnalyticsLogGroupsFilterArgsDict']]] = None,
                                 namespace: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsLogGroupsResult:
    """
    This data source provides the list of Log Analytics Log Groups in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of log groups in a compartment. You may limit the number of log groups, provide sorting options, and filter the results by specifying a display name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_groups = oci.LogAnalytics.get_log_analytics_log_groups(compartment_id=compartment_id,
        namespace=log_analytics_log_group_namespace,
        display_name=log_analytics_log_group_display_name)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only log analytics log groups whose displayName matches the entire display name given. The match is case-insensitive.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsLogGroups:getLogAnalyticsLogGroups', __args__, opts=opts, typ=GetLogAnalyticsLogGroupsResult).value

    return AwaitableGetLogAnalyticsLogGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_log_group_summary_collections=pulumi.get(__ret__, 'log_analytics_log_group_summary_collections'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_log_analytics_log_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogAnalyticsLogGroupsFilterArgs', 'GetLogAnalyticsLogGroupsFilterArgsDict']]]]] = None,
                                        namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsLogGroupsResult]:
    """
    This data source provides the list of Log Analytics Log Groups in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of log groups in a compartment. You may limit the number of log groups, provide sorting options, and filter the results by specifying a display name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_groups = oci.LogAnalytics.get_log_analytics_log_groups(compartment_id=compartment_id,
        namespace=log_analytics_log_group_namespace,
        display_name=log_analytics_log_group_display_name)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only log analytics log groups whose displayName matches the entire display name given. The match is case-insensitive.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsLogGroups:getLogAnalyticsLogGroups', __args__, opts=opts, typ=GetLogAnalyticsLogGroupsResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsLogGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        log_analytics_log_group_summary_collections=pulumi.get(__response__, 'log_analytics_log_group_summary_collections'),
        namespace=pulumi.get(__response__, 'namespace')))
