# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespaceTemplateResult',
    'AwaitableGetNamespaceTemplateResult',
    'get_namespace_template',
    'get_namespace_template_output',
]

@pulumi.output_type
class GetNamespaceTemplateResult:
    """
    A collection of values returned by getNamespaceTemplate.
    """
    def __init__(__self__, compartment_id=None, content=None, content_format=None, defined_tags=None, description=None, facets=None, freeform_tags=None, id=None, is_system=None, name=None, namespace=None, parameters=None, parameters_format=None, parameters_metadata=None, state=None, template_id=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if content_format and not isinstance(content_format, str):
            raise TypeError("Expected argument 'content_format' to be a str")
        pulumi.set(__self__, "content_format", content_format)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if facets and not isinstance(facets, list):
            raise TypeError("Expected argument 'facets' to be a list")
        pulumi.set(__self__, "facets", facets)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_system and not isinstance(is_system, bool):
            raise TypeError("Expected argument 'is_system' to be a bool")
        pulumi.set(__self__, "is_system", is_system)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if parameters and not isinstance(parameters, str):
            raise TypeError("Expected argument 'parameters' to be a str")
        pulumi.set(__self__, "parameters", parameters)
        if parameters_format and not isinstance(parameters_format, str):
            raise TypeError("Expected argument 'parameters_format' to be a str")
        pulumi.set(__self__, "parameters_format", parameters_format)
        if parameters_metadata and not isinstance(parameters_metadata, str):
            raise TypeError("Expected argument 'parameters_metadata' to be a str")
        pulumi.set(__self__, "parameters_metadata", parameters_metadata)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if template_id and not isinstance(template_id, str):
            raise TypeError("Expected argument 'template_id' to be a str")
        pulumi.set(__self__, "template_id", template_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Base64 encoded template content.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> _builtins.str:
        """
        Content format. For example - XML.
        """
        return pulumi.get(self, "content_format")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def facets(self) -> Sequence['outputs.GetNamespaceTemplateFacetResult']:
        """
        Facets of the template
        """
        return pulumi.get(self, "facets")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSystem")
    def is_system(self) -> _builtins.bool:
        """
        The system flag.  A value of false denotes a custom, or user defined object.  A value of true denotes a built in object.
        """
        return pulumi.get(self, "is_system")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The template name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> _builtins.str:
        """
        Base64 encoded template parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="parametersFormat")
    def parameters_format(self) -> _builtins.str:
        """
        Parameters format.  For example - NAME_VALUE_PAIR.
        """
        return pulumi.get(self, "parameters_format")

    @_builtins.property
    @pulumi.getter(name="parametersMetadata")
    def parameters_metadata(self) -> _builtins.str:
        """
        Base64 encoded parameters metadata definition.
        """
        return pulumi.get(self, "parameters_metadata")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the template.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The template type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamespaceTemplateResult(GetNamespaceTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceTemplateResult(
            compartment_id=self.compartment_id,
            content=self.content,
            content_format=self.content_format,
            defined_tags=self.defined_tags,
            description=self.description,
            facets=self.facets,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_system=self.is_system,
            name=self.name,
            namespace=self.namespace,
            parameters=self.parameters,
            parameters_format=self.parameters_format,
            parameters_metadata=self.parameters_metadata,
            state=self.state,
            template_id=self.template_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_namespace_template(namespace: Optional[_builtins.str] = None,
                           template_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceTemplateResult:
    """
    This data source provides details about a specific Namespace Template resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the template with the specified ocid.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_template = oci.LogAnalytics.get_namespace_template(namespace=namespace_template_namespace,
        template_id=test_template["id"])
    ```


    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str template_id: Unique ocid of the template.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['templateId'] = template_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceTemplate:getNamespaceTemplate', __args__, opts=opts, typ=GetNamespaceTemplateResult).value

    return AwaitableGetNamespaceTemplateResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        content=pulumi.get(__ret__, 'content'),
        content_format=pulumi.get(__ret__, 'content_format'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        facets=pulumi.get(__ret__, 'facets'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_system=pulumi.get(__ret__, 'is_system'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        parameters=pulumi.get(__ret__, 'parameters'),
        parameters_format=pulumi.get(__ret__, 'parameters_format'),
        parameters_metadata=pulumi.get(__ret__, 'parameters_metadata'),
        state=pulumi.get(__ret__, 'state'),
        template_id=pulumi.get(__ret__, 'template_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_namespace_template_output(namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                  template_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceTemplateResult]:
    """
    This data source provides details about a specific Namespace Template resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the template with the specified ocid.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_template = oci.LogAnalytics.get_namespace_template(namespace=namespace_template_namespace,
        template_id=test_template["id"])
    ```


    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str template_id: Unique ocid of the template.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['templateId'] = template_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getNamespaceTemplate:getNamespaceTemplate', __args__, opts=opts, typ=GetNamespaceTemplateResult)
    return __ret__.apply(lambda __response__: GetNamespaceTemplateResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        content=pulumi.get(__response__, 'content'),
        content_format=pulumi.get(__response__, 'content_format'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        facets=pulumi.get(__response__, 'facets'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_system=pulumi.get(__response__, 'is_system'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        parameters=pulumi.get(__response__, 'parameters'),
        parameters_format=pulumi.get(__response__, 'parameters_format'),
        parameters_metadata=pulumi.get(__response__, 'parameters_metadata'),
        state=pulumi.get(__response__, 'state'),
        template_id=pulumi.get(__response__, 'template_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
