# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNamespaceTemplatesResult',
    'AwaitableGetNamespaceTemplatesResult',
    'get_namespace_templates',
    'get_namespace_templates_output',
]

@pulumi.output_type
class GetNamespaceTemplatesResult:
    """
    A collection of values returned by getNamespaceTemplates.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, log_analytics_template_collections=None, name=None, namespace=None, namespace_template_filter=None, state=None, template_display_text=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_template_collections and not isinstance(log_analytics_template_collections, list):
            raise TypeError("Expected argument 'log_analytics_template_collections' to be a list")
        pulumi.set(__self__, "log_analytics_template_collections", log_analytics_template_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if namespace_template_filter and not isinstance(namespace_template_filter, str):
            raise TypeError("Expected argument 'namespace_template_filter' to be a str")
        pulumi.set(__self__, "namespace_template_filter", namespace_template_filter)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if template_display_text and not isinstance(template_display_text, str):
            raise TypeError("Expected argument 'template_display_text' to be a str")
        pulumi.set(__self__, "template_display_text", template_display_text)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNamespaceTemplatesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsTemplateCollections")
    def log_analytics_template_collections(self) -> Sequence['outputs.GetNamespaceTemplatesLogAnalyticsTemplateCollectionResult']:
        """
        The list of log_analytics_template_collection.
        """
        return pulumi.get(self, "log_analytics_template_collections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The template name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="namespaceTemplateFilter")
    def namespace_template_filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_template_filter")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the template.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="templateDisplayText")
    def template_display_text(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "template_display_text")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The template type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamespaceTemplatesResult(GetNamespaceTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceTemplatesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            log_analytics_template_collections=self.log_analytics_template_collections,
            name=self.name,
            namespace=self.namespace,
            namespace_template_filter=self.namespace_template_filter,
            state=self.state,
            template_display_text=self.template_display_text,
            type=self.type)


def get_namespace_templates(compartment_id: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetNamespaceTemplatesFilterArgs', 'GetNamespaceTemplatesFilterArgsDict']]] = None,
                            name: Optional[_builtins.str] = None,
                            namespace: Optional[_builtins.str] = None,
                            namespace_template_filter: Optional[_builtins.str] = None,
                            state: Optional[_builtins.str] = None,
                            template_display_text: Optional[_builtins.str] = None,
                            type: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceTemplatesResult:
    """
    This data source provides the list of Namespace Templates in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of templates, containing detailed information about them. You may limit the number of results, provide sorting order, and filter by information such as template name, type, display name and description.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_templates = oci.LogAnalytics.get_namespace_templates(compartment_id=compartment_id,
        namespace=namespace_template_namespace,
        name=namespace_template_name,
        namespace_template_filter=namespace_template_namespace_template_filter,
        state=namespace_template_state,
        template_display_text=namespace_template_template_display_text,
        type=namespace_template_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str name: The template name used for filtering.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str namespace_template_filter: filter
    :param _builtins.str state: The template lifecycle state used for filtering. Currently supported values are ACTIVE and DELETED.
    :param _builtins.str template_display_text: The template display text used for filtering. Only templates with the specified name or description will be returned.
    :param _builtins.str type: The template type used for filtering. Only templates of the specified type will be returned.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['namespaceTemplateFilter'] = namespace_template_filter
    __args__['state'] = state
    __args__['templateDisplayText'] = template_display_text
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceTemplates:getNamespaceTemplates', __args__, opts=opts, typ=GetNamespaceTemplatesResult).value

    return AwaitableGetNamespaceTemplatesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_template_collections=pulumi.get(__ret__, 'log_analytics_template_collections'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        namespace_template_filter=pulumi.get(__ret__, 'namespace_template_filter'),
        state=pulumi.get(__ret__, 'state'),
        template_display_text=pulumi.get(__ret__, 'template_display_text'),
        type=pulumi.get(__ret__, 'type'))
def get_namespace_templates_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNamespaceTemplatesFilterArgs', 'GetNamespaceTemplatesFilterArgsDict']]]]] = None,
                                   name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                   namespace_template_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   template_display_text: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceTemplatesResult]:
    """
    This data source provides the list of Namespace Templates in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of templates, containing detailed information about them. You may limit the number of results, provide sorting order, and filter by information such as template name, type, display name and description.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_templates = oci.LogAnalytics.get_namespace_templates(compartment_id=compartment_id,
        namespace=namespace_template_namespace,
        name=namespace_template_name,
        namespace_template_filter=namespace_template_namespace_template_filter,
        state=namespace_template_state,
        template_display_text=namespace_template_template_display_text,
        type=namespace_template_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str name: The template name used for filtering.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str namespace_template_filter: filter
    :param _builtins.str state: The template lifecycle state used for filtering. Currently supported values are ACTIVE and DELETED.
    :param _builtins.str template_display_text: The template display text used for filtering. Only templates with the specified name or description will be returned.
    :param _builtins.str type: The template type used for filtering. Only templates of the specified type will be returned.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['namespaceTemplateFilter'] = namespace_template_filter
    __args__['state'] = state
    __args__['templateDisplayText'] = template_display_text
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getNamespaceTemplates:getNamespaceTemplates', __args__, opts=opts, typ=GetNamespaceTemplatesResult)
    return __ret__.apply(lambda __response__: GetNamespaceTemplatesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        log_analytics_template_collections=pulumi.get(__response__, 'log_analytics_template_collections'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        namespace_template_filter=pulumi.get(__response__, 'namespace_template_filter'),
        state=pulumi.get(__response__, 'state'),
        template_display_text=pulumi.get(__response__, 'template_display_text'),
        type=pulumi.get(__response__, 'type')))
