# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementAgentsResult',
    'AwaitableGetManagementAgentsResult',
    'get_management_agents',
    'get_management_agents_output',
]

@pulumi.output_type
class GetManagementAgentsResult:
    """
    A collection of values returned by getManagementAgents.
    """
    def __init__(__self__, access_level=None, availability_status=None, compartment_id=None, compartment_id_in_subtree=None, data_source_names=None, data_source_type=None, display_name=None, filters=None, gateway_ids=None, host_id=None, id=None, install_type=None, is_customer_deployed=None, management_agents=None, platform_types=None, plugin_names=None, state=None, versions=None, wait_for_host_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if data_source_names and not isinstance(data_source_names, list):
            raise TypeError("Expected argument 'data_source_names' to be a list")
        pulumi.set(__self__, "data_source_names", data_source_names)
        if data_source_type and not isinstance(data_source_type, str):
            raise TypeError("Expected argument 'data_source_type' to be a str")
        pulumi.set(__self__, "data_source_type", data_source_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway_ids and not isinstance(gateway_ids, list):
            raise TypeError("Expected argument 'gateway_ids' to be a list")
        pulumi.set(__self__, "gateway_ids", gateway_ids)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if install_type and not isinstance(install_type, str):
            raise TypeError("Expected argument 'install_type' to be a str")
        pulumi.set(__self__, "install_type", install_type)
        if is_customer_deployed and not isinstance(is_customer_deployed, bool):
            raise TypeError("Expected argument 'is_customer_deployed' to be a bool")
        pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        if management_agents and not isinstance(management_agents, list):
            raise TypeError("Expected argument 'management_agents' to be a list")
        pulumi.set(__self__, "management_agents", management_agents)
        if platform_types and not isinstance(platform_types, list):
            raise TypeError("Expected argument 'platform_types' to be a list")
        pulumi.set(__self__, "platform_types", platform_types)
        if plugin_names and not isinstance(plugin_names, list):
            raise TypeError("Expected argument 'plugin_names' to be a list")
        pulumi.set(__self__, "plugin_names", plugin_names)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)
        if wait_for_host_id and not isinstance(wait_for_host_id, int):
            raise TypeError("Expected argument 'wait_for_host_id' to be a int")
        pulumi.set(__self__, "wait_for_host_id", wait_for_host_id)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional[_builtins.str]:
        """
        The current availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="dataSourceNames")
    def data_source_names(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "data_source_names")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Management Agent Name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementAgentsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "gateway_ids")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[_builtins.str]:
        """
        Host resource ocid
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="installType")
    def install_type(self) -> Optional[_builtins.str]:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @_builtins.property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> Optional[_builtins.bool]:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @_builtins.property
    @pulumi.getter(name="managementAgents")
    def management_agents(self) -> Sequence['outputs.GetManagementAgentsManagementAgentResult']:
        """
        The list of management_agents.
        """
        return pulumi.get(self, "management_agents")

    @_builtins.property
    @pulumi.getter(name="platformTypes")
    def platform_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_types")

    @_builtins.property
    @pulumi.getter(name="pluginNames")
    def plugin_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_names")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Management Agent Version
        """
        return pulumi.get(self, "versions")

    @_builtins.property
    @pulumi.getter(name="waitForHostId")
    def wait_for_host_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "wait_for_host_id")


class AwaitableGetManagementAgentsResult(GetManagementAgentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentsResult(
            access_level=self.access_level,
            availability_status=self.availability_status,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            data_source_names=self.data_source_names,
            data_source_type=self.data_source_type,
            display_name=self.display_name,
            filters=self.filters,
            gateway_ids=self.gateway_ids,
            host_id=self.host_id,
            id=self.id,
            install_type=self.install_type,
            is_customer_deployed=self.is_customer_deployed,
            management_agents=self.management_agents,
            platform_types=self.platform_types,
            plugin_names=self.plugin_names,
            state=self.state,
            versions=self.versions,
            wait_for_host_id=self.wait_for_host_id)


def get_management_agents(access_level: Optional[_builtins.str] = None,
                          availability_status: Optional[_builtins.str] = None,
                          compartment_id: Optional[_builtins.str] = None,
                          compartment_id_in_subtree: Optional[_builtins.bool] = None,
                          data_source_names: Optional[Sequence[_builtins.str]] = None,
                          data_source_type: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetManagementAgentsFilterArgs', 'GetManagementAgentsFilterArgsDict']]] = None,
                          gateway_ids: Optional[Sequence[_builtins.str]] = None,
                          host_id: Optional[_builtins.str] = None,
                          install_type: Optional[_builtins.str] = None,
                          is_customer_deployed: Optional[_builtins.bool] = None,
                          platform_types: Optional[Sequence[_builtins.str]] = None,
                          plugin_names: Optional[Sequence[_builtins.str]] = None,
                          state: Optional[_builtins.str] = None,
                          versions: Optional[Sequence[_builtins.str]] = None,
                          wait_for_host_id: Optional[_builtins.int] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentsResult:
    """
    This data source provides the list of Management Agents in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agents.
    If no explicit page size limit is specified, it will default to 1000 when compartmentIdInSubtree is true and 5000 otherwise.
    The response is limited to maximum 1000 records when compartmentIdInSubtree is true.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agents = oci.ManagementAgent.get_management_agents(compartment_id=compartment_id,
        access_level=management_agent_access_level,
        availability_status=management_agent_availability_status,
        compartment_id_in_subtree=management_agent_compartment_id_in_subtree,
        data_source_names=test_management_agent_data_source["name"],
        data_source_type=management_agent_data_source_type,
        display_name=management_agent_display_name,
        gateway_ids=test_gateway["id"],
        host_id=test_host["id"],
        wait_for_host_id=10,
        install_type=management_agent_install_type,
        is_customer_deployed=management_agent_is_customer_deployed,
        platform_types=management_agent_platform_type,
        plugin_names=management_agent_plugin_name,
        state=management_agent_state,
        versions=management_agent_version)
    ```


    :param _builtins.str access_level: When the value is "ACCESSIBLE", insufficient permissions for a compartment will filter out resources in that compartment without rejecting the request.
    :param _builtins.str availability_status: Filter to return only Management Agents in the particular availability status.
    :param _builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param _builtins.bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param Sequence[_builtins.str] data_source_names: Unique name of the dataSource.
    :param _builtins.str data_source_type: The type of the dataSource.
    :param _builtins.str display_name: Filter to return only Management Agents having the particular display name.
    :param Sequence[_builtins.str] gateway_ids: Filter to return only results having the particular gatewayId.
    :param _builtins.str host_id: Filter to return only Management Agents having the particular agent host id.
    :param _builtins.str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    :param _builtins.bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
    :param Sequence[_builtins.str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param Sequence[_builtins.str] plugin_names: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
    :param _builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
    :param Sequence[_builtins.str] versions: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
    :param _builtins.int wait_for_host_id: When host_id argument is set, the data source will wait for the given period of time (in minutes) for this host_id to become available. This can be used when compute instance with Management Agent has been recently created.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['availabilityStatus'] = availability_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['dataSourceNames'] = data_source_names
    __args__['dataSourceType'] = data_source_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['gatewayIds'] = gateway_ids
    __args__['hostId'] = host_id
    __args__['installType'] = install_type
    __args__['isCustomerDeployed'] = is_customer_deployed
    __args__['platformTypes'] = platform_types
    __args__['pluginNames'] = plugin_names
    __args__['state'] = state
    __args__['versions'] = versions
    __args__['waitForHostId'] = wait_for_host_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgents:getManagementAgents', __args__, opts=opts, typ=GetManagementAgentsResult).value

    return AwaitableGetManagementAgentsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        availability_status=pulumi.get(__ret__, 'availability_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        data_source_names=pulumi.get(__ret__, 'data_source_names'),
        data_source_type=pulumi.get(__ret__, 'data_source_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        gateway_ids=pulumi.get(__ret__, 'gateway_ids'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        install_type=pulumi.get(__ret__, 'install_type'),
        is_customer_deployed=pulumi.get(__ret__, 'is_customer_deployed'),
        management_agents=pulumi.get(__ret__, 'management_agents'),
        platform_types=pulumi.get(__ret__, 'platform_types'),
        plugin_names=pulumi.get(__ret__, 'plugin_names'),
        state=pulumi.get(__ret__, 'state'),
        versions=pulumi.get(__ret__, 'versions'),
        wait_for_host_id=pulumi.get(__ret__, 'wait_for_host_id'))
def get_management_agents_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 availability_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 data_source_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 data_source_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagementAgentsFilterArgs', 'GetManagementAgentsFilterArgsDict']]]]] = None,
                                 gateway_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 host_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 install_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 is_customer_deployed: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 platform_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 plugin_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 versions: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 wait_for_host_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementAgentsResult]:
    """
    This data source provides the list of Management Agents in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agents.
    If no explicit page size limit is specified, it will default to 1000 when compartmentIdInSubtree is true and 5000 otherwise.
    The response is limited to maximum 1000 records when compartmentIdInSubtree is true.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agents = oci.ManagementAgent.get_management_agents(compartment_id=compartment_id,
        access_level=management_agent_access_level,
        availability_status=management_agent_availability_status,
        compartment_id_in_subtree=management_agent_compartment_id_in_subtree,
        data_source_names=test_management_agent_data_source["name"],
        data_source_type=management_agent_data_source_type,
        display_name=management_agent_display_name,
        gateway_ids=test_gateway["id"],
        host_id=test_host["id"],
        wait_for_host_id=10,
        install_type=management_agent_install_type,
        is_customer_deployed=management_agent_is_customer_deployed,
        platform_types=management_agent_platform_type,
        plugin_names=management_agent_plugin_name,
        state=management_agent_state,
        versions=management_agent_version)
    ```


    :param _builtins.str access_level: When the value is "ACCESSIBLE", insufficient permissions for a compartment will filter out resources in that compartment without rejecting the request.
    :param _builtins.str availability_status: Filter to return only Management Agents in the particular availability status.
    :param _builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param _builtins.bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param Sequence[_builtins.str] data_source_names: Unique name of the dataSource.
    :param _builtins.str data_source_type: The type of the dataSource.
    :param _builtins.str display_name: Filter to return only Management Agents having the particular display name.
    :param Sequence[_builtins.str] gateway_ids: Filter to return only results having the particular gatewayId.
    :param _builtins.str host_id: Filter to return only Management Agents having the particular agent host id.
    :param _builtins.str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    :param _builtins.bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
    :param Sequence[_builtins.str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param Sequence[_builtins.str] plugin_names: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
    :param _builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
    :param Sequence[_builtins.str] versions: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
    :param _builtins.int wait_for_host_id: When host_id argument is set, the data source will wait for the given period of time (in minutes) for this host_id to become available. This can be used when compute instance with Management Agent has been recently created.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['availabilityStatus'] = availability_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['dataSourceNames'] = data_source_names
    __args__['dataSourceType'] = data_source_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['gatewayIds'] = gateway_ids
    __args__['hostId'] = host_id
    __args__['installType'] = install_type
    __args__['isCustomerDeployed'] = is_customer_deployed
    __args__['platformTypes'] = platform_types
    __args__['pluginNames'] = plugin_names
    __args__['state'] = state
    __args__['versions'] = versions
    __args__['waitForHostId'] = wait_for_host_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getManagementAgents:getManagementAgents', __args__, opts=opts, typ=GetManagementAgentsResult)
    return __ret__.apply(lambda __response__: GetManagementAgentsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        availability_status=pulumi.get(__response__, 'availability_status'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        data_source_names=pulumi.get(__response__, 'data_source_names'),
        data_source_type=pulumi.get(__response__, 'data_source_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        gateway_ids=pulumi.get(__response__, 'gateway_ids'),
        host_id=pulumi.get(__response__, 'host_id'),
        id=pulumi.get(__response__, 'id'),
        install_type=pulumi.get(__response__, 'install_type'),
        is_customer_deployed=pulumi.get(__response__, 'is_customer_deployed'),
        management_agents=pulumi.get(__response__, 'management_agents'),
        platform_types=pulumi.get(__response__, 'platform_types'),
        plugin_names=pulumi.get(__response__, 'plugin_names'),
        state=pulumi.get(__response__, 'state'),
        versions=pulumi.get(__response__, 'versions'),
        wait_for_host_id=pulumi.get(__response__, 'wait_for_host_id')))
