# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UsageCarbonEmissionArgs', 'UsageCarbonEmission']

@pulumi.input_type
class UsageCarbonEmissionArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[_builtins.str],
                 time_usage_ended: pulumi.Input[_builtins.str],
                 time_usage_started: pulumi.Input[_builtins.str],
                 compartment_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 emission_calculation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 emission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 usage_carbon_emission_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UsageCarbonEmission resource.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant ID.
        :param pulumi.Input[_builtins.str] time_usage_ended: The usage end time.
        :param pulumi.Input[_builtins.str] time_usage_started: The usage start time.
        :param pulumi.Input[_builtins.int] compartment_depth: The compartment depth level.
        :param pulumi.Input[_builtins.str] emission_calculation_method: Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        :param pulumi.Input[_builtins.str] emission_type: Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        :param pulumi.Input[_builtins.str] granularity: The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        :param pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]] group_by_tags: GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[_builtins.bool] is_aggregate_by_time: Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        :param pulumi.Input[_builtins.str] usage_carbon_emission_filter: The filter object for query usage.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        pulumi.set(__self__, "time_usage_started", time_usage_started)
        if compartment_depth is not None:
            pulumi.set(__self__, "compartment_depth", compartment_depth)
        if emission_calculation_method is not None:
            pulumi.set(__self__, "emission_calculation_method", emission_calculation_method)
        if emission_type is not None:
            pulumi.set(__self__, "emission_type", emission_type)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_by_tags is not None:
            pulumi.set(__self__, "group_by_tags", group_by_tags)
        if is_aggregate_by_time is not None:
            pulumi.set(__self__, "is_aggregate_by_time", is_aggregate_by_time)
        if usage_carbon_emission_filter is not None:
            pulumi.set(__self__, "usage_carbon_emission_filter", usage_carbon_emission_filter)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> pulumi.Input[_builtins.str]:
        """
        The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @time_usage_ended.setter
    def time_usage_ended(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_usage_ended", value)

    @_builtins.property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> pulumi.Input[_builtins.str]:
        """
        The usage start time.
        """
        return pulumi.get(self, "time_usage_started")

    @time_usage_started.setter
    def time_usage_started(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_usage_started", value)

    @_builtins.property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The compartment depth level.
        """
        return pulumi.get(self, "compartment_depth")

    @compartment_depth.setter
    def compartment_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compartment_depth", value)

    @_builtins.property
    @pulumi.getter(name="emissionCalculationMethod")
    def emission_calculation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        """
        return pulumi.get(self, "emission_calculation_method")

    @emission_calculation_method.setter
    def emission_calculation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emission_calculation_method", value)

    @_builtins.property
    @pulumi.getter(name="emissionType")
    def emission_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        """
        return pulumi.get(self, "emission_type")

    @emission_type.setter
    def emission_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emission_type", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]]:
        """
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        """
        return pulumi.get(self, "group_by_tags")

    @group_by_tags.setter
    def group_by_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]]):
        pulumi.set(self, "group_by_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAggregateByTime")
    def is_aggregate_by_time(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        """
        return pulumi.get(self, "is_aggregate_by_time")

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_aggregate_by_time", value)

    @_builtins.property
    @pulumi.getter(name="usageCarbonEmissionFilter")
    def usage_carbon_emission_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filter object for query usage.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "usage_carbon_emission_filter")

    @usage_carbon_emission_filter.setter
    def usage_carbon_emission_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_carbon_emission_filter", value)


@pulumi.input_type
class _UsageCarbonEmissionState:
    def __init__(__self__, *,
                 compartment_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 emission_calculation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 emission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionItemArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_ended: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_started: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_carbon_emission_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UsageCarbonEmission resources.
        :param pulumi.Input[_builtins.int] compartment_depth: The compartment depth level.
        :param pulumi.Input[_builtins.str] emission_calculation_method: Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        :param pulumi.Input[_builtins.str] emission_type: Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        :param pulumi.Input[_builtins.str] granularity: The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        :param pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]] group_by_tags: GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[_builtins.bool] is_aggregate_by_time: Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        :param pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionItemArgs']]] items: A list of carbon emission usage items.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant ID.
        :param pulumi.Input[_builtins.str] time_usage_ended: The usage end time.
        :param pulumi.Input[_builtins.str] time_usage_started: The usage start time.
        :param pulumi.Input[_builtins.str] usage_carbon_emission_filter: The filter object for query usage.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_depth is not None:
            pulumi.set(__self__, "compartment_depth", compartment_depth)
        if emission_calculation_method is not None:
            pulumi.set(__self__, "emission_calculation_method", emission_calculation_method)
        if emission_type is not None:
            pulumi.set(__self__, "emission_type", emission_type)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_by_tags is not None:
            pulumi.set(__self__, "group_by_tags", group_by_tags)
        if is_aggregate_by_time is not None:
            pulumi.set(__self__, "is_aggregate_by_time", is_aggregate_by_time)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_usage_ended is not None:
            pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        if time_usage_started is not None:
            pulumi.set(__self__, "time_usage_started", time_usage_started)
        if usage_carbon_emission_filter is not None:
            pulumi.set(__self__, "usage_carbon_emission_filter", usage_carbon_emission_filter)

    @_builtins.property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The compartment depth level.
        """
        return pulumi.get(self, "compartment_depth")

    @compartment_depth.setter
    def compartment_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compartment_depth", value)

    @_builtins.property
    @pulumi.getter(name="emissionCalculationMethod")
    def emission_calculation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        """
        return pulumi.get(self, "emission_calculation_method")

    @emission_calculation_method.setter
    def emission_calculation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emission_calculation_method", value)

    @_builtins.property
    @pulumi.getter(name="emissionType")
    def emission_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        """
        return pulumi.get(self, "emission_type")

    @emission_type.setter
    def emission_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emission_type", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]]:
        """
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        """
        return pulumi.get(self, "group_by_tags")

    @group_by_tags.setter
    def group_by_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionGroupByTagArgs']]]]):
        pulumi.set(self, "group_by_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAggregateByTime")
    def is_aggregate_by_time(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        """
        return pulumi.get(self, "is_aggregate_by_time")

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_aggregate_by_time", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionItemArgs']]]]:
        """
        A list of carbon emission usage items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageCarbonEmissionItemArgs']]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @time_usage_ended.setter
    def time_usage_ended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_usage_ended", value)

    @_builtins.property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage start time.
        """
        return pulumi.get(self, "time_usage_started")

    @time_usage_started.setter
    def time_usage_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_usage_started", value)

    @_builtins.property
    @pulumi.getter(name="usageCarbonEmissionFilter")
    def usage_carbon_emission_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filter object for query usage.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "usage_carbon_emission_filter")

    @usage_carbon_emission_filter.setter
    def usage_carbon_emission_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_carbon_emission_filter", value)


@pulumi.type_token("oci:MeteringComputation/usageCarbonEmission:UsageCarbonEmission")
class UsageCarbonEmission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 emission_calculation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 emission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionGroupByTagArgs', 'UsageCarbonEmissionGroupByTagArgsDict']]]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_ended: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_started: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_carbon_emission_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Usage Carbon Emission resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns carbon emission usage for the given account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_carbon_emission = oci.meteringcomputation.UsageCarbonEmission("test_usage_carbon_emission",
            tenant_id=test_tenant["id"],
            time_usage_ended=usage_carbon_emission_time_usage_ended,
            time_usage_started=usage_carbon_emission_time_usage_started,
            compartment_depth=usage_carbon_emission_compartment_depth,
            emission_calculation_method=usage_carbon_emission_emission_calculation_method,
            emission_type=usage_carbon_emission_emission_type,
            granularity=usage_carbon_emission_granularity,
            group_bies=usage_carbon_emission_group_by,
            group_by_tags=[{
                "key": usage_carbon_emission_group_by_tag_key,
                "namespace": usage_carbon_emission_group_by_tag_namespace,
                "value": usage_carbon_emission_group_by_tag_value,
            }],
            is_aggregate_by_time=usage_carbon_emission_is_aggregate_by_time,
            usage_carbon_emission_filter=usage_carbon_emission_usage_carbon_emission_filter)
        ```

        ## Import

        UsageCarbonEmissions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageCarbonEmission:UsageCarbonEmission test_usage_carbon_emission "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] compartment_depth: The compartment depth level.
        :param pulumi.Input[_builtins.str] emission_calculation_method: Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        :param pulumi.Input[_builtins.str] emission_type: Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        :param pulumi.Input[_builtins.str] granularity: The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionGroupByTagArgs', 'UsageCarbonEmissionGroupByTagArgsDict']]]] group_by_tags: GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[_builtins.bool] is_aggregate_by_time: Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant ID.
        :param pulumi.Input[_builtins.str] time_usage_ended: The usage end time.
        :param pulumi.Input[_builtins.str] time_usage_started: The usage start time.
        :param pulumi.Input[_builtins.str] usage_carbon_emission_filter: The filter object for query usage.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsageCarbonEmissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Usage Carbon Emission resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns carbon emission usage for the given account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_usage_carbon_emission = oci.meteringcomputation.UsageCarbonEmission("test_usage_carbon_emission",
            tenant_id=test_tenant["id"],
            time_usage_ended=usage_carbon_emission_time_usage_ended,
            time_usage_started=usage_carbon_emission_time_usage_started,
            compartment_depth=usage_carbon_emission_compartment_depth,
            emission_calculation_method=usage_carbon_emission_emission_calculation_method,
            emission_type=usage_carbon_emission_emission_type,
            granularity=usage_carbon_emission_granularity,
            group_bies=usage_carbon_emission_group_by,
            group_by_tags=[{
                "key": usage_carbon_emission_group_by_tag_key,
                "namespace": usage_carbon_emission_group_by_tag_namespace,
                "value": usage_carbon_emission_group_by_tag_value,
            }],
            is_aggregate_by_time=usage_carbon_emission_is_aggregate_by_time,
            usage_carbon_emission_filter=usage_carbon_emission_usage_carbon_emission_filter)
        ```

        ## Import

        UsageCarbonEmissions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MeteringComputation/usageCarbonEmission:UsageCarbonEmission test_usage_carbon_emission "id"
        ```

        :param str resource_name: The name of the resource.
        :param UsageCarbonEmissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsageCarbonEmissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 emission_calculation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 emission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionGroupByTagArgs', 'UsageCarbonEmissionGroupByTagArgsDict']]]]] = None,
                 is_aggregate_by_time: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_ended: Optional[pulumi.Input[_builtins.str]] = None,
                 time_usage_started: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_carbon_emission_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsageCarbonEmissionArgs.__new__(UsageCarbonEmissionArgs)

            __props__.__dict__["compartment_depth"] = compartment_depth
            __props__.__dict__["emission_calculation_method"] = emission_calculation_method
            __props__.__dict__["emission_type"] = emission_type
            __props__.__dict__["granularity"] = granularity
            __props__.__dict__["group_bies"] = group_bies
            __props__.__dict__["group_by_tags"] = group_by_tags
            __props__.__dict__["is_aggregate_by_time"] = is_aggregate_by_time
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if time_usage_ended is None and not opts.urn:
                raise TypeError("Missing required property 'time_usage_ended'")
            __props__.__dict__["time_usage_ended"] = time_usage_ended
            if time_usage_started is None and not opts.urn:
                raise TypeError("Missing required property 'time_usage_started'")
            __props__.__dict__["time_usage_started"] = time_usage_started
            __props__.__dict__["usage_carbon_emission_filter"] = usage_carbon_emission_filter
            __props__.__dict__["items"] = None
        super(UsageCarbonEmission, __self__).__init__(
            'oci:MeteringComputation/usageCarbonEmission:UsageCarbonEmission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_depth: Optional[pulumi.Input[_builtins.int]] = None,
            emission_calculation_method: Optional[pulumi.Input[_builtins.str]] = None,
            emission_type: Optional[pulumi.Input[_builtins.str]] = None,
            granularity: Optional[pulumi.Input[_builtins.str]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_by_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionGroupByTagArgs', 'UsageCarbonEmissionGroupByTagArgsDict']]]]] = None,
            is_aggregate_by_time: Optional[pulumi.Input[_builtins.bool]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionItemArgs', 'UsageCarbonEmissionItemArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_usage_ended: Optional[pulumi.Input[_builtins.str]] = None,
            time_usage_started: Optional[pulumi.Input[_builtins.str]] = None,
            usage_carbon_emission_filter: Optional[pulumi.Input[_builtins.str]] = None) -> 'UsageCarbonEmission':
        """
        Get an existing UsageCarbonEmission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] compartment_depth: The compartment depth level.
        :param pulumi.Input[_builtins.str] emission_calculation_method: Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        :param pulumi.Input[_builtins.str] emission_type: Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        :param pulumi.Input[_builtins.str] granularity: The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionGroupByTagArgs', 'UsageCarbonEmissionGroupByTagArgsDict']]]] group_by_tags: GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        :param pulumi.Input[_builtins.bool] is_aggregate_by_time: Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UsageCarbonEmissionItemArgs', 'UsageCarbonEmissionItemArgsDict']]]] items: A list of carbon emission usage items.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant ID.
        :param pulumi.Input[_builtins.str] time_usage_ended: The usage end time.
        :param pulumi.Input[_builtins.str] time_usage_started: The usage start time.
        :param pulumi.Input[_builtins.str] usage_carbon_emission_filter: The filter object for query usage.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsageCarbonEmissionState.__new__(_UsageCarbonEmissionState)

        __props__.__dict__["compartment_depth"] = compartment_depth
        __props__.__dict__["emission_calculation_method"] = emission_calculation_method
        __props__.__dict__["emission_type"] = emission_type
        __props__.__dict__["granularity"] = granularity
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["group_by_tags"] = group_by_tags
        __props__.__dict__["is_aggregate_by_time"] = is_aggregate_by_time
        __props__.__dict__["items"] = items
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_usage_ended"] = time_usage_ended
        __props__.__dict__["time_usage_started"] = time_usage_started
        __props__.__dict__["usage_carbon_emission_filter"] = usage_carbon_emission_filter
        return UsageCarbonEmission(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentDepth")
    def compartment_depth(self) -> pulumi.Output[_builtins.int]:
        """
        The compartment depth level.
        """
        return pulumi.get(self, "compartment_depth")

    @_builtins.property
    @pulumi.getter(name="emissionCalculationMethod")
    def emission_calculation_method(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED
        """
        return pulumi.get(self, "emission_calculation_method")

    @_builtins.property
    @pulumi.getter(name="emissionType")
    def emission_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.
        """
        return pulumi.get(self, "emission_type")

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> pulumi.Output[_builtins.str]:
        """
        The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.
        """
        return pulumi.get(self, "granularity")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Aggregate the result by. For example: `["tagNamespace", "tagKey", "tagValue", "service", "skuName", "skuPartNumber", "unit", "compartmentName", "compartmentPath", "compartmentId", "platform", "region", "logicalAd", "resourceId", "resourceName", "tenantId", "tenantName", "subscriptionId"]`
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="groupByTags")
    def group_by_tags(self) -> pulumi.Output[Sequence['outputs.UsageCarbonEmissionGroupByTag']]:
        """
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list. For example: `[{"namespace":"oracle", "key":"createdBy"]`
        """
        return pulumi.get(self, "group_by_tags")

    @_builtins.property
    @pulumi.getter(name="isAggregateByTime")
    def is_aggregate_by_time(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.
        """
        return pulumi.get(self, "is_aggregate_by_time")

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.UsageCarbonEmissionItem']]:
        """
        A list of carbon emission usage items.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> pulumi.Output[_builtins.str]:
        """
        The usage end time.
        """
        return pulumi.get(self, "time_usage_ended")

    @_builtins.property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> pulumi.Output[_builtins.str]:
        """
        The usage start time.
        """
        return pulumi.get(self, "time_usage_started")

    @_builtins.property
    @pulumi.getter(name="usageCarbonEmissionFilter")
    def usage_carbon_emission_filter(self) -> pulumi.Output[_builtins.str]:
        """
        The filter object for query usage.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "usage_carbon_emission_filter")

