# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AlarmOverrideArgs',
    'AlarmOverrideArgsDict',
    'AlarmSuppressionArgs',
    'AlarmSuppressionArgsDict',
    'AlarmSuppressionAlarmSuppressionTargetArgs',
    'AlarmSuppressionAlarmSuppressionTargetArgsDict',
    'AlarmSuppressionSuppressionConditionArgs',
    'AlarmSuppressionSuppressionConditionArgsDict',
    'GetAlarmStatusesFilterArgs',
    'GetAlarmStatusesFilterArgsDict',
    'GetAlarmSuppressionsFilterArgs',
    'GetAlarmSuppressionsFilterArgsDict',
    'GetAlarmsFilterArgs',
    'GetAlarmsFilterArgsDict',
    'GetMetricDataFilterArgs',
    'GetMetricDataFilterArgsDict',
    'GetMetricsFilterArgs',
    'GetMetricsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class AlarmOverrideArgsDict(TypedDict):
        body: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        pending_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        query: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        ----- Example of absence alarm with custom absence detection period of 20 hours:

        ----- CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent(20h) -----
        """
        rule_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) A user-friendly description for this alarm override. Must be unique across all `ruleName` values for the alarm.
        """
        severity: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The perceived severity of the alarm with regard to the affected system.  Example: `CRITICAL`
        """
elif False:
    AlarmOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmOverrideArgs:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] body: (Updatable) The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param pulumi.Input[_builtins.str] pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param pulumi.Input[_builtins.str] query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               ----- Example of absence alarm with custom absence detection period of 20 hours:
               
               ----- CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent(20h) -----
        :param pulumi.Input[_builtins.str] rule_name: (Updatable) A user-friendly description for this alarm override. Must be unique across all `ruleName` values for the alarm.
        :param pulumi.Input[_builtins.str] severity: (Updatable) The perceived severity of the alarm with regard to the affected system.  Example: `CRITICAL`
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if pending_duration is not None:
            pulumi.set(__self__, "pending_duration", pending_duration)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        return pulumi.get(self, "pending_duration")

    @pending_duration.setter
    def pending_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pending_duration", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        ----- Example of absence alarm with custom absence detection period of 20 hours:

        ----- CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent(20h) -----
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly description for this alarm override. Must be unique across all `ruleName` values for the alarm.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The perceived severity of the alarm with regard to the affected system.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)


if not MYPY:
    class AlarmSuppressionArgsDict(TypedDict):
        time_suppress_from: pulumi.Input[_builtins.str]
        """
        (Updatable) The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        time_suppress_until: pulumi.Input[_builtins.str]
        """
        (Updatable) The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
elif False:
    AlarmSuppressionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmSuppressionArgs:
    def __init__(__self__, *,
                 time_suppress_from: pulumi.Input[_builtins.str],
                 time_suppress_until: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] time_suppress_from: (Updatable) The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[_builtins.str] time_suppress_until: (Updatable) The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] description: (Updatable) Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        """
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @time_suppress_from.setter
    def time_suppress_from(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_suppress_from", value)

    @_builtins.property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @time_suppress_until.setter
    def time_suppress_until(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_suppress_until", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class AlarmSuppressionAlarmSuppressionTargetArgsDict(TypedDict):
        target_type: pulumi.Input[_builtins.str]
        """
        The type of the alarm suppression target.
        """
        alarm_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        compartment_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment or tenancy that is the  target of the alarm suppression. Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        compartment_id_in_subtree: NotRequired[pulumi.Input[_builtins.bool]]
        """
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
elif False:
    AlarmSuppressionAlarmSuppressionTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmSuppressionAlarmSuppressionTargetArgs:
    def __init__(__self__, *,
                 target_type: pulumi.Input[_builtins.str],
                 alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id_in_subtree: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] target_type: The type of the alarm suppression target.
        :param pulumi.Input[_builtins.str] alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment or tenancy that is the  target of the alarm suppression. Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param pulumi.Input[_builtins.bool] compartment_id_in_subtree: When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        pulumi.set(__self__, "target_type", target_type)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree is not None:
            pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the alarm suppression target.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @alarm_id.setter
    def alarm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment or tenancy that is the  target of the alarm suppression. Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @compartment_id_in_subtree.setter
    def compartment_id_in_subtree(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compartment_id_in_subtree", value)


if not MYPY:
    class AlarmSuppressionSuppressionConditionArgsDict(TypedDict):
        condition_type: pulumi.Input[_builtins.str]
        """
        Type of suppression condition.
        """
        suppression_duration: pulumi.Input[_builtins.str]
        """
        Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        """
        suppression_recurrence: pulumi.Input[_builtins.str]
        """
        Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
        * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
        * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
        * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
elif False:
    AlarmSuppressionSuppressionConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmSuppressionSuppressionConditionArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[_builtins.str],
                 suppression_duration: pulumi.Input[_builtins.str],
                 suppression_recurrence: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] condition_type: Type of suppression condition.
        :param pulumi.Input[_builtins.str] suppression_duration: Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        :param pulumi.Input[_builtins.str] suppression_recurrence: Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
               * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
               * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
               * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "suppression_duration", suppression_duration)
        pulumi.set(__self__, "suppression_recurrence", suppression_recurrence)

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of suppression condition.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "condition_type", value)

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> pulumi.Input[_builtins.str]:
        """
        Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        """
        return pulumi.get(self, "suppression_duration")

    @suppression_duration.setter
    def suppression_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "suppression_duration", value)

    @_builtins.property
    @pulumi.getter(name="suppressionRecurrence")
    def suppression_recurrence(self) -> pulumi.Input[_builtins.str]:
        """
        Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
        * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
        * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
        * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        return pulumi.get(self, "suppression_recurrence")

    @suppression_recurrence.setter
    def suppression_recurrence(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "suppression_recurrence", value)


if not MYPY:
    class GetAlarmStatusesFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetAlarmStatusesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAlarmStatusesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetAlarmSuppressionsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetAlarmSuppressionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAlarmSuppressionsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetAlarmsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetAlarmsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAlarmsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMetricDataFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The name of the metric.  Example: `CpuUtilization`
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMetricDataFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMetricDataFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the metric.  Example: `CpuUtilization`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMetricsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMetricsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMetricsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


