# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHeatWaveClusterResult',
    'AwaitableGetHeatWaveClusterResult',
    'get_heat_wave_cluster',
    'get_heat_wave_cluster_output',
]

@pulumi.output_type
class GetHeatWaveClusterResult:
    """
    A collection of values returned by getHeatWaveCluster.
    """
    def __init__(__self__, cluster_nodes=None, cluster_size=None, db_system_id=None, id=None, is_lakehouse_enabled=None, lifecycle_details=None, shape_name=None, state=None, time_created=None, time_updated=None):
        if cluster_nodes and not isinstance(cluster_nodes, list):
            raise TypeError("Expected argument 'cluster_nodes' to be a list")
        pulumi.set(__self__, "cluster_nodes", cluster_nodes)
        if cluster_size and not isinstance(cluster_size, int):
            raise TypeError("Expected argument 'cluster_size' to be a int")
        pulumi.set(__self__, "cluster_size", cluster_size)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lakehouse_enabled and not isinstance(is_lakehouse_enabled, bool):
            raise TypeError("Expected argument 'is_lakehouse_enabled' to be a bool")
        pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> Sequence['outputs.GetHeatWaveClusterClusterNodeResult']:
        """
        A HeatWave node is a compute host that is part of a HeatWave cluster.
        """
        return pulumi.get(self, "cluster_nodes")

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> _builtins.int:
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the parent DB System this HeatWave cluster is attached to.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> _builtins.bool:
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape determines resources to allocate to the HeatWave nodes - CPU cores, memory.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the HeatWave cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetHeatWaveClusterResult(GetHeatWaveClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHeatWaveClusterResult(
            cluster_nodes=self.cluster_nodes,
            cluster_size=self.cluster_size,
            db_system_id=self.db_system_id,
            id=self.id,
            is_lakehouse_enabled=self.is_lakehouse_enabled,
            lifecycle_details=self.lifecycle_details,
            shape_name=self.shape_name,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_heat_wave_cluster(db_system_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHeatWaveClusterResult:
    """
    This data source provides details about a specific HeatWave cluster resource in Oracle Cloud Infrastructure MySQL Database service.

    Gets information about the HeatWave cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_heat_wave_cluster = oci.Mysql.get_heat_wave_cluster(db_system_id=test_db_system["id"])
    ```


    :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getHeatWaveCluster:getHeatWaveCluster', __args__, opts=opts, typ=GetHeatWaveClusterResult).value

    return AwaitableGetHeatWaveClusterResult(
        cluster_nodes=pulumi.get(__ret__, 'cluster_nodes'),
        cluster_size=pulumi.get(__ret__, 'cluster_size'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        id=pulumi.get(__ret__, 'id'),
        is_lakehouse_enabled=pulumi.get(__ret__, 'is_lakehouse_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_heat_wave_cluster_output(db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHeatWaveClusterResult]:
    """
    This data source provides details about a specific HeatWave cluster resource in Oracle Cloud Infrastructure MySQL Database service.

    Gets information about the HeatWave cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_heat_wave_cluster = oci.Mysql.get_heat_wave_cluster(db_system_id=test_db_system["id"])
    ```


    :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Mysql/getHeatWaveCluster:getHeatWaveCluster', __args__, opts=opts, typ=GetHeatWaveClusterResult)
    return __ret__.apply(lambda __response__: GetHeatWaveClusterResult(
        cluster_nodes=pulumi.get(__response__, 'cluster_nodes'),
        cluster_size=pulumi.get(__response__, 'cluster_size'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        id=pulumi.get(__response__, 'id'),
        is_lakehouse_enabled=pulumi.get(__response__, 'is_lakehouse_enabled'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        shape_name=pulumi.get(__response__, 'shape_name'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
