# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackendSetBackend',
    'BackendSetHealthChecker',
    'BackendSetHealthCheckerDns',
    'NetworkLoadBalancerIpAddress',
    'NetworkLoadBalancerIpAddressReservedIp',
    'NetworkLoadBalancerReservedIp',
    'NetworkLoadBalancersBackendSetsUnifiedBackend',
    'NetworkLoadBalancersBackendSetsUnifiedHealthChecker',
    'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns',
    'GetBackendHealthHealthCheckResultResult',
    'GetBackendSetBackendResult',
    'GetBackendSetHealthCheckerResult',
    'GetBackendSetHealthCheckerDnResult',
    'GetBackendSetsBackendSetCollectionResult',
    'GetBackendSetsBackendSetCollectionItemResult',
    'GetBackendSetsBackendSetCollectionItemBackendResult',
    'GetBackendSetsBackendSetCollectionItemHealthCheckerResult',
    'GetBackendSetsBackendSetCollectionItemHealthCheckerDnResult',
    'GetBackendSetsFilterResult',
    'GetBackendsBackendCollectionResult',
    'GetBackendsBackendCollectionItemResult',
    'GetBackendsFilterResult',
    'GetListenersFilterResult',
    'GetListenersListenerCollectionResult',
    'GetListenersListenerCollectionItemResult',
    'GetNetworkLoadBalancerIpAddressResult',
    'GetNetworkLoadBalancerIpAddressReservedIpResult',
    'GetNetworkLoadBalancerReservedIpResult',
    'GetNetworkLoadBalancersFilterResult',
    'GetNetworkLoadBalancersNetworkLoadBalancerCollectionResult',
    'GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemResult',
    'GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressResult',
    'GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressReservedIpResult',
    'GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemReservedIpResult',
    'GetNetworkLoadBalancersPoliciesFilterResult',
    'GetNetworkLoadBalancersPoliciesNetworkLoadBalancersPolicyCollectionResult',
    'GetNetworkLoadBalancersProtocolsFilterResult',
    'GetNetworkLoadBalancersProtocolsNetworkLoadBalancersProtocolCollectionResult',
]

@pulumi.output_type
class BackendSetBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "isBackup":
            suggest = "is_backup"
        elif key == "isDrain":
            suggest = "is_drain"
        elif key == "isOffline":
            suggest = "is_offline"
        elif key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 ip_address: Optional[_builtins.str] = None,
                 is_backup: Optional[_builtins.bool] = None,
                 is_drain: Optional[_builtins.bool] = None,
                 is_offline: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 target_id: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: (Updatable) The communication port for the backend server.  Example: `8080`
        :param _builtins.str ip_address: (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        :param _builtins.bool is_backup: (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param _builtins.bool is_drain: (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param _builtins.bool is_offline: (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.str name: (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        :param _builtins.str target_id: (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param _builtins.int weight: (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "port", port)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if is_drain is not None:
            pulumi.set(__self__, "is_drain", is_drain)
        if is_offline is not None:
            pulumi.set(__self__, "is_offline", is_offline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @_builtins.property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class BackendSetHealthChecker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInMillis":
            suggest = "interval_in_millis"
        elif key == "requestData":
            suggest = "request_data"
        elif key == "responseBodyRegex":
            suggest = "response_body_regex"
        elif key == "responseData":
            suggest = "response_data"
        elif key == "returnCode":
            suggest = "return_code"
        elif key == "timeoutInMillis":
            suggest = "timeout_in_millis"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetHealthChecker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetHealthChecker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetHealthChecker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 dns: Optional['outputs.BackendSetHealthCheckerDns'] = None,
                 interval_in_millis: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 request_data: Optional[_builtins.str] = None,
                 response_body_regex: Optional[_builtins.str] = None,
                 response_data: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 return_code: Optional[_builtins.int] = None,
                 timeout_in_millis: Optional[_builtins.int] = None,
                 url_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: (Updatable) The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        :param 'BackendSetHealthCheckerDnsArgs' dns: (Updatable) DNS healthcheck configurations.
        :param _builtins.int interval_in_millis: (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param _builtins.int port: (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str request_data: (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param _builtins.str response_body_regex: (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.str response_data: (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param _builtins.int retries: (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param _builtins.int return_code: (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param _builtins.int timeout_in_millis: (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param _builtins.str url_path: (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "protocol", protocol)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if interval_in_millis is not None:
            pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_data is not None:
            pulumi.set(__self__, "request_data", request_data)
        if response_body_regex is not None:
            pulumi.set(__self__, "response_body_regex", response_body_regex)
        if response_data is not None:
            pulumi.set(__self__, "response_data", response_data)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if return_code is not None:
            pulumi.set(__self__, "return_code", return_code)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (Updatable) The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional['outputs.BackendSetHealthCheckerDns']:
        """
        (Updatable) DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> Optional[_builtins.int]:
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="requestData")
    def request_data(self) -> Optional[_builtins.str]:
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> Optional[_builtins.str]:
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter(name="responseData")
    def response_data(self) -> Optional[_builtins.str]:
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> Optional[_builtins.int]:
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class BackendSetHealthCheckerDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "queryClass":
            suggest = "query_class"
        elif key == "queryType":
            suggest = "query_type"
        elif key == "transportProtocol":
            suggest = "transport_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetHealthCheckerDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetHealthCheckerDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetHealthCheckerDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 query_class: Optional[_builtins.str] = None,
                 query_type: Optional[_builtins.str] = None,
                 rcodes: Optional[Sequence[_builtins.str]] = None,
                 transport_protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param _builtins.str query_class: (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param _builtins.str query_type: (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param Sequence[_builtins.str] rcodes: (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param _builtins.str transport_protocol: (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if query_class is not None:
            pulumi.set(__self__, "query_class", query_class)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if rcodes is not None:
            pulumi.set(__self__, "rcodes", rcodes)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> Optional[_builtins.str]:
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter
    def rcodes(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[_builtins.str]:
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class NetworkLoadBalancerIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "isPublic":
            suggest = "is_public"
        elif key == "reservedIps":
            suggest = "reserved_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkLoadBalancerIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkLoadBalancerIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkLoadBalancerIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 ip_version: Optional[_builtins.str] = None,
                 is_public: Optional[_builtins.bool] = None,
                 reserved_ips: Optional[Sequence['outputs.NetworkLoadBalancerIpAddressReservedIp']] = None):
        """
        :param _builtins.str ip_address: An IP address.  Example: `192.168.0.3`
        :param _builtins.str ip_version: IP version associated with the listener.
        :param _builtins.bool is_public: Whether the IP address is public or private.
        :param Sequence['NetworkLoadBalancerIpAddressReservedIpArgs'] reserved_ips: An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.str]:
        """
        IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[_builtins.bool]:
        """
        Whether the IP address is public or private.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[Sequence['outputs.NetworkLoadBalancerIpAddressReservedIp']]:
        """
        An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class NetworkLoadBalancerIpAddressReservedIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class NetworkLoadBalancerReservedIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
               
               Reserved public IP addresses are IP addresses that are registered using the virtual cloud network API.
               
               Create a reserved public IP address. When you create the network load balancer, enter the OCID of the reserved public IP address in the reservedIp field to attach the IP address to the network load balancer. This task configures the network load balancer to listen to traffic on this IP address.
               
               Reserved public IP addresses are not deleted when the network load balancer is deleted. The IP addresses become unattached from the network load balancer.
               
               Example: "ocid1.publicip.oc1.phx.unique_ID"
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        OCID of the reserved public IP address created with the virtual cloud network.

        Reserved public IP addresses are IP addresses that are registered using the virtual cloud network API.

        Create a reserved public IP address. When you create the network load balancer, enter the OCID of the reserved public IP address in the reservedIp field to attach the IP address to the network load balancer. This task configures the network load balancer to listen to traffic on this IP address.

        Reserved public IP addresses are not deleted when the network load balancer is deleted. The IP addresses become unattached from the network load balancer.

        Example: "ocid1.publicip.oc1.phx.unique_ID"
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class NetworkLoadBalancersBackendSetsUnifiedBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "isBackup":
            suggest = "is_backup"
        elif key == "isDrain":
            suggest = "is_drain"
        elif key == "isOffline":
            suggest = "is_offline"
        elif key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkLoadBalancersBackendSetsUnifiedBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 ip_address: Optional[_builtins.str] = None,
                 is_backup: Optional[_builtins.bool] = None,
                 is_drain: Optional[_builtins.bool] = None,
                 is_offline: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 target_id: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: (Updatable) The communication port for the backend server.  Example: `8080`
        :param _builtins.str ip_address: (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        :param _builtins.bool is_backup: (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param _builtins.bool is_drain: (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param _builtins.bool is_offline: (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.str name: (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        :param _builtins.str target_id: (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param _builtins.int weight: (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "port", port)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if is_drain is not None:
            pulumi.set(__self__, "is_drain", is_drain)
        if is_offline is not None:
            pulumi.set(__self__, "is_offline", is_offline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @_builtins.property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class NetworkLoadBalancersBackendSetsUnifiedHealthChecker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInMillis":
            suggest = "interval_in_millis"
        elif key == "requestData":
            suggest = "request_data"
        elif key == "responseBodyRegex":
            suggest = "response_body_regex"
        elif key == "responseData":
            suggest = "response_data"
        elif key == "returnCode":
            suggest = "return_code"
        elif key == "timeoutInMillis":
            suggest = "timeout_in_millis"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkLoadBalancersBackendSetsUnifiedHealthChecker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedHealthChecker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedHealthChecker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 dns: Optional['outputs.NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns'] = None,
                 interval_in_millis: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 request_data: Optional[_builtins.str] = None,
                 response_body_regex: Optional[_builtins.str] = None,
                 response_data: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 return_code: Optional[_builtins.int] = None,
                 timeout_in_millis: Optional[_builtins.int] = None,
                 url_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: (Updatable) The protocol the health check must use; either HTTP or HTTPS, or UDP or TCP.  Example: `HTTP`
        :param 'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs' dns: (Updatable) DNS healthcheck configurations.
        :param _builtins.int interval_in_millis: (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param _builtins.int port: (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str request_data: (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param _builtins.str response_body_regex: (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.str response_data: (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param _builtins.int retries: (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param _builtins.int return_code: (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param _builtins.int timeout_in_millis: (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param _builtins.str url_path: (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "protocol", protocol)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if interval_in_millis is not None:
            pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_data is not None:
            pulumi.set(__self__, "request_data", request_data)
        if response_body_regex is not None:
            pulumi.set(__self__, "response_body_regex", response_body_regex)
        if response_data is not None:
            pulumi.set(__self__, "response_data", response_data)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if return_code is not None:
            pulumi.set(__self__, "return_code", return_code)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (Updatable) The protocol the health check must use; either HTTP or HTTPS, or UDP or TCP.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional['outputs.NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns']:
        """
        (Updatable) DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> Optional[_builtins.int]:
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="requestData")
    def request_data(self) -> Optional[_builtins.str]:
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> Optional[_builtins.str]:
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter(name="responseData")
    def response_data(self) -> Optional[_builtins.str]:
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> Optional[_builtins.int]:
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "queryClass":
            suggest = "query_class"
        elif key == "queryType":
            suggest = "query_type"
        elif key == "transportProtocol":
            suggest = "transport_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 query_class: Optional[_builtins.str] = None,
                 query_type: Optional[_builtins.str] = None,
                 rcodes: Optional[Sequence[_builtins.str]] = None,
                 transport_protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param _builtins.str query_class: (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param _builtins.str query_type: (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param Sequence[_builtins.str] rcodes: (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param _builtins.str transport_protocol: (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if query_class is not None:
            pulumi.set(__self__, "query_class", query_class)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if rcodes is not None:
            pulumi.set(__self__, "rcodes", rcodes)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> Optional[_builtins.str]:
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter
    def rcodes(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[_builtins.str]:
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class GetBackendHealthHealthCheckResultResult(dict):
    def __init__(__self__, *,
                 health_check_status: _builtins.str,
                 timestamp: _builtins.str):
        """
        :param _builtins.str health_check_status: The result of the most recent health check.
        :param _builtins.str timestamp: The date and time the data was retrieved, in the format defined by RFC3339.  Example: `2020-05-01T18:28:11+00:00`
        """
        pulumi.set(__self__, "health_check_status", health_check_status)
        pulumi.set(__self__, "timestamp", timestamp)

    @_builtins.property
    @pulumi.getter(name="healthCheckStatus")
    def health_check_status(self) -> _builtins.str:
        """
        The result of the most recent health check.
        """
        return pulumi.get(self, "health_check_status")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> _builtins.str:
        """
        The date and time the data was retrieved, in the format defined by RFC3339.  Example: `2020-05-01T18:28:11+00:00`
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetBackendSetBackendResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 is_backup: _builtins.bool,
                 is_drain: _builtins.bool,
                 is_offline: _builtins.bool,
                 name: _builtins.str,
                 port: _builtins.int,
                 target_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip_address: The IP address of the backend server. Example: `10.0.0.3`
        :param _builtins.bool is_backup: Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param _builtins.bool is_drain: Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param _builtins.bool is_offline: Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.str name: A user-friendly name for the backend set that must be unique and cannot be changed.
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str target_id: The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param _builtins.int weight: The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_backup", is_backup)
        pulumi.set(__self__, "is_drain", is_drain)
        pulumi.set(__self__, "is_offline", is_offline)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the backend server. Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> _builtins.bool:
        """
        Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @_builtins.property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendSetHealthCheckerResult(dict):
    def __init__(__self__, *,
                 dns: Sequence['outputs.GetBackendSetHealthCheckerDnResult'],
                 interval_in_millis: _builtins.int,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 request_data: _builtins.str,
                 response_body_regex: _builtins.str,
                 response_data: _builtins.str,
                 retries: _builtins.int,
                 return_code: _builtins.int,
                 timeout_in_millis: _builtins.int,
                 url_path: _builtins.str):
        """
        :param Sequence['GetBackendSetHealthCheckerDnArgs'] dns: DNS healthcheck configurations.
        :param _builtins.int interval_in_millis: The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str protocol: The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        :param _builtins.str request_data: Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param _builtins.str response_body_regex: A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.str response_data: Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param _builtins.int retries: The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param _builtins.int return_code: The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param _builtins.int timeout_in_millis: The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param _builtins.str url_path: The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "request_data", request_data)
        pulumi.set(__self__, "response_body_regex", response_body_regex)
        pulumi.set(__self__, "response_data", response_data)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "return_code", return_code)
        pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetBackendSetHealthCheckerDnResult']:
        """
        DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> _builtins.int:
        """
        The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="requestData")
    def request_data(self) -> _builtins.str:
        """
        Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> _builtins.str:
        """
        A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter(name="responseData")
    def response_data(self) -> _builtins.str:
        """
        Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> _builtins.int:
        """
        The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> _builtins.int:
        """
        The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> _builtins.str:
        """
        The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class GetBackendSetHealthCheckerDnResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 query_class: _builtins.str,
                 query_type: _builtins.str,
                 rcodes: Sequence[_builtins.str],
                 transport_protocol: _builtins.str):
        """
        :param _builtins.str domain_name: The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param _builtins.str query_class: The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param _builtins.str query_type: The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param Sequence[_builtins.str] rcodes: An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param _builtins.str transport_protocol: DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "query_class", query_class)
        pulumi.set(__self__, "query_type", query_type)
        pulumi.set(__self__, "rcodes", rcodes)
        pulumi.set(__self__, "transport_protocol", transport_protocol)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> _builtins.str:
        """
        The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> _builtins.str:
        """
        The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter
    def rcodes(self) -> Sequence[_builtins.str]:
        """
        An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> _builtins.str:
        """
        DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class GetBackendSetsBackendSetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBackendSetsBackendSetCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBackendSetsBackendSetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBackendSetsBackendSetCollectionItemResult(dict):
    def __init__(__self__, *,
                 are_operationally_active_backends_preferred: _builtins.bool,
                 backends: Sequence['outputs.GetBackendSetsBackendSetCollectionItemBackendResult'],
                 health_checkers: Sequence['outputs.GetBackendSetsBackendSetCollectionItemHealthCheckerResult'],
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 is_fail_open: _builtins.bool,
                 is_instant_failover_enabled: _builtins.bool,
                 is_instant_failover_tcp_reset_enabled: _builtins.bool,
                 is_preserve_source: _builtins.bool,
                 name: _builtins.str,
                 network_load_balancer_id: _builtins.str,
                 policy: _builtins.str):
        """
        :param _builtins.bool are_operationally_active_backends_preferred: If enabled, NLB supports active-standby backends. The standby backend takes over the traffic when the active node fails, and continues to serve the traffic even when the old active node is back healthy.
        :param Sequence['GetBackendSetsBackendSetCollectionItemBackendArgs'] backends: An array of backends.
        :param Sequence['GetBackendSetsBackendSetCollectionItemHealthCheckerArgs'] health_checkers: The health check policy configuration. For more information, see [Editing Network Load Balancer Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/HealthCheckPolicies/update-health-check-management.htm).
        :param _builtins.str ip_version: IP version associated with the backend set.
        :param _builtins.bool is_fail_open: If enabled, the network load balancer will continue to distribute traffic in the configured distribution in the event all backends are unhealthy. The value is false by default.
        :param _builtins.bool is_instant_failover_enabled: If enabled existing connections will be forwarded to an alternative healthy backend as soon as current backend becomes unhealthy.
        :param _builtins.bool is_instant_failover_tcp_reset_enabled: If enabled along with instant failover, the network load balancer will send TCP RST to the clients for the existing connections instead of failing over to a healthy backend. This only applies when using the instant failover. By default, TCP RST is enabled.
        :param _builtins.bool is_preserve_source: If this parameter is enabled, then the network load balancer preserves the source IP of the packet when it is forwarded to backends. Backends see the original source IP. If the isPreserveSourceDestination parameter is enabled for the network load balancer resource, then this parameter cannot be disabled. The value is true by default.
        :param _builtins.str name: A user-friendly name for the backend set that must be unique and cannot be changed.
        :param _builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param _builtins.str policy: The network load balancer policy for the backend set.  Example: `FIVE_TUPLE`
        """
        pulumi.set(__self__, "are_operationally_active_backends_preferred", are_operationally_active_backends_preferred)
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "health_checkers", health_checkers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_fail_open", is_fail_open)
        pulumi.set(__self__, "is_instant_failover_enabled", is_instant_failover_enabled)
        pulumi.set(__self__, "is_instant_failover_tcp_reset_enabled", is_instant_failover_tcp_reset_enabled)
        pulumi.set(__self__, "is_preserve_source", is_preserve_source)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter(name="areOperationallyActiveBackendsPreferred")
    def are_operationally_active_backends_preferred(self) -> _builtins.bool:
        """
        If enabled, NLB supports active-standby backends. The standby backend takes over the traffic when the active node fails, and continues to serve the traffic even when the old active node is back healthy.
        """
        return pulumi.get(self, "are_operationally_active_backends_preferred")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.GetBackendSetsBackendSetCollectionItemBackendResult']:
        """
        An array of backends.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="healthCheckers")
    def health_checkers(self) -> Sequence['outputs.GetBackendSetsBackendSetCollectionItemHealthCheckerResult']:
        """
        The health check policy configuration. For more information, see [Editing Network Load Balancer Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/HealthCheckPolicies/update-health-check-management.htm).
        """
        return pulumi.get(self, "health_checkers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        IP version associated with the backend set.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isFailOpen")
    def is_fail_open(self) -> _builtins.bool:
        """
        If enabled, the network load balancer will continue to distribute traffic in the configured distribution in the event all backends are unhealthy. The value is false by default.
        """
        return pulumi.get(self, "is_fail_open")

    @_builtins.property
    @pulumi.getter(name="isInstantFailoverEnabled")
    def is_instant_failover_enabled(self) -> _builtins.bool:
        """
        If enabled existing connections will be forwarded to an alternative healthy backend as soon as current backend becomes unhealthy.
        """
        return pulumi.get(self, "is_instant_failover_enabled")

    @_builtins.property
    @pulumi.getter(name="isInstantFailoverTcpResetEnabled")
    def is_instant_failover_tcp_reset_enabled(self) -> _builtins.bool:
        """
        If enabled along with instant failover, the network load balancer will send TCP RST to the clients for the existing connections instead of failing over to a healthy backend. This only applies when using the instant failover. By default, TCP RST is enabled.
        """
        return pulumi.get(self, "is_instant_failover_tcp_reset_enabled")

    @_builtins.property
    @pulumi.getter(name="isPreserveSource")
    def is_preserve_source(self) -> _builtins.bool:
        """
        If this parameter is enabled, then the network load balancer preserves the source IP of the packet when it is forwarded to backends. Backends see the original source IP. If the isPreserveSourceDestination parameter is enabled for the network load balancer resource, then this parameter cannot be disabled. The value is true by default.
        """
        return pulumi.get(self, "is_preserve_source")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The network load balancer policy for the backend set.  Example: `FIVE_TUPLE`
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetBackendSetsBackendSetCollectionItemBackendResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 is_backup: _builtins.bool,
                 is_drain: _builtins.bool,
                 is_offline: _builtins.bool,
                 name: _builtins.str,
                 port: _builtins.int,
                 target_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip_address: The IP address of the backend server. Example: `10.0.0.3`
        :param _builtins.bool is_backup: Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param _builtins.bool is_drain: Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param _builtins.bool is_offline: Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.str name: A user-friendly name for the backend set that must be unique and cannot be changed.
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str target_id: The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param _builtins.int weight: The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_backup", is_backup)
        pulumi.set(__self__, "is_drain", is_drain)
        pulumi.set(__self__, "is_offline", is_offline)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the backend server. Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> _builtins.bool:
        """
        Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @_builtins.property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendSetsBackendSetCollectionItemHealthCheckerResult(dict):
    def __init__(__self__, *,
                 dns: Sequence['outputs.GetBackendSetsBackendSetCollectionItemHealthCheckerDnResult'],
                 interval_in_millis: _builtins.int,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 request_data: _builtins.str,
                 response_body_regex: _builtins.str,
                 response_data: _builtins.str,
                 retries: _builtins.int,
                 return_code: _builtins.int,
                 timeout_in_millis: _builtins.int,
                 url_path: _builtins.str):
        """
        :param Sequence['GetBackendSetsBackendSetCollectionItemHealthCheckerDnArgs'] dns: DNS healthcheck configurations.
        :param _builtins.int interval_in_millis: The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param _builtins.str protocol: The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        :param _builtins.str request_data: Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param _builtins.str response_body_regex: A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.str response_data: Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param _builtins.int retries: The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param _builtins.int return_code: The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param _builtins.int timeout_in_millis: The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param _builtins.str url_path: The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "request_data", request_data)
        pulumi.set(__self__, "response_body_regex", response_body_regex)
        pulumi.set(__self__, "response_data", response_data)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "return_code", return_code)
        pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetBackendSetsBackendSetCollectionItemHealthCheckerDnResult']:
        """
        DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> _builtins.int:
        """
        The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="requestData")
    def request_data(self) -> _builtins.str:
        """
        Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> _builtins.str:
        """
        A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter(name="responseData")
    def response_data(self) -> _builtins.str:
        """
        Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> _builtins.int:
        """
        The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> _builtins.int:
        """
        The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> _builtins.str:
        """
        The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class GetBackendSetsBackendSetCollectionItemHealthCheckerDnResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 query_class: _builtins.str,
                 query_type: _builtins.str,
                 rcodes: Sequence[_builtins.str],
                 transport_protocol: _builtins.str):
        """
        :param _builtins.str domain_name: The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param _builtins.str query_class: The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param _builtins.str query_type: The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param Sequence[_builtins.str] rcodes: An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param _builtins.str transport_protocol: DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "query_class", query_class)
        pulumi.set(__self__, "query_type", query_type)
        pulumi.set(__self__, "rcodes", rcodes)
        pulumi.set(__self__, "transport_protocol", transport_protocol)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> _builtins.str:
        """
        The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> _builtins.str:
        """
        The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter
    def rcodes(self) -> Sequence[_builtins.str]:
        """
        An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> _builtins.str:
        """
        DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class GetBackendSetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBackendsBackendCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBackendsBackendCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBackendsBackendCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBackendsBackendCollectionItemResult(dict):
    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 is_backup: _builtins.bool,
                 is_drain: _builtins.bool,
                 is_offline: _builtins.bool,
                 name: _builtins.str,
                 network_load_balancer_id: _builtins.str,
                 port: _builtins.int,
                 target_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str backend_set_name: The name of the backend set associated with the backend servers.  Example: `example_backend_set`
        :param _builtins.str ip_address: The IP address of the backend server. Example: `10.0.0.3`
        :param _builtins.bool is_backup: Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param _builtins.bool is_drain: Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param _builtins.bool is_offline: Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.str name: A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        :param _builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param _builtins.int port: The communication port for the backend server.  Example: `8080`
        :param _builtins.str target_id: The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param _builtins.int weight: The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_backup", is_backup)
        pulumi.set(__self__, "is_drain", is_drain)
        pulumi.set(__self__, "is_offline", is_offline)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        The name of the backend set associated with the backend servers.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the backend server. Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @_builtins.property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> _builtins.bool:
        """
        Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @_builtins.property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> _builtins.bool:
        """
        Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about network load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListenersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListenersListenerCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetListenersListenerCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetListenersListenerCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetListenersListenerCollectionItemResult(dict):
    def __init__(__self__, *,
                 default_backend_set_name: _builtins.str,
                 id: _builtins.str,
                 ip_version: _builtins.str,
                 is_ppv2enabled: _builtins.bool,
                 l3ip_idle_timeout: _builtins.int,
                 name: _builtins.str,
                 network_load_balancer_id: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 tcp_idle_timeout: _builtins.int,
                 udp_idle_timeout: _builtins.int):
        """
        :param _builtins.str default_backend_set_name: The name of the associated backend set.  Example: `example_backend_set`
        :param _builtins.str ip_version: IP version associated with the listener.
        :param _builtins.bool is_ppv2enabled: Property to enable/disable PPv2 feature for this listener.
        :param _builtins.int l3ip_idle_timeout: The duration for L3IP idle timeout in seconds. Example: `200`
        :param _builtins.str name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        :param _builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param _builtins.int port: The communication port for the listener.  Example: `80`
        :param _builtins.str protocol: The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        :param _builtins.int tcp_idle_timeout: The duration for TCP idle timeout in seconds. Example: `300`
        :param _builtins.int udp_idle_timeout: The duration for UDP idle timeout in seconds. Example: `120`
        """
        pulumi.set(__self__, "default_backend_set_name", default_backend_set_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_ppv2enabled", is_ppv2enabled)
        pulumi.set(__self__, "l3ip_idle_timeout", l3ip_idle_timeout)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "tcp_idle_timeout", tcp_idle_timeout)
        pulumi.set(__self__, "udp_idle_timeout", udp_idle_timeout)

    @_builtins.property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> _builtins.str:
        """
        The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isPpv2enabled")
    def is_ppv2enabled(self) -> _builtins.bool:
        """
        Property to enable/disable PPv2 feature for this listener.
        """
        return pulumi.get(self, "is_ppv2enabled")

    @_builtins.property
    @pulumi.getter(name="l3ipIdleTimeout")
    def l3ip_idle_timeout(self) -> _builtins.int:
        """
        The duration for L3IP idle timeout in seconds. Example: `200`
        """
        return pulumi.get(self, "l3ip_idle_timeout")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="tcpIdleTimeout")
    def tcp_idle_timeout(self) -> _builtins.int:
        """
        The duration for TCP idle timeout in seconds. Example: `300`
        """
        return pulumi.get(self, "tcp_idle_timeout")

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeout")
    def udp_idle_timeout(self) -> _builtins.int:
        """
        The duration for UDP idle timeout in seconds. Example: `120`
        """
        return pulumi.get(self, "udp_idle_timeout")


@pulumi.output_type
class GetNetworkLoadBalancerIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 ip_version: _builtins.str,
                 is_public: _builtins.bool,
                 reserved_ips: Sequence['outputs.GetNetworkLoadBalancerIpAddressReservedIpResult']):
        """
        :param _builtins.str ip_address: An IP address.  Example: `192.168.0.3`
        :param _builtins.str ip_version: IP version associated with the listener.
        :param _builtins.bool is_public: Whether the IP address is public or private.
        :param Sequence['GetNetworkLoadBalancerIpAddressReservedIpArgs'] reserved_ips: An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_public", is_public)
        pulumi.set(__self__, "reserved_ips", reserved_ips)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        Whether the IP address is public or private.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Sequence['outputs.GetNetworkLoadBalancerIpAddressReservedIpResult']:
        """
        An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class GetNetworkLoadBalancerIpAddressReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNetworkLoadBalancerReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNetworkLoadBalancersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkLoadBalancersNetworkLoadBalancerCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemResult(dict):
    def __init__(__self__, *,
                 assigned_ipv6: _builtins.str,
                 assigned_private_ipv4: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 ip_addresses: Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressResult'],
                 is_preserve_source_destination: _builtins.bool,
                 is_private: _builtins.bool,
                 is_symmetric_hash_enabled: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 network_security_group_ids: Sequence[_builtins.str],
                 nlb_ip_version: _builtins.str,
                 reserved_ips: Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemReservedIpResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 subnet_ipv6cidr: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancers to list.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        :param Sequence['GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressArgs'] ip_addresses: An array of IP addresses.
        :param _builtins.bool is_preserve_source_destination: When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC. Packets are sent to the backend set without any changes to the source and destination IP.
        :param _builtins.bool is_private: Whether the network load balancer has a virtual cloud network-local (private) IP address.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence[_builtins.str] network_security_group_ids: An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
        :param _builtins.str nlb_ip_version: IP version associated with the NLB.
        :param Mapping[str, _builtins.str] security_attributes: ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{ "oracle-zpr": { "td": { "value": "42", "mode": "audit" } } }`
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state.
        :param _builtins.str subnet_id: The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)."
        :param Mapping[str, _builtins.str] system_tags: Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        :param _builtins.str time_created: The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        :param _builtins.str time_updated: The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        pulumi.set(__self__, "assigned_ipv6", assigned_ipv6)
        pulumi.set(__self__, "assigned_private_ipv4", assigned_private_ipv4)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "is_preserve_source_destination", is_preserve_source_destination)
        pulumi.set(__self__, "is_private", is_private)
        pulumi.set(__self__, "is_symmetric_hash_enabled", is_symmetric_hash_enabled)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "nlb_ip_version", nlb_ip_version)
        pulumi.set(__self__, "reserved_ips", reserved_ips)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "subnet_ipv6cidr", subnet_ipv6cidr)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="assignedIpv6")
    def assigned_ipv6(self) -> _builtins.str:
        return pulumi.get(self, "assigned_ipv6")

    @_builtins.property
    @pulumi.getter(name="assignedPrivateIpv4")
    def assigned_private_ipv4(self) -> _builtins.str:
        return pulumi.get(self, "assigned_private_ipv4")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancers to list.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressResult']:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="isPreserveSourceDestination")
    def is_preserve_source_destination(self) -> _builtins.bool:
        """
        When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC. Packets are sent to the backend set without any changes to the source and destination IP.
        """
        return pulumi.get(self, "is_preserve_source_destination")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> _builtins.bool:
        """
        Whether the network load balancer has a virtual cloud network-local (private) IP address.
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="isSymmetricHashEnabled")
    def is_symmetric_hash_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_symmetric_hash_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="nlbIpVersion")
    def nlb_ip_version(self) -> _builtins.str:
        """
        IP version associated with the NLB.
        """
        return pulumi.get(self, "nlb_ip_version")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemReservedIpResult']:
        return pulumi.get(self, "reserved_ips")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{ "oracle-zpr": { "td": { "value": "42", "mode": "audit" } } }`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)."
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetIpv6cidr")
    def subnet_ipv6cidr(self) -> _builtins.str:
        return pulumi.get(self, "subnet_ipv6cidr")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 ip_version: _builtins.str,
                 is_public: _builtins.bool,
                 reserved_ips: Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressReservedIpResult']):
        """
        :param _builtins.str ip_address: An IP address.  Example: `192.168.0.3`
        :param _builtins.str ip_version: IP version associated with the listener.
        :param _builtins.bool is_public: Whether the IP address is public or private.
               If "true", then the IP address is public and accessible from the internet.
        :param Sequence['GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressReservedIpArgs'] reserved_ips: An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_public", is_public)
        pulumi.set(__self__, "reserved_ips", reserved_ips)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        Whether the IP address is public or private.
        If "true", then the IP address is public and accessible from the internet.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressReservedIpResult']:
        """
        An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemIpAddressReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNetworkLoadBalancersNetworkLoadBalancerCollectionItemReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetNetworkLoadBalancersPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkLoadBalancersPoliciesNetworkLoadBalancersPolicyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] items: Array of NetworkLoadBalancersPolicySummary objects.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        Array of NetworkLoadBalancersPolicySummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkLoadBalancersProtocolsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkLoadBalancersProtocolsNetworkLoadBalancersProtocolCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] items: Array of NetworkLoadBalancersProtocolSummary objects.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        Array of NetworkLoadBalancersProtocolSummary objects.
        """
        return pulumi.get(self, "items")


