# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReplicationPoliciesResult',
    'AwaitableGetReplicationPoliciesResult',
    'get_replication_policies',
    'get_replication_policies_output',
]

@pulumi.output_type
class GetReplicationPoliciesResult:
    """
    A collection of values returned by getReplicationPolicies.
    """
    def __init__(__self__, bucket=None, filters=None, id=None, namespace=None, replication_policies=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if replication_policies and not isinstance(replication_policies, list):
            raise TypeError("Expected argument 'replication_policies' to be a list")
        pulumi.set(__self__, "replication_policies", replication_policies)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReplicationPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="replicationPolicies")
    def replication_policies(self) -> Sequence['outputs.GetReplicationPoliciesReplicationPolicyResult']:
        """
        The list of replication_policies.
        """
        return pulumi.get(self, "replication_policies")


class AwaitableGetReplicationPoliciesResult(GetReplicationPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationPoliciesResult(
            bucket=self.bucket,
            filters=self.filters,
            id=self.id,
            namespace=self.namespace,
            replication_policies=self.replication_policies)


def get_replication_policies(bucket: Optional[_builtins.str] = None,
                             filters: Optional[Sequence[Union['GetReplicationPoliciesFilterArgs', 'GetReplicationPoliciesFilterArgsDict']]] = None,
                             namespace: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationPoliciesResult:
    """
    This data source provides the list of Replication Policies in Oracle Cloud Infrastructure Object Storage service.

    List the replication policies associated with a bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_policies = oci.ObjectStorage.get_replication_policies(bucket=replication_policy_bucket,
        namespace=replication_policy_namespace)
    ```


    :param _builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param _builtins.str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getReplicationPolicies:getReplicationPolicies', __args__, opts=opts, typ=GetReplicationPoliciesResult).value

    return AwaitableGetReplicationPoliciesResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        replication_policies=pulumi.get(__ret__, 'replication_policies'))
def get_replication_policies_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReplicationPoliciesFilterArgs', 'GetReplicationPoliciesFilterArgsDict']]]]] = None,
                                    namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicationPoliciesResult]:
    """
    This data source provides the list of Replication Policies in Oracle Cloud Infrastructure Object Storage service.

    List the replication policies associated with a bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replication_policies = oci.ObjectStorage.get_replication_policies(bucket=replication_policy_bucket,
        namespace=replication_policy_namespace)
    ```


    :param _builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param _builtins.str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ObjectStorage/getReplicationPolicies:getReplicationPolicies', __args__, opts=opts, typ=GetReplicationPoliciesResult)
    return __ret__.apply(lambda __response__: GetReplicationPoliciesResult(
        bucket=pulumi.get(__response__, 'bucket'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        replication_policies=pulumi.get(__response__, 'replication_policies')))
