# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApiPlatformApiPlatformInstancesResult',
    'AwaitableGetApiPlatformApiPlatformInstancesResult',
    'get_api_platform_api_platform_instances',
    'get_api_platform_api_platform_instances_output',
]

@pulumi.output_type
class GetApiPlatformApiPlatformInstancesResult:
    """
    A collection of values returned by getApiPlatformApiPlatformInstances.
    """
    def __init__(__self__, api_platform_instance_collections=None, compartment_id=None, filters=None, id=None, name=None, state=None):
        if api_platform_instance_collections and not isinstance(api_platform_instance_collections, list):
            raise TypeError("Expected argument 'api_platform_instance_collections' to be a list")
        pulumi.set(__self__, "api_platform_instance_collections", api_platform_instance_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apiPlatformInstanceCollections")
    def api_platform_instance_collections(self) -> Sequence['outputs.GetApiPlatformApiPlatformInstancesApiPlatformInstanceCollectionResult']:
        """
        The list of api_platform_instance_collection.
        """
        return pulumi.get(self, "api_platform_instance_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApiPlatformApiPlatformInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A regionally unique, non-changeable instance name provided by the user during instance creation
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the instance
        """
        return pulumi.get(self, "state")


class AwaitableGetApiPlatformApiPlatformInstancesResult(GetApiPlatformApiPlatformInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiPlatformApiPlatformInstancesResult(
            api_platform_instance_collections=self.api_platform_instance_collections,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_api_platform_api_platform_instances(compartment_id: Optional[_builtins.str] = None,
                                            filters: Optional[Sequence[Union['GetApiPlatformApiPlatformInstancesFilterArgs', 'GetApiPlatformApiPlatformInstancesFilterArgsDict']]] = None,
                                            id: Optional[_builtins.str] = None,
                                            name: Optional[_builtins.str] = None,
                                            state: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiPlatformApiPlatformInstancesResult:
    """
    This data source provides the list of Api Platform Instances in Oracle Cloud Infrastructure Api Platform service.

    Gets a list of API Platform Instances

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_platform_instances = oci.oci.get_api_platform_api_platform_instances(compartment_id=compartment_id,
        id=api_platform_instance_id,
        name=api_platform_instance_name,
        state=api_platform_instance_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
    :param _builtins.str name: A filter to return only resources that match the given name exactly
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getApiPlatformApiPlatformInstances:getApiPlatformApiPlatformInstances', __args__, opts=opts, typ=GetApiPlatformApiPlatformInstancesResult).value

    return AwaitableGetApiPlatformApiPlatformInstancesResult(
        api_platform_instance_collections=pulumi.get(__ret__, 'api_platform_instance_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_api_platform_api_platform_instances_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApiPlatformApiPlatformInstancesFilterArgs', 'GetApiPlatformApiPlatformInstancesFilterArgsDict']]]]] = None,
                                                   id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiPlatformApiPlatformInstancesResult]:
    """
    This data source provides the list of Api Platform Instances in Oracle Cloud Infrastructure Api Platform service.

    Gets a list of API Platform Instances

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_platform_instances = oci.oci.get_api_platform_api_platform_instances(compartment_id=compartment_id,
        id=api_platform_instance_id,
        name=api_platform_instance_name,
        state=api_platform_instance_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
    :param _builtins.str name: A filter to return only resources that match the given name exactly
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getApiPlatformApiPlatformInstances:getApiPlatformApiPlatformInstances', __args__, opts=opts, typ=GetApiPlatformApiPlatformInstancesResult)
    return __ret__.apply(lambda __response__: GetApiPlatformApiPlatformInstancesResult(
        api_platform_instance_collections=pulumi.get(__response__, 'api_platform_instance_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
