# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedKafkaKafkaClusterResult',
    'AwaitableGetManagedKafkaKafkaClusterResult',
    'get_managed_kafka_kafka_cluster',
    'get_managed_kafka_kafka_cluster_output',
]

@pulumi.output_type
class GetManagedKafkaKafkaClusterResult:
    """
    A collection of values returned by getManagedKafkaKafkaCluster.
    """
    def __init__(__self__, access_subnets=None, broker_shapes=None, client_certificate_bundle=None, cluster_config_id=None, cluster_config_version=None, cluster_type=None, compartment_id=None, coordination_type=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, kafka_bootstrap_urls=None, kafka_cluster_id=None, kafka_version=None, lifecycle_details=None, secret_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if access_subnets and not isinstance(access_subnets, list):
            raise TypeError("Expected argument 'access_subnets' to be a list")
        pulumi.set(__self__, "access_subnets", access_subnets)
        if broker_shapes and not isinstance(broker_shapes, list):
            raise TypeError("Expected argument 'broker_shapes' to be a list")
        pulumi.set(__self__, "broker_shapes", broker_shapes)
        if client_certificate_bundle and not isinstance(client_certificate_bundle, str):
            raise TypeError("Expected argument 'client_certificate_bundle' to be a str")
        pulumi.set(__self__, "client_certificate_bundle", client_certificate_bundle)
        if cluster_config_id and not isinstance(cluster_config_id, str):
            raise TypeError("Expected argument 'cluster_config_id' to be a str")
        pulumi.set(__self__, "cluster_config_id", cluster_config_id)
        if cluster_config_version and not isinstance(cluster_config_version, int):
            raise TypeError("Expected argument 'cluster_config_version' to be a int")
        pulumi.set(__self__, "cluster_config_version", cluster_config_version)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if coordination_type and not isinstance(coordination_type, str):
            raise TypeError("Expected argument 'coordination_type' to be a str")
        pulumi.set(__self__, "coordination_type", coordination_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_bootstrap_urls and not isinstance(kafka_bootstrap_urls, list):
            raise TypeError("Expected argument 'kafka_bootstrap_urls' to be a list")
        pulumi.set(__self__, "kafka_bootstrap_urls", kafka_bootstrap_urls)
        if kafka_cluster_id and not isinstance(kafka_cluster_id, str):
            raise TypeError("Expected argument 'kafka_cluster_id' to be a str")
        pulumi.set(__self__, "kafka_cluster_id", kafka_cluster_id)
        if kafka_version and not isinstance(kafka_version, str):
            raise TypeError("Expected argument 'kafka_version' to be a str")
        pulumi.set(__self__, "kafka_version", kafka_version)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="accessSubnets")
    def access_subnets(self) -> Sequence['outputs.GetManagedKafkaKafkaClusterAccessSubnetResult']:
        """
        Subnets where broker/coordinator VNICs will be created.
        """
        return pulumi.get(self, "access_subnets")

    @_builtins.property
    @pulumi.getter(name="brokerShapes")
    def broker_shapes(self) -> Sequence['outputs.GetManagedKafkaKafkaClusterBrokerShapeResult']:
        """
        Configuration of the broker node.
        """
        return pulumi.get(self, "broker_shapes")

    @_builtins.property
    @pulumi.getter(name="clientCertificateBundle")
    def client_certificate_bundle(self) -> _builtins.str:
        """
        CA certificate bundle for mTLS broker authentication.
        """
        return pulumi.get(self, "client_certificate_bundle")

    @_builtins.property
    @pulumi.getter(name="clusterConfigId")
    def cluster_config_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Kafka Cluster configuration object
        """
        return pulumi.get(self, "cluster_config_id")

    @_builtins.property
    @pulumi.getter(name="clusterConfigVersion")
    def cluster_config_version(self) -> _builtins.int:
        """
        The version of configuration object
        """
        return pulumi.get(self, "cluster_config_version")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        Type of the cluster to spin up.  DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on a single node PRODUCTION - Minimum allowed broker count is 3
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="coordinationType")
    def coordination_type(self) -> _builtins.str:
        """
        Kafka coordination type. Set of available types depends on Kafka version
        """
        return pulumi.get(self, "coordination_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kafkaBootstrapUrls")
    def kafka_bootstrap_urls(self) -> Sequence['outputs.GetManagedKafkaKafkaClusterKafkaBootstrapUrlResult']:
        """
        Bootstrap URL that can be used to connect to Kafka
        """
        return pulumi.get(self, "kafka_bootstrap_urls")

    @_builtins.property
    @pulumi.getter(name="kafkaClusterId")
    def kafka_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "kafka_cluster_id")

    @_builtins.property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> _builtins.str:
        """
        Version of Kafka to use to spin up the cluster
        """
        return pulumi.get(self, "kafka_version")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the KafkaCluster in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that contains superuser password.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the KafkaCluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the KafkaCluster was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the KafkaCluster was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetManagedKafkaKafkaClusterResult(GetManagedKafkaKafkaClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedKafkaKafkaClusterResult(
            access_subnets=self.access_subnets,
            broker_shapes=self.broker_shapes,
            client_certificate_bundle=self.client_certificate_bundle,
            cluster_config_id=self.cluster_config_id,
            cluster_config_version=self.cluster_config_version,
            cluster_type=self.cluster_type,
            compartment_id=self.compartment_id,
            coordination_type=self.coordination_type,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            kafka_bootstrap_urls=self.kafka_bootstrap_urls,
            kafka_cluster_id=self.kafka_cluster_id,
            kafka_version=self.kafka_version,
            lifecycle_details=self.lifecycle_details,
            secret_id=self.secret_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_managed_kafka_kafka_cluster(kafka_cluster_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedKafkaKafkaClusterResult:
    """
    This data source provides details about a specific Kafka Cluster resource in Oracle Cloud Infrastructure Managed Kafka service.

    Gets information about a KafkaCluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_kafka_cluster = oci.oci.get_managed_kafka_kafka_cluster(kafka_cluster_id=test_kafka_cluster_oci_managed_kafka_kafka_cluster["id"])
    ```


    :param _builtins.str kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
    """
    __args__ = dict()
    __args__['kafkaClusterId'] = kafka_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getManagedKafkaKafkaCluster:getManagedKafkaKafkaCluster', __args__, opts=opts, typ=GetManagedKafkaKafkaClusterResult).value

    return AwaitableGetManagedKafkaKafkaClusterResult(
        access_subnets=pulumi.get(__ret__, 'access_subnets'),
        broker_shapes=pulumi.get(__ret__, 'broker_shapes'),
        client_certificate_bundle=pulumi.get(__ret__, 'client_certificate_bundle'),
        cluster_config_id=pulumi.get(__ret__, 'cluster_config_id'),
        cluster_config_version=pulumi.get(__ret__, 'cluster_config_version'),
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        coordination_type=pulumi.get(__ret__, 'coordination_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        kafka_bootstrap_urls=pulumi.get(__ret__, 'kafka_bootstrap_urls'),
        kafka_cluster_id=pulumi.get(__ret__, 'kafka_cluster_id'),
        kafka_version=pulumi.get(__ret__, 'kafka_version'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_managed_kafka_kafka_cluster_output(kafka_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedKafkaKafkaClusterResult]:
    """
    This data source provides details about a specific Kafka Cluster resource in Oracle Cloud Infrastructure Managed Kafka service.

    Gets information about a KafkaCluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_kafka_cluster = oci.oci.get_managed_kafka_kafka_cluster(kafka_cluster_id=test_kafka_cluster_oci_managed_kafka_kafka_cluster["id"])
    ```


    :param _builtins.str kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
    """
    __args__ = dict()
    __args__['kafkaClusterId'] = kafka_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getManagedKafkaKafkaCluster:getManagedKafkaKafkaCluster', __args__, opts=opts, typ=GetManagedKafkaKafkaClusterResult)
    return __ret__.apply(lambda __response__: GetManagedKafkaKafkaClusterResult(
        access_subnets=pulumi.get(__response__, 'access_subnets'),
        broker_shapes=pulumi.get(__response__, 'broker_shapes'),
        client_certificate_bundle=pulumi.get(__response__, 'client_certificate_bundle'),
        cluster_config_id=pulumi.get(__response__, 'cluster_config_id'),
        cluster_config_version=pulumi.get(__response__, 'cluster_config_version'),
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        coordination_type=pulumi.get(__response__, 'coordination_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        kafka_bootstrap_urls=pulumi.get(__response__, 'kafka_bootstrap_urls'),
        kafka_cluster_id=pulumi.get(__response__, 'kafka_cluster_id'),
        kafka_version=pulumi.get(__response__, 'kafka_version'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
