# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSupportedCommitmentsResult',
    'AwaitableGetSupportedCommitmentsResult',
    'get_supported_commitments',
    'get_supported_commitments_output',
]

@pulumi.output_type
class GetSupportedCommitmentsResult:
    """
    A collection of values returned by getSupportedCommitments.
    """
    def __init__(__self__, compartment_id=None, filters=None, host_shape_name=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_shape_name and not isinstance(host_shape_name, str):
            raise TypeError("Expected argument 'host_shape_name' to be a str")
        pulumi.set(__self__, "host_shape_name", host_shape_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSupportedCommitmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "host_shape_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSupportedCommitmentsItemResult']:
        """
        A list of the supported Commitments.
        """
        return pulumi.get(self, "items")


class AwaitableGetSupportedCommitmentsResult(GetSupportedCommitmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSupportedCommitmentsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            host_shape_name=self.host_shape_name,
            id=self.id,
            items=self.items)


def get_supported_commitments(compartment_id: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetSupportedCommitmentsFilterArgs', 'GetSupportedCommitmentsFilterArgsDict']]] = None,
                              host_shape_name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSupportedCommitmentsResult:
    """
    This data source provides the list of Supported Commitments in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported Commitments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_commitments = oci.Ocvp.get_supported_commitments(compartment_id=compartment_id,
        host_shape_name=test_shape["name"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str host_shape_name: A filter to return only resources that match or support the given ESXi host shape.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['hostShapeName'] = host_shape_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getSupportedCommitments:getSupportedCommitments', __args__, opts=opts, typ=GetSupportedCommitmentsResult).value

    return AwaitableGetSupportedCommitmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        host_shape_name=pulumi.get(__ret__, 'host_shape_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_supported_commitments_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSupportedCommitmentsFilterArgs', 'GetSupportedCommitmentsFilterArgsDict']]]]] = None,
                                     host_shape_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSupportedCommitmentsResult]:
    """
    This data source provides the list of Supported Commitments in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported Commitments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_commitments = oci.Ocvp.get_supported_commitments(compartment_id=compartment_id,
        host_shape_name=test_shape["name"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str host_shape_name: A filter to return only resources that match or support the given ESXi host shape.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['hostShapeName'] = host_shape_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ocvp/getSupportedCommitments:getSupportedCommitments', __args__, opts=opts, typ=GetSupportedCommitmentsResult)
    return __ret__.apply(lambda __response__: GetSupportedCommitmentsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        host_shape_name=pulumi.get(__response__, 'host_shape_name'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
