# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OdaInstanceRestrictedOperation',
    'OdaPrivateEndpointScanProxyScanListenerInfo',
    'GetOdaInstanceRestrictedOperationResult',
    'GetOdaInstancesFilterResult',
    'GetOdaInstancesOdaInstanceResult',
    'GetOdaInstancesOdaInstanceRestrictedOperationResult',
    'GetOdaPrivateEndpointAttachmentsFilterResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesFilterResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult',
    'GetOdaPrivateEndpointScanProxyScanListenerInfoResult',
    'GetOdaPrivateEndpointsFilterResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult',
]

@pulumi.output_type
class OdaInstanceRestrictedOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "restrictingService":
            suggest = "restricting_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaInstanceRestrictedOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[_builtins.str] = None,
                 restricting_service: Optional[_builtins.str] = None):
        """
        :param _builtins.str operation_name: Name of the restricted operation.
        :param _builtins.str restricting_service: Name of the service restricting the operation.
        """
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if restricting_service is not None:
            pulumi.set(__self__, "restricting_service", restricting_service)

    @_builtins.property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[_builtins.str]:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @_builtins.property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> Optional[_builtins.str]:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class OdaPrivateEndpointScanProxyScanListenerInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanListenerFqdn":
            suggest = "scan_listener_fqdn"
        elif key == "scanListenerIp":
            suggest = "scan_listener_ip"
        elif key == "scanListenerPort":
            suggest = "scan_listener_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaPrivateEndpointScanProxyScanListenerInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_listener_fqdn: Optional[_builtins.str] = None,
                 scan_listener_ip: Optional[_builtins.str] = None,
                 scan_listener_port: Optional[_builtins.int] = None):
        """
        :param _builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param _builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param _builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        if scan_listener_fqdn is not None:
            pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        if scan_listener_ip is not None:
            pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        if scan_listener_port is not None:
            pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @_builtins.property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> Optional[_builtins.str]:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @_builtins.property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> Optional[_builtins.str]:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @_builtins.property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> Optional[_builtins.int]:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: _builtins.str,
                 restricting_service: _builtins.str):
        """
        :param _builtins.str operation_name: Name of the restricted operation.
        :param _builtins.str restricting_service: Name of the service restricting the operation.
        """
        pulumi.set(__self__, "operation_name", operation_name)
        pulumi.set(__self__, "restricting_service", restricting_service)

    @_builtins.property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> _builtins.str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @_builtins.property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> _builtins.str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaInstancesOdaInstanceResult(dict):
    def __init__(__self__, *,
                 attachment_ids: Sequence[_builtins.str],
                 attachment_types: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 connector_url: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 identity_app_console_url: _builtins.str,
                 identity_app_guid: _builtins.str,
                 identity_domain: _builtins.str,
                 imported_package_ids: Sequence[_builtins.str],
                 imported_package_names: Sequence[_builtins.str],
                 is_role_based_access: _builtins.bool,
                 lifecycle_sub_state: _builtins.str,
                 restricted_operations: Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult'],
                 shape_name: _builtins.str,
                 state: _builtins.str,
                 state_message: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 web_app_url: _builtins.str):
        """
        :param Sequence[_builtins.str] attachment_ids: A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param Sequence[_builtins.str] attachment_types: A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        :param _builtins.str compartment_id: List the Digital Assistant instances that belong to this compartment.
        :param _builtins.str connector_url: URL for the connector's endpoint.
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: Description of the Digital Assistant instance.
        :param _builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param _builtins.str id: Unique immutable identifier that was assigned when the instance was created.
        :param _builtins.str identity_app_console_url: If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        :param _builtins.str identity_app_guid: If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        :param _builtins.str identity_domain: If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        :param Sequence[_builtins.str] imported_package_ids: A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        :param Sequence[_builtins.str] imported_package_names: A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        :param _builtins.bool is_role_based_access: Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        :param _builtins.str lifecycle_sub_state: The current sub-state of the Digital Assistant instance.
        :param Sequence['GetOdaInstancesOdaInstanceRestrictedOperationArgs'] restricted_operations: A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param _builtins.str shape_name: Shape or size of the instance.
        :param _builtins.str state: List only the Digital Assistant instances that are in this lifecycle state.
        :param _builtins.str state_message: A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        :param _builtins.str time_created: When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param _builtins.str time_updated: When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param _builtins.str web_app_url: URL for the Digital Assistant web application that's associated with the instance.
        """
        pulumi.set(__self__, "attachment_ids", attachment_ids)
        pulumi.set(__self__, "attachment_types", attachment_types)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connector_url", connector_url)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "identity_app_console_url", identity_app_console_url)
        pulumi.set(__self__, "identity_app_guid", identity_app_guid)
        pulumi.set(__self__, "identity_domain", identity_domain)
        pulumi.set(__self__, "imported_package_ids", imported_package_ids)
        pulumi.set(__self__, "imported_package_names", imported_package_names)
        pulumi.set(__self__, "is_role_based_access", is_role_based_access)
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        pulumi.set(__self__, "restricted_operations", restricted_operations)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "web_app_url", web_app_url)

    @_builtins.property
    @pulumi.getter(name="attachmentIds")
    def attachment_ids(self) -> Sequence[_builtins.str]:
        """
        A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_ids")

    @_builtins.property
    @pulumi.getter(name="attachmentTypes")
    def attachment_types(self) -> Sequence[_builtins.str]:
        """
        A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_types")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        List the Digital Assistant instances that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectorUrl")
    def connector_url(self) -> _builtins.str:
        """
        URL for the connector's endpoint.
        """
        return pulumi.get(self, "connector_url")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Digital Assistant instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique immutable identifier that was assigned when the instance was created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityAppConsoleUrl")
    def identity_app_console_url(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        """
        return pulumi.get(self, "identity_app_console_url")

    @_builtins.property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @_builtins.property
    @pulumi.getter(name="identityDomain")
    def identity_domain(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        """
        return pulumi.get(self, "identity_domain")

    @_builtins.property
    @pulumi.getter(name="importedPackageIds")
    def imported_package_ids(self) -> Sequence[_builtins.str]:
        """
        A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_ids")

    @_builtins.property
    @pulumi.getter(name="importedPackageNames")
    def imported_package_names(self) -> Sequence[_builtins.str]:
        """
        A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_names")

    @_builtins.property
    @pulumi.getter(name="isRoleBasedAccess")
    def is_role_based_access(self) -> _builtins.bool:
        """
        Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        """
        return pulumi.get(self, "is_role_based_access")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> _builtins.str:
        """
        The current sub-state of the Digital Assistant instance.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @_builtins.property
    @pulumi.getter(name="restrictedOperations")
    def restricted_operations(self) -> Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult']:
        """
        A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "restricted_operations")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        Shape or size of the instance.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        List only the Digital Assistant instances that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> _builtins.str:
        """
        A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> _builtins.str:
        """
        URL for the Digital Assistant web application that's associated with the instance.
        """
        return pulumi.get(self, "web_app_url")


@pulumi.output_type
class GetOdaInstancesOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: _builtins.str,
                 restricting_service: _builtins.str):
        """
        :param _builtins.str operation_name: Name of the restricted operation.
        :param _builtins.str restricting_service: Name of the service restricting the operation.
        """
        pulumi.set(__self__, "operation_name", operation_name)
        pulumi.set(__self__, "restricting_service", restricting_service)

    @_builtins.property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> _builtins.str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @_builtins.property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> _builtins.str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 id: _builtins.str,
                 oda_instance_id: _builtins.str,
                 oda_private_endpoint_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: List the ODA Private Endpoint Attachments that belong to this compartment.
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        :param _builtins.str oda_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        :param _builtins.str oda_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        :param _builtins.str state: List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        :param _builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param _builtins.str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oda_instance_id", oda_instance_id)
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        List the ODA Private Endpoint Attachments that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="odaInstanceId")
    def oda_instance_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        """
        return pulumi.get(self, "oda_instance_id")

    @_builtins.property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 oda_private_endpoint_id: _builtins.str,
                 protocol: _builtins.str,
                 scan_listener_infos: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult'],
                 scan_listener_type: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        :param _builtins.str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param Sequence['GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoArgs'] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param _builtins.str scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs
        :param _builtins.str state: List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        :param _builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "scan_listener_infos", scan_listener_infos)
        pulumi.set(__self__, "scan_listener_type", scan_listener_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> _builtins.str:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult']:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @_builtins.property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> _builtins.str:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs
        """
        return pulumi.get(self, "scan_listener_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: _builtins.str,
                 scan_listener_ip: _builtins.str,
                 scan_listener_port: _builtins.int):
        """
        :param _builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param _builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param _builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @_builtins.property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> _builtins.str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @_builtins.property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> _builtins.str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @_builtins.property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> _builtins.int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxyScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: _builtins.str,
                 scan_listener_ip: _builtins.str,
                 scan_listener_port: _builtins.int):
        """
        :param _builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param _builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param _builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @_builtins.property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> _builtins.str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @_builtins.property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> _builtins.str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @_builtins.property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> _builtins.int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: List the ODA Private Endpoints that belong to this compartment.
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: Description of the ODA private endpoint.
        :param _builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        :param Sequence[_builtins.str] nsg_ids: List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        :param _builtins.str state: List only the ODA Private Endpoints that are in this lifecycle state.
        :param _builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        :param _builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param _builtins.str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        List the ODA Private Endpoints that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the ODA private endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        List only the ODA Private Endpoints that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


