# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccessRequestsResult',
    'AwaitableGetAccessRequestsResult',
    'get_access_requests',
    'get_access_requests_output',
]

@pulumi.output_type
class GetAccessRequestsResult:
    """
    A collection of values returned by getAccessRequests.
    """
    def __init__(__self__, access_request_collections=None, compartment_id=None, filters=None, id=None, resource_name=None, resource_type=None, state=None, time_end=None, time_start=None):
        if access_request_collections and not isinstance(access_request_collections, list):
            raise TypeError("Expected argument 'access_request_collections' to be a list")
        pulumi.set(__self__, "access_request_collections", access_request_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="accessRequestCollections")
    def access_request_collections(self) -> Sequence['outputs.GetAccessRequestsAccessRequestCollectionResult']:
        """
        The list of access_request_collection.
        """
        return pulumi.get(self, "access_request_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the access request.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAccessRequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        The name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        resourceType for which the AccessRequest is applicable
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the AccessRequest.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_end")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetAccessRequestsResult(GetAccessRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRequestsResult(
            access_request_collections=self.access_request_collections,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            state=self.state,
            time_end=self.time_end,
            time_start=self.time_start)


def get_access_requests(compartment_id: Optional[_builtins.str] = None,
                        filters: Optional[Sequence[Union['GetAccessRequestsFilterArgs', 'GetAccessRequestsFilterArgsDict']]] = None,
                        resource_name: Optional[_builtins.str] = None,
                        resource_type: Optional[_builtins.str] = None,
                        state: Optional[_builtins.str] = None,
                        time_end: Optional[_builtins.str] = None,
                        time_start: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRequestsResult:
    """
    This data source provides the list of Access Requests in Oracle Cloud Infrastructure Operator Access Control service.

    Lists all access requests in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_requests = oci.OperatorAccessControl.get_access_requests(compartment_id=compartment_id,
        resource_name=access_request_resource_name,
        resource_type=access_request_resource_type,
        state=access_request_state,
        time_end=access_request_time_end,
        time_start=access_request_time_start)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str resource_name: A filter to return only resources that match the given ResourceName.
    :param _builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
    :param _builtins.str time_end: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters are used together.
    :param _builtins.str time_start: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters are used together.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceName'] = resource_name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getAccessRequests:getAccessRequests', __args__, opts=opts, typ=GetAccessRequestsResult).value

    return AwaitableGetAccessRequestsResult(
        access_request_collections=pulumi.get(__ret__, 'access_request_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_access_requests_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAccessRequestsFilterArgs', 'GetAccessRequestsFilterArgsDict']]]]] = None,
                               resource_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               time_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               time_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessRequestsResult]:
    """
    This data source provides the list of Access Requests in Oracle Cloud Infrastructure Operator Access Control service.

    Lists all access requests in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_requests = oci.OperatorAccessControl.get_access_requests(compartment_id=compartment_id,
        resource_name=access_request_resource_name,
        resource_type=access_request_resource_type,
        state=access_request_state,
        time_end=access_request_time_end,
        time_start=access_request_time_start)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str resource_name: A filter to return only resources that match the given ResourceName.
    :param _builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given AccessRequest lifecycleState.
    :param _builtins.str time_end: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters are used together.
    :param _builtins.str time_start: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters are used together.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceName'] = resource_name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getAccessRequests:getAccessRequests', __args__, opts=opts, typ=GetAccessRequestsResult)
    return __ret__.apply(lambda __response__: GetAccessRequestsResult(
        access_request_collections=pulumi.get(__response__, 'access_request_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_name=pulumi.get(__response__, 'resource_name'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
